/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.Severity;

public class StandardReportingContext
implements ReportingContext,
ControllerServiceLookup {
    private final FlowController flowController;
    private final EventAccess eventAccess;
    private final ReportingTask reportingTask;
    private final BulletinRepository bulletinRepository;
    private final ControllerServiceProvider serviceProvider;
    private final Map<PropertyDescriptor, String> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final VariableRegistry variableRegistry;
    private final ParameterLookup parameterLookup;
    private final boolean analyticsEnabled;

    public StandardReportingContext(FlowController flowController, BulletinRepository bulletinRepository, Map<PropertyDescriptor, String> properties, ReportingTask reportingTask, VariableRegistry variableRegistry, ParameterLookup parameterLookup) {
        this.flowController = flowController;
        this.eventAccess = flowController.getEventAccess();
        this.bulletinRepository = bulletinRepository;
        this.properties = Collections.unmodifiableMap(properties);
        this.serviceProvider = flowController.getControllerServiceProvider();
        this.reportingTask = reportingTask;
        this.variableRegistry = variableRegistry;
        this.parameterLookup = parameterLookup;
        this.analyticsEnabled = flowController.getStatusAnalyticsEngine() != null;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public EventAccess getEventAccess() {
        return this.eventAccess;
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public Bulletin createBulletin(String category, Severity severity, String message) {
        return BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
    }

    public Bulletin createBulletin(String componentId, String category, Severity severity, String message) {
        Connectable connectable = this.flowController.getFlowManager().findConnectable(componentId);
        if (connectable == null) {
            throw new IllegalStateException("Cannot create Component-Level Bulletin because no component can be found with ID " + componentId);
        }
        return BulletinFactory.createBulletin((Connectable)connectable, (String)category, (String)severity.name(), (String)message);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyDescriptor descriptor = this.reportingTask.getPropertyDescriptor(property.getName());
        if (descriptor == null) {
            return null;
        }
        String configuredValue = this.properties.get(property);
        return new StandardPropertyValue(configuredValue == null ? descriptor.getDefaultValue() : configuredValue, (ControllerServiceLookup)this, this.parameterLookup, this.preparedQueries.get(property), this.variableRegistry);
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.serviceProvider.getControllerService(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.serviceProvider.getControllerServiceIdentifiers(serviceType, null);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.serviceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.serviceProvider.getControllerServiceName(serviceIdentifier);
    }

    public StateManager getStateManager() {
        return this.flowController.getStateManagerProvider().getStateManager(this.reportingTask.getIdentifier());
    }

    public boolean isClustered() {
        return this.flowController.isConfiguredForClustering();
    }

    public String getClusterNodeIdentifier() {
        NodeIdentifier nodeId = this.flowController.getNodeId();
        return nodeId == null ? null : nodeId.getId();
    }

    public boolean isAnalyticsEnabled() {
        return this.analyticsEnabled;
    }
}

