/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.ActiveThreadInfo;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.util.FormatUtils;

public class LongRunningProcessorTask
implements DiagnosticTask {
    private static final long MIN_ACTIVE_MILLIS = 30000L;
    private final FlowController flowController;

    public LongRunningProcessorTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        for (ProcessorNode processorNode : this.flowController.getFlowManager().getRootGroup().findAllProcessors()) {
            List activeThreads = processorNode.getActiveThreads();
            for (ActiveThreadInfo activeThread : activeThreads) {
                if (activeThread.getActiveMillis() <= 30000L) continue;
                String threadName = activeThread.getThreadName();
                if (activeThread.isTerminated()) {
                    threadName = threadName + " (Terminated)";
                }
                details.add(processorNode + " - " + threadName + " has been active for " + FormatUtils.formatMinutesSeconds((long)activeThread.getActiveMillis(), (TimeUnit)TimeUnit.MILLISECONDS) + " minutes");
            }
        }
        if (details.isEmpty()) {
            details.add("No long-running tasks identified");
        }
        return new StandardDiagnosticsDumpElement("Long-Running Processor Tasks", details);
    }
}

