/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.provenance.IdentifierLookup;

public class ComponentIdentifierLookup
implements IdentifierLookup {
    private final FlowController flowController;

    public ComponentIdentifierLookup(FlowController flowController) {
        this.flowController = flowController;
    }

    public List<String> getComponentIdentifiers() {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        ArrayList<String> componentIds = new ArrayList<String>();
        rootGroup.findAllProcessors().forEach(proc -> componentIds.add(proc.getIdentifier()));
        rootGroup.getInputPorts().forEach(port -> componentIds.add(port.getIdentifier()));
        rootGroup.getOutputPorts().forEach(port -> componentIds.add(port.getIdentifier()));
        return componentIds;
    }

    public List<String> getComponentTypes() {
        Set procClasses = this.flowController.getExtensionManager().getExtensions(Processor.class);
        ArrayList<String> componentTypes = new ArrayList<String>(procClasses.size() + 2);
        componentTypes.add("Remote Input Port");
        componentTypes.add("Remote Output Port");
        procClasses.stream().map(Class::getSimpleName).forEach(componentTypes::add);
        return componentTypes;
    }

    public List<String> getQueueIdentifiers() {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        return rootGroup.findAllConnections().stream().map(Connection::getIdentifier).collect(Collectors.toList());
    }
}

