/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.ValueMapper;

public enum ConnectionStatusDescriptor {
    INPUT_BYTES("inputBytes", "Bytes In (5 mins)", "The cumulative size of all FlowFiles that were transferred to this Connection in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ConnectionStatus>)((ValueMapper)ConnectionStatus::getInputBytes)),
    INPUT_COUNT("inputCount", "FlowFiles In (5 mins)", "The number of FlowFiles that were transferred to this Connection in the past 5 minutes", MetricDescriptor.Formatter.COUNT, (ValueMapper<ConnectionStatus>)((ValueMapper)s -> s.getInputCount())),
    OUTPUT_BYTES("outputBytes", "Bytes Out (5 mins)", "The cumulative size of all FlowFiles that were pulled from this Connection in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ConnectionStatus>)((ValueMapper)ConnectionStatus::getOutputBytes)),
    OUTPUT_COUNT("outputCount", "FlowFiles Out (5 mins)", "The number of FlowFiles that were pulled from this Connection in the past 5 minutes", MetricDescriptor.Formatter.COUNT, (ValueMapper<ConnectionStatus>)((ValueMapper)s -> s.getOutputCount())),
    QUEUED_BYTES("queuedBytes", "Queued Bytes", "The number of Bytes queued in this Connection", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ConnectionStatus>)((ValueMapper)ConnectionStatus::getQueuedBytes)),
    QUEUED_COUNT("queuedCount", "Queued Count", "The number of FlowFiles queued in this Connection", MetricDescriptor.Formatter.COUNT, (ValueMapper<ConnectionStatus>)((ValueMapper)s -> s.getQueuedCount()));

    private MetricDescriptor<ConnectionStatus> descriptor;

    private ConnectionStatusDescriptor(String field, String label, String description, MetricDescriptor.Formatter formatter, ValueMapper<ConnectionStatus> valueFunction) {
        this.descriptor = new StandardMetricDescriptor<ConnectionStatus>(this::ordinal, field, label, description, formatter, valueFunction);
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<ConnectionStatus> getDescriptor() {
        return this.descriptor;
    }
}

