/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.tasks;

import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.util.ReflectionUtils;

public class ReportingTaskWrapper
implements Runnable {
    private final ReportingTaskNode taskNode;
    private final LifecycleState lifecycleState;
    private final ExtensionManager extensionManager;

    public ReportingTaskWrapper(ReportingTaskNode taskNode, LifecycleState lifecycleState, ExtensionManager extensionManager) {
        this.taskNode = taskNode;
        this.lifecycleState = lifecycleState;
        this.extensionManager = extensionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void run() {
        this.lifecycleState.incrementActiveThreadCount(null);
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, this.taskNode.getReportingTask().getClass(), (String)this.taskNode.getIdentifier());){
            this.taskNode.getReportingTask().onTrigger(this.taskNode.getReportingContext());
        }
        try {
            if (this.lifecycleState.isScheduled() || this.lifecycleState.getActiveThreadCount() != 1 || !this.lifecycleState.mustCallOnStoppedMethods()) return;
            var2_4 = null;
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, this.taskNode.getReportingTask().getClass(), (String)this.taskNode.getIdentifier());){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)this.taskNode.getReportingTask(), this.taskNode.getConfigurationContext());
                return;
            }
            catch (Throwable throwable) {
                var2_4 = throwable;
                throw throwable;
            }
        }
        finally {
            this.lifecycleState.decrementActiveThreadCount(null);
        }
        catch (Throwable t) {
            block62: {
                try {
                    SimpleProcessLogger componentLog = new SimpleProcessLogger(this.taskNode.getIdentifier(), this.taskNode.getReportingTask());
                    componentLog.error("Error running task {} due to {}", new Object[]{this.taskNode.getReportingTask(), t.toString()});
                    if (!componentLog.isDebugEnabled()) break block62;
                    componentLog.error("", t);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.lifecycleState.isScheduled() || this.lifecycleState.getActiveThreadCount() != 1 || !this.lifecycleState.mustCallOnStoppedMethods()) throw throwable;
                        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, this.taskNode.getReportingTask().getClass(), (String)this.taskNode.getIdentifier());){
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)this.taskNode.getReportingTask(), this.taskNode.getConfigurationContext());
                            throw throwable;
                        }
                    }
                    finally {
                        this.lifecycleState.decrementActiveThreadCount(null);
                    }
                }
            }
            try {
                if (this.lifecycleState.isScheduled() || this.lifecycleState.getActiveThreadCount() != 1 || !this.lifecycleState.mustCallOnStoppedMethods()) return;
                try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, this.taskNode.getReportingTask().getClass(), (String)this.taskNode.getIdentifier());){
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)this.taskNode.getReportingTask(), this.taskNode.getConfigurationContext());
                    return;
                }
            }
            finally {
                this.lifecycleState.decrementActiveThreadCount(null);
            }
        }
    }
}

