/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatingSystemDiagnosticTask
implements DiagnosticTask {
    private static final Logger logger = LoggerFactory.getLogger(OperatingSystemDiagnosticTask.class);
    private static final Set<String> IGNORABLE_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("ObjectName", ""));

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        ArrayList details = new ArrayList();
        NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            TreeMap<String, String> attributes = new TreeMap<String, String>();
            ObjectName osObjectName = os.getObjectName();
            MBeanInfo mbeanInfo = ManagementFactory.getPlatformMBeanServer().getMBeanInfo(osObjectName);
            for (MBeanAttributeInfo attributeInfo : mbeanInfo.getAttributes()) {
                String attributeName = attributeInfo.getName();
                if (IGNORABLE_ATTRIBUTE_NAMES.contains(attributeName)) continue;
                Object attributeValue = ManagementFactory.getPlatformMBeanServer().getAttribute(osObjectName, attributeName);
                if (attributeValue instanceof Number) {
                    attributes.put(attributeName, numberFormat.format(attributeValue));
                    continue;
                }
                attributes.put(attributeName, String.valueOf(attributeValue));
            }
            attributes.forEach((key, value) -> details.add(key + " : " + value));
        }
        catch (Exception e) {
            logger.error("Failed to obtain Operating System details", (Throwable)e);
            return new StandardDiagnosticsDumpElement("Operating System / Hardware", Collections.singletonList("Failed to obtain Operating System details"));
        }
        return new StandardDiagnosticsDumpElement("Operating System / Hardware", details);
    }
}

