/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Positionable;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.groups.StandardVersionedFlowStatus;
import org.apache.nifi.groups.VersionControlFields;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.BatchSize;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.ConnectableComponent;
import org.apache.nifi.registry.flow.ExternalControllerServiceReference;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.ScheduledState;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.VersionedConnection;
import org.apache.nifi.registry.flow.VersionedControllerService;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedFlowStatus;
import org.apache.nifi.registry.flow.VersionedFunnel;
import org.apache.nifi.registry.flow.VersionedLabel;
import org.apache.nifi.registry.flow.VersionedParameter;
import org.apache.nifi.registry.flow.VersionedParameterContext;
import org.apache.nifi.registry.flow.VersionedPort;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.VersionedProcessor;
import org.apache.nifi.registry.flow.VersionedPropertyDescriptor;
import org.apache.nifi.registry.flow.VersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.EvolvingDifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardComparableDataFlow;
import org.apache.nifi.registry.flow.diff.StandardFlowComparator;
import org.apache.nifi.registry.flow.diff.StaticDifferenceDescriptor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.registry.variable.MutableVariableRegistry;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FlowDifferenceFilters;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.SnippetUtils;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardProcessGroup
implements ProcessGroup {
    private final String id;
    private final AtomicReference<ProcessGroup> parent;
    private final AtomicReference<String> name;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> comments;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final AtomicReference<StandardVersionControlInformation> versionControlInfo = new AtomicReference();
    private static final SecureRandom randomGenerator = new SecureRandom();
    private final StandardProcessScheduler scheduler;
    private final ControllerServiceProvider controllerServiceProvider;
    private final FlowController flowController;
    private final FlowManager flowManager;
    private final Map<String, Port> inputPorts = new HashMap<String, Port>();
    private final Map<String, Port> outputPorts = new HashMap<String, Port>();
    private final Map<String, Connection> connections = new HashMap<String, Connection>();
    private final Map<String, ProcessGroup> processGroups = new HashMap<String, ProcessGroup>();
    private final Map<String, Label> labels = new HashMap<String, Label>();
    private final Map<String, RemoteProcessGroup> remoteGroups = new HashMap<String, RemoteProcessGroup>();
    private final Map<String, ProcessorNode> processors = new HashMap<String, ProcessorNode>();
    private final Map<String, Funnel> funnels = new HashMap<String, Funnel>();
    private final Map<String, ControllerServiceNode> controllerServices = new HashMap<String, ControllerServiceNode>();
    private final Map<String, Template> templates = new HashMap<String, Template>();
    private final StringEncryptor encryptor;
    private final MutableVariableRegistry variableRegistry;
    private final VersionControlFields versionControlFields = new VersionControlFields();
    private volatile ParameterContext parameterContext;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessGroup.class);

    public StandardProcessGroup(String id, ControllerServiceProvider serviceProvider, StandardProcessScheduler scheduler, NiFiProperties nifiProps, StringEncryptor encryptor, FlowController flowController, MutableVariableRegistry variableRegistry) {
        this.id = id;
        this.controllerServiceProvider = serviceProvider;
        this.parent = new AtomicReference();
        this.scheduler = scheduler;
        this.comments = new AtomicReference<String>("");
        this.encryptor = encryptor;
        this.flowController = flowController;
        this.variableRegistry = variableRegistry;
        this.flowManager = flowController.getFlowManager();
        this.name = new AtomicReference();
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
    }

    public ProcessGroup getParent() {
        return this.parent.get();
    }

    private ProcessGroup getRoot() {
        StandardProcessGroup root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public void setParent(ProcessGroup newParent) {
        this.parent.set(newParent);
    }

    public Authorizable getParentAuthorizable() {
        return this.getParent();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ProcessGroup, (String)this.getIdentifier(), (String)this.getName());
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup parentProcessGroup = this.getParent();
        if (parentProcessGroup == null) {
            return null;
        }
        return parentProcessGroup.getIdentifier();
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The name of the process group must be specified.");
        }
        this.name.set(name);
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        this.comments.set(comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessGroupCounts getCounts() {
        int localInputPortCount = 0;
        int localOutputPortCount = 0;
        int publicInputPortCount = 0;
        int publicOutputPortCount = 0;
        int running = 0;
        int stopped = 0;
        int invalid = 0;
        int disabled = 0;
        int activeRemotePorts = 0;
        int inactiveRemotePorts = 0;
        int upToDate = 0;
        int locallyModified = 0;
        int stale = 0;
        int locallyModifiedAndStale = 0;
        int syncFailure = 0;
        this.readLock.lock();
        try {
            for (ProcessorNode procNode : this.processors.values()) {
                if (org.apache.nifi.controller.ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (procNode.isRunning()) {
                    ++running;
                    continue;
                }
                if (procNode.getValidationStatus() == ValidationStatus.INVALID) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (Port port : this.inputPorts.values()) {
                if (port instanceof PublicPort) {
                    ++publicInputPortCount;
                } else {
                    ++localInputPortCount;
                }
                if (org.apache.nifi.controller.ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (port.isRunning()) {
                    ++running;
                    continue;
                }
                if (!port.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (Port port : this.outputPorts.values()) {
                if (port instanceof PublicPort) {
                    ++publicOutputPortCount;
                } else {
                    ++localOutputPortCount;
                }
                if (org.apache.nifi.controller.ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (port.isRunning()) {
                    ++running;
                    continue;
                }
                if (!port.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                ProcessGroupCounts childCounts = childGroup.getCounts();
                running += childCounts.getRunningCount();
                stopped += childCounts.getStoppedCount();
                invalid += childCounts.getInvalidCount();
                disabled += childCounts.getDisabledCount();
                VersionControlInformation vci = childGroup.getVersionControlInformation();
                if (vci != null) {
                    switch (vci.getStatus().getState()) {
                        case LOCALLY_MODIFIED: {
                            ++locallyModified;
                            break;
                        }
                        case LOCALLY_MODIFIED_AND_STALE: {
                            ++locallyModifiedAndStale;
                            break;
                        }
                        case STALE: {
                            ++stale;
                            break;
                        }
                        case SYNC_FAILURE: {
                            ++syncFailure;
                            break;
                        }
                        case UP_TO_DATE: {
                            ++upToDate;
                        }
                    }
                }
                upToDate += childCounts.getUpToDateCount();
                locallyModified += childCounts.getLocallyModifiedCount();
                stale += childCounts.getStaleCount();
                locallyModifiedAndStale += childCounts.getLocallyModifiedAndStaleCount();
                syncFailure += childCounts.getSyncFailureCount();
            }
            for (RemoteProcessGroup remoteGroup : this.findAllRemoteProcessGroups()) {
                for (Port port : remoteGroup.getInputPorts()) {
                    if (!port.hasIncomingConnection()) continue;
                    if (port.isRunning()) {
                        ++activeRemotePorts;
                        continue;
                    }
                    ++inactiveRemotePorts;
                }
                for (Port port : remoteGroup.getOutputPorts()) {
                    if (port.getConnections().isEmpty()) continue;
                    if (port.isRunning()) {
                        ++activeRemotePorts;
                        continue;
                    }
                    ++inactiveRemotePorts;
                }
                String authIssue = remoteGroup.getAuthorizationIssue();
                if (authIssue == null) continue;
                ++invalid;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return new ProcessGroupCounts(localInputPortCount, localOutputPortCount, publicInputPortCount, publicOutputPortCount, running, stopped, invalid, disabled, activeRemotePorts, inactiveRemotePorts, upToDate, locallyModified, stale, locallyModifiedAndStale, syncFailure);
    }

    public boolean isRootGroup() {
        return this.parent.get() == null;
    }

    public void startProcessing() {
        this.readLock.lock();
        try {
            this.findAllProcessors().stream().filter(START_PROCESSORS_FILTER).forEach(node -> {
                try {
                    node.getProcessGroup().startProcessor(node, true);
                }
                catch (Throwable t) {
                    LOG.error("Unable to start processor {} due to {}", new Object[]{node.getIdentifier(), t});
                }
            });
            this.findAllInputPorts().stream().filter(START_PORTS_FILTER).forEach(port -> port.getProcessGroup().startInputPort(port));
            this.findAllOutputPorts().stream().filter(START_PORTS_FILTER).forEach(port -> port.getProcessGroup().startOutputPort(port));
        }
        finally {
            this.readLock.unlock();
        }
        this.onComponentModified();
    }

    public void stopProcessing() {
        this.readLock.lock();
        try {
            this.findAllProcessors().stream().filter(STOP_PROCESSORS_FILTER).forEach(node -> {
                try {
                    node.getProcessGroup().stopProcessor(node);
                }
                catch (Throwable t) {
                    LOG.error("Unable to stop processor {} due to {}", new Object[]{node.getIdentifier(), t});
                }
            });
            this.findAllInputPorts().stream().filter(STOP_PORTS_FILTER).forEach(port -> port.getProcessGroup().stopInputPort(port));
            this.findAllOutputPorts().stream().filter(STOP_PORTS_FILTER).forEach(port -> port.getProcessGroup().stopOutputPort(port));
        }
        finally {
            this.readLock.unlock();
        }
        this.onComponentModified();
    }

    private StateManager getStateManager(String componentId) {
        return this.flowController.getStateManagerProvider().getStateManager(componentId);
    }

    private void shutdown(ProcessGroup procGroup) {
        for (ProcessorNode node : procGroup.getProcessors()) {
            NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), node.getProcessor().getClass(), (String)node.getIdentifier());
            Throwable throwable = null;
            try {
                StandardProcessContext processContext = new StandardProcessContext(node, this.controllerServiceProvider, this.encryptor, this.getStateManager(node.getIdentifier()), () -> false);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)node.getProcessor(), processContext);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (x == null) continue;
                if (throwable != null) {
                    try {
                        x.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                x.close();
            }
        }
        for (RemoteProcessGroup rpg : procGroup.getRemoteProcessGroups()) {
            rpg.shutdown();
        }
        for (Connection connection : procGroup.getConnections()) {
            connection.getFlowFileQueue().stopLoadBalancing();
        }
        for (ProcessGroup group : procGroup.getProcessGroups()) {
            this.shutdown(group);
        }
    }

    public void shutdown() {
        this.readLock.lock();
        try {
            this.shutdown(this);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyPortUniqueness(Port port, Map<String, Port> portIdMap, Function<String, Port> getPortByName) {
        if (portIdMap.containsKey(Objects.requireNonNull(port).getIdentifier())) {
            throw new IllegalStateException("A port with the same id already exists.");
        }
        if (getPortByName.apply(port.getName()) != null) {
            throw new IllegalStateException("A port with the same name already exists.");
        }
    }

    public void addInputPort(Port port) {
        if (this.isRootGroup() && !(port instanceof PublicPort)) {
            throw new IllegalArgumentException("Cannot add Input Port of type " + port.getClass().getName() + " to the Root Group");
        }
        this.writeLock.lock();
        try {
            this.verifyPortUniqueness(port, this.inputPorts, name -> this.getInputPortByName((String)name));
            port.setProcessGroup((ProcessGroup)this);
            this.inputPorts.put(Objects.requireNonNull(port).getIdentifier(), port);
            this.flowManager.onInputPortAdded(port);
            this.onComponentModified();
            LOG.info("Input Port {} added to {}", (Object)port, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputPort(Port port) {
        this.writeLock.lock();
        try {
            Port toRemove = this.inputPorts.get(Objects.requireNonNull(port).getIdentifier());
            if (toRemove == null) {
                throw new IllegalStateException(port.getIdentifier() + " is not an Input Port of this Process Group");
            }
            port.verifyCanDelete();
            for (Object conn : port.getConnections()) {
                conn.verifyCanDelete();
            }
            if (port.isRunning()) {
                this.stopInputPort(port);
            }
            HashSet copy = new HashSet(port.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            Port removed = this.inputPorts.remove(port.getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(port.getIdentifier() + " is not an Input Port of this Process Group");
            }
            this.scheduler.onPortRemoved(port);
            this.onComponentModified();
            this.flowManager.onInputPortRemoved(port);
            LOG.info("Input Port {} removed from flow", (Object)port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Port getInputPort(String id) {
        this.readLock.lock();
        try {
            Port port = this.inputPorts.get(Objects.requireNonNull(id));
            return port;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Port> getInputPorts() {
        this.readLock.lock();
        try {
            HashSet<Port> hashSet = new HashSet<Port>(this.inputPorts.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addOutputPort(Port port) {
        if (this.isRootGroup() && !(port instanceof PublicPort)) {
            throw new IllegalArgumentException("Cannot add Output Port " + port.getClass().getName() + " to the Root Group");
        }
        this.writeLock.lock();
        try {
            this.verifyPortUniqueness(port, this.outputPorts, this::getOutputPortByName);
            port.setProcessGroup((ProcessGroup)this);
            this.outputPorts.put(port.getIdentifier(), port);
            this.flowManager.onOutputPortAdded(port);
            this.onComponentModified();
            LOG.info("Output Port {} added to {}", (Object)port, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputPort(Port port) {
        this.writeLock.lock();
        try {
            Port toRemove = this.outputPorts.get(Objects.requireNonNull(port).getIdentifier());
            toRemove.verifyCanDelete();
            if (port.isRunning()) {
                this.stopOutputPort(port);
            }
            if (!toRemove.getConnections().isEmpty()) {
                throw new IllegalStateException(port.getIdentifier() + " cannot be removed until its connections are removed");
            }
            Port removed = this.outputPorts.remove(port.getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(port.getIdentifier() + " is not an Output Port of this Process Group");
            }
            this.scheduler.onPortRemoved(port);
            this.onComponentModified();
            this.flowManager.onOutputPortRemoved(port);
            LOG.info("Output Port {} removed from flow", (Object)port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Port getOutputPort(String id) {
        this.readLock.lock();
        try {
            Port port = this.outputPorts.get(Objects.requireNonNull(id));
            return port;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Port> getOutputPorts() {
        this.readLock.lock();
        try {
            HashSet<Port> hashSet = new HashSet<Port>(this.outputPorts.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addProcessGroup(ProcessGroup group) {
        if (StringUtils.isEmpty((CharSequence)group.getName())) {
            throw new IllegalArgumentException("Process Group's name must be specified");
        }
        this.writeLock.lock();
        try {
            group.setParent((ProcessGroup)this);
            group.getVariableRegistry().setParent((VariableRegistry)this.getVariableRegistry());
            this.processGroups.put(Objects.requireNonNull(group).getIdentifier(), group);
            this.flowManager.onProcessGroupAdded(group);
            group.findAllControllerServices().forEach(this::updateControllerServiceReferences);
            group.findAllProcessors().forEach(this::updateControllerServiceReferences);
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)group, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ProcessGroup getProcessGroup(String id) {
        this.readLock.lock();
        try {
            ProcessGroup processGroup = this.processGroups.get(id);
            return processGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<ProcessGroup> getProcessGroups() {
        this.readLock.lock();
        try {
            HashSet<ProcessGroup> hashSet = new HashSet<ProcessGroup>(this.processGroups.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void removeProcessGroup(ProcessGroup group) {
        Objects.requireNonNull(group).verifyCanDelete();
        this.writeLock.lock();
        try {
            ProcessGroup toRemove = this.processGroups.get(group.getIdentifier());
            if (toRemove == null) {
                throw new IllegalStateException(group.getIdentifier() + " is not a member of this Process Group");
            }
            toRemove.verifyCanDelete();
            this.removeComponents(group);
            this.processGroups.remove(group.getIdentifier());
            this.onComponentModified();
            this.flowManager.onProcessGroupRemoved(group);
            LOG.info("{} removed from flow", (Object)group);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeComponents(ProcessGroup group) {
        for (Connection connection : new ArrayList(group.getConnections())) {
            group.removeConnection(connection);
        }
        for (Port port : new ArrayList(group.getInputPorts())) {
            group.removeInputPort(port);
        }
        for (Port port : new ArrayList(group.getOutputPorts())) {
            group.removeOutputPort(port);
        }
        for (Funnel funnel : new ArrayList(group.getFunnels())) {
            group.removeFunnel(funnel);
        }
        for (ProcessorNode processor : new ArrayList(group.getProcessors())) {
            group.removeProcessor(processor);
        }
        for (RemoteProcessGroup rpg : new ArrayList(group.getRemoteProcessGroups())) {
            group.removeRemoteProcessGroup(rpg);
        }
        for (Label label : new ArrayList(group.getLabels())) {
            group.removeLabel(label);
        }
        for (ControllerServiceNode cs : group.getControllerServices(false)) {
            this.flowController.getControllerServiceProvider().removeControllerService(cs);
        }
        for (ProcessGroup childGroup : new ArrayList(group.getProcessGroups())) {
            group.removeProcessGroup(childGroup);
        }
    }

    public void addRemoteProcessGroup(RemoteProcessGroup remoteGroup) {
        this.writeLock.lock();
        try {
            if (this.remoteGroups.containsKey(Objects.requireNonNull(remoteGroup).getIdentifier())) {
                throw new IllegalStateException("RemoteProcessGroup already exists with ID " + remoteGroup.getIdentifier());
            }
            remoteGroup.setProcessGroup((ProcessGroup)this);
            this.remoteGroups.put(Objects.requireNonNull(remoteGroup).getIdentifier(), remoteGroup);
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)remoteGroup, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<RemoteProcessGroup> getRemoteProcessGroups() {
        this.readLock.lock();
        try {
            HashSet<RemoteProcessGroup> hashSet = new HashSet<RemoteProcessGroup>(this.remoteGroups.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup) {
        String remoteGroupId = Objects.requireNonNull(remoteProcessGroup).getIdentifier();
        this.writeLock.lock();
        try {
            final RemoteProcessGroup remoteGroup = this.remoteGroups.get(remoteGroupId);
            if (remoteGroup == null) {
                throw new IllegalStateException(remoteProcessGroup.getIdentifier() + " is not a member of this Process Group");
            }
            remoteGroup.verifyCanDelete();
            for (RemoteGroupPort port : remoteGroup.getOutputPorts()) {
                for (Connection connection : port.getConnections()) {
                    connection.verifyCanDelete();
                }
            }
            this.onComponentModified();
            for (RemoteGroupPort port : remoteGroup.getOutputPorts()) {
                HashSet copy = new HashSet(port.getConnections());
                for (Connection connection : copy) {
                    this.removeConnection(connection);
                }
            }
            try {
                remoteGroup.onRemove();
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up resources for {} due to {}", (Object)remoteGroup, (Object)e);
            }
            remoteGroup.getInputPorts().forEach(this.scheduler::onPortRemoved);
            remoteGroup.getOutputPorts().forEach(this.scheduler::onPortRemoved);
            final StateManagerProvider stateManagerProvider = this.flowController.getStateManagerProvider();
            this.scheduler.submitFrameworkTask(new Runnable(){

                @Override
                public void run() {
                    stateManagerProvider.onComponentRemoved(remoteGroup.getIdentifier());
                }
            });
            this.remoteGroups.remove(remoteGroupId);
            LOG.info("{} removed from flow", (Object)remoteProcessGroup);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessor(ProcessorNode processor) {
        this.writeLock.lock();
        try {
            String processorId = Objects.requireNonNull(processor).getIdentifier();
            ProcessorNode existingProcessor = this.processors.get(processorId);
            if (existingProcessor != null) {
                throw new IllegalStateException("A processor is already registered to this ProcessGroup with ID " + processorId);
            }
            processor.setProcessGroup((ProcessGroup)this);
            processor.getVariableRegistry().setParent((VariableRegistry)this.getVariableRegistry());
            this.processors.put(processorId, processor);
            this.flowManager.onProcessorAdded(processor);
            this.updateControllerServiceReferences((ComponentNode)processor);
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)processor, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateControllerServiceReferences(ComponentNode component) {
        for (Map.Entry entry : component.getEffectivePropertyValues().entrySet()) {
            PropertyDescriptor propertyDescriptor;
            Class serviceClass;
            String serviceId = (String)entry.getValue();
            if (serviceId == null || (serviceClass = (propertyDescriptor = (PropertyDescriptor)entry.getKey()).getControllerServiceDefinition()) == null) continue;
            boolean validReference = this.isValidServiceReference(serviceId, serviceClass);
            ControllerServiceNode serviceNode = this.controllerServiceProvider.getControllerServiceNode(serviceId);
            if (serviceNode == null) continue;
            if (validReference) {
                serviceNode.addReference(component, propertyDescriptor);
                continue;
            }
            serviceNode.removeReference(component, propertyDescriptor);
        }
    }

    private boolean isValidServiceReference(String serviceId, Class<? extends ControllerService> serviceClass) {
        Set validServiceIds = this.controllerServiceProvider.getControllerServiceIdentifiers(serviceClass, this.getIdentifier());
        return validServiceIds.contains(serviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessor(final ProcessorNode processor) {
        boolean removed = false;
        String id = Objects.requireNonNull(processor).getIdentifier();
        this.writeLock.lock();
        try {
            if (!this.processors.containsKey(id)) {
                throw new IllegalStateException(processor.getIdentifier() + " is not a member of this Process Group");
            }
            processor.verifyCanDelete();
            for (Object conn : processor.getConnections()) {
                conn.verifyCanDelete();
            }
            try {
                Object conn;
                NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), processor.getProcessor().getClass(), (String)processor.getIdentifier());
                conn = null;
                try {
                    StandardProcessContext processContext = new StandardProcessContext(processor, this.controllerServiceProvider, this.encryptor, this.getStateManager(processor.getIdentifier()), () -> false);
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)processor.getProcessor(), processContext);
                }
                catch (Throwable processContext) {
                    conn = processContext;
                    throw processContext;
                }
                finally {
                    if (x != null) {
                        if (conn != null) {
                            try {
                                x.close();
                            }
                            catch (Throwable processContext) {
                                ((Throwable)conn).addSuppressed(processContext);
                            }
                        } else {
                            x.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke 'OnRemoved' methods of processor with id " + processor.getIdentifier(), (Throwable)e);
            }
            for (Map.Entry entry : processor.getEffectivePropertyValues().entrySet()) {
                ControllerServiceNode serviceNode;
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
                serviceNode.removeReference((ComponentNode)processor, descriptor);
            }
            this.processors.remove(id);
            this.onComponentModified();
            this.scheduler.onProcessorRemoved(processor);
            this.flowManager.onProcessorRemoved(processor);
            LogRepository logRepository = LogRepositoryFactory.getRepository((String)processor.getIdentifier());
            if (logRepository != null) {
                logRepository.removeAllObservers();
            }
            final StateManagerProvider stateManagerProvider = this.flowController.getStateManagerProvider();
            this.scheduler.submitFrameworkTask(new Runnable(){

                @Override
                public void run() {
                    stateManagerProvider.onComponentRemoved(processor.getIdentifier());
                }
            });
            HashSet copy = new HashSet(processor.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            removed = true;
            LOG.info("{} removed from flow", (Object)processor);
        }
        finally {
            if (removed) {
                try {
                    LogRepositoryFactory.removeRepository((String)processor.getIdentifier());
                    this.flowController.getExtensionManager().removeInstanceClassLoader(id);
                }
                catch (Throwable throwable) {}
            }
            this.writeLock.unlock();
        }
    }

    public Collection<ProcessorNode> getProcessors() {
        this.readLock.lock();
        try {
            ArrayList<ProcessorNode> arrayList = new ArrayList<ProcessorNode>(this.processors.values());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ProcessorNode getProcessor(String id) {
        this.readLock.lock();
        try {
            ProcessorNode processorNode = this.processors.get(Objects.requireNonNull(id));
            return processorNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isInputPort(Connectable connectable) {
        if (connectable.getConnectableType() != ConnectableType.INPUT_PORT) {
            return false;
        }
        return this.findInputPort(connectable.getIdentifier()) != null;
    }

    private boolean isOutputPort(Connectable connectable) {
        if (connectable.getConnectableType() != ConnectableType.OUTPUT_PORT) {
            return false;
        }
        return this.findOutputPort(connectable.getIdentifier()) != null;
    }

    public void inheritConnection(Connection connection) {
        this.writeLock.lock();
        try {
            this.connections.put(connection.getIdentifier(), connection);
            this.onComponentModified();
            connection.setProcessGroup((ProcessGroup)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        this.writeLock.lock();
        try {
            String id = Objects.requireNonNull(connection).getIdentifier();
            Connection existingConnection = this.connections.get(id);
            if (existingConnection != null) {
                throw new IllegalStateException("Connection already exists with ID " + id);
            }
            Connectable source = connection.getSource();
            Connectable destination = connection.getDestination();
            ProcessGroup sourceGroup = source.getProcessGroup();
            ProcessGroup destinationGroup = destination.getProcessGroup();
            if (this.isInputPort(source)) {
                if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because destination is an Input Port that does not belong to a child Process Group");
                    }
                } else if (sourceGroup != this || destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because source and destination are not both in this Process Group");
                }
            } else if (this.isOutputPort(source)) {
                if (!this.processGroups.containsKey(sourceGroup.getIdentifier())) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because source is an Output Port that does not belong to a child Process Group");
                }
                if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because its destination is an Input Port that does not belong to a child Process Group");
                    }
                } else if (destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because its destination does not belong to this Process Group");
                }
            } else {
                if (sourceGroup != this) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because the source does not belong to this Process Group");
                }
                if (this.isOutputPort(destination)) {
                    if (destinationGroup != this) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because its destination is an Output Port but does not belong to this Process Group");
                    }
                } else if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because its destination is an Input Port but the Input Port does not belong to a child Process Group");
                    }
                } else if (destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection between " + source.getIdentifier() + " and " + destination.getIdentifier() + " because they are in different Process Groups and neither is an Input Port or Output Port");
                }
            }
            connection.setProcessGroup((ProcessGroup)this);
            source.addConnection(connection);
            if (source != destination) {
                destination.addConnection(connection);
            }
            this.connections.put(connection.getIdentifier(), connection);
            this.flowManager.onConnectionAdded(connection);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connectable getConnectable(String id) {
        this.readLock.lock();
        try {
            ProcessorNode node = this.processors.get(id);
            if (node != null) {
                ProcessorNode processorNode = node;
                return processorNode;
            }
            Port inputPort = this.inputPorts.get(id);
            if (inputPort != null) {
                Port port = inputPort;
                return port;
            }
            Port outputPort = this.outputPorts.get(id);
            if (outputPort != null) {
                Port port = outputPort;
                return port;
            }
            Funnel funnel = this.funnels.get(id);
            if (funnel != null) {
                Funnel funnel2 = funnel;
                return funnel2;
            }
            Connectable connectable = null;
            return connectable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connectionToRemove) {
        this.writeLock.lock();
        try {
            Connection connection = this.connections.get(Objects.requireNonNull(connectionToRemove).getIdentifier());
            if (connection == null) {
                throw new IllegalStateException("Connection " + connectionToRemove.getIdentifier() + " is not a member of this Process Group");
            }
            connectionToRemove.verifyCanDelete();
            connectionToRemove.getFlowFileQueue().stopLoadBalancing();
            Connectable source = connectionToRemove.getSource();
            Connectable dest = connectionToRemove.getDestination();
            source.removeConnection(connection);
            if (source != dest) {
                dest.removeConnection(connection);
            }
            this.connections.remove(connection.getIdentifier());
            LOG.info("{} removed from flow", (Object)connection);
            this.onComponentModified();
            this.flowManager.onConnectionRemoved(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            HashSet<Connection> hashSet = new HashSet<Connection>(this.connections.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Connection getConnection(String id) {
        this.readLock.lock();
        try {
            Connection connection = this.connections.get(Objects.requireNonNull(id));
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Connection findConnection(String id) {
        Connection connection = this.flowManager.getConnection(id);
        if (connection == null) {
            return null;
        }
        if (this.isOwner(connection.getProcessGroup())) {
            return connection;
        }
        return null;
    }

    public List<Connection> findAllConnections() {
        return this.findAllConnections(this);
    }

    private List<Connection> findAllConnections(ProcessGroup group) {
        ArrayList<Connection> connections = new ArrayList<Connection>(group.getConnections());
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            connections.addAll(this.findAllConnections(childGroup));
        }
        return connections;
    }

    public void addLabel(Label label) {
        this.writeLock.lock();
        try {
            Label existing = this.labels.get(Objects.requireNonNull(label).getIdentifier());
            if (existing != null) {
                throw new IllegalStateException("A label already exists in this ProcessGroup with ID " + label.getIdentifier());
            }
            label.setProcessGroup((ProcessGroup)this);
            this.labels.put(label.getIdentifier(), label);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeLabel(Label label) {
        this.writeLock.lock();
        try {
            Label removed = this.labels.remove(Objects.requireNonNull(label).getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(label + " is not a member of this Process Group.");
            }
            this.onComponentModified();
            LOG.info("Label with ID {} removed from flow", (Object)label.getIdentifier());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Label> getLabels() {
        this.readLock.lock();
        try {
            HashSet<Label> hashSet = new HashSet<Label>(this.labels.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Label getLabel(String id) {
        this.readLock.lock();
        try {
            Label label = this.labels.get(id);
            return label;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.inputPorts.isEmpty() && this.outputPorts.isEmpty() && this.connections.isEmpty() && this.processGroups.isEmpty() && this.labels.isEmpty() && this.processors.isEmpty() && this.remoteGroups.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public RemoteProcessGroup getRemoteProcessGroup(String id) {
        this.readLock.lock();
        try {
            RemoteProcessGroup remoteProcessGroup = this.remoteGroups.get(Objects.requireNonNull(id));
            return remoteProcessGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> startProcessor(ProcessorNode processor, boolean failIfStopping) {
        this.readLock.lock();
        try {
            if (this.getProcessor(processor.getIdentifier()) == null) {
                throw new IllegalStateException("Processor is not a member of this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = processor.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            processor.reloadAdditionalResourcesIfNecessary();
            Future future = this.scheduler.startProcessor(processor, failIfStopping);
            return future;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startInputPort(Port port) {
        this.readLock.lock();
        try {
            if (this.getInputPort(port.getIdentifier()) == null) {
                throw new IllegalStateException("Port " + port.getIdentifier() + " is not a member of this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("InputPort " + port.getIdentifier() + " is disabled");
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (this.getOutputPort(port.getIdentifier()) == null) {
                throw new IllegalStateException("Port is not a member of this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("OutputPort is disabled");
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startFunnel(Funnel funnel) {
        this.readLock.lock();
        try {
            if (this.getFunnel(funnel.getIdentifier()) == null) {
                throw new IllegalStateException("Funnel is not a member of this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = funnel.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startFunnel(funnel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stopProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = processor.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            Future future = this.scheduler.stopProcessor(processor);
            return future;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void terminateProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = processor.getScheduledState();
            if (state != org.apache.nifi.controller.ScheduledState.STOPPED) {
                throw new IllegalStateException("Cannot terminate processor with ID " + processor.getIdentifier() + " because it is not stopped");
            }
            this.scheduler.terminateProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Input Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("InputPort is disabled");
            }
            if (state == org.apache.nifi.controller.ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Output Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("OutputPort is disabled");
            }
            if (state == org.apache.nifi.controller.ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void stopFunnel(Funnel funnel) {
        this.readLock.lock();
        try {
            if (!this.funnels.containsKey(funnel.getIdentifier())) {
                throw new IllegalStateException("No Funnel with ID " + funnel.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = funnel.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                throw new IllegalStateException("Funnel is disabled");
            }
            if (state == org.apache.nifi.controller.ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopFunnel(funnel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Input Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.STOPPED) {
                return;
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                throw new IllegalStateException("InputPort is currently running");
            }
            this.scheduler.enablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Output Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.STOPPED) {
                return;
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                throw new IllegalStateException("OutputPort is currently running");
            }
            this.scheduler.enablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No Processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = processor.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.STOPPED) {
                return;
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is currently running");
            }
            this.scheduler.enableProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No InputPort with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                return;
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                throw new IllegalStateException("InputPort is currently running");
            }
            this.scheduler.disablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No OutputPort with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = port.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                return;
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                throw new IllegalStateException("OutputPort is currently running");
            }
            this.scheduler.disablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No Processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            org.apache.nifi.controller.ScheduledState state = processor.getScheduledState();
            if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
                return;
            }
            if (state == org.apache.nifi.controller.ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is currently running");
            }
            this.scheduler.disableProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StandardProcessGroup) {
            StandardProcessGroup other = (StandardProcessGroup)obj;
            return this.getIdentifier().equals(other.getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getIdentifier()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("identifier", (Object)this.getIdentifier()).toString();
    }

    public ProcessGroup findProcessGroup(String id) {
        if (Objects.requireNonNull(id).equals(this.getIdentifier())) {
            return this;
        }
        ProcessGroup group = this.flowManager.getGroup(id);
        if (group == null) {
            return null;
        }
        if (this.isOwner(group.getParent())) {
            return group;
        }
        return null;
    }

    public List<ProcessGroup> findAllProcessGroups() {
        return this.findAllProcessGroups(this);
    }

    public List<ProcessGroup> findAllProcessGroups(Predicate<ProcessGroup> filter) {
        ArrayList<ProcessGroup> matching = new ArrayList<ProcessGroup>();
        if (filter.test(this)) {
            matching.add(this);
        }
        for (ProcessGroup group : this.getProcessGroups()) {
            matching.addAll(group.findAllProcessGroups(filter));
        }
        return matching;
    }

    private List<ProcessGroup> findAllProcessGroups(ProcessGroup start) {
        ArrayList<ProcessGroup> allProcessGroups = new ArrayList<ProcessGroup>(start.getProcessGroups());
        for (ProcessGroup childGroup : start.getProcessGroups()) {
            allProcessGroups.addAll(this.findAllProcessGroups(childGroup));
        }
        return allProcessGroups;
    }

    public List<RemoteProcessGroup> findAllRemoteProcessGroups() {
        return this.findAllRemoteProcessGroups(this);
    }

    private List<RemoteProcessGroup> findAllRemoteProcessGroups(ProcessGroup start) {
        ArrayList<RemoteProcessGroup> remoteGroups = new ArrayList<RemoteProcessGroup>(start.getRemoteProcessGroups());
        for (ProcessGroup childGroup : start.getProcessGroups()) {
            remoteGroups.addAll(this.findAllRemoteProcessGroups(childGroup));
        }
        return remoteGroups;
    }

    public RemoteProcessGroup findRemoteProcessGroup(String id) {
        return this.findRemoteProcessGroup(Objects.requireNonNull(id), this);
    }

    private RemoteProcessGroup findRemoteProcessGroup(String id, ProcessGroup start) {
        RemoteProcessGroup remoteGroup = start.getRemoteProcessGroup(id);
        if (remoteGroup != null) {
            return remoteGroup;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            remoteGroup = this.findRemoteProcessGroup(id, group);
            if (remoteGroup == null) continue;
            return remoteGroup;
        }
        return null;
    }

    public ProcessorNode findProcessor(String id) {
        ProcessorNode node = this.flowManager.getProcessorNode(id);
        if (node == null) {
            return null;
        }
        if (this.isOwner(node.getProcessGroup())) {
            return node;
        }
        return null;
    }

    private boolean isOwner(ProcessGroup owner) {
        while (owner != this && owner != null) {
            owner = owner.getParent();
        }
        return owner == this;
    }

    public List<ProcessorNode> findAllProcessors() {
        return this.findAllProcessors(this);
    }

    private List<ProcessorNode> findAllProcessors(ProcessGroup start) {
        ArrayList<ProcessorNode> allNodes = new ArrayList<ProcessorNode>(start.getProcessors());
        for (ProcessGroup group : start.getProcessGroups()) {
            allNodes.addAll(this.findAllProcessors(group));
        }
        return allNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteGroupPort findRemoteGroupPort(String identifier) {
        this.readLock.lock();
        try {
            RemoteGroupPort remoteGroupPort;
            for (RemoteProcessGroup remoteGroup : this.remoteGroups.values()) {
                RemoteGroupPort remoteInPort = remoteGroup.getInputPort(identifier);
                if (remoteInPort != null) {
                    remoteGroupPort = remoteInPort;
                    return remoteGroupPort;
                }
                RemoteGroupPort remoteOutPort = remoteGroup.getOutputPort(identifier);
                if (remoteOutPort == null) continue;
                RemoteGroupPort remoteGroupPort2 = remoteOutPort;
                return remoteGroupPort2;
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                RemoteGroupPort childGroupRemoteGroupPort = childGroup.findRemoteGroupPort(identifier);
                if (childGroupRemoteGroupPort == null) continue;
                remoteGroupPort = childGroupRemoteGroupPort;
                return remoteGroupPort;
            }
            Iterator<RemoteProcessGroup> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Label findLabel(String id) {
        return this.findLabel(id, this);
    }

    private Label findLabel(String id, ProcessGroup start) {
        Label label = start.getLabel(id);
        if (label != null) {
            return label;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            label = this.findLabel(id, group);
            if (label == null) continue;
            return label;
        }
        return null;
    }

    public List<Label> findAllLabels() {
        return this.findAllLabels(this);
    }

    private List<Label> findAllLabels(ProcessGroup start) {
        ArrayList<Label> allLabels = new ArrayList<Label>(start.getLabels());
        for (ProcessGroup group : start.getProcessGroups()) {
            allLabels.addAll(this.findAllLabels(group));
        }
        return allLabels;
    }

    public Port findInputPort(String id) {
        Port port = this.flowManager.getInputPort(id);
        if (port == null) {
            return null;
        }
        if (this.isOwner(port.getProcessGroup())) {
            return port;
        }
        return null;
    }

    public List<Port> findAllInputPorts() {
        return this.findAllInputPorts(this);
    }

    private List<Port> findAllInputPorts(ProcessGroup start) {
        ArrayList<Port> allOutputPorts = new ArrayList<Port>(start.getInputPorts());
        for (ProcessGroup group : start.getProcessGroups()) {
            allOutputPorts.addAll(this.findAllInputPorts(group));
        }
        return allOutputPorts;
    }

    public Port findOutputPort(String id) {
        Port port = this.flowManager.getOutputPort(id);
        if (port == null) {
            return null;
        }
        if (this.isOwner(port.getProcessGroup())) {
            return port;
        }
        return null;
    }

    public List<Port> findAllOutputPorts() {
        return this.findAllOutputPorts(this);
    }

    private List<Port> findAllOutputPorts(ProcessGroup start) {
        ArrayList<Port> allOutputPorts = new ArrayList<Port>(start.getOutputPorts());
        for (ProcessGroup group : start.getProcessGroups()) {
            allOutputPorts.addAll(this.findAllOutputPorts(group));
        }
        return allOutputPorts;
    }

    public List<Funnel> findAllFunnels() {
        return this.findAllFunnels(this);
    }

    private List<Funnel> findAllFunnels(ProcessGroup start) {
        ArrayList<Funnel> allFunnels = new ArrayList<Funnel>(start.getFunnels());
        for (ProcessGroup group : start.getProcessGroups()) {
            allFunnels.addAll(this.findAllFunnels(group));
        }
        return allFunnels;
    }

    public Port getInputPortByName(String name) {
        return this.getPortByName(name, this, new InputPortRetriever());
    }

    public Port getOutputPortByName(String name) {
        return this.getPortByName(name, this, new OutputPortRetriever());
    }

    private Port getPortByName(String name, ProcessGroup group, PortRetriever retriever) {
        for (Port port : retriever.getPorts(group)) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    public void addFunnel(Funnel funnel) {
        this.addFunnel(funnel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunnel(Funnel funnel, boolean autoStart) {
        this.writeLock.lock();
        try {
            Funnel existing = this.funnels.get(Objects.requireNonNull(funnel).getIdentifier());
            if (existing != null) {
                throw new IllegalStateException("A funnel already exists in this ProcessGroup with ID " + funnel.getIdentifier());
            }
            funnel.setProcessGroup((ProcessGroup)this);
            this.funnels.put(funnel.getIdentifier(), funnel);
            this.flowManager.onFunnelAdded(funnel);
            if (autoStart) {
                this.startFunnel(funnel);
            }
            this.onComponentModified();
            LOG.info("{} added to {}", (Object)funnel, (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Funnel getFunnel(String id) {
        this.readLock.lock();
        try {
            Funnel funnel = this.funnels.get(id);
            return funnel;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Funnel findFunnel(String id) {
        Funnel funnel = this.flowManager.getFunnel(id);
        if (funnel == null) {
            return funnel;
        }
        if (this.isOwner(funnel.getProcessGroup())) {
            return funnel;
        }
        return null;
    }

    public ControllerServiceNode findControllerService(String id, boolean includeDescendants, boolean includeAncestors) {
        ControllerServiceNode serviceNode = includeDescendants ? this.findDescendantControllerService(id, this) : this.getControllerService(id);
        if (serviceNode == null && includeAncestors) {
            serviceNode = this.findAncestorControllerService(id, this.getParent());
        }
        return serviceNode;
    }

    private ControllerServiceNode findAncestorControllerService(String id, ProcessGroup start) {
        if (start == null) {
            return null;
        }
        ControllerServiceNode serviceNode = start.getControllerService(id);
        if (serviceNode != null) {
            return serviceNode;
        }
        ProcessGroup parent = start.getParent();
        return this.findAncestorControllerService(id, parent);
    }

    private ControllerServiceNode findDescendantControllerService(String id, ProcessGroup start) {
        ControllerServiceNode service = start.getControllerService(id);
        if (service != null) {
            return service;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            service = this.findDescendantControllerService(id, group);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public Set<ControllerServiceNode> findAllControllerServices() {
        return this.findAllControllerServices(this);
    }

    public Set<ControllerServiceNode> findAllControllerServices(ProcessGroup start) {
        Set services = start.getControllerServices(false);
        for (ProcessGroup group : start.getProcessGroups()) {
            services.addAll(this.findAllControllerServices(group));
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunnel(Funnel funnel) {
        this.writeLock.lock();
        try {
            Funnel existing = this.funnels.get(Objects.requireNonNull(funnel).getIdentifier());
            if (existing == null) {
                throw new IllegalStateException("Funnel " + funnel.getIdentifier() + " is not a member of this ProcessGroup");
            }
            funnel.verifyCanDelete();
            for (Connection conn : funnel.getConnections()) {
                conn.verifyCanDelete();
            }
            this.stopFunnel(funnel);
            HashSet copy = new HashSet(funnel.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            this.funnels.remove(funnel.getIdentifier());
            this.onComponentModified();
            this.flowManager.onFunnelRemoved(funnel);
            LOG.info("{} removed from flow", (Object)funnel);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Funnel> getFunnels() {
        this.readLock.lock();
        try {
            HashSet<Funnel> hashSet = new HashSet<Funnel>(this.funnels.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControllerService(ControllerServiceNode service) {
        this.writeLock.lock();
        try {
            String id = Objects.requireNonNull(service).getIdentifier();
            ControllerServiceNode existingService = this.controllerServices.get(id);
            if (existingService != null) {
                throw new IllegalStateException("A Controller Service is already registered to this ProcessGroup with ID " + id);
            }
            service.setProcessGroup((ProcessGroup)this);
            service.getVariableRegistry().setParent((VariableRegistry)this.getVariableRegistry());
            this.controllerServices.put(service.getIdentifier(), service);
            LOG.info("{} added to {}", (Object)service, (Object)this);
            this.updateControllerServiceReferences((ComponentNode)service);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceNode getControllerService(String id) {
        this.readLock.lock();
        try {
            ControllerServiceNode controllerServiceNode = this.controllerServices.get(Objects.requireNonNull(id));
            return controllerServiceNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<ControllerServiceNode> getControllerServices(boolean recursive) {
        ProcessGroup parentGroup;
        HashSet<ControllerServiceNode> services = new HashSet<ControllerServiceNode>();
        this.readLock.lock();
        try {
            services.addAll(this.controllerServices.values());
        }
        finally {
            this.readLock.unlock();
        }
        if (recursive && (parentGroup = this.parent.get()) != null) {
            services.addAll(parentGroup.getControllerServices(true));
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControllerService(ControllerServiceNode service) {
        boolean removed = false;
        this.writeLock.lock();
        try {
            ControllerServiceNode existing = this.controllerServices.get(Objects.requireNonNull(service).getIdentifier());
            if (existing == null) {
                throw new IllegalStateException("ControllerService " + service.getIdentifier() + " is not a member of this Process Group");
            }
            service.verifyCanDelete();
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), service.getControllerServiceImplementation().getClass(), (String)service.getIdentifier());){
                StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)service, (ControllerServiceLookup)this.controllerServiceProvider, null, this.variableRegistry);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)service.getControllerServiceImplementation(), configurationContext);
            }
            for (Map.Entry entry : service.getEffectivePropertyValues().entrySet()) {
                ControllerServiceNode referencedNode;
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (referencedNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
                referencedNode.removeReference((ComponentNode)service, descriptor);
            }
            this.controllerServices.remove(service.getIdentifier());
            this.onComponentModified();
            service.getReferences().getReferencingComponents().stream().map(ComponentAuthorizable::getProcessGroupIdentifier).filter(id -> !id.equals(this.getIdentifier())).forEach(groupId -> {
                ProcessGroup descendant = this.findProcessGroup((String)groupId);
                if (descendant != null) {
                    descendant.onComponentModified();
                }
            });
            this.flowController.getStateManagerProvider().onComponentRemoved(service.getIdentifier());
            removed = true;
            LOG.info("{} removed from {}", (Object)service, (Object)this);
        }
        finally {
            if (removed) {
                try {
                    this.flowController.getExtensionManager().removeInstanceClassLoader(service.getIdentifier());
                }
                catch (Throwable throwable) {}
            }
            this.writeLock.unlock();
        }
    }

    public void addTemplate(Template template) {
        Objects.requireNonNull(template);
        this.writeLock.lock();
        try {
            String id = template.getDetails().getId();
            if (id == null) {
                throw new IllegalStateException("Cannot add template that has no ID");
            }
            if (this.templates.containsKey(id)) {
                throw new IllegalStateException("Process Group already contains a Template with ID " + id);
            }
            this.templates.put(id, template);
            template.setProcessGroup((ProcessGroup)this);
            LOG.info("{} added to {}", (Object)template, (Object)this);
            this.onComponentModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Template getTemplate(String id) {
        this.readLock.lock();
        try {
            Template template = this.templates.get(id);
            return template;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Template findTemplate(String id) {
        return this.findTemplate(id, this);
    }

    private Template findTemplate(String id, ProcessGroup start) {
        Template template = start.getTemplate(id);
        if (template != null) {
            return template;
        }
        for (ProcessGroup child : start.getProcessGroups()) {
            Template childTemplate = this.findTemplate(id, child);
            if (childTemplate == null) continue;
            return childTemplate;
        }
        return null;
    }

    public Set<Template> getTemplates() {
        this.readLock.lock();
        try {
            HashSet<Template> hashSet = new HashSet<Template>(this.templates.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Template> findAllTemplates() {
        return this.findAllTemplates(this);
    }

    private Set<Template> findAllTemplates(ProcessGroup group) {
        HashSet<Template> templates = new HashSet<Template>(group.getTemplates());
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            templates.addAll(this.findAllTemplates(childGroup));
        }
        return templates;
    }

    public void removeTemplate(Template template) {
        this.writeLock.lock();
        try {
            Template existing = this.templates.get(Objects.requireNonNull(template).getIdentifier());
            if (existing == null) {
                throw new IllegalStateException("Template " + template.getIdentifier() + " is not a member of this ProcessGroup");
            }
            this.templates.remove(template.getIdentifier());
            this.onComponentModified();
            LOG.info("{} removed from flow", (Object)template);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Snippet snippet) {
        this.writeLock.lock();
        try {
            this.verifyContents(snippet);
            Set<Connectable> connectables = this.getAllConnectables(snippet);
            HashSet<String> connectionIdsToRemove = new HashSet<String>(this.getKeys(snippet.getConnections()));
            for (Connectable connectable : connectables) {
                for (Connection conn : connectable.getConnections()) {
                    if (!this.connections.containsKey(conn.getIdentifier())) {
                        throw new IllegalStateException("Connectable component " + connectable.getIdentifier() + " cannot be removed because it has incoming connections from the parent Process Group");
                    }
                    connectionIdsToRemove.add(conn.getIdentifier());
                }
            }
            for (String id : connectionIdsToRemove) {
                this.connections.get(id).verifyCanDelete();
            }
            for (String procId : snippet.getProcessors().keySet()) {
                ProcessorNode procNode = this.getProcessor(procId);
                if (procNode.isRunning()) {
                    throw new IllegalStateException("Processor " + procNode.getIdentifier() + " cannot be removed because it is running");
                }
                int activeThreadCount = this.scheduler.getActiveThreadCount(procNode);
                if (activeThreadCount == 0) continue;
                throw new IllegalStateException("Processor " + procNode.getIdentifier() + " cannot be removed because it still has " + activeThreadCount + " active threads");
            }
            Set connectionIds = snippet.getConnections().keySet();
            for (Connectable connectable : connectables) {
                for (Connection conn : connectable.getIncomingConnections()) {
                    if (connectionIds.contains(conn.getIdentifier()) || connectables.contains(conn.getSource())) continue;
                    throw new IllegalStateException("Connectable component " + connectable.getIdentifier() + " cannot be removed because it has incoming connections that are not selected to be deleted");
                }
            }
            for (String groupId : snippet.getProcessGroups().keySet()) {
                ProcessGroup toRemove = this.getProcessGroup(groupId);
                toRemove.verifyCanDelete(true);
            }
            this.onComponentModified();
            for (String id : connectionIdsToRemove) {
                this.removeConnection(this.connections.get(id));
            }
            for (String id : this.getKeys(snippet.getInputPorts())) {
                this.removeInputPort(this.inputPorts.get(id));
            }
            for (String id : this.getKeys(snippet.getOutputPorts())) {
                this.removeOutputPort(this.outputPorts.get(id));
            }
            for (String id : this.getKeys(snippet.getFunnels())) {
                this.removeFunnel(this.funnels.get(id));
            }
            for (String id : this.getKeys(snippet.getLabels())) {
                this.removeLabel(this.labels.get(id));
            }
            for (String id : this.getKeys(snippet.getProcessors())) {
                this.removeProcessor(this.processors.get(id));
            }
            for (String id : this.getKeys(snippet.getRemoteProcessGroups())) {
                this.removeRemoteProcessGroup(this.remoteGroups.get(id));
            }
            for (String id : this.getKeys(snippet.getProcessGroups())) {
                this.removeProcessGroup(this.processGroups.get(id));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<String> getKeys(Map<String, Revision> map) {
        return map == null ? Collections.emptySet() : map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Snippet snippet, ProcessGroup destination) {
        this.writeLock.lock();
        try {
            this.verifyContents(snippet);
            this.verifyDestinationNotInSnippet(snippet, destination);
            SnippetUtils.verifyNoVersionControlConflicts(snippet, this, destination);
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            if (destination.isRootGroup() && (snippet.getInputPorts().keySet().stream().map(this::getInputPort).anyMatch(port -> port instanceof LocalPort) || snippet.getOutputPorts().keySet().stream().map(this::getOutputPort).anyMatch(port -> port instanceof LocalPort))) {
                throw new IllegalStateException("Cannot move local Ports into the root group");
            }
            this.onComponentModified();
            for (String id : this.getKeys(snippet.getInputPorts())) {
                destination.addInputPort(this.inputPorts.remove(id));
            }
            for (String id : this.getKeys(snippet.getOutputPorts())) {
                destination.addOutputPort(this.outputPorts.remove(id));
            }
            for (String id : this.getKeys(snippet.getFunnels())) {
                destination.addFunnel(this.funnels.remove(id));
            }
            for (String id : this.getKeys(snippet.getLabels())) {
                destination.addLabel(this.labels.remove(id));
            }
            for (String id : this.getKeys(snippet.getProcessGroups())) {
                destination.addProcessGroup(this.processGroups.remove(id));
            }
            for (String id : this.getKeys(snippet.getProcessors())) {
                destination.addProcessor(this.processors.remove(id));
            }
            for (String id : this.getKeys(snippet.getRemoteProcessGroups())) {
                destination.addRemoteProcessGroup(this.remoteGroups.remove(id));
            }
            for (String id : this.getKeys(snippet.getConnections())) {
                destination.inheritConnection(this.connections.remove(id));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<Connectable> getAllConnectables(Snippet snippet) {
        HashSet<Connectable> connectables = new HashSet<Connectable>();
        for (String id : this.getKeys(snippet.getInputPorts())) {
            connectables.add((Connectable)this.getInputPort(id));
        }
        for (String id : this.getKeys(snippet.getOutputPorts())) {
            connectables.add((Connectable)this.getOutputPort(id));
        }
        for (String id : this.getKeys(snippet.getFunnels())) {
            connectables.add((Connectable)this.getFunnel(id));
        }
        for (String id : this.getKeys(snippet.getProcessors())) {
            connectables.add((Connectable)this.getProcessor(id));
        }
        return connectables;
    }

    private boolean isDisconnected(Snippet snippet) {
        Set<Connectable> connectables = this.getAllConnectables(snippet);
        for (String string : this.getKeys(snippet.getRemoteProcessGroups())) {
            RemoteProcessGroup remoteGroup = this.getRemoteProcessGroup(string);
            connectables.addAll(remoteGroup.getInputPorts());
            connectables.addAll(remoteGroup.getOutputPorts());
        }
        Set connectionIds = snippet.getConnections().keySet();
        for (Connectable connectable : connectables) {
            for (Connection conn : connectable.getIncomingConnections()) {
                if (connectionIds.contains(conn.getIdentifier())) continue;
                return false;
            }
            for (Connection conn : connectable.getConnections()) {
                if (connectionIds.contains(conn.getIdentifier())) continue;
                return false;
            }
        }
        HashSet<Connectable> hashSet = new HashSet<Connectable>(connectables);
        for (String id : snippet.getProcessGroups().keySet()) {
            ProcessGroup childGroup = this.getProcessGroup(id);
            hashSet.addAll(this.findAllConnectables(childGroup, true));
        }
        for (String id : connectionIds) {
            Connection connection = this.getConnection(id);
            if (hashSet.contains(connection.getSource()) && hashSet.contains(connection.getDestination())) continue;
            return false;
        }
        return true;
    }

    public Set<Positionable> findAllPositionables() {
        HashSet<Positionable> positionables = new HashSet<Positionable>();
        positionables.addAll(this.findAllConnectables(this, true));
        List<ProcessGroup> allProcessGroups = this.findAllProcessGroups();
        positionables.addAll(allProcessGroups);
        positionables.addAll(this.findAllRemoteProcessGroups());
        positionables.addAll(this.findAllLabels());
        return positionables;
    }

    private Set<Connectable> findAllConnectables(ProcessGroup group, boolean includeRemotePorts) {
        HashSet<Connectable> set = new HashSet<Connectable>();
        set.addAll(group.getInputPorts());
        set.addAll(group.getOutputPorts());
        set.addAll(group.getFunnels());
        set.addAll(group.getProcessors());
        if (includeRemotePorts) {
            for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
                set.addAll(remoteGroup.getInputPorts());
                set.addAll(remoteGroup.getOutputPorts());
            }
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            set.addAll(this.findAllConnectables(childGroup, includeRemotePorts));
        }
        return set;
    }

    private void verifyContents(Snippet snippet) throws NullPointerException, IllegalStateException {
        Objects.requireNonNull(snippet);
        this.verifyAllKeysExist(snippet.getInputPorts().keySet(), this.inputPorts, "Input Port");
        this.verifyAllKeysExist(snippet.getOutputPorts().keySet(), this.outputPorts, "Output Port");
        this.verifyAllKeysExist(snippet.getFunnels().keySet(), this.funnels, "Funnel");
        this.verifyAllKeysExist(snippet.getLabels().keySet(), this.labels, "Label");
        this.verifyAllKeysExist(snippet.getProcessGroups().keySet(), this.processGroups, "Process Group");
        this.verifyAllKeysExist(snippet.getProcessors().keySet(), this.processors, "Processor");
        this.verifyAllKeysExist(snippet.getRemoteProcessGroups().keySet(), this.remoteGroups, "Remote Process Group");
        this.verifyAllKeysExist(snippet.getConnections().keySet(), this.connections, "Connection");
    }

    private void verifyDestinationNotInSnippet(Snippet snippet, ProcessGroup destination) throws IllegalStateException {
        if (snippet.getProcessGroups() != null && destination != null) {
            snippet.getProcessGroups().forEach((processGroupId, revision) -> {
                if (processGroupId.equals(destination.getIdentifier())) {
                    throw new IllegalStateException("Unable to move Process Group into itself.");
                }
            });
        }
    }

    private void verifyAllKeysExist(Set<String> ids, Map<String, ?> map, String componentType) {
        if (ids != null) {
            for (String id : ids) {
                if (map.containsKey(id)) continue;
                throw new IllegalStateException("ID " + id + " does not refer to a(n) " + componentType + " in this ProcessGroup");
            }
        }
    }

    public void verifyCanAddTemplate(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Template name cannot be blank.");
        }
        for (Template template : this.getRoot().findAllTemplates()) {
            TemplateDTO existingDto = template.getDetails();
            if (!name.equals(existingDto.getName())) continue;
            throw new IllegalStateException(String.format("A template named '%s' already exists.", name));
        }
    }

    public void verifyCanDelete() {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            for (Port port : this.inputPorts.values()) {
                port.verifyCanDelete(true);
            }
            for (Port port : this.outputPorts.values()) {
                port.verifyCanDelete(true);
            }
            for (ProcessorNode procNode : this.processors.values()) {
                procNode.verifyCanDelete(true);
            }
            for (Connection connection : this.connections.values()) {
                connection.verifyCanDelete();
            }
            for (ControllerServiceNode cs : this.controllerServices.values()) {
                cs.verifyCanDelete();
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                childGroup.verifyCanDelete(true);
            }
            if (!this.templates.isEmpty()) {
                throw new IllegalStateException(String.format("Cannot delete Process Group because it contains %s Templates. The Templates must be deleted first.", this.templates.size()));
            }
            if (!ignoreConnections) {
                for (Port port : this.inputPorts.values()) {
                    for (Connection connection : port.getIncomingConnections()) {
                        if (connection.getSource().equals(port)) {
                            connection.verifyCanDelete();
                            continue;
                        }
                        throw new IllegalStateException("Cannot delete Process Group because Input Port " + port.getIdentifier() + " has at least one incoming connection from a component outside of the Process Group. Delete this connection first.");
                    }
                }
                for (Port port : this.outputPorts.values()) {
                    for (Connection connection : port.getConnections()) {
                        if (connection.getDestination().equals(port)) {
                            connection.verifyCanDelete();
                            continue;
                        }
                        throw new IllegalStateException("Cannot delete Process Group because Output Port " + port.getIdentifier() + " has at least one outgoing connection to a component outside of the Process Group. Delete this connection first.");
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStop(Connectable connectable) {
        org.apache.nifi.controller.ScheduledState state = connectable.getScheduledState();
        if (state == org.apache.nifi.controller.ScheduledState.DISABLED) {
            throw new IllegalStateException("Cannot stop component with id " + connectable + " because it is currently disabled.");
        }
    }

    public void verifyCanStop() {
    }

    public void verifyCanStart(Connectable connectable) {
        this.readLock.lock();
        try {
            if (connectable.getScheduledState() == org.apache.nifi.controller.ScheduledState.STOPPED) {
                if (this.scheduler.getActiveThreadCount(connectable) > 0) {
                    throw new IllegalStateException("Cannot start component with id" + connectable.getIdentifier() + " because it is currently stopping");
                }
                connectable.verifyCanStart();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStart() {
        this.readLock.lock();
        try {
            for (Connectable connectable : this.findAllConnectables(this, false)) {
                this.verifyCanStart(connectable);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(Snippet snippet) throws IllegalStateException {
        this.readLock.lock();
        try {
            ProcessGroup group;
            Port port;
            if (!this.id.equals(snippet.getParentGroupId())) {
                throw new IllegalStateException("Snippet belongs to ProcessGroup with ID " + snippet.getParentGroupId() + " but this ProcessGroup has id " + this.id);
            }
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            for (String id : snippet.getConnections().keySet()) {
                Connection connection = this.getConnection(id);
                if (connection == null) {
                    throw new IllegalStateException("Snippet references Connection with ID " + id + ", which does not exist in this ProcessGroup");
                }
                connection.verifyCanDelete();
            }
            for (String id : snippet.getFunnels().keySet()) {
                Funnel funnel = this.getFunnel(id);
                if (funnel == null) {
                    throw new IllegalStateException("Snippet references Funnel with ID " + id + ", which does not exist in this ProcessGroup");
                }
                funnel.verifyCanDelete(true);
            }
            for (String id : snippet.getInputPorts().keySet()) {
                port = this.getInputPort(id);
                if (port == null) {
                    throw new IllegalStateException("Snippet references Input Port with ID " + id + ", which does not exist in this ProcessGroup");
                }
                port.verifyCanDelete(true);
            }
            for (String id : snippet.getLabels().keySet()) {
                Label label = this.getLabel(id);
                if (label != null) continue;
                throw new IllegalStateException("Snippet references Label with ID " + id + ", which does not exist in this ProcessGroup");
            }
            for (String id : snippet.getOutputPorts().keySet()) {
                port = this.getOutputPort(id);
                if (port == null) {
                    throw new IllegalStateException("Snippet references Output Port with ID " + id + ", which does not exist in this ProcessGroup");
                }
                port.verifyCanDelete(true);
            }
            for (String id : snippet.getProcessGroups().keySet()) {
                group = this.getProcessGroup(id);
                if (group == null) {
                    throw new IllegalStateException("Snippet references Process Group with ID " + id + ", which does not exist in this ProcessGroup");
                }
                group.verifyCanDelete(true);
            }
            for (String id : snippet.getProcessors().keySet()) {
                ProcessorNode processor = this.getProcessor(id);
                if (processor == null) {
                    throw new IllegalStateException("Snippet references Processor with ID " + id + ", which does not exist in this ProcessGroup");
                }
                processor.verifyCanDelete(true);
            }
            for (String id : snippet.getRemoteProcessGroups().keySet()) {
                group = this.getRemoteProcessGroup(id);
                if (group == null) {
                    throw new IllegalStateException("Snippet references Remote Process Group with ID " + id + ", which does not exist in this ProcessGroup");
                }
                group.verifyCanDelete(true);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanMove(Snippet snippet, ProcessGroup newProcessGroup) throws IllegalStateException {
        this.readLock.lock();
        try {
            String portName;
            Port port;
            if (!this.id.equals(snippet.getParentGroupId())) {
                throw new IllegalStateException("Snippet belongs to ProcessGroup with ID " + snippet.getParentGroupId() + " but this ProcessGroup has id " + this.id);
            }
            this.verifyContents(snippet);
            this.verifyDestinationNotInSnippet(snippet, newProcessGroup);
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            for (String id : snippet.getInputPorts().keySet()) {
                port = this.getInputPort(id);
                portName = port.getName();
                if (newProcessGroup.getInputPortByName(portName) == null) continue;
                throw new IllegalStateException("Cannot perform Move Operation because of a naming conflict with another port in the destination Process Group");
            }
            for (String id : snippet.getOutputPorts().keySet()) {
                port = this.getOutputPort(id);
                portName = port.getName();
                if (newProcessGroup.getOutputPortByName(portName) == null) continue;
                throw new IllegalStateException("Cannot perform Move Operation because of a naming conflict with another port in the destination Process Group");
            }
            ParameterContext currentParameterContext = this.getParameterContext();
            String currentParameterContextId = currentParameterContext == null ? null : currentParameterContext.getIdentifier();
            ParameterContext destinationParameterContext = newProcessGroup.getParameterContext();
            String destinationParameterContextId = destinationParameterContext == null ? null : destinationParameterContext.getIdentifier();
            boolean parameterContextsDiffer = !Objects.equals(currentParameterContextId, destinationParameterContextId);
            Set<ProcessorNode> processors = this.findAllProcessors(snippet);
            for (ProcessorNode processorNode : processors) {
                for (PropertyDescriptor descriptor : processorNode.getProperties().keySet()) {
                    String serviceId;
                    Class serviceDefinition = descriptor.getControllerServiceDefinition();
                    if (serviceDefinition != null && (serviceId = processorNode.getEffectivePropertyValue(descriptor)) != null) {
                        Set currentControllerServiceIds = this.controllerServiceProvider.getControllerServiceIdentifiers(serviceDefinition, this.getIdentifier());
                        Set proposedControllerServiceIds = this.controllerServiceProvider.getControllerServiceIdentifiers(serviceDefinition, newProcessGroup.getIdentifier());
                        if (currentControllerServiceIds.contains(serviceId) && !proposedControllerServiceIds.contains(serviceId)) {
                            throw new IllegalStateException("Cannot perform Move Operation because Processor with ID " + processorNode.getIdentifier() + " references a service that is not available in the destination Process Group");
                        }
                    }
                    if (!parameterContextsDiffer || !processorNode.isRunning() || !processorNode.isReferencingParameter()) continue;
                    throw new IllegalStateException("Cannot perform Move Operation because Processor with ID " + processorNode.getIdentifier() + " references one or more Parameters, and the Processor is running, and the destination Process Group is bound to a different Parameter Context that the current Process Group. This would result in changing the configuration of the Processor while it is running, which is not allowed. You must first stop the Processor before moving it to another Process Group if the destination's Parameter Context is not the same.");
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Set<ProcessorNode> findAllProcessors(Snippet snippet) {
        HashSet<ProcessorNode> processors = new HashSet<ProcessorNode>();
        snippet.getProcessors().keySet().stream().map(this::getProcessor).forEach(processors::add);
        for (String groupId : snippet.getProcessGroups().keySet()) {
            processors.addAll(this.getProcessGroup(groupId).findAllProcessors());
        }
        return processors;
    }

    public ParameterContext getParameterContext() {
        return this.parameterContext;
    }

    public void setParameterContext(ParameterContext parameterContext) {
        this.verifyCanSetParameterContext(parameterContext);
        this.parameterContext = parameterContext;
        this.getProcessors().forEach(AbstractComponentNode::resetValidationState);
        this.getControllerServices(false).forEach(ComponentNode::resetValidationState);
    }

    public void onParameterContextUpdated() {
        this.readLock.lock();
        try {
            for (ProcessorNode processorNode : this.getProcessors()) {
                if (!processorNode.isReferencingParameter() || processorNode.getScheduledState() == org.apache.nifi.controller.ScheduledState.RUNNING) continue;
                processorNode.resetValidationState();
            }
            for (ControllerServiceNode serviceNode : this.getControllerServices(false)) {
                if ((!serviceNode.isReferencingParameter() || serviceNode.getState() != ControllerServiceState.DISABLING) && serviceNode.getState() != ControllerServiceState.DISABLED) continue;
                serviceNode.resetValidationState();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanSetParameterContext(ParameterContext parameterContext) {
        this.readLock.lock();
        try {
            boolean referencingParam;
            if (Objects.equals(parameterContext, this.getParameterContext())) {
                return;
            }
            for (ProcessorNode processor : this.processors.values()) {
                referencingParam = processor.isReferencingParameter();
                if (!referencingParam) continue;
                if (processor.isRunning()) {
                    throw new IllegalStateException("Cannot change Parameter Context for " + this + " because " + processor + " is referencing at least one Parameter and is running");
                }
                this.verifyParameterSensitivityIsValid((ComponentNode)processor, parameterContext);
            }
            for (ControllerServiceNode service : this.controllerServices.values()) {
                referencingParam = service.isReferencingParameter();
                if (!referencingParam) continue;
                if (service.getState() != ControllerServiceState.DISABLED) {
                    throw new IllegalStateException("Cannot change Parameter Context for " + this + " because " + service + " is referencing at least one Parameter and is not disabled");
                }
                this.verifyParameterSensitivityIsValid((ComponentNode)service, parameterContext);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyParameterSensitivityIsValid(ComponentNode component, ParameterContext parameterContext) {
        if (parameterContext == null) {
            return;
        }
        Map properties = component.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            if (configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                String paramName = reference.getParameterName();
                Optional parameter = parameterContext.getParameter(paramName);
                if (!parameter.isPresent()) continue;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
                if (((Parameter)parameter.get()).getDescriptor().isSensitive() && !propertyDescriptor.isSensitive()) {
                    throw new IllegalStateException("Cannot change Parameter Context for " + this + " because " + component + " is referencing Parameter '" + paramName + "' from the '" + propertyDescriptor.getDisplayName() + "' property and the Parameter is sensitive. Sensitive Parameters may only be referenced by sensitive properties.");
                }
                if (((Parameter)parameter.get()).getDescriptor().isSensitive() || !propertyDescriptor.isSensitive()) continue;
                throw new IllegalStateException("Cannot change Parameter Context for " + this + " because " + component + " is referencing Parameter '" + paramName + "' from a sensitive property and the Parameter is not sensitive. Sensitive properties may only reference by Sensitive Parameters.");
            }
        }
    }

    public MutableVariableRegistry getVariableRegistry() {
        return this.variableRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanUpdateVariables(Map<String, String> updatedVariables) {
        if (updatedVariables == null || updatedVariables.isEmpty()) {
            return;
        }
        this.readLock.lock();
        try {
            Set<String> updatedVariableNames = this.getUpdatedVariables(updatedVariables);
            if (updatedVariableNames.isEmpty()) {
                return;
            }
            for (ProcessorNode processor : this.getProcessors()) {
                if (!processor.isRunning()) continue;
                for (VariableImpact impact : this.getVariableImpact((ComponentNode)processor)) {
                    for (String variableName : updatedVariableNames) {
                        if (!impact.isImpacted(variableName)) continue;
                        throw new IllegalStateException("Cannot update variable '" + variableName + "' because it is referenced by " + processor + ", which is currently running");
                    }
                }
            }
            for (ControllerServiceNode service : this.getControllerServices(false)) {
                if (!service.isActive()) continue;
                for (VariableImpact impact : this.getVariableImpact((ComponentNode)service)) {
                    for (String variableName : updatedVariableNames) {
                        if (!impact.isImpacted(variableName)) continue;
                        throw new IllegalStateException("Cannot update variable '" + variableName + "' because it is referenced by " + service + ", which is currently running");
                    }
                }
            }
            for (ProcessGroup childGroup : this.getProcessGroups()) {
                for (String variableName : updatedVariableNames) {
                    ComponentVariableRegistry childRegistry = childGroup.getVariableRegistry();
                    VariableDescriptor descriptor = childRegistry.getVariableKey(variableName);
                    boolean overridden = childRegistry.getVariableMap().containsKey(descriptor);
                    if (overridden) continue;
                    Set affectedComponents = childGroup.getComponentsAffectedByVariable(variableName);
                    for (ComponentNode affectedComponent : affectedComponents) {
                        ReportingTaskNode affectedReportingTask;
                        if (affectedComponent instanceof ProcessorNode) {
                            ProcessorNode affectedProcessor = (ProcessorNode)affectedComponent;
                            if (!affectedProcessor.isRunning()) continue;
                            throw new IllegalStateException("Cannot update variable '" + variableName + "' because it is referenced by " + affectedComponent + ", which is currently running.");
                        }
                        if (affectedComponent instanceof ControllerServiceNode) {
                            ControllerServiceNode affectedService = (ControllerServiceNode)affectedComponent;
                            if (!affectedService.isActive()) continue;
                            throw new IllegalStateException("Cannot update variable '" + variableName + "' because it is referenced by " + affectedComponent + ", which is currently active.");
                        }
                        if (!(affectedComponent instanceof ReportingTaskNode) || !(affectedReportingTask = (ReportingTaskNode)affectedComponent).isRunning()) continue;
                        throw new IllegalStateException("Cannot update variable '" + variableName + "' because it is referenced by " + affectedComponent + ", which is currently running.");
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String componentId) {
        block7: {
            this.writeLock.lock();
            try {
                String currentId = this.versionedComponentId.get();
                if (currentId == null) {
                    this.versionedComponentId.set(componentId);
                    break block7;
                }
                if (currentId.equals(componentId)) {
                    return;
                }
                if (componentId == null) {
                    this.versionedComponentId.set(null);
                    break block7;
                }
                throw new IllegalStateException(this + " is already under version control with a different Versioned Component ID");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public Set<ComponentNode> getComponentsAffectedByVariable(String variableName) {
        HashSet<ComponentNode> affected = new HashSet<ComponentNode>();
        for (ProcessorNode processor : this.getProcessors()) {
            for (VariableImpact impact : this.getVariableImpact((ComponentNode)processor)) {
                if (!impact.isImpacted(variableName)) continue;
                affected.add((ComponentNode)processor);
            }
        }
        for (ControllerServiceNode service : this.getControllerServices(false)) {
            for (VariableImpact impact : this.getVariableImpact((ComponentNode)service)) {
                if (!impact.isImpacted(variableName)) continue;
                affected.add((ComponentNode)service);
                ControllerServiceReference reference = service.getReferences();
                affected.addAll(reference.findRecursiveReferences(ComponentNode.class));
            }
        }
        for (ProcessGroup childGroup : this.getProcessGroups()) {
            ComponentVariableRegistry childRegistry = childGroup.getVariableRegistry();
            VariableDescriptor descriptor = childRegistry.getVariableKey(variableName);
            boolean overridden = childRegistry.getVariableMap().containsKey(descriptor);
            if (overridden) continue;
            affected.addAll(childGroup.getComponentsAffectedByVariable(variableName));
        }
        return affected;
    }

    private Set<String> getUpdatedVariables(Map<String, String> newVariableValues) {
        HashSet<String> updatedVariableNames = new HashSet<String>();
        MutableVariableRegistry registry = this.getVariableRegistry();
        for (Map.Entry<String, String> entry : newVariableValues.entrySet()) {
            String curValue;
            String varName = entry.getKey();
            String newValue = entry.getValue();
            if (Objects.equals(newValue, curValue = registry.getVariableValue(varName))) continue;
            updatedVariableNames.add(varName);
        }
        return updatedVariableNames;
    }

    private List<VariableImpact> getVariableImpact(ComponentNode component) {
        return component.getEffectivePropertyValues().keySet().stream().map(descriptor -> {
            String configuredVal = component.getEffectivePropertyValue(descriptor);
            return configuredVal == null ? descriptor.getDefaultValue() : configuredVal;
        }).map(propVal -> Query.prepare((String)propVal).getVariableImpact()).collect(Collectors.toList());
    }

    public void setVariables(Map<String, String> variables) {
        this.writeLock.lock();
        try {
            this.verifyCanUpdateVariables(variables);
            if (variables == null) {
                return;
            }
            HashMap<VariableDescriptor, String> variableMap = new HashMap<VariableDescriptor, String>();
            variables.forEach((key, value) -> variableMap.put(new VariableDescriptor(key), (String)value));
            this.variableRegistry.setVariables(variableMap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public VersionControlInformation getVersionControlInformation() {
        return this.versionControlInfo.get();
    }

    public void onComponentModified() {
        ProcessGroup parentGroup;
        StandardVersionControlInformation svci = this.versionControlInfo.get();
        if (svci == null && (parentGroup = this.parent.get()) != null) {
            parentGroup.onComponentModified();
        }
        this.versionControlFields.setFlowDifferences(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersionControlInformation(final VersionControlInformation versionControlInformation, Map<String, String> versionedComponentIds) {
        StandardVersionControlInformation svci = new StandardVersionControlInformation(versionControlInformation.getRegistryIdentifier(), versionControlInformation.getRegistryName(), versionControlInformation.getBucketIdentifier(), versionControlInformation.getFlowIdentifier(), versionControlInformation.getVersion(), this.stripContentsFromRemoteDescendantGroups(versionControlInformation.getFlowSnapshot(), true), versionControlInformation.getStatus()){

            @Override
            public String getRegistryName() {
                String registryId = versionControlInformation.getRegistryIdentifier();
                FlowRegistry registry = StandardProcessGroup.this.flowController.getFlowRegistryClient().getFlowRegistry(registryId);
                return registry == null ? registryId : registry.getName();
            }

            private boolean isModified() {
                if (versionControlInformation.getVersion() == 0) {
                    return true;
                }
                Set differences = StandardProcessGroup.this.versionControlFields.getFlowDifferences();
                if (differences == null) {
                    differences = StandardProcessGroup.this.getModifications();
                    if (differences == null) {
                        return false;
                    }
                    StandardProcessGroup.this.versionControlFields.setFlowDifferences(differences);
                }
                return !differences.isEmpty();
            }

            @Override
            public VersionedFlowStatus getStatus() {
                VersionControlInformation vci;
                String syncFailureExplanation = StandardProcessGroup.this.versionControlFields.getSyncFailureExplanation();
                if (syncFailureExplanation != null) {
                    return new StandardVersionedFlowStatus(VersionedFlowState.SYNC_FAILURE, syncFailureExplanation);
                }
                boolean modified = this.isModified();
                if (!modified && (vci = (VersionControlInformation)StandardProcessGroup.this.versionControlInfo.get()).getFlowSnapshot() == null) {
                    return new StandardVersionedFlowStatus(VersionedFlowState.SYNC_FAILURE, "Process Group has not yet been synchronized with Flow Registry");
                }
                boolean stale = StandardProcessGroup.this.versionControlFields.isStale();
                VersionedFlowState flowState = modified && stale ? VersionedFlowState.LOCALLY_MODIFIED_AND_STALE : (modified ? VersionedFlowState.LOCALLY_MODIFIED : (stale ? VersionedFlowState.STALE : VersionedFlowState.UP_TO_DATE));
                return new StandardVersionedFlowStatus(flowState, flowState.getDescription());
            }
        };
        svci.setBucketName(versionControlInformation.getBucketName());
        svci.setFlowName(versionControlInformation.getFlowName());
        svci.setFlowDescription(versionControlInformation.getFlowDescription());
        VersionedFlowState flowState = versionControlInformation.getStatus().getState();
        this.versionControlFields.setStale(flowState == VersionedFlowState.STALE || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE);
        this.versionControlFields.setLocallyModified(flowState == VersionedFlowState.LOCALLY_MODIFIED || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE);
        this.versionControlFields.setSyncFailureExplanation(flowState == VersionedFlowState.SYNC_FAILURE ? versionControlInformation.getStatus().getStateExplanation() : null);
        this.writeLock.lock();
        try {
            this.updateVersionedComponentIds(this, versionedComponentIds);
            this.versionControlInfo.set(svci);
            this.versionControlFields.setFlowDifferences(null);
            ProcessGroup parent = this.getParent();
            if (parent != null) {
                parent.onComponentModified();
            }
            this.scheduler.submitFrameworkTask(() -> this.synchronizeWithFlowRegistry(this.flowController.getFlowRegistryClient()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private VersionedProcessGroup stripContentsFromRemoteDescendantGroups(VersionedProcessGroup processGroup, boolean topLevel) {
        if (processGroup == null) {
            return null;
        }
        VersionedProcessGroup copy = new VersionedProcessGroup();
        copy.setComments(processGroup.getComments());
        copy.setComponentType(processGroup.getComponentType());
        copy.setGroupIdentifier(processGroup.getGroupIdentifier());
        copy.setIdentifier(processGroup.getIdentifier());
        copy.setName(processGroup.getName());
        copy.setPosition(processGroup.getPosition());
        copy.setVersionedFlowCoordinates(topLevel ? null : processGroup.getVersionedFlowCoordinates());
        copy.setConnections(processGroup.getConnections());
        copy.setControllerServices(processGroup.getControllerServices());
        copy.setFunnels(processGroup.getFunnels());
        copy.setInputPorts(processGroup.getInputPorts());
        copy.setOutputPorts(processGroup.getOutputPorts());
        copy.setProcessors(processGroup.getProcessors());
        copy.setRemoteProcessGroups(processGroup.getRemoteProcessGroups());
        copy.setVariables(processGroup.getVariables());
        copy.setLabels(processGroup.getLabels());
        HashSet<VersionedProcessGroup> copyChildren = new HashSet<VersionedProcessGroup>();
        for (VersionedProcessGroup childGroup : processGroup.getProcessGroups()) {
            if (childGroup.getVersionedFlowCoordinates() == null) {
                copyChildren.add(this.stripContentsFromRemoteDescendantGroups(childGroup, false));
                continue;
            }
            VersionedProcessGroup childCopy = new VersionedProcessGroup();
            childCopy.setComments(childGroup.getComments());
            childCopy.setComponentType(childGroup.getComponentType());
            childCopy.setGroupIdentifier(childGroup.getGroupIdentifier());
            childCopy.setIdentifier(childGroup.getIdentifier());
            childCopy.setName(childGroup.getName());
            childCopy.setPosition(childGroup.getPosition());
            childCopy.setVersionedFlowCoordinates(childGroup.getVersionedFlowCoordinates());
            copyChildren.add(childCopy);
        }
        copy.setProcessGroups(copyChildren);
        return copy;
    }

    public void disconnectVersionControl(boolean removeVersionedComponentIds) {
        this.writeLock.lock();
        try {
            this.versionControlInfo.set(null);
            if (removeVersionedComponentIds) {
                this.applyVersionedComponentIds(this, id -> null);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateVersionedComponentIds(ProcessGroup processGroup, Map<String, String> versionedComponentIds) {
        if (versionedComponentIds == null || versionedComponentIds.isEmpty()) {
            return;
        }
        this.applyVersionedComponentIds(processGroup, versionedComponentIds::get);
        ProcessGroup parent = processGroup.getParent();
        if (parent != null) {
            for (ControllerServiceNode service : parent.getControllerServices(true)) {
                String versionedId;
                if (service.getVersionedComponentId().isPresent() || (versionedId = versionedComponentIds.get(service.getIdentifier())) == null) continue;
                service.setVersionedComponentId(versionedId);
            }
        }
    }

    private void applyVersionedComponentIds(ProcessGroup processGroup, Function<String, String> lookup) {
        processGroup.setVersionedComponentId(lookup.apply(processGroup.getIdentifier()));
        processGroup.getConnections().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getProcessors().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getInputPorts().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getOutputPorts().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getLabels().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getFunnels().forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getControllerServices(false).forEach(component -> component.setVersionedComponentId((String)lookup.apply(component.getIdentifier())));
        processGroup.getRemoteProcessGroups().forEach(rpg -> {
            rpg.setVersionedComponentId((String)lookup.apply(rpg.getIdentifier()));
            rpg.getInputPorts().forEach(port -> port.setVersionedComponentId((String)lookup.apply(port.getIdentifier())));
            rpg.getOutputPorts().forEach(port -> port.setVersionedComponentId((String)lookup.apply(port.getIdentifier())));
        });
        for (ProcessGroup childGroup : processGroup.getProcessGroups()) {
            if (childGroup.getVersionControlInformation() == null) {
                this.applyVersionedComponentIds(childGroup, lookup);
                continue;
            }
            if (childGroup.getVersionedComponentId().isPresent()) continue;
            childGroup.setVersionedComponentId(lookup.apply(childGroup.getIdentifier()));
        }
    }

    public void synchronizeWithFlowRegistry(FlowRegistryClient flowRegistryClient) {
        StandardVersionControlInformation vci = this.versionControlInfo.get();
        if (vci == null) {
            return;
        }
        String registryId = vci.getRegistryIdentifier();
        FlowRegistry flowRegistry = flowRegistryClient.getFlowRegistry(registryId);
        if (flowRegistry == null) {
            String message = String.format("Unable to synchronize Process Group with Flow Registry because Process Group was placed under Version Control using Flow Registry with identifier %s but cannot find any Flow Registry with this identifier", registryId);
            this.versionControlFields.setSyncFailureExplanation(message);
            LOG.error("Unable to synchronize {} with Flow Registry because Process Group was placed under Version Control using Flow Registry with identifier {} but cannot find any Flow Registry with this identifier", (Object)this, (Object)registryId);
            return;
        }
        VersionedProcessGroup snapshot = vci.getFlowSnapshot();
        if (snapshot == null && vci.getVersion() > 0) {
            try {
                VersionedFlowSnapshot registrySnapshot = flowRegistry.getFlowContents(vci.getBucketIdentifier(), vci.getFlowIdentifier(), vci.getVersion(), false);
                VersionedProcessGroup registryFlow = registrySnapshot.getFlowContents();
                vci.setFlowSnapshot(registryFlow);
            }
            catch (IOException | NiFiRegistryException e) {
                String message = String.format("Failed to synchronize Process Group with Flow Registry because could not retrieve version %s of flow with identifier %s in bucket %s", vci.getVersion(), vci.getFlowIdentifier(), vci.getBucketIdentifier());
                this.versionControlFields.setSyncFailureExplanation(message);
                String logErrorMessage = "Failed to synchronize {} with Flow Registry because could not retrieve version {} of flow with identifier {} in bucket {}";
                if (e instanceof ConnectException) {
                    LOG.error("Failed to synchronize {} with Flow Registry because could not retrieve version {} of flow with identifier {} in bucket {} due to: {}", new Object[]{this, vci.getVersion(), vci.getFlowIdentifier(), vci.getBucketIdentifier(), e.getLocalizedMessage()});
                } else {
                    LOG.error("Failed to synchronize {} with Flow Registry because could not retrieve version {} of flow with identifier {} in bucket {}", new Object[]{this, vci.getVersion(), vci.getFlowIdentifier(), vci.getBucketIdentifier(), e});
                }
                return;
            }
        }
        try {
            VersionedFlow versionedFlow = flowRegistry.getVersionedFlow(vci.getBucketIdentifier(), vci.getFlowIdentifier());
            int latestVersion = (int)versionedFlow.getVersionCount();
            vci.setBucketName(versionedFlow.getBucketName());
            vci.setFlowName(versionedFlow.getName());
            vci.setFlowDescription(versionedFlow.getDescription());
            vci.setRegistryName(flowRegistry.getName());
            if (latestVersion == vci.getVersion()) {
                this.versionControlFields.setStale(false);
                if (latestVersion == 0) {
                    LOG.debug("{} does not have any version in the Registry", (Object)this);
                    this.versionControlFields.setLocallyModified(true);
                } else {
                    LOG.debug("{} is currently at the most recent version ({}) of the flow that is under Version Control", (Object)this, (Object)latestVersion);
                }
            } else {
                LOG.info("{} is not the most recent version of the flow that is under Version Control; current version is {}; most recent version is {}", new Object[]{this, vci.getVersion(), latestVersion});
                this.versionControlFields.setStale(true);
            }
            this.versionControlFields.setSyncFailureExplanation(null);
        }
        catch (IOException | NiFiRegistryException e) {
            String message = String.format("Failed to synchronize Process Group with Flow Registry : " + e.getMessage(), new Object[0]);
            this.versionControlFields.setSyncFailureExplanation(message);
            LOG.error("Failed to synchronize {} with Flow Registry because could not determine the most recent version of the Flow in the Flow Registry", (Object)this, (Object)e);
        }
    }

    public void updateFlow(VersionedFlowSnapshot proposedSnapshot, String componentIdSeed, boolean verifyNotDirty, boolean updateSettings, boolean updateDescendantVersionedFlows) {
        this.writeLock.lock();
        try {
            this.verifyCanUpdate(proposedSnapshot, true, verifyNotDirty);
            NiFiRegistryFlowMapper mapper = new NiFiRegistryFlowMapper(this.flowController.getExtensionManager());
            InstantiatedVersionedProcessGroup versionedGroup = mapper.mapProcessGroup(this, this.controllerServiceProvider, this.flowController.getFlowRegistryClient(), true);
            StandardComparableDataFlow localFlow = new StandardComparableDataFlow("Local Flow", (VersionedProcessGroup)versionedGroup);
            StandardComparableDataFlow remoteFlow = new StandardComparableDataFlow("Remote Flow", proposedSnapshot.getFlowContents());
            StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)remoteFlow, (ComparableDataFlow)localFlow, this.getAncestorGroupServiceIds(), (DifferenceDescriptor)new StaticDifferenceDescriptor());
            FlowComparison flowComparison = flowComparator.compare();
            HashSet<String> updatedVersionedComponentIds = new HashSet<String>();
            for (FlowDifference diff : flowComparison.getDifferences()) {
                VersionedComponent component;
                if (diff.getDifferenceType() == DifferenceType.BUNDLE_CHANGED) continue;
                if (diff.getDifferenceType() == DifferenceType.COMPONENT_ADDED) {
                    ControllerServiceNode serviceNode;
                    VersionedComponent versionedComponent = component = diff.getComponentA() == null ? diff.getComponentB() : diff.getComponentA();
                    if (ComponentType.CONTROLLER_SERVICE == component.getComponentType() && (serviceNode = this.getVersionedControllerService(this, component.getIdentifier())) != null) {
                        VersionedControllerService versionedService = mapper.mapControllerService(serviceNode, this.controllerServiceProvider, Collections.singleton(serviceNode.getProcessGroupIdentifier()), new HashMap<String, ExternalControllerServiceReference>());
                        Set differences = flowComparator.compareControllerServices(versionedService, (VersionedControllerService)component);
                        if (differences.isEmpty()) continue;
                        updatedVersionedComponentIds.add(component.getIdentifier());
                        continue;
                    }
                }
                component = diff.getComponentA() == null ? diff.getComponentB() : diff.getComponentA();
                updatedVersionedComponentIds.add(component.getIdentifier());
                if (component.getComponentType() != ComponentType.REMOTE_INPUT_PORT && component.getComponentType() != ComponentType.REMOTE_OUTPUT_PORT) continue;
                String remoteGroupId = ((VersionedRemoteGroupPort)component).getRemoteGroupId();
                updatedVersionedComponentIds.add(remoteGroupId);
            }
            if (LOG.isInfoEnabled()) {
                String differencesByLine = flowComparison.getDifferences().stream().map(Object::toString).collect(Collectors.joining("\n"));
                LOG.info("Updating {} to {}; there are {} differences to take into account:\n{}", new Object[]{this, proposedSnapshot, flowComparison.getDifferences().size(), differencesByLine});
            }
            Set<String> knownVariables = this.getKnownVariableNames();
            StandardVersionControlInformation originalVci = this.versionControlInfo.get();
            try {
                this.updateProcessGroup(this, proposedSnapshot.getFlowContents(), componentIdSeed, updatedVersionedComponentIds, false, updateSettings, updateDescendantVersionedFlows, knownVariables, proposedSnapshot.getParameterContexts());
            }
            catch (Throwable t) {
                if (this.versionControlInfo.get() == null) {
                    this.versionControlInfo.set(originalVci);
                }
                throw t;
            }
        }
        catch (ProcessorInstantiationException pie) {
            throw new IllegalStateException("Failed to update flow", pie);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<String> getAncestorGroupServiceIds() {
        ProcessGroup parentGroup = this.getParent();
        Set<String> ancestorServiceIds = parentGroup == null ? Collections.emptySet() : parentGroup.getControllerServices(true).stream().map(cs -> {
            Optional versionedId = cs.getVersionedComponentId();
            if (versionedId.isPresent()) {
                return (String)versionedId.get();
            }
            return UUID.nameUUIDFromBytes(cs.getIdentifier().getBytes(StandardCharsets.UTF_8)).toString();
        }).collect(Collectors.toSet());
        return ancestorServiceIds;
    }

    private ControllerServiceNode getVersionedControllerService(ProcessGroup group, String versionedComponentId) {
        if (group == null) {
            return null;
        }
        for (ControllerServiceNode serviceNode : group.getControllerServices(false)) {
            if (!serviceNode.getVersionedComponentId().isPresent() || !((String)serviceNode.getVersionedComponentId().get()).equals(versionedComponentId)) continue;
            return serviceNode;
        }
        return this.getVersionedControllerService(group.getParent(), versionedComponentId);
    }

    private Set<String> getKnownVariableNames() {
        HashSet<String> variableNames = new HashSet<String>();
        this.populateKnownVariableNames(this, variableNames);
        return variableNames;
    }

    private void populateKnownVariableNames(ProcessGroup group, Set<String> knownVariables) {
        group.getVariableRegistry().getVariableMap().keySet().stream().map(VariableDescriptor::getName).forEach(knownVariables::add);
        ProcessGroup parent = group.getParent();
        if (parent != null) {
            this.populateKnownVariableNames(parent, knownVariables);
        }
    }

    private void updateProcessGroup(ProcessGroup group, VersionedProcessGroup proposed, String componentIdSeed, Set<String> updatedVersionedComponentIds, boolean updatePosition, boolean updateName, boolean updateDescendantVersionedGroups, Set<String> variablesToSkip, Map<String, VersionedParameterContext> versionedParameterContexts) throws ProcessorInstantiationException {
        Port port;
        Connection connection;
        ProcessGroup added;
        Object service;
        HashMap<Object, String> proposedPortFinalNames = new HashMap<Object, String>();
        group.setComments(proposed.getComments());
        if (updateName) {
            group.setName(proposed.getName());
        }
        if (updatePosition && proposed.getPosition() != null) {
            group.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        }
        this.updateParameterContext(group, proposed, versionedParameterContexts, componentIdSeed);
        this.updateVariableRegistry(group, proposed, variablesToSkip);
        VersionedFlowCoordinates remoteCoordinates = proposed.getVersionedFlowCoordinates();
        if (remoteCoordinates == null) {
            group.disconnectVersionControl(false);
        } else {
            String registryId = this.flowController.getFlowRegistryClient().getFlowRegistryId(remoteCoordinates.getRegistryUrl());
            String bucketId = remoteCoordinates.getBucketId();
            String flowId = remoteCoordinates.getFlowId();
            int version = remoteCoordinates.getVersion();
            FlowRegistry flowRegistry = this.flowController.getFlowRegistryClient().getFlowRegistry(registryId);
            String string = flowRegistry == null ? registryId : flowRegistry.getName();
            VersionedFlowState flowState = remoteCoordinates.getLatest() != false ? VersionedFlowState.UP_TO_DATE : VersionedFlowState.STALE;
            StandardVersionControlInformation vci = new StandardVersionControlInformation.Builder().registryId(registryId).registryName(string).bucketId(bucketId).bucketName(bucketId).flowId(flowId).flowName(flowId).version(version).flowSnapshot(proposed).status(new StandardVersionedFlowStatus(flowState, flowState.getDescription())).build();
            group.setVersionControlInformation((VersionControlInformation)vci, Collections.emptyMap());
        }
        Map servicesByVersionedId = group.getControllerServices(false).stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> controllerServicesRemoved = new HashSet<String>(servicesByVersionedId.keySet());
        HashMap<ControllerServiceNode, VersionedControllerService> services = new HashMap<ControllerServiceNode, VersionedControllerService>();
        HashMap<String, ControllerServiceNode> servicesAdded = new HashMap<String, ControllerServiceNode>();
        for (VersionedControllerService versionedControllerService : proposed.getControllerServices()) {
            service = (ControllerServiceNode)servicesByVersionedId.get(versionedControllerService.getIdentifier());
            if (service == null) {
                service = this.addControllerService(group, versionedControllerService, componentIdSeed);
                LOG.info("Added {} to {}", service, (Object)this);
                servicesAdded.put(versionedControllerService.getIdentifier(), (ControllerServiceNode)service);
            }
            services.put((ControllerServiceNode)service, versionedControllerService);
        }
        for (VersionedControllerService versionedControllerService : proposed.getControllerServices()) {
            ControllerServiceNode addedService = (ControllerServiceNode)servicesAdded.get(versionedControllerService.getIdentifier());
            if (addedService == null) continue;
            this.updateControllerService(addedService, versionedControllerService);
        }
        for (Map.Entry entry : services.entrySet()) {
            service = (ControllerServiceNode)entry.getKey();
            VersionedControllerService proposedService = (VersionedControllerService)entry.getValue();
            if (updatedVersionedComponentIds.contains(proposedService.getIdentifier())) {
                this.updateControllerService((ControllerServiceNode)service, proposedService);
                LOG.info("Updated {}", service);
            }
            controllerServicesRemoved.remove(proposedService.getIdentifier());
        }
        Map childGroupsByVersionedId = group.getProcessGroups().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> hashSet = new HashSet<String>(childGroupsByVersionedId.keySet());
        for (VersionedProcessGroup proposedChildGroup : proposed.getProcessGroups()) {
            ProcessGroup childGroup = (ProcessGroup)childGroupsByVersionedId.get(proposedChildGroup.getIdentifier());
            VersionedFlowCoordinates childCoordinates = proposedChildGroup.getVersionedFlowCoordinates();
            Map<String, VersionedParameterContext> childParameterContexts = versionedParameterContexts;
            if (childCoordinates != null && updateDescendantVersionedGroups) {
                childParameterContexts = this.getVersionedParameterContexts(childCoordinates);
            }
            if (childGroup == null) {
                added = this.addProcessGroup(group, proposedChildGroup, componentIdSeed, variablesToSkip, childParameterContexts);
                this.flowManager.onProcessGroupAdded(added);
                added.findAllRemoteProcessGroups().forEach(RemoteProcessGroup::initialize);
                LOG.info("Added {} to {}", (Object)added, (Object)this);
            } else if (childCoordinates == null || updateDescendantVersionedGroups) {
                this.updateProcessGroup(childGroup, proposedChildGroup, componentIdSeed, updatedVersionedComponentIds, true, true, updateDescendantVersionedGroups, variablesToSkip, childParameterContexts);
                LOG.info("Updated {}", (Object)childGroup);
            }
            hashSet.remove(proposedChildGroup.getIdentifier());
        }
        Map funnelsByVersionedId = group.getFunnels().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> funnelsRemoved = new HashSet<String>(funnelsByVersionedId.keySet());
        for (VersionedFunnel proposedFunnel : proposed.getFunnels()) {
            Funnel funnel = (Funnel)funnelsByVersionedId.get(proposedFunnel.getIdentifier());
            if (funnel == null) {
                added = this.addFunnel(group, proposedFunnel, componentIdSeed);
                this.flowManager.onFunnelAdded((Funnel)added);
                LOG.info("Added {} to {}", (Object)added, (Object)this);
            } else if (updatedVersionedComponentIds.contains(proposedFunnel.getIdentifier())) {
                this.updateFunnel(funnel, proposedFunnel);
                LOG.info("Updated {}", (Object)funnel);
            } else {
                funnel.setPosition(new Position(proposedFunnel.getPosition().getX(), proposedFunnel.getPosition().getY()));
            }
            funnelsRemoved.remove(proposedFunnel.getIdentifier());
        }
        Map inputPortsByVersionedId = group.getInputPorts().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> inputPortsRemoved = new HashSet<String>(inputPortsByVersionedId.keySet());
        for (VersionedPort proposedPort : proposed.getInputPorts()) {
            String temporaryName;
            Port port2 = (Port)inputPortsByVersionedId.get(proposedPort.getIdentifier());
            if (port2 == null) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                Port added2 = this.addInputPort(group, proposedPort, componentIdSeed, temporaryName);
                proposedPortFinalNames.put(added2, proposedPort.getName());
                this.flowManager.onInputPortAdded(added2);
                LOG.info("Added {} to {}", (Object)added2, (Object)this);
            } else if (updatedVersionedComponentIds.contains(proposedPort.getIdentifier())) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                proposedPortFinalNames.put(port2, proposedPort.getName());
                this.updatePort(port2, proposedPort, temporaryName);
                LOG.info("Updated {}", (Object)port2);
            } else {
                port2.setPosition(new Position(proposedPort.getPosition().getX(), proposedPort.getPosition().getY()));
            }
            inputPortsRemoved.remove(proposedPort.getIdentifier());
        }
        Map outputPortsByVersionedId = group.getOutputPorts().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> outputPortsRemoved = new HashSet<String>(outputPortsByVersionedId.keySet());
        for (VersionedPort proposedPort : proposed.getOutputPorts()) {
            String temporaryName;
            Port port3 = (Port)outputPortsByVersionedId.get(proposedPort.getIdentifier());
            if (port3 == null) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                Port added3 = this.addOutputPort(group, proposedPort, componentIdSeed, temporaryName);
                proposedPortFinalNames.put(added3, proposedPort.getName());
                this.flowManager.onOutputPortAdded(added3);
                LOG.info("Added {} to {}", (Object)added3, (Object)this);
            } else if (updatedVersionedComponentIds.contains(proposedPort.getIdentifier())) {
                temporaryName = this.generateTemporaryPortName(proposedPort);
                proposedPortFinalNames.put(port3, proposedPort.getName());
                this.updatePort(port3, proposedPort, temporaryName);
                LOG.info("Updated {}", (Object)port3);
            } else {
                port3.setPosition(new Position(proposedPort.getPosition().getX(), proposedPort.getPosition().getY()));
            }
            outputPortsRemoved.remove(proposedPort.getIdentifier());
        }
        Map labelsByVersionedId = group.getLabels().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> labelsRemoved = new HashSet<String>(labelsByVersionedId.keySet());
        for (VersionedLabel proposedLabel : proposed.getLabels()) {
            Label label = (Label)labelsByVersionedId.get(proposedLabel.getIdentifier());
            if (label == null) {
                Label added4 = this.addLabel(group, proposedLabel, componentIdSeed);
                LOG.info("Added {} to {}", (Object)added4, (Object)this);
            } else if (updatedVersionedComponentIds.contains(proposedLabel.getIdentifier())) {
                this.updateLabel(label, proposedLabel);
                LOG.info("Updated {}", (Object)label);
            } else {
                label.setPosition(new Position(proposedLabel.getPosition().getX(), proposedLabel.getPosition().getY()));
            }
            labelsRemoved.remove(proposedLabel.getIdentifier());
        }
        Map processorsByVersionedId = group.getProcessors().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> processorsRemoved = new HashSet<String>(processorsByVersionedId.keySet());
        HashMap<Object, Set> autoTerminatedRelationships = new HashMap<Object, Set>();
        for (VersionedProcessor proposedProcessor : proposed.getProcessors()) {
            ProcessorNode processor = (ProcessorNode)processorsByVersionedId.get(proposedProcessor.getIdentifier());
            if (processor == null) {
                ProcessorNode added5 = this.addProcessor(group, proposedProcessor, componentIdSeed);
                this.flowManager.onProcessorAdded(added5);
                Set proposedAutoTerminated = proposedProcessor.getAutoTerminatedRelationships() == null ? Collections.emptySet() : proposedProcessor.getAutoTerminatedRelationships().stream().map(arg_0 -> ((ProcessorNode)added5).getRelationship(arg_0)).collect(Collectors.toSet());
                autoTerminatedRelationships.put(added5, proposedAutoTerminated);
                LOG.info("Added {} to {}", (Object)added5, (Object)this);
            } else if (updatedVersionedComponentIds.contains(proposedProcessor.getIdentifier())) {
                Set proposedAutoTerminated;
                this.updateProcessor(processor, proposedProcessor);
                Set set = proposedAutoTerminated = proposedProcessor.getAutoTerminatedRelationships() == null ? Collections.emptySet() : proposedProcessor.getAutoTerminatedRelationships().stream().map(arg_0 -> ((ProcessorNode)processor).getRelationship(arg_0)).collect(Collectors.toSet());
                if (!processor.getAutoTerminatedRelationships().equals(proposedAutoTerminated)) {
                    autoTerminatedRelationships.put(processor, proposedAutoTerminated);
                }
                LOG.info("Updated {}", (Object)processor);
            } else {
                processor.setPosition(new Position(proposedProcessor.getPosition().getX(), proposedProcessor.getPosition().getY()));
            }
            processorsRemoved.remove(proposedProcessor.getIdentifier());
        }
        Map rpgsByVersionedId = group.getRemoteProcessGroups().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> rpgsRemoved = new HashSet<String>(rpgsByVersionedId.keySet());
        for (VersionedRemoteProcessGroup proposedRpg : proposed.getRemoteProcessGroups()) {
            RemoteProcessGroup rpg = (RemoteProcessGroup)rpgsByVersionedId.get(proposedRpg.getIdentifier());
            if (rpg == null) {
                RemoteProcessGroup remoteProcessGroup = this.addRemoteProcessGroup(group, proposedRpg, componentIdSeed);
                LOG.info("Added {} to {}", (Object)remoteProcessGroup, (Object)this);
            } else if (updatedVersionedComponentIds.contains(proposedRpg.getIdentifier())) {
                this.updateRemoteProcessGroup(rpg, proposedRpg, componentIdSeed);
                LOG.info("Updated {}", (Object)rpg);
            } else {
                rpg.setPosition(new Position(proposedRpg.getPosition().getX(), proposedRpg.getPosition().getY()));
            }
            rpgsRemoved.remove(proposedRpg.getIdentifier());
        }
        Map connectionsByVersionedId = group.getConnections().stream().collect(Collectors.toMap(component -> component.getVersionedComponentId().orElse(component.getIdentifier()), Function.identity()));
        HashSet<String> connectionsRemoved = new HashSet<String>(connectionsByVersionedId.keySet());
        for (VersionedConnection versionedConnection : proposed.getConnections()) {
            connection = (Connection)connectionsByVersionedId.get(versionedConnection.getIdentifier());
            if (connection == null) {
                Connection added7 = this.addConnection(group, versionedConnection, componentIdSeed);
                this.flowManager.onConnectionAdded(added7);
                LOG.info("Added {} to {}", (Object)added7, (Object)this);
            } else if (this.isUpdateable(connection)) {
                this.updateConnection(connection, versionedConnection);
                LOG.info("Updated {}", (Object)connection);
            }
            connectionsRemoved.remove(versionedConnection.getIdentifier());
        }
        for (String string : connectionsRemoved) {
            connection = (Connection)connectionsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)connection, (Object)group);
            group.removeConnection(connection);
            this.flowManager.onConnectionRemoved(connection);
        }
        autoTerminatedRelationships.forEach(ProcessorNode::setAutoTerminatedRelationships);
        for (String string : controllerServicesRemoved) {
            ControllerServiceNode service2 = (ControllerServiceNode)servicesByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)service2, (Object)group);
            this.flowController.getControllerServiceProvider().removeControllerService(service2);
        }
        for (String string : funnelsRemoved) {
            Funnel funnel = (Funnel)funnelsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)funnel, (Object)group);
            group.removeFunnel(funnel);
        }
        for (String string : inputPortsRemoved) {
            port = (Port)inputPortsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)port, (Object)group);
            group.removeInputPort(port);
        }
        for (String string : outputPortsRemoved) {
            port = (Port)outputPortsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)port, (Object)group);
            group.removeOutputPort(port);
        }
        for (Map.Entry entry : proposedPortFinalNames.entrySet()) {
            port = (Port)entry.getKey();
            String finalName = (String)entry.getValue();
            LOG.info("Updating {} to replace temporary name with final name", (Object)port);
            if (port instanceof PublicPort) {
                PublicPort publicPort = (PublicPort)port;
                String publicPortFinalName = this.getPublicPortFinalName(publicPort, finalName);
                this.updatePortToSetFinalName((Port)publicPort, publicPortFinalName);
                continue;
            }
            this.updatePortToSetFinalName(port, finalName);
        }
        for (String string : labelsRemoved) {
            Label label = (Label)labelsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)label, (Object)group);
            group.removeLabel(label);
        }
        for (String string : processorsRemoved) {
            ProcessorNode processor = (ProcessorNode)processorsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)processor, (Object)group);
            group.removeProcessor(processor);
        }
        for (String string : rpgsRemoved) {
            RemoteProcessGroup rpg = (RemoteProcessGroup)rpgsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)rpg, (Object)group);
            group.removeRemoteProcessGroup(rpg);
        }
        for (String string : hashSet) {
            ProcessGroup childGroup = (ProcessGroup)childGroupsByVersionedId.get(string);
            LOG.info("Removing {} from {}", (Object)childGroup, (Object)group);
            group.removeProcessGroup(childGroup);
        }
    }

    private Map<String, VersionedParameterContext> getVersionedParameterContexts(VersionedFlowCoordinates versionedFlowCoordinates) {
        FlowRegistryClient flowRegistryClient = this.flowController.getFlowRegistryClient();
        String registryId = flowRegistryClient.getFlowRegistryId(versionedFlowCoordinates.getRegistryUrl());
        if (registryId == null) {
            throw new ResourceNotFoundException("Could not find any Flow Registry registered with url: " + versionedFlowCoordinates.getRegistryUrl());
        }
        FlowRegistry flowRegistry = flowRegistryClient.getFlowRegistry(registryId);
        if (flowRegistry == null) {
            throw new ResourceNotFoundException("Could not find any Flow Registry registered with identifier " + registryId);
        }
        String bucketId = versionedFlowCoordinates.getBucketId();
        String flowId = versionedFlowCoordinates.getFlowId();
        int flowVersion = versionedFlowCoordinates.getVersion();
        try {
            VersionedFlowSnapshot childSnapshot = flowRegistry.getFlowContents(bucketId, flowId, flowVersion, false);
            return childSnapshot.getParameterContexts();
        }
        catch (NiFiRegistryException e) {
            throw new IllegalArgumentException("The Flow Registry with ID " + registryId + " reports that no Flow exists with Bucket " + bucketId + ", Flow " + flowId + ", Version " + flowVersion);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to communicate with Flow Registry when attempting to retrieve a versioned flow");
        }
    }

    private ParameterContext createParameterContext(VersionedParameterContext versionedParameterContext, String parameterContextId) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (VersionedParameter versionedParameter : versionedParameterContext.getParameters()) {
            ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(versionedParameter.getName()).description(versionedParameter.getDescription()).sensitive(versionedParameter.isSensitive()).build();
            Parameter parameter = new Parameter(descriptor, versionedParameter.getValue());
            parameters.put(versionedParameter.getName(), parameter);
        }
        return this.flowController.getFlowManager().createParameterContext(parameterContextId, versionedParameterContext.getName(), parameters);
    }

    private void addMissingParameters(VersionedParameterContext versionedParameterContext, ParameterContext currentParameterContext) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (VersionedParameter versionedParameter : versionedParameterContext.getParameters()) {
            Optional parameterOption = currentParameterContext.getParameter(versionedParameter.getName());
            if (parameterOption.isPresent()) continue;
            ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(versionedParameter.getName()).description(versionedParameter.getDescription()).sensitive(versionedParameter.isSensitive()).build();
            Parameter parameter = new Parameter(descriptor, versionedParameter.getValue());
            parameters.put(versionedParameter.getName(), parameter);
        }
        currentParameterContext.setParameters(parameters);
    }

    private ParameterContext getParameterContextByName(String contextName) {
        return this.flowController.getFlowManager().getParameterContextManager().getParameterContexts().stream().filter(context -> context.getName().equals(contextName)).findAny().orElse(null);
    }

    private void updateParameterContext(ProcessGroup group, VersionedProcessGroup proposed, Map<String, VersionedParameterContext> versionedParameterContexts, String componentIdSeed) {
        ParameterContext currentParamContext = group.getParameterContext();
        String proposedParameterContextName = proposed.getParameterContextName();
        if (proposedParameterContextName != null) {
            if (currentParamContext == null) {
                ParameterContext selectedParameterContext;
                VersionedParameterContext versionedParameterContext = versionedParameterContexts.get(proposedParameterContextName);
                ParameterContext contextByName = this.getParameterContextByName(versionedParameterContext.getName());
                if (contextByName == null) {
                    String parameterContextId = this.generateUuid(versionedParameterContext.getName(), versionedParameterContext.getName(), componentIdSeed);
                    selectedParameterContext = this.createParameterContext(versionedParameterContext, parameterContextId);
                } else {
                    selectedParameterContext = contextByName;
                    this.addMissingParameters(versionedParameterContext, selectedParameterContext);
                }
                group.setParameterContext(selectedParameterContext);
            } else {
                VersionedParameterContext versionedParameterContext = versionedParameterContexts.get(proposedParameterContextName);
                this.addMissingParameters(versionedParameterContext, currentParamContext);
            }
        }
    }

    private void updateVariableRegistry(ProcessGroup group, VersionedProcessGroup proposed, Set<String> variablesToSkip) {
        Set existingVariableNames = group.getVariableRegistry().getVariableMap().keySet().stream().map(VariableDescriptor::getName).collect(Collectors.toSet());
        HashMap updatedVariableMap = new HashMap();
        for (Map.Entry entry : proposed.getVariables().entrySet()) {
            if (existingVariableNames.contains(entry.getKey()) || variablesToSkip.contains(entry.getKey())) continue;
            updatedVariableMap.put(entry.getKey(), entry.getValue());
        }
        group.setVariables(updatedVariableMap);
    }

    private String getPublicPortFinalName(PublicPort publicPort, String proposedFinalName) {
        Optional existingPublicPort = TransferDirection.RECEIVE == publicPort.getDirection() ? this.flowManager.getPublicInputPort(proposedFinalName) : this.flowManager.getPublicOutputPort(proposedFinalName);
        if (existingPublicPort.isPresent() && !((Port)existingPublicPort.get()).getIdentifier().equals(publicPort.getIdentifier())) {
            return this.getPublicPortFinalName(publicPort, "Copy of " + proposedFinalName);
        }
        return proposedFinalName;
    }

    private boolean isUpdateable(Connection connection) {
        Connectable source = connection.getSource();
        if (source.getConnectableType() != ConnectableType.FUNNEL && source.isRunning()) {
            return false;
        }
        Connectable destination = connection.getDestination();
        return destination.getConnectableType() == ConnectableType.FUNNEL || !destination.isRunning();
    }

    private String generateTemporaryPortName(VersionedPort proposedPort) {
        String versionedPortId = proposedPort.getIdentifier();
        String proposedPortFinalName = proposedPort.getName();
        return proposedPortFinalName + " (" + versionedPortId + ")";
    }

    private void updatePortToSetFinalName(Port port, String name) {
        this.writeLock.lock();
        try {
            port.setName(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String generateUuid(String propposedId, String destinationGroupId, String seed) {
        UUID uuid;
        long msb = UUID.nameUUIDFromBytes((propposedId + destinationGroupId).getBytes(StandardCharsets.UTF_8)).getMostSignificantBits();
        if (StringUtils.isBlank((CharSequence)seed)) {
            long lsb = randomGenerator.nextLong();
            uuid = new UUID(msb, lsb);
        } else {
            UUID seedId = UUID.nameUUIDFromBytes((propposedId + destinationGroupId + seed).getBytes(StandardCharsets.UTF_8));
            uuid = new UUID(msb, seedId.getLeastSignificantBits());
        }
        LOG.debug("Generating UUID {} from currentId={}, seed={}", new Object[]{uuid, propposedId, seed});
        return uuid.toString();
    }

    private ProcessGroup addProcessGroup(ProcessGroup destination, VersionedProcessGroup proposed, String componentIdSeed, Set<String> variablesToSkip, Map<String, VersionedParameterContext> versionedParameterContexts) throws ProcessorInstantiationException {
        ProcessGroup group = this.flowManager.createProcessGroup(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed));
        group.setVersionedComponentId(proposed.getIdentifier());
        group.setParent(destination);
        this.updateProcessGroup(group, proposed, componentIdSeed, Collections.emptySet(), true, true, true, variablesToSkip, versionedParameterContexts);
        destination.addProcessGroup(group);
        return group;
    }

    private void updateConnection(Connection connection, VersionedConnection proposed) {
        connection.setBendPoints(proposed.getBends() == null ? Collections.emptyList() : proposed.getBends().stream().map(pos -> new Position(pos.getX(), pos.getY())).collect(Collectors.toList()));
        connection.setDestination(this.getConnectable(connection.getProcessGroup(), proposed.getDestination()));
        connection.setLabelIndex(proposed.getLabelIndex().intValue());
        connection.setName(proposed.getName());
        connection.setRelationships((Collection)proposed.getSelectedRelationships().stream().map(name -> new Relationship.Builder().name(name).build()).collect(Collectors.toSet()));
        connection.setZIndex(proposed.getzIndex().longValue());
        FlowFileQueue queue = connection.getFlowFileQueue();
        queue.setBackPressureDataSizeThreshold(proposed.getBackPressureDataSizeThreshold());
        queue.setBackPressureObjectThreshold(proposed.getBackPressureObjectThreshold().longValue());
        queue.setFlowFileExpiration(proposed.getFlowFileExpiration());
        List prioritizers = proposed.getPrioritizers() == null ? Collections.emptyList() : proposed.getPrioritizers().stream().map(prioritizerName -> {
            try {
                return this.flowManager.createPrioritizer(prioritizerName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create Prioritizer of type " + prioritizerName + " for Connection with ID " + connection.getIdentifier());
            }
        }).collect(Collectors.toList());
        queue.setPriorities(prioritizers);
        String loadBalanceStrategyName = proposed.getLoadBalanceStrategy();
        if (loadBalanceStrategyName == null) {
            queue.setLoadBalanceStrategy(LoadBalanceStrategy.DO_NOT_LOAD_BALANCE, proposed.getPartitioningAttribute());
        } else {
            LoadBalanceStrategy loadBalanceStrategy = LoadBalanceStrategy.valueOf((String)loadBalanceStrategyName);
            String partitioningAttribute = proposed.getPartitioningAttribute();
            queue.setLoadBalanceStrategy(loadBalanceStrategy, partitioningAttribute);
        }
        String compressionName = proposed.getLoadBalanceCompression();
        if (compressionName == null) {
            queue.setLoadBalanceCompression(LoadBalanceCompression.DO_NOT_COMPRESS);
        } else {
            queue.setLoadBalanceCompression(LoadBalanceCompression.valueOf((String)compressionName));
        }
    }

    private Connection addConnection(ProcessGroup destinationGroup, VersionedConnection proposed, String componentIdSeed) {
        Connectable source = this.getConnectable(destinationGroup, proposed.getSource());
        if (source == null) {
            throw new IllegalArgumentException("Connection has a source with identifier " + proposed.getIdentifier() + " but no component could be found in the Process Group with a corresponding identifier");
        }
        Connectable destination = this.getConnectable(destinationGroup, proposed.getDestination());
        if (destination == null) {
            throw new IllegalArgumentException("Connection has a destination with identifier " + proposed.getDestination().getId() + " but no component could be found in the Process Group with a corresponding identifier");
        }
        Connection connection = this.flowController.createConnection(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), proposed.getName(), source, destination, proposed.getSelectedRelationships());
        connection.setVersionedComponentId(proposed.getIdentifier());
        destinationGroup.addConnection(connection);
        this.updateConnection(connection, proposed);
        this.flowManager.onConnectionAdded(connection);
        return connection;
    }

    private Connectable getConnectable(ProcessGroup group, ConnectableComponent connectableComponent) {
        String id = connectableComponent.getId();
        switch (connectableComponent.getType()) {
            case FUNNEL: {
                return group.getFunnels().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny().orElse(null);
            }
            case INPUT_PORT: {
                Optional<Port> port = group.getInputPorts().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny();
                if (port.isPresent()) {
                    return (Connectable)port.get();
                }
                Optional<ProcessGroup> optionalSpecifiedGroup = group.getProcessGroups().stream().filter(child -> child.getVersionedComponentId().isPresent()).filter(child -> ((String)child.getVersionedComponentId().get()).equals(connectableComponent.getGroupId())).findFirst();
                if (optionalSpecifiedGroup.isPresent()) {
                    ProcessGroup specifiedGroup = optionalSpecifiedGroup.get();
                    return specifiedGroup.getInputPorts().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny().orElse(null);
                }
                return group.getProcessGroups().stream().flatMap(gr -> gr.getInputPorts().stream()).filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny().orElse(null);
            }
            case OUTPUT_PORT: {
                Optional<Port> port = group.getOutputPorts().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny();
                if (port.isPresent()) {
                    return (Connectable)port.get();
                }
                Optional<ProcessGroup> optionalSpecifiedGroup = group.getProcessGroups().stream().filter(child -> child.getVersionedComponentId().isPresent()).filter(child -> ((String)child.getVersionedComponentId().get()).equals(connectableComponent.getGroupId())).findFirst();
                if (optionalSpecifiedGroup.isPresent()) {
                    ProcessGroup specifiedGroup = optionalSpecifiedGroup.get();
                    return specifiedGroup.getOutputPorts().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny().orElse(null);
                }
                return group.getProcessGroups().stream().flatMap(gr -> gr.getOutputPorts().stream()).filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny().orElse(null);
            }
            case PROCESSOR: {
                return group.getProcessors().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny().orElse(null);
            }
            case REMOTE_INPUT_PORT: {
                String rpgId = connectableComponent.getGroupId();
                Optional<RemoteProcessGroup> rpgOption = group.getRemoteProcessGroups().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> rpgId.equals(component.getVersionedComponentId().get())).findAny();
                if (!rpgOption.isPresent()) {
                    throw new IllegalArgumentException("Connection refers to a Port with ID " + id + " within Remote Process Group with ID " + rpgId + " but could not find a Remote Process Group corresponding to that ID");
                }
                RemoteProcessGroup rpg = rpgOption.get();
                Optional<RemoteGroupPort> portByIdOption = rpg.getInputPorts().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny();
                if (portByIdOption.isPresent()) {
                    return (Connectable)portByIdOption.get();
                }
                return rpg.getInputPorts().stream().filter(component -> connectableComponent.getName().equals(component.getName())).findAny().orElse(null);
            }
            case REMOTE_OUTPUT_PORT: {
                String rpgId = connectableComponent.getGroupId();
                Optional<RemoteProcessGroup> rpgOption = group.getRemoteProcessGroups().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> rpgId.equals(component.getVersionedComponentId().get())).findAny();
                if (!rpgOption.isPresent()) {
                    throw new IllegalArgumentException("Connection refers to a Port with ID " + id + " within Remote Process Group with ID " + rpgId + " but could not find a Remote Process Group corresponding to that ID");
                }
                RemoteProcessGroup rpg = rpgOption.get();
                Optional<RemoteGroupPort> portByIdOption = rpg.getOutputPorts().stream().filter(component -> component.getVersionedComponentId().isPresent()).filter(component -> id.equals(component.getVersionedComponentId().get())).findAny();
                if (portByIdOption.isPresent()) {
                    return (Connectable)portByIdOption.get();
                }
                return rpg.getOutputPorts().stream().filter(component -> connectableComponent.getName().equals(component.getName())).findAny().orElse(null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateControllerService(ControllerServiceNode service, VersionedControllerService proposed) {
        service.pauseValidationTrigger();
        try {
            service.setAnnotationData(proposed.getAnnotationData());
            service.setComments(proposed.getComments());
            service.setName(proposed.getName());
            Map<String, String> properties = this.populatePropertiesMap((ComponentNode)service, proposed.getProperties(), proposed.getPropertyDescriptors(), service.getProcessGroup());
            service.setProperties(properties, true);
            if (!this.isEqual(service.getBundleCoordinate(), proposed.getBundle())) {
                BundleCoordinate newBundleCoordinate = this.toCoordinate(proposed.getBundle());
                ArrayList descriptors = new ArrayList(service.getRawPropertyValues().keySet());
                Set additionalUrls = service.getAdditionalClasspathResources(descriptors);
                this.flowController.getReloadComponent().reload(service, proposed.getType(), newBundleCoordinate, additionalUrls);
            }
        }
        finally {
            service.resumeValidationTrigger();
        }
    }

    private boolean isEqual(BundleCoordinate coordinate, Bundle bundle) {
        if (!bundle.getGroup().equals(coordinate.getGroup())) {
            return false;
        }
        if (!bundle.getArtifact().equals(coordinate.getId())) {
            return false;
        }
        return bundle.getVersion().equals(coordinate.getVersion());
    }

    private BundleCoordinate toCoordinate(Bundle bundle) {
        return new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
    }

    private ControllerServiceNode addControllerService(ProcessGroup destination, VersionedControllerService proposed, String componentIdSeed) {
        String type = proposed.getType();
        String id = this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed);
        Bundle bundle = proposed.getBundle();
        BundleCoordinate coordinate = this.toCoordinate(bundle);
        boolean firstTimeAdded = true;
        Set additionalUrls = Collections.emptySet();
        ControllerServiceNode newService = this.flowManager.createControllerService(type, id, coordinate, additionalUrls, true, true);
        newService.setVersionedComponentId(proposed.getIdentifier());
        destination.addControllerService(newService);
        this.updateControllerService(newService, proposed);
        return newService;
    }

    private void updateFunnel(Funnel funnel, VersionedFunnel proposed) {
        funnel.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
    }

    private Funnel addFunnel(ProcessGroup destination, VersionedFunnel proposed, String componentIdSeed) {
        Funnel funnel = this.flowManager.createFunnel(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed));
        funnel.setVersionedComponentId(proposed.getIdentifier());
        destination.addFunnel(funnel);
        this.updateFunnel(funnel, proposed);
        return funnel;
    }

    private void updatePort(Port port, VersionedPort proposed, String temporaryName) {
        String name = temporaryName != null ? temporaryName : proposed.getName();
        port.setComments(proposed.getComments());
        port.setName(name);
        port.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        port.setMaxConcurrentTasks(proposed.getConcurrentlySchedulableTaskCount().intValue());
    }

    private Port addInputPort(ProcessGroup destination, VersionedPort proposed, String componentIdSeed, String temporaryName) {
        String name = temporaryName != null ? temporaryName : proposed.getName();
        Port port = proposed.isAllowRemoteAccess() ? this.flowManager.createPublicInputPort(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), name) : this.flowManager.createLocalInputPort(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), name);
        port.setVersionedComponentId(proposed.getIdentifier());
        destination.addInputPort(port);
        this.updatePort(port, proposed, temporaryName);
        return port;
    }

    private Port addOutputPort(ProcessGroup destination, VersionedPort proposed, String componentIdSeed, String temporaryName) {
        String name = temporaryName != null ? temporaryName : proposed.getName();
        Port port = proposed.isAllowRemoteAccess() ? this.flowManager.createPublicOutputPort(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), name) : this.flowManager.createLocalOutputPort(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), name);
        port.setVersionedComponentId(proposed.getIdentifier());
        destination.addOutputPort(port);
        this.updatePort(port, proposed, temporaryName);
        return port;
    }

    private Label addLabel(ProcessGroup destination, VersionedLabel proposed, String componentIdSeed) {
        Label label = this.flowManager.createLabel(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), proposed.getLabel());
        label.setVersionedComponentId(proposed.getIdentifier());
        destination.addLabel(label);
        this.updateLabel(label, proposed);
        return label;
    }

    private void updateLabel(Label label, VersionedLabel proposed) {
        label.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        label.setSize(new Size(proposed.getWidth().doubleValue(), proposed.getHeight().doubleValue()));
        label.setStyle(proposed.getStyle());
        label.setValue(proposed.getLabel());
    }

    private ProcessorNode addProcessor(ProcessGroup destination, VersionedProcessor proposed, String componentIdSeed) throws ProcessorInstantiationException {
        BundleCoordinate coordinate = this.toCoordinate(proposed.getBundle());
        ProcessorNode procNode = this.flowManager.createProcessor(proposed.getType(), this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), coordinate, true);
        procNode.setVersionedComponentId(proposed.getIdentifier());
        destination.addProcessor(procNode);
        this.updateProcessor(procNode, proposed);
        return procNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessor(ProcessorNode processor, VersionedProcessor proposed) throws ProcessorInstantiationException {
        processor.pauseValidationTrigger();
        try {
            processor.setAnnotationData(proposed.getAnnotationData());
            processor.setBulletinLevel(LogLevel.valueOf((String)proposed.getBulletinLevel()));
            processor.setComments(proposed.getComments());
            processor.setName(proposed.getName());
            processor.setPenalizationPeriod(proposed.getPenaltyDuration());
            Map<String, String> properties = this.populatePropertiesMap((ComponentNode)processor, proposed.getProperties(), proposed.getPropertyDescriptors(), processor.getProcessGroup());
            processor.setProperties(properties, true);
            processor.setRunDuration(proposed.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
            processor.setSchedulingStrategy(SchedulingStrategy.valueOf((String)proposed.getSchedulingStrategy()));
            processor.setScheduldingPeriod(proposed.getSchedulingPeriod());
            processor.setMaxConcurrentTasks(proposed.getConcurrentlySchedulableTaskCount().intValue());
            processor.setExecutionNode(ExecutionNode.valueOf((String)proposed.getExecutionNode()));
            processor.setStyle(proposed.getStyle());
            processor.setYieldPeriod(proposed.getYieldDuration());
            processor.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
            if (proposed.getScheduledState() == ScheduledState.DISABLED) {
                processor.getProcessGroup().disableProcessor(processor);
            } else if (processor.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED) {
                processor.getProcessGroup().enableProcessor(processor);
            }
            if (!this.isEqual(processor.getBundleCoordinate(), proposed.getBundle())) {
                BundleCoordinate newBundleCoordinate = this.toCoordinate(proposed.getBundle());
                ArrayList descriptors = new ArrayList(processor.getProperties().keySet());
                Set additionalUrls = processor.getAdditionalClasspathResources(descriptors);
                this.flowController.getReloadComponent().reload(processor, proposed.getType(), newBundleCoordinate, additionalUrls);
            }
        }
        finally {
            processor.resumeValidationTrigger();
        }
    }

    private Map<String, String> populatePropertiesMap(ComponentNode componentNode, Map<String, String> proposedProperties, Map<String, VersionedPropertyDescriptor> proposedDescriptors, ProcessGroup group) {
        HashSet<String> sensitiveProperties = new HashSet<String>();
        HashMap<String, String> fullPropertyMap = new HashMap<String, String>();
        for (PropertyDescriptor property : componentNode.getRawPropertyValues().keySet()) {
            if (property.isSensitive()) {
                sensitiveProperties.add(property.getName());
                continue;
            }
            fullPropertyMap.put(property.getName(), null);
        }
        if (proposedProperties != null) {
            HashSet<String> updatedPropertyNames = new HashSet<String>();
            updatedPropertyNames.addAll(proposedProperties.keySet());
            componentNode.getProperties().keySet().stream().map(PropertyDescriptor::getName).forEach(updatedPropertyNames::add);
            for (String propertyName : updatedPropertyNames) {
                PropertyConfiguration propertyConfiguration;
                String value;
                VersionedPropertyDescriptor descriptor = proposedDescriptors.get(propertyName);
                if (descriptor != null && descriptor.getIdentifiesControllerService()) {
                    String serviceVersionedComponentId;
                    String instanceId;
                    ControllerServiceNode serviceNode;
                    String componentDescriptorValue;
                    String existingExternalServiceId = null;
                    PropertyDescriptor componentDescriptor = componentNode.getPropertyDescriptor(propertyName);
                    if (componentDescriptor != null && (componentDescriptorValue = componentNode.getEffectivePropertyValue(componentDescriptor)) != null && (serviceNode = this.findAncestorControllerService(componentDescriptorValue, this.getParent())) != null) {
                        existingExternalServiceId = componentDescriptorValue;
                    }
                    value = existingExternalServiceId == null ? ((instanceId = this.getServiceInstanceId(serviceVersionedComponentId = proposedProperties.get(propertyName), group)) == null ? serviceVersionedComponentId : instanceId) : existingExternalServiceId;
                } else {
                    value = proposedProperties.get(propertyName);
                }
                if (sensitiveProperties.contains(propertyName) && value == null && ((propertyConfiguration = componentNode.getProperty(componentNode.getPropertyDescriptor(propertyName))) == null || propertyConfiguration.getParameterReferences().isEmpty())) continue;
                fullPropertyMap.put(propertyName, value);
            }
        }
        return fullPropertyMap;
    }

    private String getServiceInstanceId(String serviceVersionedComponentId, ProcessGroup group) {
        for (ControllerServiceNode serviceNode : group.getControllerServices(false)) {
            Optional optionalVersionedId = serviceNode.getVersionedComponentId();
            String versionedId = optionalVersionedId.orElseGet(() -> UUID.nameUUIDFromBytes(serviceNode.getIdentifier().getBytes(StandardCharsets.UTF_8)).toString());
            if (!versionedId.equals(serviceVersionedComponentId)) continue;
            return serviceNode.getIdentifier();
        }
        ProcessGroup parent = group.getParent();
        if (parent == null) {
            return null;
        }
        return this.getServiceInstanceId(serviceVersionedComponentId, parent);
    }

    private RemoteProcessGroup addRemoteProcessGroup(ProcessGroup destination, VersionedRemoteProcessGroup proposed, String componentIdSeed) {
        RemoteProcessGroup rpg = this.flowManager.createRemoteProcessGroup(this.generateUuid(proposed.getIdentifier(), destination.getIdentifier(), componentIdSeed), proposed.getTargetUris());
        rpg.setVersionedComponentId(proposed.getIdentifier());
        destination.addRemoteProcessGroup(rpg);
        this.updateRemoteProcessGroup(rpg, proposed, componentIdSeed);
        return rpg;
    }

    private void updateRemoteProcessGroup(RemoteProcessGroup rpg, VersionedRemoteProcessGroup proposed, String componentIdSeed) {
        rpg.setComments(proposed.getComments());
        rpg.setCommunicationsTimeout(proposed.getCommunicationsTimeout());
        rpg.setInputPorts(proposed.getInputPorts() == null ? Collections.emptySet() : proposed.getInputPorts().stream().map(port -> this.createPortDescriptor((VersionedRemoteGroupPort)port, componentIdSeed, rpg.getIdentifier())).collect(Collectors.toSet()), false);
        rpg.setName(proposed.getName());
        rpg.setNetworkInterface(proposed.getLocalNetworkInterface());
        rpg.setOutputPorts(proposed.getOutputPorts() == null ? Collections.emptySet() : proposed.getOutputPorts().stream().map(port -> this.createPortDescriptor((VersionedRemoteGroupPort)port, componentIdSeed, rpg.getIdentifier())).collect(Collectors.toSet()), false);
        rpg.setPosition(new Position(proposed.getPosition().getX(), proposed.getPosition().getY()));
        rpg.setProxyHost(proposed.getProxyHost());
        rpg.setProxyPort(proposed.getProxyPort());
        rpg.setProxyUser(proposed.getProxyUser());
        rpg.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)proposed.getTransportProtocol()));
        rpg.setYieldDuration(proposed.getYieldDuration());
    }

    private RemoteProcessGroupPortDescriptor createPortDescriptor(VersionedRemoteGroupPort proposed, String componentIdSeed, String rpgId) {
        StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
        descriptor.setVersionedComponentId(proposed.getIdentifier());
        BatchSize batchSize = proposed.getBatchSize();
        if (batchSize != null) {
            descriptor.setBatchCount(batchSize.getCount());
            descriptor.setBatchDuration(batchSize.getDuration());
            descriptor.setBatchSize(batchSize.getSize());
        }
        descriptor.setComments(proposed.getComments());
        descriptor.setConcurrentlySchedulableTaskCount(proposed.getConcurrentlySchedulableTaskCount());
        descriptor.setGroupId(proposed.getRemoteGroupId());
        descriptor.setTargetId(proposed.getTargetId());
        descriptor.setId(this.generateUuid(proposed.getIdentifier(), rpgId, componentIdSeed));
        descriptor.setName(proposed.getName());
        descriptor.setUseCompression(proposed.isUseCompression());
        return descriptor;
    }

    private Set<FlowDifference> getModifications() {
        StandardVersionControlInformation vci = this.versionControlInfo.get();
        if (vci == null) {
            return null;
        }
        if (vci.getFlowSnapshot() == null) {
            return null;
        }
        NiFiRegistryFlowMapper mapper = new NiFiRegistryFlowMapper(this.flowController.getExtensionManager());
        InstantiatedVersionedProcessGroup versionedGroup = mapper.mapProcessGroup(this, this.controllerServiceProvider, this.flowController.getFlowRegistryClient(), false);
        StandardComparableDataFlow currentFlow = new StandardComparableDataFlow("Local Flow", (VersionedProcessGroup)versionedGroup);
        StandardComparableDataFlow snapshotFlow = new StandardComparableDataFlow("Versioned Flow", vci.getFlowSnapshot());
        StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)snapshotFlow, (ComparableDataFlow)currentFlow, this.getAncestorGroupServiceIds(), (DifferenceDescriptor)new EvolvingDifferenceDescriptor());
        FlowComparison comparison = flowComparator.compare();
        Set differences = comparison.getDifferences().stream().filter(difference -> difference.getDifferenceType() != DifferenceType.BUNDLE_CHANGED).filter(FlowDifferenceFilters.FILTER_ADDED_REMOVED_REMOTE_PORTS).filter(FlowDifferenceFilters.FILTER_PUBLIC_PORT_NAME_CHANGES).filter(FlowDifferenceFilters.FILTER_IGNORABLE_VERSIONED_FLOW_COORDINATE_CHANGES).filter(diff -> !FlowDifferenceFilters.isNewPropertyWithDefaultValue(diff, this.flowManager)).filter(diff -> !FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted(diff, versionedGroup, this.flowManager)).filter(diff -> !FlowDifferenceFilters.isScheduledStateNew(diff)).collect(Collectors.toCollection(HashSet::new));
        LOG.debug("There are {} differences between this Local Flow and the Versioned Flow: {}", (Object)differences.size(), (Object)differences);
        return differences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyCanUpdate(VersionedFlowSnapshot updatedFlow, boolean verifyConnectionRemoval, boolean verifyNotDirty) {
        this.readLock.lock();
        try {
            VersionControlInformation versionControlInfo = this.getVersionControlInformation();
            if (versionControlInfo != null) {
                if (!versionControlInfo.getFlowIdentifier().equals(updatedFlow.getSnapshotMetadata().getFlowIdentifier())) {
                    throw new IllegalStateException(this + " is under version control but the given flow does not match the flow that this Process Group is synchronized with");
                }
                if (verifyNotDirty) {
                    VersionedFlowState flowState = versionControlInfo.getStatus().getState();
                    boolean modified = flowState == VersionedFlowState.LOCALLY_MODIFIED || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE;
                    Set<FlowDifference> modifications = this.getModifications();
                    if (modified) {
                        String changes = modifications.stream().map(Object::toString).collect(Collectors.joining("\n"));
                        LOG.error("Cannot change the Version of the flow for {} because the Process Group has been modified ({} modifications) since it was last synchronized with the Flow Registry. The following differences were found:\n{}", new Object[]{this, modifications.size(), changes});
                        throw new IllegalStateException("Cannot change the Version of the flow for " + this + " because the Process Group has been modified (" + modifications.size() + " modifications) since it was last synchronized with the Flow Registry. The Process Group must be reverted to its original form before changing the version.");
                    }
                }
                this.verifyNoDescendantsWithLocalModifications("be updated");
            }
            VersionedProcessGroup flowContents = updatedFlow.getFlowContents();
            if (verifyConnectionRemoval) {
                HashMap removedConnectionByVersionedId = new HashMap();
                this.findAllConnections().forEach(conn -> removedConnectionByVersionedId.put(conn.getVersionedComponentId().orElse(conn.getIdentifier()), conn));
                HashSet<String> proposedFlowConnectionIds = new HashSet<String>();
                this.findAllConnectionIds(flowContents, proposedFlowConnectionIds);
                Iterator<Object> changes = proposedFlowConnectionIds.iterator();
                while (changes.hasNext()) {
                    String proposedConnectionId = (String)changes.next();
                    removedConnectionByVersionedId.remove(proposedConnectionId);
                }
                for (Connection connection : removedConnectionByVersionedId.values()) {
                    FlowFileQueue flowFileQueue = connection.getFlowFileQueue();
                    if (flowFileQueue.isEmpty()) continue;
                    throw new IllegalStateException(this + " cannot be updated to the proposed version of the flow because the proposed version does not contain " + connection + " and the connection currently has data in the queue.");
                }
            }
            HashMap removedInputPortsByVersionId = new HashMap();
            this.getInputPorts().stream().filter(port -> port.getVersionedComponentId().isPresent()).forEach(port -> removedInputPortsByVersionId.put(port.getVersionedComponentId().get(), port));
            flowContents.getInputPorts().stream().map(VersionedComponent::getIdentifier).forEach(removedInputPortsByVersionId::remove);
            for (Object inputPort : removedInputPortsByVersionId.values()) {
                List incomingConnections = inputPort.getIncomingConnections();
                if (incomingConnections.isEmpty()) continue;
                throw new IllegalStateException(this + " cannot be updated to the proposed version of the flow because the proposed version does not contain the Input Port " + inputPort + " and the Input Port currently has an incoming connections");
            }
            HashMap removedOutputPortsByVersionId = new HashMap();
            this.getOutputPorts().stream().filter(port -> port.getVersionedComponentId().isPresent()).forEach(port -> removedOutputPortsByVersionId.put(port.getVersionedComponentId().get(), port));
            flowContents.getOutputPorts().stream().map(VersionedComponent::getIdentifier).forEach(removedOutputPortsByVersionId::remove);
            for (Object outputPort : removedOutputPortsByVersionId.values()) {
                Set set = outputPort.getConnections();
                if (set.isEmpty()) continue;
                throw new IllegalStateException(this + " cannot be updated to the proposed version of the flow because the proposed version does not contain the Output Port " + outputPort + " and the Output Port currently has an outgoing connections");
            }
            HashMap<String, VersionedProcessGroup> proposedProcessGroups = new HashMap<String, VersionedProcessGroup>();
            this.findAllProcessGroups(updatedFlow.getFlowContents(), proposedProcessGroups);
            for (ProcessGroup processGroup : this.findAllProcessGroups()) {
                String versionedId;
                Optional versionedIdOption;
                if (processGroup.getTemplates().isEmpty() || !(versionedIdOption = processGroup.getVersionedComponentId()).isPresent() || proposedProcessGroups.containsKey(versionedId = (String)versionedIdOption.get())) continue;
                throw new IllegalStateException(this + " cannot be updated to the proposed version of the flow because the child " + processGroup + " that exists locally has one or more Templates, and the proposed flow does not contain these templates. A Process Group cannot be deleted while it contains Templates. Please remove the Templates before attempting to change the version of the flow.");
            }
            HashMap<String, VersionedProcessor> proposedProcessors = new HashMap<String, VersionedProcessor>();
            this.findAllProcessors(updatedFlow.getFlowContents(), proposedProcessors);
            this.findAllProcessors().stream().filter(proc -> proc.getVersionedComponentId().isPresent()).forEach(proc -> {
                VersionedProcessor cfr_ignored_0 = (VersionedProcessor)proposedProcessors.remove(proc.getVersionedComponentId().get());
            });
            for (Object processorToAdd : proposedProcessors.values()) {
                String processorToAddClass = processorToAdd.getType();
                BundleCoordinate processorToAddCoordinate = this.toCoordinate(processorToAdd.getBundle());
                boolean bundleExists = this.flowController.getExtensionManager().getBundles(processorToAddClass).stream().anyMatch(b -> processorToAddCoordinate.equals((Object)b.getBundleDetails().getCoordinate()));
                if (bundleExists) continue;
                throw new IllegalArgumentException("Unknown bundle " + processorToAddCoordinate.toString() + " for processor type " + processorToAddClass);
            }
            HashMap<String, VersionedControllerService> hashMap = new HashMap<String, VersionedControllerService>();
            this.findAllControllerServices(updatedFlow.getFlowContents(), hashMap);
            this.findAllControllerServices().stream().filter(service -> service.getVersionedComponentId().isPresent()).forEach(service -> {
                VersionedControllerService cfr_ignored_0 = (VersionedControllerService)hashMap.remove(service.getVersionedComponentId().get());
            });
            for (VersionedControllerService serviceToAdd : hashMap.values()) {
                String serviceToAddClass = serviceToAdd.getType();
                BundleCoordinate serviceToAddCoordinate = this.toCoordinate(serviceToAdd.getBundle());
                boolean bundleExists = this.flowController.getExtensionManager().getBundles(serviceToAddClass).stream().anyMatch(b -> serviceToAddCoordinate.equals((Object)b.getBundleDetails().getCoordinate()));
                if (bundleExists) continue;
                throw new IllegalArgumentException("Unknown bundle " + serviceToAddCoordinate.toString() + " for service type " + serviceToAddClass);
            }
            HashMap<String, VersionedConnection> proposedConnections = new HashMap<String, VersionedConnection>();
            this.findAllConnections(updatedFlow.getFlowContents(), proposedConnections);
            this.findAllConnections().stream().filter(conn -> conn.getVersionedComponentId().isPresent()).forEach(conn -> {
                VersionedConnection cfr_ignored_0 = (VersionedConnection)proposedConnections.remove(conn.getVersionedComponentId().get());
            });
            for (VersionedConnection connectionToAdd : proposedConnections.values()) {
                String loadBalanceStrategyName;
                if (connectionToAdd.getPrioritizers() != null) {
                    for (String prioritizerType : connectionToAdd.getPrioritizers()) {
                        try {
                            this.flowManager.createPrioritizer(prioritizerType);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Unable to create Prioritizer of type " + prioritizerType, e);
                        }
                    }
                }
                if ((loadBalanceStrategyName = connectionToAdd.getLoadBalanceStrategy()) == null) continue;
                try {
                    LoadBalanceStrategy.valueOf((String)loadBalanceStrategyName);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Unable to create Connection with Load Balance Strategy of '" + loadBalanceStrategyName + "' because this is not a known Load Balance Strategy");
                    return;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void findAllConnectionIds(VersionedProcessGroup group, Set<String> ids) {
        for (VersionedConnection connection : group.getConnections()) {
            ids.add(connection.getIdentifier());
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.findAllConnectionIds(childGroup, ids);
        }
    }

    private void findAllProcessors(VersionedProcessGroup group, Map<String, VersionedProcessor> map) {
        for (VersionedProcessor processor : group.getProcessors()) {
            map.put(processor.getIdentifier(), processor);
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.findAllProcessors(childGroup, map);
        }
    }

    private void findAllControllerServices(VersionedProcessGroup group, Map<String, VersionedControllerService> map) {
        for (VersionedControllerService service : group.getControllerServices()) {
            map.put(service.getIdentifier(), service);
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.findAllControllerServices(childGroup, map);
        }
    }

    private void findAllConnections(VersionedProcessGroup group, Map<String, VersionedConnection> map) {
        for (VersionedConnection connection : group.getConnections()) {
            map.put(connection.getIdentifier(), connection);
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.findAllConnections(childGroup, map);
        }
    }

    private void findAllProcessGroups(VersionedProcessGroup group, Map<String, VersionedProcessGroup> map) {
        map.put(group.getIdentifier(), group);
        for (VersionedProcessGroup child : group.getProcessGroups()) {
            this.findAllProcessGroups(child, map);
        }
    }

    public void verifyCanSaveToFlowRegistry(String registryId, String bucketId, String flowId, String saveAction) {
        this.verifyNoDescendantsWithLocalModifications("be saved to a Flow Registry");
        StandardVersionControlInformation vci = this.versionControlInfo.get();
        if (vci != null) {
            if (flowId != null && flowId.equals(vci.getFlowIdentifier())) {
                VersionedFlowState state = vci.getStatus().getState();
                if (state == VersionedFlowState.STALE || state == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE && "COMMIT".equals(saveAction)) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group in the flow is not synchronized with the most recent version of the Flow in the Flow Registry. In order to publish a new version of the Flow, the Process Group must first be in synch with the latest version in the Flow Registry.");
                }
                if (!bucketId.equals(vci.getBucketIdentifier())) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
                }
                if (!registryId.equals(vci.getRegistryIdentifier())) {
                    throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
                }
            } else if (flowId != null) {
                throw new IllegalStateException("Cannot update Version Control Information for Process Group with ID " + this.getIdentifier() + " because the Process Group is currently synchronized with a different Versioned Flow than the one specified in the request.");
            }
        }
    }

    public void verifyCanRevertLocalModifications() {
        StandardVersionControlInformation svci = this.versionControlInfo.get();
        if (svci == null) {
            throw new IllegalStateException("Cannot revert local modifications to Process Group because the Process Group is not under Version Control.");
        }
        this.verifyNoDescendantsWithLocalModifications("have its local modifications reverted");
    }

    public void verifyCanShowLocalModifications() {
    }

    private void verifyNoDescendantsWithLocalModifications(String action) {
        for (ProcessGroup descendant : this.findAllProcessGroups()) {
            boolean modified;
            VersionControlInformation descendantVci = descendant.getVersionControlInformation();
            if (descendantVci == null) continue;
            VersionedFlowState flowState = descendantVci.getStatus().getState();
            boolean bl = modified = flowState == VersionedFlowState.LOCALLY_MODIFIED || flowState == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE;
            if (modified) {
                throw new IllegalStateException("Process Group cannot " + action + " because it contains a child or descendant Process Group that is under Version Control and has local modifications. Each descendant Process Group that is under Version Control must first be reverted or have its changes pushed to the Flow Registry before this action can be performed on the parent Process Group.");
            }
            if (flowState != VersionedFlowState.SYNC_FAILURE) continue;
            throw new IllegalStateException("Process Group cannot " + action + " because it contains a child or descendant Process Group that is under Version Control and is not synchronized with the Flow Registry. Each descendant Process Group must first be synchronized with the Flow Registry before this action can be performed on the parent Process Group. NiFi will continue to attempt to communicate with the Flow Registry periodically in the background.");
        }
    }

    private static class OutputPortRetriever
    implements PortRetriever {
        private OutputPortRetriever() {
        }

        @Override
        public Set<Port> getPorts(ProcessGroup group) {
            return group.getOutputPorts();
        }

        @Override
        public Port getPort(ProcessGroup group, String id) {
            return group.getOutputPort(id);
        }
    }

    private static class InputPortRetriever
    implements PortRetriever {
        private InputPortRetriever() {
        }

        @Override
        public Set<Port> getPorts(ProcessGroup group) {
            return group.getInputPorts();
        }

        @Override
        public Port getPort(ProcessGroup group, String id) {
            return group.getInputPort(id);
        }
    }

    private static interface PortRetriever {
        public Port getPort(ProcessGroup var1, String var2);

        public Set<Port> getPorts(ProcessGroup var1);
    }
}

