/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.client.async.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.OptionalInt;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerChannel
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PeerChannel.class);
    private final SocketChannel socketChannel;
    private final SSLEngine sslEngine;
    private final String peerDescription;
    private final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);
    private ByteBuffer destinationBuffer = ByteBuffer.allocate(16384);
    private ByteBuffer streamBuffer = ByteBuffer.allocate(16384);
    private ByteBuffer applicationBuffer = ByteBuffer.allocate(0);

    public PeerChannel(SocketChannel socketChannel, SSLEngine sslEngine, String peerDescription) {
        this.socketChannel = socketChannel;
        this.sslEngine = sslEngine;
        this.peerDescription = peerDescription;
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.close();
    }

    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    public String getPeerDescription() {
        return this.peerDescription;
    }

    public boolean write(byte b) throws IOException {
        this.singleByteBuffer.clear();
        this.singleByteBuffer.put(b);
        this.singleByteBuffer.rewind();
        ByteBuffer prepared = this.prepareForWrite(this.singleByteBuffer);
        int bytesWritten = this.write(prepared);
        return bytesWritten > 0;
    }

    public OptionalInt read() throws IOException {
        this.singleByteBuffer.clear();
        int bytesRead = this.read(this.singleByteBuffer);
        if (bytesRead < 0) {
            return OptionalInt.of(-1);
        }
        if (bytesRead == 0) {
            return OptionalInt.empty();
        }
        this.singleByteBuffer.flip();
        byte read = this.singleByteBuffer.get();
        return OptionalInt.of(read & 0xFF);
    }

    public ByteBuffer prepareForWrite(ByteBuffer plaintext) throws IOException {
        if (this.sslEngine == null) {
            return plaintext;
        }
        ByteBuffer prepared = ByteBuffer.allocate(Math.min(85, plaintext.capacity() - plaintext.position()));
        while (plaintext.hasRemaining()) {
            this.encrypt(plaintext);
            int bytesRemaining = prepared.capacity() - prepared.position();
            if (bytesRemaining < this.destinationBuffer.remaining()) {
                ByteBuffer temp = ByteBuffer.allocate(prepared.capacity() + this.sslEngine.getSession().getApplicationBufferSize());
                prepared.flip();
                temp.put(prepared);
                prepared = temp;
            }
            prepared.put(this.destinationBuffer);
        }
        prepared.flip();
        return prepared;
    }

    public int write(ByteBuffer preparedBuffer) throws IOException {
        return this.socketChannel.write(preparedBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        int bytesCopied = this.copy(this.applicationBuffer, dst);
        if (bytesCopied != 0) {
            return bytesCopied;
        }
        int bytesRead = this.socketChannel.read(this.streamBuffer);
        if (bytesRead < 1) {
            return bytesRead;
        }
        if (bytesRead > 0) {
            logger.trace("Read {} bytes from SocketChannel", (Object)bytesRead);
        }
        this.streamBuffer.flip();
        try {
            if (this.sslEngine == null) {
                this.cloneToApplicationBuffer(this.streamBuffer);
                int n = this.copy(this.applicationBuffer, dst);
                return n;
            }
            boolean decrypted = this.decrypt(this.streamBuffer);
            logger.trace("Decryption after reading those bytes successful = {}", (Object)decrypted);
            if (decrypted) {
                this.cloneToApplicationBuffer(this.destinationBuffer);
                logger.trace("Cloned destination buffer to application buffer");
                int n = this.copy(this.applicationBuffer, dst);
                return n;
            }
            logger.debug("Not enough data to decrypt. Will need to consume more data before decrypting");
            this.streamBuffer.compact();
            int n = 0;
            return n;
        }
        finally {
            this.streamBuffer.compact();
        }
    }

    private void cloneToApplicationBuffer(ByteBuffer buffer) {
        if (this.applicationBuffer.capacity() < buffer.remaining()) {
            this.applicationBuffer = ByteBuffer.allocate(buffer.remaining());
        } else {
            this.applicationBuffer.clear();
        }
        this.applicationBuffer.put(buffer);
        this.applicationBuffer.flip();
    }

    private int copy(ByteBuffer src, ByteBuffer dst) {
        if (src != null && src.hasRemaining()) {
            int bytesToCopy = Math.min(dst.remaining(), src.remaining());
            if (bytesToCopy < 1) {
                return bytesToCopy;
            }
            byte[] buff = new byte[bytesToCopy];
            src.get(buff);
            dst.put(buff);
            return bytesToCopy;
        }
        return 0;
    }

    private void encrypt(ByteBuffer plaintext) throws IOException {
        if (this.sslEngine == null) {
            throw new SSLException("Unable to encrypt message because no SSLEngine has been configured");
        }
        this.destinationBuffer.clear();
        while (true) {
            SSLEngineResult result = this.sslEngine.wrap(plaintext, this.destinationBuffer);
            switch (result.getStatus()) {
                case OK: {
                    this.destinationBuffer.flip();
                    return;
                }
                case CLOSED: {
                    throw new IOException("Failed to encrypt data to write to Peer " + this.peerDescription + " because Peer unexpectedly closed connection");
                }
                case BUFFER_OVERFLOW: {
                    ByteBuffer tempBuffer = ByteBuffer.allocate(this.destinationBuffer.capacity() + this.sslEngine.getSession().getApplicationBufferSize());
                    this.destinationBuffer.flip();
                    tempBuffer.put(this.destinationBuffer);
                    this.destinationBuffer = tempBuffer;
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    throw new IOException("Received unexpected Buffer Underflow result when encrypting data to write to Peer " + this.peerDescription);
                }
            }
        }
    }

    private boolean decrypt(ByteBuffer encrypted) throws IOException {
        if (this.sslEngine == null) {
            throw new SSLException("Unable to decrypt message because no SSLEngine has been configured");
        }
        this.destinationBuffer.clear();
        while (true) {
            SSLEngineResult result = this.sslEngine.unwrap(encrypted, this.destinationBuffer);
            switch (result.getStatus()) {
                case OK: {
                    this.destinationBuffer.flip();
                    return true;
                }
                case CLOSED: {
                    throw new IOException("Failed to decrypt data from Peer " + this.peerDescription + " because Peer unexpectedly closed connection");
                }
                case BUFFER_OVERFLOW: {
                    ByteBuffer tempBuffer = ByteBuffer.allocate(encrypted.position() + this.sslEngine.getSession().getApplicationBufferSize());
                    this.destinationBuffer.flip();
                    tempBuffer.put(this.destinationBuffer);
                    this.destinationBuffer = tempBuffer;
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    return false;
                }
            }
        }
    }

    public void performHandshake() throws IOException {
        if (this.sslEngine == null) {
            return;
        }
        this.sslEngine.beginHandshake();
        ByteBuffer emptyMessage = ByteBuffer.allocate(0);
        ByteBuffer unwrapBuffer = ByteBuffer.allocate(0);
        block6: while (true) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            block0 : switch (handshakeStatus) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    this.streamBuffer.clear();
                    this.destinationBuffer.clear();
                    logger.debug("Completed SSL Handshake with Peer {}", (Object)this.peerDescription);
                    return;
                }
                case NEED_TASK: {
                    Runnable runnable;
                    logger.debug("SSL Handshake with Peer {} Needs Task", (Object)this.peerDescription);
                    while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                        runnable.run();
                    }
                    continue block6;
                }
                case NEED_WRAP: {
                    logger.trace("SSL Handshake with Peer {} Needs Wrap", (Object)this.peerDescription);
                    this.encrypt(emptyMessage);
                    int bytesWritten = this.write(this.destinationBuffer);
                    logger.debug("Wrote {} bytes for NEED_WRAP portion of Handshake", (Object)bytesWritten);
                    break;
                }
                case NEED_UNWRAP: {
                    logger.trace("SSL Handshake with Peer {} Needs Unwrap", (Object)this.peerDescription);
                    while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        boolean decrypted = this.decrypt(unwrapBuffer);
                        if (decrypted) {
                            logger.trace("Decryption was successful for NEED_UNWRAP portion of Handshake");
                            break block0;
                        }
                        if (unwrapBuffer.capacity() - unwrapBuffer.position() < 1) {
                            logger.trace("Enlarging size of Buffer for NEED_UNWRAP portion of Handshake");
                            ByteBuffer tempBuffer = ByteBuffer.allocate(unwrapBuffer.capacity() + this.sslEngine.getSession().getApplicationBufferSize());
                            tempBuffer.put(unwrapBuffer);
                            unwrapBuffer = tempBuffer;
                            unwrapBuffer.flip();
                            continue;
                        }
                        logger.trace("Need to read more bytes for NEED_UNWRAP portion of Handshake");
                        unwrapBuffer.compact();
                        int bytesRead = this.socketChannel.read(unwrapBuffer);
                        unwrapBuffer.flip();
                        logger.debug("Read {} bytes for NEED_UNWRAP portion of Handshake", (Object)bytesRead);
                    }
                    continue block6;
                }
            }
        }
    }
}

