/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentRepositoryScanTask
implements DiagnosticTask {
    private static final Logger logger = LoggerFactory.getLogger(ContentRepositoryScanTask.class);
    private final FlowController flowController;

    public ContentRepositoryScanTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        if (!verbose) {
            return null;
        }
        ContentRepository contentRepository = this.flowController.getRepositoryContextFactory().getContentRepository();
        if (!contentRepository.isActiveResourceClaimsSupported()) {
            return new StandardDiagnosticsDumpElement("Content Repository Scan", Collections.singletonList("Current Content Repository does not support scanning for in-use content"));
        }
        FlowFileRepository flowFileRepository = this.flowController.getRepositoryContextFactory().getFlowFileRepository();
        ResourceClaimManager resourceClaimManager = this.flowController.getResourceClaimManager();
        FlowFileSwapManager swapManager = this.flowController.createSwapManager();
        ArrayList<String> details = new ArrayList<String>();
        for (String containerName : contentRepository.getContainerNames()) {
            try {
                Set resourceClaims = contentRepository.getActiveResourceClaims(containerName);
                Map referenceMap = flowFileRepository.findResourceClaimReferences(resourceClaims, swapManager);
                for (ResourceClaim resourceClaim : resourceClaims) {
                    int claimCount = resourceClaimManager.getClaimantCount(resourceClaim);
                    boolean inUse = resourceClaim.isInUse();
                    boolean destructable = resourceClaimManager.isDestructable(resourceClaim);
                    Set references = referenceMap == null ? Collections.emptySet() : referenceMap.getOrDefault(resourceClaim, Collections.emptySet());
                    String path = resourceClaim.getContainer() + "/" + resourceClaim.getSection() + "/" + resourceClaim.getId();
                    details.add(String.format("%1$s, Claimant Count = %2$d, In Use = %3$b, Awaiting Destruction = %4$b, References (%5$d) = %6$s", path, claimCount, inUse, destructable, references.size(), references.toString()));
                }
            }
            catch (Exception e) {
                logger.error("Failed to obtain listing of Active Resource Claims for container {}", (Object)containerName, (Object)e);
                details.add("Failed to obtain listing of Active Resource Claims in container " + containerName);
            }
        }
        return new StandardDiagnosticsDumpElement("Content Repository Scan", details);
    }
}

