/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.ScheduledState;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.VersionedConnection;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedPort;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.VersionedProcessor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;

public class FlowDifferenceFilters {
    public static Predicate<FlowDifference> FILTER_PUBLIC_PORT_NAME_CHANGES = fd -> !FlowDifferenceFilters.isPublicPortNameChange(fd);
    public static Predicate<FlowDifference> FILTER_ADDED_REMOVED_REMOTE_PORTS = fd -> !FlowDifferenceFilters.isAddedOrRemovedRemotePort(fd);
    public static Predicate<FlowDifference> FILTER_IGNORABLE_VERSIONED_FLOW_COORDINATE_CHANGES = fd -> !FlowDifferenceFilters.isIgnorableVersionedFlowCoordinateChange(fd);

    public static boolean isPublicPortNameChange(FlowDifference fd) {
        VersionedPort versionedPort;
        VersionedComponent versionedComponent = fd.getComponentA();
        return fd.getDifferenceType() == DifferenceType.NAME_CHANGED && versionedComponent instanceof VersionedPort && (versionedPort = (VersionedPort)versionedComponent).isAllowRemoteAccess();
    }

    public static boolean isAddedOrRemovedRemotePort(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.COMPONENT_ADDED || fd.getDifferenceType() == DifferenceType.COMPONENT_REMOVED) {
            VersionedComponent component = fd.getComponentA();
            if (component == null || fd.getComponentB() instanceof InstantiatedVersionedComponent) {
                component = fd.getComponentB();
            }
            if (component.getComponentType() == ComponentType.REMOTE_INPUT_PORT || component.getComponentType() == ComponentType.REMOTE_OUTPUT_PORT) {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnorableVersionedFlowCoordinateChange(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED) {
            VersionedComponent componentA = fd.getComponentA();
            VersionedComponent componentB = fd.getComponentB();
            if (componentA instanceof VersionedProcessGroup && componentB instanceof VersionedProcessGroup) {
                VersionedProcessGroup versionedProcessGroupA = (VersionedProcessGroup)componentA;
                VersionedProcessGroup versionedProcessGroupB = (VersionedProcessGroup)componentB;
                VersionedFlowCoordinates coordinatesA = versionedProcessGroupA.getVersionedFlowCoordinates();
                VersionedFlowCoordinates coordinatesB = versionedProcessGroupB.getVersionedFlowCoordinates();
                if (coordinatesA != null && coordinatesB != null) {
                    String registryUrlA = coordinatesA.getRegistryUrl();
                    String registryUrlB = coordinatesB.getRegistryUrl();
                    if (registryUrlA != null && registryUrlB != null && !registryUrlA.equals(registryUrlB)) {
                        if (registryUrlA.endsWith("/")) {
                            registryUrlA = registryUrlA.substring(0, registryUrlA.length() - 1);
                        }
                        if (registryUrlB.endsWith("/")) {
                            registryUrlB = registryUrlB.substring(0, registryUrlB.length() - 1);
                        }
                        if (registryUrlA.equals(registryUrlB)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean isNewPropertyWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.PROPERTY_ADDED) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
            ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceId());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)processorNode);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            InstantiatedVersionedControllerService instantiatedControllerService = (InstantiatedVersionedControllerService)componentB;
            ControllerServiceNode controllerService = flowManager.getControllerServiceNode(instantiatedControllerService.getInstanceId());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)controllerService);
        }
        return false;
    }

    private static boolean isNewPropertyWithDefaultValue(FlowDifference fd, ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        Optional optionalFieldName = fd.getFieldName();
        if (!optionalFieldName.isPresent()) {
            return false;
        }
        String fieldName = (String)optionalFieldName.get();
        PropertyDescriptor propertyDescriptor = componentNode.getPropertyDescriptor(fieldName);
        if (propertyDescriptor == null) {
            return false;
        }
        return Objects.equals(fd.getValueB(), propertyDescriptor.getDefaultValue());
    }

    public static boolean isScheduledStateNew(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getValueA() == null && ScheduledState.ENABLED.equals(fd.getValueB())) {
            return true;
        }
        return fd.getValueB() == null && "ENABLED".equals(fd.getValueA());
    }

    public static boolean isNewRelationshipAutoTerminatedAndDefaulted(FlowDifference fd, VersionedProcessGroup processGroup, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.AUTO_TERMINATED_RELATIONSHIPS_CHANGED) {
            return false;
        }
        if (!(fd.getComponentA() instanceof VersionedProcessor) || !(fd.getComponentB() instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        VersionedProcessor processorA = (VersionedProcessor)fd.getComponentA();
        VersionedProcessor processorB = (VersionedProcessor)fd.getComponentB();
        Set autoTerminatedA = processorA.getAutoTerminatedRelationships();
        Set autoTerminatedB = processorB.getAutoTerminatedRelationships();
        if (autoTerminatedB.size() < autoTerminatedA.size() || !autoTerminatedB.containsAll(autoTerminatedA)) {
            return false;
        }
        InstantiatedVersionedProcessor instantiatedVersionedProcessor = (InstantiatedVersionedProcessor)processorB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedVersionedProcessor.getInstanceId());
        if (processorNode == null) {
            return false;
        }
        HashSet newlyAddedAutoTerminated = new HashSet(autoTerminatedB);
        newlyAddedAutoTerminated.removeAll(autoTerminatedA);
        for (String relationshipName : newlyAddedAutoTerminated) {
            Relationship relationship = processorNode.getRelationship(relationshipName);
            if (relationship == null) {
                return false;
            }
            boolean defaultAutoTerminated = relationship.isAutoTerminated();
            if (!defaultAutoTerminated) {
                return false;
            }
            if (!FlowDifferenceFilters.hasConnection(processGroup, processorA, relationshipName)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasConnection(VersionedProcessGroup processGroup, VersionedProcessor processor, String relationship) {
        for (VersionedConnection connection : processGroup.getConnections()) {
            if (!connection.getSource().getId().equals(processor.getIdentifier()) || !connection.getSelectedRelationships().contains(relationship)) continue;
            return true;
        }
        return false;
    }
}

