/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;

public class ThreadUtils {
    public static String createStackTrace(Thread thread, ThreadInfo threadInfo, long[] deadlockedThreadIds, long[] monitorDeadlockThreadIds, long activeMillis) {
        StackTraceElement[] stackTraces;
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(threadInfo.getThreadName()).append("\" Id=");
        sb.append(threadInfo.getThreadId()).append(" ");
        sb.append(threadInfo.getThreadState().toString()).append(" ");
        switch (threadInfo.getThreadState()) {
            case BLOCKED: 
            case TIMED_WAITING: 
            case WAITING: {
                sb.append(" on ");
                sb.append(threadInfo.getLockInfo());
                break;
            }
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native code)");
        }
        if (deadlockedThreadIds != null && deadlockedThreadIds.length > 0) {
            for (long id : deadlockedThreadIds) {
                if (id != threadInfo.getThreadId()) continue;
                sb.append(" ** DEADLOCKED THREAD **");
            }
        }
        if (monitorDeadlockThreadIds != null && monitorDeadlockThreadIds.length > 0) {
            for (long id : monitorDeadlockThreadIds) {
                if (id != threadInfo.getThreadId()) continue;
                sb.append(" ** MONITOR-DEADLOCKED THREAD **");
            }
        }
        for (StackTraceElement element : stackTraces = threadInfo.getStackTrace()) {
            MonitorInfo[] monitors;
            sb.append("\n\tat ").append(element);
            for (MonitorInfo monitor : monitors = threadInfo.getLockedMonitors()) {
                if (!monitor.getLockedStackFrame().equals(element)) continue;
                sb.append("\n\t- waiting on ").append(monitor);
            }
        }
        LockInfo[] lockInfos = threadInfo.getLockedSynchronizers();
        if (lockInfos.length > 0) {
            sb.append("\n\t");
            sb.append("Number of Locked Synchronizers: ").append(lockInfos.length);
            for (LockInfo lockInfo : lockInfos) {
                sb.append("\n\t- ").append(lockInfo.toString());
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

