/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.groups.DataValve;
import org.apache.nifi.groups.FlowFileConcurrency;
import org.apache.nifi.groups.FlowFileGate;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPort
extends AbstractPort {
    private static final Logger logger = LoggerFactory.getLogger(LocalPort.class);
    static final String MAX_CONCURRENT_TASKS_PROP_NAME = "_nifi.funnel.max.concurrent.tasks";
    static final String MAX_TRANSFERRED_FLOWFILES_PROP_NAME = "_nifi.funnel.max.transferred.flowfiles";
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final int maxIterations;

    public LocalPort(String id, String name, ConnectableType type, ProcessScheduler scheduler, NiFiProperties nifiProperties) {
        super(id, name, type, scheduler);
        int maxConcurrentTasks = Integer.parseInt(nifiProperties.getProperty(MAX_CONCURRENT_TASKS_PROP_NAME, "1"));
        this.setMaxConcurrentTasks(maxConcurrentTasks);
        int maxTransferredFlowFiles = Integer.parseInt(nifiProperties.getProperty(MAX_TRANSFERRED_FLOWFILES_PROP_NAME, "10000"));
        this.maxIterations = Math.max(1, (int)Math.ceil((double)maxTransferredFlowFiles / 1000.0));
        this.setYieldPeriod(nifiProperties.getBoredYieldDuration());
    }

    protected int getMaxIterations() {
        return this.maxIterations;
    }

    public boolean isValid() {
        return this.hasIncomingConnection() && this.hasOutboundConnection();
    }

    private boolean hasOutboundConnection() {
        return !this.getConnections(Relationship.ANONYMOUS).isEmpty();
    }

    public Collection<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> validationErrors = new ArrayList<ValidationResult>();
        if (!this.hasIncomingConnection()) {
            validationErrors.add(new ValidationResult.Builder().explanation("Port has no incoming connections").subject(String.format("Port '%s'", this.getName())).valid(false).build());
        }
        if (!this.hasOutboundConnection()) {
            validationErrors.add(new ValidationResult.Builder().explanation("Port has no outgoing connections").subject(String.format("Port '%s'", this.getName())).valid(false).build());
        }
        return validationErrors;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        this.readLock.lock();
        try {
            if (this.getConnectableType() == ConnectableType.OUTPUT_PORT) {
                this.triggerOutputPort(context, session);
            } else {
                this.triggerInputPort(context, session);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerOutputPort(ProcessContext context, ProcessSession session) {
        DataValve dataValve = this.getProcessGroup().getDataValve((Port)this);
        boolean shouldTransfer = this.isTransferDataOut();
        if (shouldTransfer) {
            if (!dataValve.tryOpenFlowOutOfGroup(this.getProcessGroup())) {
                logger.trace("{} will not transfer data out of Process Group because Data Valve prevents data from flowing out of the Process Group", (Object)this);
                context.yield();
                return;
            }
            try {
                this.transferUnboundedConcurrency(context, session);
            }
            finally {
                dataValve.closeFlowOutOfGroup(this.getProcessGroup());
            }
        } else {
            context.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void triggerInputPort(ProcessContext context, ProcessSession session) {
        FlowFileGate flowFileGate = this.getProcessGroup().getFlowFileGate();
        boolean obtainedClaim = flowFileGate.tryClaim((Port)this);
        if (!obtainedClaim) {
            logger.trace("{} failed to obtain claim for FlowFileGate. Will yield and will not transfer any FlowFiles", (Object)this);
            context.yield();
            return;
        }
        try {
            logger.trace("{} obtained claim for FlowFileGate", (Object)this);
            FlowFileConcurrency flowFileConcurrency = this.getProcessGroup().getFlowFileConcurrency();
            switch (flowFileConcurrency) {
                case UNBOUNDED: {
                    this.transferUnboundedConcurrency(context, session);
                    return;
                }
                case SINGLE_FLOWFILE_PER_NODE: {
                    this.transferSingleFlowFile(session);
                    return;
                }
                case SINGLE_BATCH_PER_NODE: {
                    this.transferInputBatch(session);
                    return;
                }
            }
            return;
        }
        finally {
            flowFileGate.releaseClaim((Port)this);
            logger.trace("{} released claim for FlowFileGate", (Object)this);
        }
    }

    private boolean isTransferDataOut() {
        FlowFileConcurrency flowFileConcurrency = this.getProcessGroup().getFlowFileConcurrency();
        if (flowFileConcurrency == FlowFileConcurrency.UNBOUNDED) {
            logger.trace("{} will transfer data out of Process Group because FlowFile Concurrency is Unbounded", (Object)this);
            return true;
        }
        FlowFileOutboundPolicy outboundPolicy = this.getProcessGroup().getFlowFileOutboundPolicy();
        if (outboundPolicy == FlowFileOutboundPolicy.STREAM_WHEN_AVAILABLE) {
            logger.trace("{} will transfer data out of Process Group because FlowFile Outbound Policy is Stream When Available", (Object)this);
            return true;
        }
        boolean queuedForProcessing = this.getProcessGroup().isDataQueuedForProcessing();
        if (queuedForProcessing) {
            logger.trace("{} will not transfer data out of Process Group because FlowFile Outbound Policy is Batch Output and there is data queued for Processing", (Object)this);
            return false;
        }
        logger.trace("{} will transfer data out of Process Group because there is no data queued for processing", (Object)this);
        return true;
    }

    private void transferInputBatch(ProcessSession session) {
        ProcessGroup processGroup = this.getProcessGroup();
        while (session.getQueueSize().getObjectCount() > 0) {
            List flowFiles = session.get(10000);
            session.transfer((Collection)flowFiles, Relationship.ANONYMOUS);
            session.commit();
            logger.debug("{} Successfully transferred {} FlowFiles into {}", new Object[]{this, flowFiles.size(), processGroup});
        }
    }

    private void transferSingleFlowFile(ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        session.transfer(flowFile, Relationship.ANONYMOUS);
        this.getProcessGroup().getBatchCounts().reset();
        logger.debug("{} Transferred Single FlowFile", (Object)this);
    }

    protected void transferUnboundedConcurrency(ProcessContext context, ProcessSession session) {
        List flowFiles;
        HashMap attributes = new HashMap();
        Map counts = this.getProcessGroup().getBatchCounts().captureCounts();
        counts.forEach((k, v) -> attributes.put("batch.output." + k, String.valueOf(v)));
        Set available = context.getAvailableRelationships();
        int iterations = 0;
        while (!available.isEmpty() && !(flowFiles = session.get(1000)).isEmpty()) {
            if (!attributes.isEmpty()) {
                flowFiles.forEach(ff -> session.putAllAttributes(ff, attributes));
            }
            session.transfer((Collection)flowFiles, Relationship.ANONYMOUS);
            session.commit();
            logger.debug("{} Transferred {} FlowFiles", (Object)this, (Object)flowFiles.size());
            if (flowFiles.size() < 1000 || ++iterations >= this.maxIterations) break;
            available = context.getAvailableRelationships();
        }
    }

    public void updateConnection(Connection connection) throws IllegalStateException {
        this.writeLock.lock();
        try {
            super.updateConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addConnection(Connection connection) throws IllegalArgumentException {
        this.writeLock.lock();
        try {
            super.addConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeConnection(Connection connection) throws IllegalArgumentException, IllegalStateException {
        this.writeLock.lock();
        try {
            super.removeConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            Set set = super.getConnections();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Connection> getConnections(Relationship relationship) {
        this.readLock.lock();
        try {
            Set set = super.getConnections(relationship);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Connection> getIncomingConnections() {
        this.readLock.lock();
        try {
            List list = super.getIncomingConnections();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasIncomingConnection() {
        this.readLock.lock();
        try {
            boolean bl = super.hasIncomingConnection();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isTriggerWhenEmpty() {
        return false;
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    public boolean isSideEffectFree() {
        return true;
    }

    public String getComponentType() {
        return "Local Port";
    }

    public String toString() {
        return "LocalPort[id=" + this.getIdentifier() + ", type=" + this.getConnectableType() + ", name=" + this.getName() + ", group=" + this.getProcessGroup().getName() + "]";
    }
}

