/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.management.NotificationEmitter;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.Heartbeat;
import org.apache.nifi.cluster.protocol.HeartbeatPayload;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.UnknownServiceAddressException;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.StandardValidationTrigger;
import org.apache.nifi.components.validation.TriggerValidationTask;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.StandardConnection;
import org.apache.nifi.controller.ClusterCoordinatorNodeInformant;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ContentAvailability;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.EventDrivenWorkerQueue;
import org.apache.nifi.controller.GarbageCollectionLog;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.RingBufferGarbageCollectionLog;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardReloadComponent;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.cluster.ClusterProtocolHeartbeater;
import org.apache.nifi.controller.cluster.Heartbeater;
import org.apache.nifi.controller.exception.CommunicationsException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.flow.StandardFlowManager;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionStateChangeListener;
import org.apache.nifi.controller.queue.AbstractFlowFileQueue;
import org.apache.nifi.controller.queue.ConnectionEventListener;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueueFactory;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.StandardFlowFileQueue;
import org.apache.nifi.controller.queue.clustered.ContentRepositoryFlowFileAccess;
import org.apache.nifi.controller.queue.clustered.SocketLoadBalancedFlowFileQueue;
import org.apache.nifi.controller.queue.clustered.client.StandardLoadBalanceFlowFileCodec;
import org.apache.nifi.controller.queue.clustered.client.async.nio.NioAsyncLoadBalanceClientFactory;
import org.apache.nifi.controller.queue.clustered.client.async.nio.NioAsyncLoadBalanceClientRegistry;
import org.apache.nifi.controller.queue.clustered.client.async.nio.NioAsyncLoadBalanceClientTask;
import org.apache.nifi.controller.queue.clustered.server.ClusterLoadBalanceAuthorizer;
import org.apache.nifi.controller.queue.clustered.server.ConnectionLoadBalanceServer;
import org.apache.nifi.controller.queue.clustered.server.StandardLoadBalanceProtocol;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.EncryptedRepositoryRecordSerdeFactory;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryRecordSerdeFactory;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.StandardCounterRepository;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.StandardQueueProvider;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.SwapManagerInitializationContext;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.WriteAheadFlowFileRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.repository.claim.StandardResourceClaimManager;
import org.apache.nifi.controller.repository.io.LimitedInputStream;
import org.apache.nifi.controller.scheduling.EventDrivenSchedulingAgent;
import org.apache.nifi.controller.scheduling.QuartzSchedulingAgent;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.scheduling.TimerDrivenSchedulingAgent;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSerializer;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.FlowSynchronizer;
import org.apache.nifi.controller.serialization.ScheduledStateLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceProvider;
import org.apache.nifi.controller.state.manager.StandardStateManagerProvider;
import org.apache.nifi.controller.state.server.ZooKeeperStateServer;
import org.apache.nifi.controller.status.analytics.CachingConnectionStatusAnalyticsEngine;
import org.apache.nifi.controller.status.analytics.ConnectionStatusAnalytics;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModelMapFactory;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.StandardGarbageCollectionStatus;
import org.apache.nifi.controller.status.history.StatusHistoryUtil;
import org.apache.nifi.controller.tasks.ExpireFlowFiles;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.diagnostics.SystemDiagnosticsFactory;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.StandardProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.StandardParameterContextManager;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ComponentIdentifierLookup;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.StandardProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.VersionedConnection;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.variable.MutableVariableRegistry;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RemoteResourceManager;
import org.apache.nifi.remote.RemoteSiteListener;
import org.apache.nifi.remote.SocketRemoteSiteListener;
import org.apache.nifi.remote.cluster.NodeInformant;
import org.apache.nifi.remote.protocol.socket.SocketFlowFileServerProtocol;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.reporting.StandardEventAccess;
import org.apache.nifi.reporting.UserAwareEventAccess;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.ComponentIdGenerator;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.concurrency.TimedLock;
import org.apache.nifi.wali.EncryptedSequentialAccessWriteAheadLog;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowController
implements ReportingTaskProvider,
Authorizable,
NodeTypeProvider {
    public static final String DEFAULT_FLOWFILE_REPO_IMPLEMENTATION = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository";
    public static final String DEFAULT_CONTENT_REPO_IMPLEMENTATION = "org.apache.nifi.controller.repository.FileSystemRepository";
    public static final String DEFAULT_PROVENANCE_REPO_IMPLEMENTATION = "org.apache.nifi.provenance.VolatileProvenanceRepository";
    public static final String DEFAULT_SWAP_MANAGER_IMPLEMENTATION = "org.apache.nifi.controller.FileSystemSwapManager";
    public static final String DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION = "org.apache.nifi.controller.status.history.VolatileComponentStatusRepository";
    public static final String SCHEDULE_MINIMUM_NANOSECONDS = "flowcontroller.minimum.nanoseconds";
    public static final String GRACEFUL_SHUTDOWN_PERIOD = "nifi.flowcontroller.graceful.shutdown.seconds";
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_SECONDS = 10L;
    public static final int METRICS_RESERVOIR_SIZE = 288;
    public static final double DEFAULT_POSITION_SCALE_FACTOR_X = 1.5;
    public static final double DEFAULT_POSITION_SCALE_FACTOR_Y = 1.34;
    private final AtomicInteger maxTimerDrivenThreads;
    private final AtomicInteger maxEventDrivenThreads;
    private final AtomicReference<FlowEngine> timerDrivenEngineRef;
    private final AtomicReference<FlowEngine> eventDrivenEngineRef;
    private final EventDrivenSchedulingAgent eventDrivenSchedulingAgent;
    private final ContentRepository contentRepository;
    private final FlowFileRepository flowFileRepository;
    private final FlowFileEventRepository flowFileEventRepository;
    private final ProvenanceRepository provenanceRepository;
    private final BulletinRepository bulletinRepository;
    private final StandardProcessScheduler processScheduler;
    private final SnippetManager snippetManager;
    private final long gracefulShutdownSeconds;
    private final ExtensionManager extensionManager;
    private final NiFiProperties nifiProperties;
    private final SSLContext sslContext;
    private final Set<RemoteSiteListener> externalSiteListeners = new HashSet<RemoteSiteListener>();
    private final AtomicReference<CounterRepository> counterRepositoryRef;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean flowSynchronized = new AtomicBoolean(false);
    private final StandardControllerServiceProvider controllerServiceProvider;
    private final Authorizer authorizer;
    private final AuditService auditService;
    private final EventDrivenWorkerQueue eventDrivenWorkerQueue;
    private final ComponentStatusRepository componentStatusRepository;
    private final StateManagerProvider stateManagerProvider;
    private final long systemStartTime = System.currentTimeMillis();
    private final VariableRegistry variableRegistry;
    private final ConnectionLoadBalanceServer loadBalanceServer;
    private final NioAsyncLoadBalanceClientRegistry loadBalanceClientRegistry;
    private final FlowEngine loadBalanceClientThreadPool;
    private final Set<NioAsyncLoadBalanceClientTask> loadBalanceClientTasks = new HashSet<NioAsyncLoadBalanceClientTask>();
    private final ConcurrentMap<String, ProcessorNode> allProcessors = new ConcurrentHashMap<String, ProcessorNode>();
    private final ConcurrentMap<String, ProcessGroup> allProcessGroups = new ConcurrentHashMap<String, ProcessGroup>();
    private final ConcurrentMap<String, Connection> allConnections = new ConcurrentHashMap<String, Connection>();
    private final ConcurrentMap<String, Port> allInputPorts = new ConcurrentHashMap<String, Port>();
    private final ConcurrentMap<String, Port> allOutputPorts = new ConcurrentHashMap<String, Port>();
    private final ConcurrentMap<String, Funnel> allFunnels = new ConcurrentHashMap<String, Funnel>();
    private final ZooKeeperStateServer zooKeeperStateServer;
    private final AtomicReference<HeartbeatBean> heartbeatBeanRef = new AtomicReference();
    private final AtomicBoolean heartbeatsSuspended = new AtomicBoolean(false);
    private final Integer remoteInputSocketPort;
    private final Integer remoteInputHttpPort;
    private final Boolean isSiteToSiteSecure;
    private final List<Connectable> startConnectablesAfterInitialization;
    private final List<RemoteGroupPort> startRemoteGroupPortsAfterInitialization;
    private final LeaderElectionManager leaderElectionManager;
    private final ClusterCoordinator clusterCoordinator;
    private final FlowRegistryClient flowRegistryClient;
    private final FlowEngine validationThreadPool;
    private final ValidationTrigger validationTrigger;
    private final ReloadComponent reloadComponent;
    private final ProvenanceAuthorizableFactory provenanceAuthorizableFactory;
    private final UserAwareEventAccess eventAccess;
    private final ParameterContextManager parameterContextManager;
    private final StandardFlowManager flowManager;
    private final RepositoryContextFactory repositoryContextFactory;
    private final RingBufferGarbageCollectionLog gcLog;
    private final boolean configuredForClustering;
    private final int heartbeatDelaySeconds;
    private final StringEncryptor encryptor;
    private final ScheduledExecutorService clusterTaskExecutor = new FlowEngine(3, "Clustering Tasks", true);
    private final ResourceClaimManager resourceClaimManager = new StandardResourceClaimManager();
    private ScheduledFuture<?> heartbeatSenderFuture;
    private final Heartbeater heartbeater;
    private final HeartbeatMonitor heartbeatMonitor;
    private final AtomicReference<HeartbeatSendTask> heartbeatSendTask = new AtomicReference<Object>(null);
    private volatile NodeIdentifier nodeId;
    private boolean clustered;
    private NodeConnectionStatus connectionStatus;
    private StatusAnalyticsEngine analyticsEngine;
    private String instanceId;
    private volatile boolean shutdown = false;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final TimedLock readLock = new TimedLock((Lock)this.rwLock.readLock(), "FlowControllerReadLock", 1);
    private final TimedLock writeLock = new TimedLock((Lock)this.rwLock.writeLock(), "FlowControllerWriteLock", 1);
    private static final Logger LOG = LoggerFactory.getLogger(FlowController.class);

    public static FlowController createStandaloneInstance(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, Authorizer authorizer, AuditService auditService, StringEncryptor encryptor, BulletinRepository bulletinRepo, VariableRegistry variableRegistry, FlowRegistryClient flowRegistryClient, ExtensionManager extensionManager) {
        return new FlowController(flowFileEventRepo, properties, authorizer, auditService, encryptor, false, null, bulletinRepo, null, null, null, variableRegistry, flowRegistryClient, extensionManager);
    }

    public static FlowController createClusteredInstance(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, Authorizer authorizer, AuditService auditService, StringEncryptor encryptor, NodeProtocolSender protocolSender, BulletinRepository bulletinRepo, ClusterCoordinator clusterCoordinator, HeartbeatMonitor heartbeatMonitor, LeaderElectionManager leaderElectionManager, VariableRegistry variableRegistry, FlowRegistryClient flowRegistryClient, ExtensionManager extensionManager) {
        FlowController flowController = new FlowController(flowFileEventRepo, properties, authorizer, auditService, encryptor, true, protocolSender, bulletinRepo, clusterCoordinator, heartbeatMonitor, leaderElectionManager, variableRegistry, flowRegistryClient, extensionManager);
        return flowController;
    }

    private FlowController(FlowFileEventRepository flowFileEventRepo, NiFiProperties nifiProperties, Authorizer authorizer, AuditService auditService, StringEncryptor encryptor, boolean configuredForClustering, NodeProtocolSender protocolSender, BulletinRepository bulletinRepo, ClusterCoordinator clusterCoordinator, HeartbeatMonitor heartbeatMonitor, LeaderElectionManager leaderElectionManager, VariableRegistry variableRegistry, FlowRegistryClient flowRegistryClient, ExtensionManager extensionManager) {
        long snapshotMillis;
        long shutdownSecs;
        FlowFileRepository flowFileRepo;
        this.maxTimerDrivenThreads = new AtomicInteger(10);
        this.maxEventDrivenThreads = new AtomicInteger(1);
        this.encryptor = encryptor;
        this.nifiProperties = nifiProperties;
        this.heartbeatMonitor = heartbeatMonitor;
        this.leaderElectionManager = leaderElectionManager;
        this.extensionManager = extensionManager;
        this.clusterCoordinator = clusterCoordinator;
        this.authorizer = authorizer;
        this.auditService = auditService;
        this.configuredForClustering = configuredForClustering;
        this.flowRegistryClient = flowRegistryClient;
        try {
            StandardTlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)nifiProperties);
            this.sslContext = SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
        }
        catch (TlsException e) {
            LOG.error("Unable to start the flow controller because the TLS configuration was invalid: {}", (Object)e.getLocalizedMessage());
            throw new IllegalStateException("Flow controller TLS configuration is invalid", e);
        }
        this.timerDrivenEngineRef = new AtomicReference<FlowEngine>(new FlowEngine(this.maxTimerDrivenThreads.get(), "Timer-Driven Process"));
        this.eventDrivenEngineRef = new AtomicReference<FlowEngine>(new FlowEngine(this.maxEventDrivenThreads.get(), "Event-Driven Process"));
        this.flowFileRepository = flowFileRepo = FlowController.createFlowFileRepository(nifiProperties, extensionManager, this.resourceClaimManager);
        this.flowFileEventRepository = flowFileEventRepo;
        this.counterRepositoryRef = new AtomicReference<StandardCounterRepository>(new StandardCounterRepository());
        this.gcLog = new RingBufferGarbageCollectionLog(1000, 20L);
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mxBean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)mxBean)).addNotificationListener(this.gcLog, null, null);
        }
        this.bulletinRepository = bulletinRepo;
        this.variableRegistry = variableRegistry == null ? VariableRegistry.EMPTY_REGISTRY : variableRegistry;
        try {
            this.provenanceAuthorizableFactory = new StandardProvenanceAuthorizableFactory(this);
            this.provenanceRepository = this.createProvenanceRepository(nifiProperties);
            ComponentIdentifierLookup identifierLookup = new ComponentIdentifierLookup(this);
            this.provenanceRepository.initialize(this.createEventReporter(), authorizer, this.provenanceAuthorizableFactory, (IdentifierLookup)identifierLookup);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Provenance Repository", e);
        }
        try {
            this.contentRepository = this.createContentRepository(nifiProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Content Repository", e);
        }
        try {
            this.stateManagerProvider = StandardStateManagerProvider.create(nifiProperties, this.variableRegistry, extensionManager, ParameterLookup.EMPTY);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.processScheduler = new StandardProcessScheduler(this.timerDrivenEngineRef.get(), this, encryptor, this.stateManagerProvider, this.nifiProperties);
        this.eventDrivenWorkerQueue = new EventDrivenWorkerQueue(false, false, this.processScheduler);
        this.parameterContextManager = new StandardParameterContextManager();
        this.repositoryContextFactory = new RepositoryContextFactory(this.contentRepository, this.flowFileRepository, this.flowFileEventRepository, this.counterRepositoryRef.get(), this.provenanceRepository);
        this.flowManager = new StandardFlowManager(nifiProperties, this.sslContext, this, this.flowFileEventRepository, this.parameterContextManager);
        this.controllerServiceProvider = new StandardControllerServiceProvider(this, this.processScheduler, this.bulletinRepository);
        this.eventDrivenSchedulingAgent = new EventDrivenSchedulingAgent(this.eventDrivenEngineRef.get(), this.controllerServiceProvider, this.stateManagerProvider, this.eventDrivenWorkerQueue, this.repositoryContextFactory, this.maxEventDrivenThreads.get(), encryptor, extensionManager);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.EVENT_DRIVEN, this.eventDrivenSchedulingAgent);
        QuartzSchedulingAgent quartzSchedulingAgent = new QuartzSchedulingAgent(this, this.timerDrivenEngineRef.get(), this.repositoryContextFactory, encryptor);
        TimerDrivenSchedulingAgent timerDrivenAgent = new TimerDrivenSchedulingAgent(this, this.timerDrivenEngineRef.get(), this.repositoryContextFactory, encryptor, this.nifiProperties);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.TIMER_DRIVEN, timerDrivenAgent);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.PRIMARY_NODE_ONLY, timerDrivenAgent);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.CRON_DRIVEN, quartzSchedulingAgent);
        this.startConnectablesAfterInitialization = new ArrayList<Connectable>();
        this.startRemoteGroupPortsAfterInitialization = new ArrayList<RemoteGroupPort>();
        String gracefulShutdownSecondsVal = nifiProperties.getProperty(GRACEFUL_SHUTDOWN_PERIOD);
        try {
            shutdownSecs = Long.parseLong(gracefulShutdownSecondsVal);
            if (shutdownSecs < 1L) {
                shutdownSecs = 10L;
            }
        }
        catch (NumberFormatException nfe) {
            shutdownSecs = 10L;
        }
        this.gracefulShutdownSeconds = shutdownSecs;
        this.remoteInputSocketPort = nifiProperties.getRemoteInputPort();
        this.remoteInputHttpPort = nifiProperties.getRemoteInputHttpPort();
        this.isSiteToSiteSecure = nifiProperties.isSiteToSiteSecure();
        if (this.isSiteToSiteSecure.booleanValue() && this.sslContext == null && this.remoteInputSocketPort != null) {
            throw new IllegalStateException("NiFi Configured to allow Secure Site-to-Site communications but the Keystore/Truststore properties are not configured");
        }
        this.heartbeatDelaySeconds = (int)FormatUtils.getTimeDuration((String)nifiProperties.getNodeHeartbeatInterval(), (TimeUnit)TimeUnit.SECONDS);
        this.snippetManager = new SnippetManager();
        this.reloadComponent = new StandardReloadComponent(this);
        StandardProcessGroup rootGroup = new StandardProcessGroup(ComponentIdGenerator.generateId().toString(), this.controllerServiceProvider, this.processScheduler, nifiProperties, encryptor, this, new MutableVariableRegistry(this.variableRegistry));
        rootGroup.setName("NiFi Flow");
        this.setRootGroup(rootGroup);
        this.instanceId = ComponentIdGenerator.generateId().toString();
        this.validationThreadPool = new FlowEngine(5, "Validate Components", true);
        this.validationTrigger = new StandardValidationTrigger(this.validationThreadPool, this::isInitialized);
        if (this.remoteInputSocketPort == null) {
            LOG.info("Not enabling RAW Socket Site-to-Site functionality because nifi.remote.input.socket.port is not set");
        } else if (this.isSiteToSiteSecure.booleanValue() && this.sslContext == null) {
            LOG.error("Unable to create Secure Site-to-Site Listener because not all required Keystore/Truststore Properties are set. Site-to-Site functionality will be disabled until this problem is has been fixed.");
        } else {
            RemoteResourceManager.setServerProtocolImplementation((String)"SocketFlowFileProtocol", SocketFlowFileServerProtocol.class);
            ClusterCoordinatorNodeInformant nodeInformant = configuredForClustering ? new ClusterCoordinatorNodeInformant(clusterCoordinator) : null;
            this.externalSiteListeners.add((RemoteSiteListener)new SocketRemoteSiteListener(this.remoteInputSocketPort.intValue(), this.isSiteToSiteSecure != false ? this.sslContext : null, nifiProperties, (NodeInformant)nodeInformant));
        }
        if (this.remoteInputHttpPort == null) {
            LOG.info("Not enabling HTTP(S) Site-to-Site functionality because the 'nifi.remote.input.http.enabled' property is not true");
        } else {
            this.externalSiteListeners.add((RemoteSiteListener)HttpRemoteSiteListener.getInstance((NiFiProperties)nifiProperties));
        }
        for (RemoteSiteListener listener : this.externalSiteListeners) {
            listener.setRootGroup((ProcessGroup)rootGroup);
        }
        String snapshotFrequency = nifiProperties.getProperty("nifi.components.status.snapshot.frequency", "5 mins");
        try {
            snapshotMillis = FormatUtils.getTimeDuration((String)snapshotFrequency, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            snapshotMillis = FormatUtils.getTimeDuration((String)"5 mins", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (nifiProperties.isStartEmbeddedZooKeeper() && configuredForClustering) {
            try {
                this.zooKeeperStateServer = ZooKeeperStateServer.create(nifiProperties);
                this.zooKeeperStateServer.start();
            }
            catch (IOException | QuorumPeerConfig.ConfigException e) {
                throw new IllegalStateException("Unable to initialize Flow because NiFi was configured to start an Embedded Zookeeper server but failed to do so", e);
            }
        } else {
            this.zooKeeperStateServer = null;
        }
        this.componentStatusRepository = this.createComponentStatusRepository();
        boolean analyticsEnabled = Boolean.parseBoolean(nifiProperties.getProperty("nifi.analytics.predict.enabled", "false"));
        if (analyticsEnabled) {
            Double modelScoreThreshold;
            long queryIntervalMillis;
            long predictionIntervalMillis;
            String predictionInterval = nifiProperties.getProperty("nifi.analytics.predict.interval", "3 mins");
            try {
                predictionIntervalMillis = FormatUtils.getTimeDuration((String)predictionInterval, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.warn("Analytics is enabled however could not retrieve value for nifi.analytics.predict.interval. This property has been set to '3 mins'");
                predictionIntervalMillis = FormatUtils.getTimeDuration((String)"3 mins", (TimeUnit)TimeUnit.MILLISECONDS);
            }
            String queryInterval = nifiProperties.getProperty("nifi.analytics.query.interval", "3 mins");
            try {
                queryIntervalMillis = FormatUtils.getTimeDuration((String)queryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.warn("Analytics is enabled however could not retrieve value for nifi.analytics.query.interval. This property has been set to '3 mins'");
                queryIntervalMillis = FormatUtils.getTimeDuration((String)"3 mins", (TimeUnit)TimeUnit.MILLISECONDS);
            }
            String modelScoreName = nifiProperties.getProperty("nifi.analytics.connection.model.score.name", "rSquared");
            try {
                modelScoreThreshold = Double.valueOf(nifiProperties.getProperty("nifi.analytics.connection.model.score.threshold", Double.toString(0.9)));
            }
            catch (Exception e) {
                LOG.warn("Analytics is enabled however could not retrieve value for nifi.analytics.connection.model.score.threshold. This property has been set to '0.9'.");
                modelScoreThreshold = 0.9;
            }
            StatusAnalyticsModelMapFactory statusAnalyticsModelMapFactory = new StatusAnalyticsModelMapFactory(extensionManager, nifiProperties);
            this.analyticsEngine = new CachingConnectionStatusAnalyticsEngine(this.flowManager, this.componentStatusRepository, statusAnalyticsModelMapFactory, predictionIntervalMillis, queryIntervalMillis, modelScoreName, modelScoreThreshold);
            this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        Long startTs = System.currentTimeMillis();
                        RepositoryStatusReport statusReport = FlowController.this.flowFileEventRepository.reportTransferEvents(startTs.longValue());
                        FlowController.this.flowManager.findAllConnections().forEach(connection -> {
                            ConnectionStatusAnalytics connectionStatusAnalytics = (ConnectionStatusAnalytics)FlowController.this.analyticsEngine.getStatusAnalytics(connection.getIdentifier());
                            connectionStatusAnalytics.refresh();
                            connectionStatusAnalytics.loadPredictions(statusReport);
                        });
                        Long endTs = System.currentTimeMillis();
                        LOG.debug("Time Elapsed for Prediction for loading all predictions: {}", (Object)(endTs - startTs));
                    }
                    catch (Exception e) {
                        LOG.error("Failed to generate predictions", (Throwable)e);
                    }
                }
            }, 0L, 15L, TimeUnit.SECONDS);
        }
        this.eventAccess = new StandardEventAccess(this, this.flowFileEventRepository);
        this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    FlowController.this.componentStatusRepository.capture(FlowController.this.eventAccess.getControllerStatus(), FlowController.this.getGarbageCollectionStatus());
                }
                catch (Exception e) {
                    LOG.error("Failed to capture component stats for Stats History", (Throwable)e);
                }
            }
        }, snapshotMillis, snapshotMillis, TimeUnit.MILLISECONDS);
        this.connectionStatus = new NodeConnectionStatus(this.nodeId, DisconnectionCode.NOT_YET_CONNECTED);
        this.heartbeatBeanRef.set(new HeartbeatBean(rootGroup, false));
        if (configuredForClustering) {
            this.heartbeater = new ClusterProtocolHeartbeater(protocolSender, clusterCoordinator, leaderElectionManager);
            LOG.info("Checking if there is already a Cluster Coordinator Elected...");
            String clusterCoordinatorAddress = leaderElectionManager.getLeader("Cluster Coordinator");
            if (StringUtils.isEmpty((CharSequence)clusterCoordinatorAddress)) {
                LOG.info("It appears that no Cluster Coordinator has been Elected yet. Registering for Cluster Coordinator Role.");
                this.registerForClusterCoordinator(true);
            } else {
                LOG.info("The Election for Cluster Coordinator has already begun (Leader is {}). Will not register to be elected for this role until after connecting to the cluster and inheriting the cluster's flow.", (Object)clusterCoordinatorAddress);
                this.registerForClusterCoordinator(false);
            }
            leaderElectionManager.start();
            heartbeatMonitor.start();
            InetSocketAddress loadBalanceAddress = nifiProperties.getClusterLoadBalanceAddress();
            EventReporter eventReporter = this.createEventReporter();
            ClusterLoadBalanceAuthorizer authorizeConnection = new ClusterLoadBalanceAuthorizer(clusterCoordinator, eventReporter);
            StandardLoadBalanceProtocol loadBalanceProtocol = new StandardLoadBalanceProtocol(flowFileRepo, this.contentRepository, this.provenanceRepository, this, authorizeConnection);
            int numThreads = nifiProperties.getIntegerProperty("nifi.cluster.load.balance.max.thread.count", Integer.valueOf(8));
            String timeoutPeriod = nifiProperties.getProperty("nifi.cluster.load.balance.comms.timeout", "30 sec");
            int timeoutMillis = (int)FormatUtils.getTimeDuration((String)timeoutPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
            this.loadBalanceServer = new ConnectionLoadBalanceServer(loadBalanceAddress.getHostName(), loadBalanceAddress.getPort(), this.sslContext, numThreads, loadBalanceProtocol, eventReporter, timeoutMillis);
            int connectionsPerNode = nifiProperties.getIntegerProperty("nifi.cluster.load.balance.connections.per.node", Integer.valueOf(4));
            NioAsyncLoadBalanceClientFactory asyncClientFactory = new NioAsyncLoadBalanceClientFactory(this.sslContext, timeoutMillis, new ContentRepositoryFlowFileAccess(this.contentRepository), eventReporter, new StandardLoadBalanceFlowFileCodec());
            this.loadBalanceClientRegistry = new NioAsyncLoadBalanceClientRegistry(asyncClientFactory, connectionsPerNode);
            int loadBalanceClientThreadCount = nifiProperties.getIntegerProperty("nifi.cluster.load.balance.max.thread.count", Integer.valueOf(8));
            this.loadBalanceClientThreadPool = new FlowEngine(loadBalanceClientThreadCount, "Load-Balanced Client", true);
            for (int i = 0; i < loadBalanceClientThreadCount; ++i) {
                NioAsyncLoadBalanceClientTask clientTask = new NioAsyncLoadBalanceClientTask(this.loadBalanceClientRegistry, clusterCoordinator, eventReporter);
                this.loadBalanceClientTasks.add(clientTask);
                this.loadBalanceClientThreadPool.submit(clientTask);
            }
        } else {
            this.loadBalanceClientRegistry = null;
            this.heartbeater = null;
            this.loadBalanceServer = null;
            this.loadBalanceClientThreadPool = null;
        }
    }

    public Authorizable getParentAuthorizable() {
        return null;
    }

    public Resource getResource() {
        return ResourceFactory.getControllerResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FlowFileRepository createFlowFileRepository(NiFiProperties properties, ExtensionManager extensionManager, ResourceClaimManager contentClaimManager) {
        String implementationClassName = properties.getProperty("nifi.flowfile.repository.implementation", DEFAULT_FLOWFILE_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create FlowFile Repository because the NiFi Properties is missing the following property: nifi.flowfile.repository.implementation");
        }
        try {
            FlowFileRepository created = (FlowFileRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)implementationClassName, FlowFileRepository.class, (NiFiProperties)properties);
            if (EncryptedSequentialAccessWriteAheadLog.class.getName().equals(properties.getProperty("nifi.flowfile.repository.wal.implementation")) && created instanceof WriteAheadFlowFileRepository) {
                FlowFileRepository flowFileRepository = created;
                synchronized (flowFileRepository) {
                    ((WriteAheadFlowFileRepository)created).initialize(contentClaimManager, (RepositoryRecordSerdeFactory)new EncryptedRepositoryRecordSerdeFactory(contentClaimManager, properties));
                }
            }
            FlowFileRepository flowFileRepository = created;
            synchronized (flowFileRepository) {
                created.initialize(contentClaimManager);
            }
            return created;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FlowFileSwapManager createSwapManager() {
        String implementationClassName = this.nifiProperties.getProperty("nifi.swap.manager.implementation", DEFAULT_SWAP_MANAGER_IMPLEMENTATION);
        if (implementationClassName == null) {
            return null;
        }
        try {
            FlowFileSwapManager swapManager = (FlowFileSwapManager)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)implementationClassName, FlowFileSwapManager.class, (NiFiProperties)this.nifiProperties);
            final EventReporter eventReporter = this.createEventReporter();
            try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                SwapManagerInitializationContext initializationContext = new SwapManagerInitializationContext(){

                    public ResourceClaimManager getResourceClaimManager() {
                        return FlowController.this.resourceClaimManager;
                    }

                    public FlowFileRepository getFlowFileRepository() {
                        return FlowController.this.flowFileRepository;
                    }

                    public EventReporter getEventReporter() {
                        return eventReporter;
                    }
                };
                swapManager.initialize(initializationContext);
            }
            return swapManager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EventReporter createEventReporter() {
        return new EventReporter(){
            private static final long serialVersionUID = 1L;

            public void reportEvent(Severity severity, String category, String message) {
                Bulletin bulletin = BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
                FlowController.this.bulletinRepository.addBulletin(bulletin);
            }
        };
    }

    public void purge() {
        this.getFlowManager().purge();
        this.writeLock.lock();
        try {
            this.startConnectablesAfterInitialization.clear();
            this.startRemoteGroupPortsAfterInitialization.clear();
        }
        finally {
            this.writeLock.unlock("purge");
        }
    }

    public void initializeFlow() throws IOException {
        this.initializeFlow(new StandardQueueProvider(this.getFlowManager()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFlow(QueueProvider queueProvider) throws IOException {
        this.writeLock.lock();
        try {
            FlowFileQueue queue;
            Set<Connection> connections = this.flowManager.findAllConnections();
            this.flowFileRepository.loadFlowFiles(queueProvider);
            long maxIdFromSwapFiles = -1L;
            if (this.flowFileRepository.isVolatile()) {
                for (Connection connection : connections) {
                    queue = connection.getFlowFileQueue();
                    queue.purgeSwapFiles();
                }
            } else {
                for (Connection connection : connections) {
                    queue = connection.getFlowFileQueue();
                    SwapSummary swapSummary = queue.recoverSwappedFlowFiles();
                    if (swapSummary == null) continue;
                    Long maxFlowFileId = swapSummary.getMaxFlowFileId();
                    if (maxFlowFileId != null && maxFlowFileId > maxIdFromSwapFiles) {
                        maxIdFromSwapFiles = maxFlowFileId;
                    }
                    for (ResourceClaim resourceClaim : swapSummary.getResourceClaims()) {
                        this.resourceClaimManager.incrementClaimantCount(resourceClaim);
                    }
                }
            }
            this.flowFileRepository.updateMaxFlowFileIdentifier(maxIdFromSwapFiles + 1L);
            RepositoryContextFactory contextFactory = new RepositoryContextFactory(this.contentRepository, this.flowFileRepository, this.flowFileEventRepository, this.counterRepositoryRef.get(), this.provenanceRepository);
            this.processScheduler.scheduleFrameworkTask(new ExpireFlowFiles(this, contextFactory), "Expire FlowFiles", 30L, 30L, TimeUnit.SECONDS);
            this.contentRepository.cleanup();
            for (RemoteSiteListener listener : this.externalSiteListeners) {
                listener.start();
            }
            if (this.loadBalanceServer != null) {
                this.loadBalanceServer.start();
            }
            this.notifyComponentsConfigurationRestored();
            this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            FlowController.this.updateRemoteProcessGroups();
                        }
                        catch (Throwable t) {
                            LOG.warn("Unable to update Remote Process Groups due to " + t);
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.warn("", t);
                        }
                    }
                }
            }, 0L, 30L, TimeUnit.SECONDS);
            this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ProcessGroup rootGroup = FlowController.this.flowManager.getRootGroup();
                    List allGroups = rootGroup.findAllProcessGroups();
                    allGroups.add(rootGroup);
                    for (ProcessGroup group : allGroups) {
                        try {
                            group.synchronizeWithFlowRegistry(FlowController.this.flowRegistryClient);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to synchronize {} with Flow Registry", (Object)group, (Object)e);
                        }
                    }
                }
            }, 5L, 60L, TimeUnit.SECONDS);
            this.initialized.set(true);
        }
        finally {
            this.writeLock.unlock("initializeFlow");
        }
    }

    private void notifyComponentsConfigurationRestored() {
        Throwable throwable;
        NarCloseable nc;
        for (ProcessorNode procNode : this.flowManager.getRootGroup().findAllProcessors()) {
            Processor processor = procNode.getProcessor();
            nc = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, processor.getClass(), (String)processor.getIdentifier());
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)processor, new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nc.close();
            }
        }
        for (ControllerServiceNode serviceNode : this.flowManager.getAllControllerServices()) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            nc = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, service.getClass(), (String)service.getIdentifier());
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, new Object[0]);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                nc.close();
            }
        }
        for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
            ReportingTask task = taskNode.getReportingTask();
            nc = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, task.getClass(), (String)task.getIdentifier());
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)task, new Object[0]);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                nc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFlowInitialized(boolean startDelayedComponents) {
        this.writeLock.lock();
        try {
            LOG.debug("Triggering initial validation of all components");
            long start = System.nanoTime();
            ValidationTrigger triggerIfValidating = new ValidationTrigger(){

                public void triggerAsync(ComponentNode component) {
                    ValidationStatus status = component.getValidationStatus();
                    if (component.getValidationStatus() == ValidationStatus.VALIDATING) {
                        LOG.debug("Will trigger async validation for {} because its status is VALIDATING", (Object)component);
                        FlowController.this.validationTrigger.triggerAsync(component);
                    } else {
                        LOG.debug("Will not trigger async validation for {} because its status is {}", (Object)component, (Object)status);
                    }
                }

                public void trigger(ComponentNode component) {
                    ValidationStatus status = component.getValidationStatus();
                    if (component.getValidationStatus() == ValidationStatus.VALIDATING) {
                        LOG.debug("Will trigger immediate validation for {} because its status is VALIDATING", (Object)component);
                        FlowController.this.validationTrigger.trigger(component);
                    } else {
                        LOG.debug("Will not trigger immediate validation for {} because its status is {}", (Object)component, (Object)status);
                    }
                }
            };
            new TriggerValidationTask(this.flowManager, triggerIfValidating).run();
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            LOG.info("Performed initial validation of all components in {} milliseconds", (Object)millis);
            this.validationThreadPool.scheduleWithFixedDelay(new TriggerValidationTask(this.flowManager, this.validationTrigger), 5L, 5L, TimeUnit.SECONDS);
            if (startDelayedComponents) {
                LOG.info("Starting {} processors/ports/funnels", (Object)(this.startConnectablesAfterInitialization.size() + this.startRemoteGroupPortsAfterInitialization.size()));
                for (Connectable connectable : this.startConnectablesAfterInitialization) {
                    if (connectable.getScheduledState() == ScheduledState.DISABLED) continue;
                    try {
                        if (connectable instanceof ProcessorNode) {
                            connectable.getProcessGroup().startProcessor((ProcessorNode)connectable, true);
                            continue;
                        }
                        this.startConnectable(connectable);
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start {} due to {}", new Object[]{connectable, t.toString()});
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.error("", t);
                    }
                }
                this.startConnectablesAfterInitialization.clear();
                int startedTransmitting = 0;
                for (RemoteGroupPort remoteGroupPort : this.startRemoteGroupPortsAfterInitialization) {
                    try {
                        remoteGroupPort.getRemoteProcessGroup().startTransmitting(remoteGroupPort);
                        ++startedTransmitting;
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start transmitting with {} due to {}", new Object[]{remoteGroupPort, t});
                    }
                }
                LOG.info("Started {} Remote Group Ports transmitting", (Object)startedTransmitting);
                this.startRemoteGroupPortsAfterInitialization.clear();
            } else {
                for (Connectable connectable : this.startConnectablesAfterInitialization) {
                    try {
                        if (!(connectable instanceof Funnel)) continue;
                        this.startConnectable(connectable);
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start {} due to {}", new Object[]{connectable, t});
                    }
                }
                this.startConnectablesAfterInitialization.clear();
                this.startRemoteGroupPortsAfterInitialization.clear();
            }
            for (Connection connection : this.flowManager.findAllConnections()) {
                connection.getFlowFileQueue().startLoadBalancing();
            }
        }
        finally {
            this.writeLock.unlock("onFlowInitialized");
        }
    }

    public boolean isStartAfterInitialization(Connectable component) {
        return this.startConnectablesAfterInitialization.contains(component) || this.startRemoteGroupPortsAfterInitialization.contains(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentRepository createContentRepository(NiFiProperties properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String implementationClassName = properties.getProperty("nifi.content.repository.implementation", DEFAULT_CONTENT_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Content Repository because the NiFi Properties is missing the following property: nifi.content.repository.implementation");
        }
        try {
            ContentRepository contentRepo;
            ContentRepository contentRepository = contentRepo = (ContentRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)implementationClassName, ContentRepository.class, (NiFiProperties)properties);
            synchronized (contentRepository) {
                contentRepo.initialize(this.resourceClaimManager);
            }
            return contentRepo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ProvenanceRepository createProvenanceRepository(NiFiProperties properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String implementationClassName = properties.getProperty("nifi.provenance.repository.implementation", DEFAULT_PROVENANCE_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Provenance Repository because the NiFi Properties is missing the following property: nifi.provenance.repository.implementation");
        }
        try {
            return (ProvenanceRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)implementationClassName, ProvenanceRepository.class, (NiFiProperties)properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ComponentStatusRepository createComponentStatusRepository() {
        String implementationClassName = this.nifiProperties.getProperty("nifi.components.status.repository.implementation", DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Component Status Repository because the NiFi Properties is missing the following property: nifi.components.status.repository.implementation");
        }
        try {
            return (ComponentStatusRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)implementationClassName, ComponentStatusRepository.class, (NiFiProperties)this.nifiProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KerberosConfig createKerberosConfig(NiFiProperties nifiProperties) {
        String principal = nifiProperties.getKerberosServicePrincipal();
        String keytabLocation = nifiProperties.getKerberosServiceKeytabLocation();
        File kerberosConfigFile = nifiProperties.getKerberosConfigurationFile();
        if (principal == null && keytabLocation == null && kerberosConfigFile == null) {
            return KerberosConfig.NOT_CONFIGURED;
        }
        File keytabFile = keytabLocation == null ? null : new File(keytabLocation);
        return new KerberosConfig(principal, keytabFile, kerberosConfigFile);
    }

    public ValidationTrigger getValidationTrigger() {
        return this.validationTrigger;
    }

    public StringEncryptor getEncryptor() {
        return this.encryptor;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public String getInstanceId() {
        this.readLock.lock();
        try {
            String string = this.instanceId;
            return string;
        }
        finally {
            this.readLock.unlock("getInstanceId");
        }
    }

    public Heartbeater getHeartbeater() {
        return this.heartbeater;
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public SnippetManager getSnippetManager() {
        return this.snippetManager;
    }

    public StateManagerProvider getStateManagerProvider() {
        return this.stateManagerProvider;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public boolean isTerminated() {
        this.readLock.lock();
        try {
            boolean bl = null == this.timerDrivenEngineRef.get() || this.timerDrivenEngineRef.get().isTerminated();
            return bl;
        }
        finally {
            this.readLock.unlock("isTerminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean kill) {
        this.shutdown = true;
        this.flowManager.getRootGroup().stopProcessing();
        this.readLock.lock();
        try {
            Throwable throwable;
            NarCloseable narCloseable;
            if (this.isTerminated() || this.timerDrivenEngineRef.get().isTerminating()) {
                throw new IllegalStateException("Controller already stopped or still stopping...");
            }
            if (this.leaderElectionManager != null) {
                this.leaderElectionManager.stop();
            }
            if (this.heartbeatMonitor != null) {
                this.heartbeatMonitor.stop();
            }
            if (kill) {
                this.timerDrivenEngineRef.get().shutdownNow();
                this.eventDrivenEngineRef.get().shutdownNow();
                LOG.info("Initiated immediate shutdown of flow controller...");
            } else {
                this.timerDrivenEngineRef.get().shutdown();
                this.eventDrivenEngineRef.get().shutdown();
                LOG.info("Initiated graceful shutdown of flow controller...waiting up to " + this.gracefulShutdownSeconds + " seconds");
            }
            this.validationThreadPool.shutdown();
            this.clusterTaskExecutor.shutdownNow();
            if (this.zooKeeperStateServer != null) {
                this.zooKeeperStateServer.shutdown();
            }
            if (this.loadBalanceClientThreadPool != null) {
                this.loadBalanceClientThreadPool.shutdownNow();
            }
            this.loadBalanceClientTasks.forEach(NioAsyncLoadBalanceClientTask::stop);
            this.flowManager.getRootGroup().shutdown();
            this.stateManagerProvider.shutdown();
            for (ControllerServiceNode serviceNode : this.flowManager.getAllControllerServices()) {
                Class<?> serviceImplClass = serviceNode.getControllerServiceImplementation().getClass();
                narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, serviceImplClass, (String)serviceNode.getIdentifier());
                throwable = null;
                try {
                    StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)serviceNode, (ControllerServiceLookup)this.controllerServiceProvider, null, this.variableRegistry);
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)serviceNode.getControllerServiceImplementation(), configContext);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (narCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    narCloseable.close();
                }
            }
            for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
                ConfigurationContext configContext = taskNode.getConfigurationContext();
                narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, taskNode.getReportingTask().getClass(), (String)taskNode.getIdentifier());
                throwable = null;
                try {
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)taskNode.getReportingTask(), configContext);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (narCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    narCloseable.close();
                }
            }
            try {
                this.timerDrivenEngineRef.get().awaitTermination(this.gracefulShutdownSeconds / 2L, TimeUnit.SECONDS);
                this.eventDrivenEngineRef.get().awaitTermination(this.gracefulShutdownSeconds / 2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                LOG.info("Interrupted while waiting for controller termination.");
            }
            try {
                this.flowFileRepository.close();
            }
            catch (Throwable t) {
                LOG.warn("Unable to shut down FlowFileRepository due to {}", new Object[]{t});
            }
            if (this.timerDrivenEngineRef.get().isTerminated() && this.eventDrivenEngineRef.get().isTerminated()) {
                LOG.info("Controller has been terminated successfully.");
            } else {
                LOG.warn("Controller hasn't terminated properly.  There exists an uninterruptable thread that will take an indeterminate amount of time to stop.  Might need to kill the program manually.");
            }
            for (RemoteSiteListener listener : this.externalSiteListeners) {
                listener.stop();
                listener.destroy();
            }
            if (this.loadBalanceServer != null) {
                this.loadBalanceServer.stop();
            }
            if (this.loadBalanceClientRegistry != null) {
                this.loadBalanceClientRegistry.stop();
            }
            if (this.processScheduler != null) {
                this.processScheduler.shutdown();
            }
            if (this.contentRepository != null) {
                this.contentRepository.shutdown();
            }
            if (this.provenanceRepository != null) {
                try {
                    this.provenanceRepository.close();
                }
                catch (IOException ioe) {
                    LOG.warn("There was a problem shutting down the Provenance Repository: " + ioe.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("", (Throwable)ioe);
                    }
                }
            }
        }
        finally {
            this.readLock.unlock("shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> void serialize(FlowSerializer<T> serializer, OutputStream os) throws FlowSerializationException {
        T flowConfiguration;
        this.readLock.lock();
        try {
            ScheduledStateLookup scheduledStateLookup = new ScheduledStateLookup(){

                @Override
                public ScheduledState getScheduledState(ProcessorNode procNode) {
                    if (FlowController.this.startConnectablesAfterInitialization.contains(procNode)) {
                        return ScheduledState.RUNNING;
                    }
                    return procNode.getDesiredState();
                }

                @Override
                public ScheduledState getScheduledState(Port port) {
                    if (FlowController.this.startConnectablesAfterInitialization.contains(port)) {
                        return ScheduledState.RUNNING;
                    }
                    if (FlowController.this.startRemoteGroupPortsAfterInitialization.contains(port)) {
                        return ScheduledState.RUNNING;
                    }
                    return port.getScheduledState();
                }
            };
            flowConfiguration = serializer.transform(this, scheduledStateLookup);
        }
        finally {
            this.readLock.unlock("serialize");
        }
        serializer.serialize(flowConfiguration, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(FlowSynchronizer synchronizer, DataFlow dataFlow, FlowService flowService) throws FlowSerializationException, FlowSynchronizationException, UninheritableFlowException, MissingBundleException {
        this.writeLock.lock();
        try {
            LOG.debug("Synchronizing controller with proposed flow");
            try {
                synchronizer.sync(this, dataFlow, this.encryptor, flowService);
            }
            catch (UninheritableFlowException ufe) {
                NodeIdentifier localNodeId = this.getNodeId();
                if (localNodeId != null) {
                    try {
                        this.clusterCoordinator.requestNodeDisconnect(localNodeId, DisconnectionCode.MISMATCHED_FLOWS, ufe.getMessage());
                    }
                    catch (Exception e) {
                        LOG.error("Failed to synchronize Controller with proposed flow and also failed to notify cluster that the flows do not match. Node's state may remain CONNECTING instead of transitioning to DISCONNECTED.", (Throwable)e);
                    }
                }
                throw ufe;
            }
            this.flowSynchronized.set(true);
            LOG.info("Successfully synchronized controller with proposed flow. Flow contains the following number of components: {}", this.flowManager.getComponentCounts());
        }
        finally {
            this.writeLock.unlock("synchronize");
        }
    }

    public int getMaxTimerDrivenThreadCount() {
        return this.maxTimerDrivenThreads.get();
    }

    public int getMaxEventDrivenThreadCount() {
        return this.maxEventDrivenThreads.get();
    }

    public int getActiveEventDrivenThreadCount() {
        return this.eventDrivenEngineRef.get().getActiveCount();
    }

    public int getActiveTimerDrivenThreadCount() {
        return this.timerDrivenEngineRef.get().getActiveCount();
    }

    public void setMaxTimerDrivenThreadCount(int maxThreadCount) {
        this.writeLock.lock();
        try {
            this.setMaxThreadCount(maxThreadCount, this.timerDrivenEngineRef.get(), this.maxTimerDrivenThreads);
        }
        finally {
            this.writeLock.unlock("setMaxTimerDrivenThreadCount");
        }
    }

    public void setMaxEventDrivenThreadCount(int maxThreadCount) {
        this.writeLock.lock();
        try {
            this.setMaxThreadCount(maxThreadCount, this.eventDrivenEngineRef.get(), this.maxEventDrivenThreads);
            this.processScheduler.setMaxThreadCount(SchedulingStrategy.EVENT_DRIVEN, maxThreadCount);
        }
        finally {
            this.writeLock.unlock("setMaxEventDrivenThreadCount");
        }
    }

    private void setMaxThreadCount(int maxThreadCount, FlowEngine engine, AtomicInteger maxThreads) {
        if (maxThreadCount < 1) {
            throw new IllegalArgumentException("Cannot set max number of threads to less than 2");
        }
        maxThreads.getAndSet(maxThreadCount);
        if (null != engine && engine.getCorePoolSize() < maxThreadCount) {
            engine.setCorePoolSize(maxThreads.intValue());
        }
    }

    public UserAwareEventAccess getEventAccess() {
        return this.eventAccess;
    }

    public StatusAnalyticsEngine getStatusAnalyticsEngine() {
        return this.analyticsEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRootGroup(ProcessGroup group) {
        if (Objects.requireNonNull(group).getParent() != null) {
            throw new IllegalArgumentException("A ProcessGroup that has a parent cannot be the Root Group");
        }
        this.writeLock.lock();
        try {
            this.flowManager.setRootGroup(group);
            for (RemoteSiteListener listener : this.externalSiteListeners) {
                listener.setRootGroup(group);
            }
            this.heartbeatBeanRef.set(new HeartbeatBean(group, this.isPrimary()));
            this.allProcessGroups.put(group.getIdentifier(), group);
            this.allProcessGroups.put("root", group);
        }
        finally {
            this.writeLock.unlock("setRootGroup");
        }
    }

    public SystemDiagnostics getSystemDiagnostics() {
        SystemDiagnosticsFactory factory = new SystemDiagnosticsFactory();
        return factory.create(this.flowFileRepository, this.contentRepository, this.provenanceRepository);
    }

    public String getContentRepoFileStoreName(String containerName) {
        return this.contentRepository.getContainerFileStoreName(containerName);
    }

    public String getFlowRepoFileStoreName() {
        return this.flowFileRepository.getFileStoreName();
    }

    public String getProvenanceRepoFileStoreName(String containerName) {
        return this.provenanceRepository.getContainerFileStoreName(containerName);
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    private void verifyBundleInVersionedFlow(Bundle requiredBundle, Set<BundleCoordinate> supportedBundles) {
        BundleCoordinate requiredCoordinate = new BundleCoordinate(requiredBundle.getGroup(), requiredBundle.getArtifact(), requiredBundle.getVersion());
        if (!supportedBundles.contains(requiredCoordinate)) {
            throw new IllegalStateException("Unsupported bundle: " + requiredCoordinate);
        }
    }

    private void verifyProcessorsInVersionedFlow(VersionedProcessGroup versionedFlow, Map<String, Set<BundleCoordinate>> supportedTypes) {
        if (versionedFlow.getProcessors() != null) {
            versionedFlow.getProcessors().forEach(processor -> {
                if (processor.getBundle() == null) {
                    throw new IllegalArgumentException("Processor bundle must be specified.");
                }
                if (!supportedTypes.containsKey(processor.getType())) {
                    throw new IllegalStateException("Invalid Processor Type: " + processor.getType());
                }
                this.verifyBundleInVersionedFlow(processor.getBundle(), (Set)supportedTypes.get(processor.getType()));
            });
        }
        if (versionedFlow.getProcessGroups() != null) {
            versionedFlow.getProcessGroups().forEach(processGroup -> this.verifyProcessorsInVersionedFlow((VersionedProcessGroup)processGroup, supportedTypes));
        }
    }

    private void verifyControllerServicesInVersionedFlow(VersionedProcessGroup versionedFlow, Map<String, Set<BundleCoordinate>> supportedTypes) {
        if (versionedFlow.getControllerServices() != null) {
            versionedFlow.getControllerServices().forEach(controllerService -> {
                if (supportedTypes.containsKey(controllerService.getType())) {
                    if (controllerService.getBundle() == null) {
                        throw new IllegalArgumentException("Controller Service bundle must be specified.");
                    }
                } else {
                    throw new IllegalStateException("Invalid Controller Service Type: " + controllerService.getType());
                }
                this.verifyBundleInVersionedFlow(controllerService.getBundle(), (Set)supportedTypes.get(controllerService.getType()));
            });
        }
        if (versionedFlow.getProcessGroups() != null) {
            versionedFlow.getProcessGroups().forEach(processGroup -> this.verifyControllerServicesInVersionedFlow((VersionedProcessGroup)processGroup, supportedTypes));
        }
    }

    public void verifyComponentTypesInSnippet(VersionedProcessGroup versionedFlow) {
        HashMap<String, Set<BundleCoordinate>> processorClasses = new HashMap<String, Set<BundleCoordinate>>();
        for (Object c : this.extensionManager.getExtensions(Processor.class)) {
            String name = ((Class)c).getName();
            processorClasses.put(name, this.extensionManager.getBundles(name).stream().map(bundle -> bundle.getBundleDetails().getCoordinate()).collect(Collectors.toSet()));
        }
        this.verifyProcessorsInVersionedFlow(versionedFlow, processorClasses);
        HashMap<String, Set<BundleCoordinate>> controllerServiceClasses = new HashMap<String, Set<BundleCoordinate>>();
        for (Object c : this.extensionManager.getExtensions(ControllerService.class)) {
            String name = ((Class)c).getName();
            controllerServiceClasses.put(name, this.extensionManager.getBundles(name).stream().map(bundle -> bundle.getBundleDetails().getCoordinate()).collect(Collectors.toSet()));
        }
        this.verifyControllerServicesInVersionedFlow(versionedFlow, controllerServiceClasses);
        HashSet<String> prioritizerClasses = new HashSet<String>();
        for (Class c : this.extensionManager.getExtensions(FlowFilePrioritizer.class)) {
            prioritizerClasses.add(c.getName());
        }
        HashSet<VersionedConnection> allConns = new HashSet<VersionedConnection>();
        allConns.addAll(versionedFlow.getConnections());
        for (VersionedProcessGroup childGroup : versionedFlow.getProcessGroups()) {
            allConns.addAll(this.findAllConnections(childGroup));
        }
        for (VersionedConnection conn : allConns) {
            List prioritizers = conn.getPrioritizers();
            if (prioritizers == null) continue;
            for (String prioritizer : prioritizers) {
                if (prioritizerClasses.contains(prioritizer)) continue;
                throw new IllegalStateException("Invalid FlowFile Prioritizer Type: " + prioritizer);
            }
        }
    }

    private Set<VersionedConnection> findAllConnections(VersionedProcessGroup group) {
        HashSet<VersionedConnection> conns = new HashSet<VersionedConnection>();
        for (VersionedConnection connection : group.getConnections()) {
            conns.add(connection);
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            conns.addAll(this.findAllConnections(childGroup));
        }
        return conns;
    }

    private ProcessGroup lookupGroup(String id) {
        ProcessGroup group = this.flowManager.getGroup(id);
        if (group == null) {
            throw new IllegalStateException("No Group with ID " + id + " exists");
        }
        return group;
    }

    public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        ArrayList<GarbageCollectionStatus> statuses = new ArrayList<GarbageCollectionStatus>();
        Date now = new Date();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            String managerName = mbean.getName();
            long count = mbean.getCollectionCount();
            long millis = mbean.getCollectionTime();
            StandardGarbageCollectionStatus status = new StandardGarbageCollectionStatus(managerName, now, count, millis);
            statuses.add(status);
        }
        return statuses;
    }

    public GarbageCollectionHistory getGarbageCollectionHistory() {
        return this.componentStatusRepository.getGarbageCollectionHistory(new Date(0L), new Date());
    }

    public ReloadComponent getReloadComponent() {
        return this.reloadComponent;
    }

    public void startProcessor(String parentGroupId, String processorId) {
        this.startProcessor(parentGroupId, processorId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessor(String parentGroupId, String processorId, boolean failIfStopping) {
        ProcessGroup group = this.lookupGroup(parentGroupId);
        ProcessorNode node = group.getProcessor(processorId);
        if (node == null) {
            throw new IllegalStateException("Cannot find ProcessorNode with ID " + processorId + " within ProcessGroup with ID " + parentGroupId);
        }
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                group.startProcessor(node, failIfStopping);
            } else {
                this.startConnectablesAfterInitialization.add((Connectable)node);
            }
        }
        finally {
            this.writeLock.unlock("startProcessor");
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isFlowSynchronized() {
        return this.flowSynchronized.get();
    }

    public void startConnectable(Connectable connectable) {
        block9: {
            ProcessGroup group = Objects.requireNonNull(connectable).getProcessGroup();
            this.writeLock.lock();
            try {
                if (this.initialized.get()) {
                    switch (Objects.requireNonNull(connectable).getConnectableType()) {
                        case FUNNEL: {
                            group.startFunnel((Funnel)connectable);
                            break block9;
                        }
                        case INPUT_PORT: 
                        case REMOTE_INPUT_PORT: {
                            group.startInputPort((Port)connectable);
                            break block9;
                        }
                        case OUTPUT_PORT: 
                        case REMOTE_OUTPUT_PORT: {
                            group.startOutputPort((Port)connectable);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.startConnectablesAfterInitialization.add(connectable);
            }
            finally {
                this.writeLock.unlock("startConnectable");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopConnectable(Connectable connectable) {
        ProcessGroup group = Objects.requireNonNull(connectable).getProcessGroup();
        this.writeLock.lock();
        try {
            switch (Objects.requireNonNull(connectable).getConnectableType()) {
                case FUNNEL: {
                    return;
                }
                case INPUT_PORT: 
                case REMOTE_INPUT_PORT: {
                    this.startConnectablesAfterInitialization.remove(connectable);
                    group.stopInputPort((Port)connectable);
                    return;
                }
                case OUTPUT_PORT: 
                case REMOTE_OUTPUT_PORT: {
                    this.startConnectablesAfterInitialization.remove(connectable);
                    group.stopOutputPort((Port)connectable);
                    return;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        finally {
            this.writeLock.unlock("stopConnectable");
        }
    }

    public void startTransmitting(RemoteGroupPort remoteGroupPort) {
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                remoteGroupPort.getRemoteProcessGroup().startTransmitting(remoteGroupPort);
            } else {
                this.startRemoteGroupPortsAfterInitialization.add(remoteGroupPort);
            }
        }
        finally {
            this.writeLock.unlock("startTransmitting");
        }
    }

    public void stopTransmitting(RemoteGroupPort remoteGroupPort) {
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                remoteGroupPort.getRemoteProcessGroup().stopTransmitting(remoteGroupPort);
            } else {
                this.startRemoteGroupPortsAfterInitialization.remove(remoteGroupPort);
            }
        }
        finally {
            this.writeLock.unlock("stopTransmitting");
        }
    }

    public void stopProcessor(String parentGroupId, String processorId) {
        ProcessGroup group = this.lookupGroup(parentGroupId);
        ProcessorNode node = group.getProcessor(processorId);
        if (node == null) {
            throw new IllegalStateException("Cannot find ProcessorNode with ID " + processorId + " within ProcessGroup with ID " + parentGroupId);
        }
        group.stopProcessor(node);
        this.startConnectablesAfterInitialization.remove(node);
    }

    public void startReportingTask(ReportingTaskNode reportingTaskNode) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Cannot start reporting task " + reportingTaskNode.getIdentifier() + " because the controller is terminated");
        }
        reportingTaskNode.verifyCanStart();
        reportingTaskNode.reloadAdditionalResourcesIfNecessary();
        this.processScheduler.schedule(reportingTaskNode);
    }

    public void stopReportingTask(ReportingTaskNode reportingTaskNode) {
        if (this.isTerminated()) {
            return;
        }
        reportingTaskNode.verifyCanStop();
        this.processScheduler.unschedule(reportingTaskNode);
    }

    public FlowManager getFlowManager() {
        return this.flowManager;
    }

    public GarbageCollectionLog getGarbageCollectionLog() {
        return this.gcLog;
    }

    public RepositoryContextFactory getRepositoryContextFactory() {
        return this.repositoryContextFactory;
    }

    public ClusterCoordinator getClusterCoordinator() {
        return this.clusterCoordinator;
    }

    public Connection createConnection(final String id, String name, Connectable source, Connectable destination, Collection<String> relationshipNames) {
        StandardConnection.Builder builder = new StandardConnection.Builder(this.processScheduler);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relationshipName : Objects.requireNonNull(relationshipNames)) {
            relationships.add(new Relationship.Builder().name(relationshipName).build());
        }
        final FlowFileSwapManager swapManager = this.createSwapManager();
        final EventReporter eventReporter = this.createEventReporter();
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            SwapManagerInitializationContext initializationContext = new SwapManagerInitializationContext(){

                public ResourceClaimManager getResourceClaimManager() {
                    return FlowController.this.resourceClaimManager;
                }

                public FlowFileRepository getFlowFileRepository() {
                    return FlowController.this.flowFileRepository;
                }

                public EventReporter getEventReporter() {
                    return eventReporter;
                }
            };
            swapManager.initialize(initializationContext);
        }
        FlowFileQueueFactory flowFileQueueFactory = new FlowFileQueueFactory(){

            @Override
            public FlowFileQueue createFlowFileQueue(LoadBalanceStrategy loadBalanceStrategy, String partitioningAttribute, ConnectionEventListener eventListener) {
                AbstractFlowFileQueue flowFileQueue;
                if (FlowController.this.clusterCoordinator == null) {
                    flowFileQueue = new StandardFlowFileQueue(id, eventListener, FlowController.this.flowFileRepository, (ProvenanceEventRepository)FlowController.this.provenanceRepository, FlowController.this.resourceClaimManager, FlowController.this.processScheduler, swapManager, eventReporter, FlowController.this.nifiProperties.getQueueSwapThreshold(), FlowController.this.nifiProperties.getDefaultBackPressureObjectThreshold(), FlowController.this.nifiProperties.getDefaultBackPressureDataSizeThreshold());
                } else {
                    flowFileQueue = new SocketLoadBalancedFlowFileQueue(id, eventListener, FlowController.this.processScheduler, FlowController.this.flowFileRepository, (ProvenanceEventRepository)FlowController.this.provenanceRepository, FlowController.this.contentRepository, FlowController.this.resourceClaimManager, FlowController.this.clusterCoordinator, FlowController.this.loadBalanceClientRegistry, swapManager, FlowController.this.nifiProperties.getQueueSwapThreshold(), eventReporter);
                    flowFileQueue.setBackPressureObjectThreshold(FlowController.this.nifiProperties.getDefaultBackPressureObjectThreshold());
                    flowFileQueue.setBackPressureDataSizeThreshold(FlowController.this.nifiProperties.getDefaultBackPressureDataSizeThreshold());
                }
                return flowFileQueue;
            }
        };
        StandardConnection connection = builder.id(Objects.requireNonNull(id).intern()).name(name == null ? null : name.intern()).relationships(relationships).source(Objects.requireNonNull(source)).destination(destination).flowFileQueueFactory(flowFileQueueFactory).build();
        return connection;
    }

    public ReportingTaskNode getReportingTaskNode(String identifier) {
        return this.flowManager.getReportingTaskNode(identifier);
    }

    public ReportingTaskNode createReportingTask(String type, String id, BundleCoordinate bundleCoordinate, boolean firstTimeAdded) throws ReportingTaskInstantiationException {
        return this.flowManager.createReportingTask(type, id, bundleCoordinate, firstTimeAdded);
    }

    public Set<ReportingTaskNode> getAllReportingTasks() {
        return this.flowManager.getAllReportingTasks();
    }

    public void removeReportingTask(ReportingTaskNode reportingTaskNode) {
        this.flowManager.removeReportingTask(reportingTaskNode);
    }

    public FlowRegistryClient getFlowRegistryClient() {
        return this.flowRegistryClient;
    }

    public ControllerServiceProvider getControllerServiceProvider() {
        return this.controllerServiceProvider;
    }

    public VariableRegistry getVariableRegistry() {
        return this.variableRegistry;
    }

    public ProvenanceAuthorizableFactory getProvenanceAuthorizableFactory() {
        return this.provenanceAuthorizableFactory;
    }

    public void enableReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanEnable();
        reportingTaskNode.reloadAdditionalResourcesIfNecessary();
        this.processScheduler.enableReportingTask(reportingTaskNode);
    }

    public void disableReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanDisable();
        this.processScheduler.disableReportingTask(reportingTaskNode);
    }

    public List<Counter> getCounters() {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        CounterRepository counterRepo = this.counterRepositoryRef.get();
        for (Counter counter : counterRepo.getCounters()) {
            counters.add(counter);
        }
        return counters;
    }

    public Counter resetCounter(String identifier) {
        CounterRepository counterRepo = this.counterRepositoryRef.get();
        Counter resetValue = counterRepo.resetCounter(identifier);
        return resetValue;
    }

    public QueueSize getTotalFlowFileCount(ProcessGroup group) {
        QueueSize size;
        int count = 0;
        long contentSize = 0L;
        for (Connection connection : group.getConnections()) {
            size = connection.getFlowFileQueue().size();
            count += size.getObjectCount();
            contentSize += size.getByteCount();
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            size = this.getTotalFlowFileCount(childGroup);
            count += size.getObjectCount();
            contentSize += size.getByteCount();
        }
        return new QueueSize(count, contentSize);
    }

    public GroupStatusCounts getGroupStatusCounts(ProcessGroup group) {
        return new GroupStatusCounts(group);
    }

    public int getActiveThreadCount() {
        int timerDrivenCount = this.timerDrivenEngineRef.get().getActiveCount();
        int eventDrivenCount = this.eventDrivenSchedulingAgent.getActiveThreadCount();
        return timerDrivenCount + eventDrivenCount;
    }

    public void startHeartbeating() throws IllegalStateException {
        if (!this.isConfiguredForClustering()) {
            throw new IllegalStateException("Unable to start heartbeating because heartbeating is not configured.");
        }
        this.writeLock.lock();
        try {
            this.stopHeartbeating();
            HeartbeatSendTask sendTask = new HeartbeatSendTask();
            this.heartbeatSendTask.set(sendTask);
            this.heartbeatSenderFuture = this.clusterTaskExecutor.scheduleWithFixedDelay(sendTask, 0L, this.heartbeatDelaySeconds, TimeUnit.SECONDS);
        }
        finally {
            this.writeLock.unlock("startHeartbeating");
        }
    }

    public void suspendHeartbeats() {
        this.heartbeatsSuspended.set(true);
    }

    public void resumeHeartbeats() {
        this.heartbeatsSuspended.set(false);
    }

    public void stopHeartbeating() throws IllegalStateException {
        if (!this.isConfiguredForClustering()) {
            throw new IllegalStateException("Unable to stop heartbeating because heartbeating is not configured.");
        }
        this.writeLock.lock();
        try {
            if (!this.isHeartbeating()) {
                return;
            }
            if (this.heartbeatSenderFuture != null) {
                this.heartbeatSenderFuture.cancel(false);
            }
        }
        finally {
            this.writeLock.unlock("stopHeartbeating");
        }
    }

    public boolean isHeartbeating() {
        this.readLock.lock();
        try {
            boolean bl = this.heartbeatSenderFuture != null && !this.heartbeatSenderFuture.isCancelled();
            return bl;
        }
        finally {
            this.readLock.unlock("isHeartbeating");
        }
    }

    public int getHeartbeatDelaySeconds() {
        this.readLock.lock();
        try {
            int n = this.heartbeatDelaySeconds;
            return n;
        }
        finally {
            this.readLock.unlock("getHeartbeatDelaySeconds");
        }
    }

    public NodeIdentifier getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeIdentifier nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isClustered() {
        this.readLock.lock();
        try {
            boolean bl = this.clustered;
            return bl;
        }
        finally {
            this.readLock.unlock("isClustered");
        }
    }

    public boolean isConfiguredForClustering() {
        return this.configuredForClustering;
    }

    void registerForClusterCoordinator(boolean participate) {
        final String participantId = participate ? this.heartbeatMonitor.getHeartbeatAddress() : null;
        this.leaderElectionManager.register("Cluster Coordinator", new LeaderElectionStateChangeListener(){

            @Override
            public synchronized void onLeaderRelinquish() {
                LOG.info("This node is no longer the elected Active Cluster Coordinator");
                FlowController.this.bulletinRepository.addBulletin(BulletinFactory.createBulletin((String)"Cluster Coordinator", (String)Severity.INFO.name(), (String)(participantId + " is no longer the Cluster Coordinator")));
            }

            @Override
            public synchronized void onLeaderElection() {
                LOG.info("This node elected Active Cluster Coordinator");
                FlowController.this.bulletinRepository.addBulletin(BulletinFactory.createBulletin((String)"Cluster Coordinator", (String)Severity.INFO.name(), (String)(participantId + " has been elected the Cluster Coordinator")));
                FlowController.this.heartbeatMonitor.purgeHeartbeats();
            }
        }, participantId);
    }

    void registerForPrimaryNode() {
        String participantId = this.heartbeatMonitor.getHeartbeatAddress();
        this.leaderElectionManager.register("Primary Node", new LeaderElectionStateChangeListener(){

            @Override
            public void onLeaderElection() {
                FlowController.this.setPrimary(true);
            }

            @Override
            public void onLeaderRelinquish() {
                FlowController.this.setPrimary(false);
            }
        }, participantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClustered(boolean clustered, String clusterInstanceId) {
        this.writeLock.lock();
        try {
            boolean isChanging = false;
            if (this.clustered != clustered) {
                isChanging = true;
                if (clustered) {
                    LOG.info("Cluster State changed from Not Clustered to Clustered");
                } else {
                    LOG.info("Cluster State changed from Clustered to Not Clustered");
                }
            }
            this.clustered = clustered;
            this.eventDrivenWorkerQueue.setClustered(clustered);
            if (clusterInstanceId != null) {
                this.instanceId = clusterInstanceId;
            }
            if (isChanging) {
                if (clustered) {
                    this.registerForPrimaryNode();
                    this.registerForClusterCoordinator(true);
                    this.leaderElectionManager.start();
                    this.stateManagerProvider.enableClusterProvider();
                    this.loadBalanceClientRegistry.start();
                    this.heartbeat();
                } else {
                    this.stateManagerProvider.disableClusterProvider();
                    this.setPrimary(false);
                }
                List remoteGroups = this.flowManager.getRootGroup().findAllRemoteProcessGroups();
                for (RemoteProcessGroup remoteGroup : remoteGroups) {
                    remoteGroup.reinitialize(clustered);
                }
            }
            if (!clustered) {
                this.leaderElectionManager.unregister("Primary Node");
                this.leaderElectionManager.unregister("Cluster Coordinator");
            }
            this.heartbeatBeanRef.set(new HeartbeatBean(this.flowManager.getRootGroup(), this.isPrimary()));
        }
        finally {
            this.writeLock.unlock("setClustered");
        }
    }

    public LeaderElectionManager getLeaderElectionManager() {
        return this.leaderElectionManager;
    }

    public boolean isPrimary() {
        return this.isClustered() && this.leaderElectionManager != null && this.leaderElectionManager.isLeader("Primary Node");
    }

    public boolean isClusterCoordinator() {
        return this.isClustered() && this.leaderElectionManager != null && this.leaderElectionManager.isLeader("Cluster Coordinator");
    }

    public void setPrimary(boolean primary) {
        Throwable throwable;
        NarCloseable narCloseable;
        PrimaryNodeState nodeState = primary ? PrimaryNodeState.ELECTED_PRIMARY_NODE : PrimaryNodeState.PRIMARY_NODE_REVOKED;
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        for (ProcessorNode procNode : rootGroup.findAllProcessors()) {
            narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, procNode.getProcessor().getClass(), (String)procNode.getIdentifier());
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)procNode.getProcessor(), nodeState);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (narCloseable == null) continue;
                if (throwable != null) {
                    try {
                        narCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                narCloseable.close();
            }
        }
        for (ControllerServiceNode serviceNode : this.flowManager.getAllControllerServices()) {
            Class<?> serviceImplClass = serviceNode.getControllerServiceImplementation().getClass();
            NarCloseable narCloseable2 = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, serviceImplClass, (String)serviceNode.getIdentifier());
            Throwable throwable4 = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)serviceNode.getControllerServiceImplementation(), nodeState);
            }
            catch (Throwable throwable5) {
                throwable4 = throwable5;
                throw throwable5;
            }
            finally {
                if (narCloseable2 == null) continue;
                if (throwable4 != null) {
                    try {
                        narCloseable2.close();
                    }
                    catch (Throwable throwable6) {
                        throwable4.addSuppressed(throwable6);
                    }
                    continue;
                }
                narCloseable2.close();
            }
        }
        for (ReportingTaskNode reportingTaskNode : this.getAllReportingTasks()) {
            narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, reportingTaskNode.getReportingTask().getClass(), (String)reportingTaskNode.getIdentifier());
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)reportingTaskNode.getReportingTask(), nodeState);
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (narCloseable == null) continue;
                if (throwable != null) {
                    try {
                        narCloseable.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                narCloseable.close();
            }
        }
        this.eventDrivenWorkerQueue.setPrimary(primary);
        HeartbeatBean oldBean = this.heartbeatBeanRef.getAndSet(new HeartbeatBean(rootGroup, primary));
        if (oldBean == null || oldBean.isPrimary() != primary) {
            String message = primary ? "This node has been elected Primary Node" : "This node is no longer Primary Node";
            Bulletin bulletin = BulletinFactory.createBulletin((String)"Primary Node", (String)Severity.INFO.name(), (String)message);
            this.bulletinRepository.addBulletin(bulletin);
            LOG.info(message);
        }
    }

    static boolean areEqual(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    static boolean areEqual(Long a, Long b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.compareTo(b) == 0;
    }

    public ContentAvailability getContentAvailability(final ProvenanceEventRecord event) {
        final String replayFailure = this.getReplayFailureReason(event);
        return new ContentAvailability(){

            public String getReasonNotReplayable() {
                return replayFailure;
            }

            public boolean isContentSame() {
                return FlowController.areEqual(event.getPreviousContentClaimContainer(), event.getContentClaimContainer()) && FlowController.areEqual(event.getPreviousContentClaimSection(), event.getContentClaimSection()) && FlowController.areEqual(event.getPreviousContentClaimIdentifier(), event.getContentClaimIdentifier()) && FlowController.areEqual(event.getPreviousContentClaimOffset(), event.getContentClaimOffset()) && FlowController.areEqual(event.getPreviousFileSize(), event.getFileSize());
            }

            public boolean isInputAvailable() {
                try {
                    return FlowController.this.contentRepository.isAccessible(this.createClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), event.getPreviousContentClaimOffset()));
                }
                catch (IOException e) {
                    return false;
                }
            }

            public boolean isOutputAvailable() {
                try {
                    return FlowController.this.contentRepository.isAccessible(this.createClaim(event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset()));
                }
                catch (IOException e) {
                    return false;
                }
            }

            private ContentClaim createClaim(String container, String section, String identifier, Long offset) {
                if (container == null || section == null || identifier == null) {
                    return null;
                }
                ResourceClaim resourceClaim = FlowController.this.resourceClaimManager.newResourceClaim(container, section, identifier, false, false);
                return new StandardContentClaim(resourceClaim, offset == null ? 0L : offset);
            }

            public boolean isReplayable() {
                return replayFailure == null;
            }
        };
    }

    public InputStream getContent(ProvenanceEventRecord provEvent, ContentDirection direction, String requestor, String requestUri) throws IOException {
        long size;
        long offset;
        StandardContentClaim claim;
        ResourceClaim resourceClaim;
        Objects.requireNonNull(provEvent);
        Objects.requireNonNull(direction);
        Objects.requireNonNull(requestor);
        Objects.requireNonNull(requestUri);
        if (direction == ContentDirection.INPUT) {
            if (provEvent.getPreviousContentClaimContainer() == null || provEvent.getPreviousContentClaimSection() == null || provEvent.getPreviousContentClaimIdentifier() == null) {
                throw new IllegalArgumentException("Input Content Claim not specified");
            }
            resourceClaim = this.resourceClaimManager.newResourceClaim(provEvent.getPreviousContentClaimContainer(), provEvent.getPreviousContentClaimSection(), provEvent.getPreviousContentClaimIdentifier(), false, false);
            claim = new StandardContentClaim(resourceClaim, provEvent.getPreviousContentClaimOffset().longValue());
            offset = provEvent.getPreviousContentClaimOffset() == null ? 0L : provEvent.getPreviousContentClaimOffset();
            size = provEvent.getPreviousFileSize();
        } else {
            if (provEvent.getContentClaimContainer() == null || provEvent.getContentClaimSection() == null || provEvent.getContentClaimIdentifier() == null) {
                throw new IllegalArgumentException("Output Content Claim not specified");
            }
            resourceClaim = this.resourceClaimManager.newResourceClaim(provEvent.getContentClaimContainer(), provEvent.getContentClaimSection(), provEvent.getContentClaimIdentifier(), false, false);
            claim = new StandardContentClaim(resourceClaim, provEvent.getContentClaimOffset().longValue());
            offset = provEvent.getContentClaimOffset() == null ? 0L : provEvent.getContentClaimOffset();
            size = provEvent.getFileSize();
        }
        InputStream rawStream = this.contentRepository.read((ContentClaim)claim);
        ResourceClaim resourceClaim2 = claim.getResourceClaim();
        StandardProvenanceEventRecord sendEvent = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.DOWNLOAD).setFlowFileUUID(provEvent.getFlowFileUuid()).setAttributes(provEvent.getAttributes(), Collections.emptyMap()).setCurrentContentClaim(resourceClaim2.getContainer(), resourceClaim2.getSection(), resourceClaim2.getId(), Long.valueOf(offset), size).setTransitUri(requestUri).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(provEvent.getFlowFileEntryDate()).setLineageStartDate(provEvent.getLineageStartDate()).setComponentType(this.flowManager.getRootGroup().getName()).setComponentId(this.flowManager.getRootGroupId()).setDetails("Download of " + (direction == ContentDirection.INPUT ? "Input" : "Output") + " Content requested by " + requestor + " for Provenance Event " + provEvent.getEventId()).build();
        this.provenanceRepository.registerEvent((ProvenanceEventRecord)sendEvent);
        return new LimitedInputStream(rawStream, size);
    }

    public InputStream getContent(FlowFileRecord flowFile, String requestor, String requestUri) throws IOException {
        InputStream stream;
        ResourceClaim resourceClaim;
        Objects.requireNonNull(flowFile);
        Objects.requireNonNull(requestor);
        Objects.requireNonNull(requestUri);
        ContentClaim contentClaim = flowFile.getContentClaim();
        if (contentClaim == null) {
            resourceClaim = null;
            stream = new ByteArrayInputStream(new byte[0]);
        } else {
            resourceClaim = flowFile.getContentClaim().getResourceClaim();
            stream = this.contentRepository.read(flowFile.getContentClaim());
            long contentClaimOffset = flowFile.getContentClaimOffset();
            if (contentClaimOffset > 0L) {
                StreamUtils.skip((InputStream)stream, (long)contentClaimOffset);
            }
            stream = new LimitingInputStream(stream, flowFile.getSize());
        }
        StandardProvenanceEventRecord.Builder sendEventBuilder = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.DOWNLOAD).setFlowFileUUID(flowFile.getAttribute(CoreAttributes.UUID.key())).setAttributes(flowFile.getAttributes(), Collections.emptyMap()).setTransitUri(requestUri).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(flowFile.getEntryDate()).setLineageStartDate(flowFile.getLineageStartDate()).setComponentType(this.flowManager.getRootGroup().getName()).setComponentId(this.flowManager.getRootGroupId()).setDetails("Download of Content requested by " + requestor + " for " + flowFile);
        if (contentClaim != null) {
            sendEventBuilder.setCurrentContentClaim(resourceClaim.getContainer(), resourceClaim.getSection(), resourceClaim.getId(), Long.valueOf(contentClaim.getOffset() + flowFile.getContentClaimOffset()), flowFile.getSize());
        }
        StandardProvenanceEventRecord sendEvent = sendEventBuilder.build();
        this.provenanceRepository.registerEvent((ProvenanceEventRecord)sendEvent);
        return stream;
    }

    private String getReplayFailureReason(ProvenanceEventRecord event) {
        ProvenanceEventType type = event.getEventType();
        if (type == ProvenanceEventType.JOIN) {
            return "Cannot replay events that are created from multiple parents";
        }
        Long contentSize = event.getPreviousFileSize();
        String contentClaimId = event.getPreviousContentClaimIdentifier();
        String contentClaimSection = event.getPreviousContentClaimSection();
        String contentClaimContainer = event.getPreviousContentClaimContainer();
        if (contentSize == null || contentClaimId == null || contentClaimSection == null || contentClaimContainer == null) {
            return "Cannot replay data from Provenance Event because the event does not contain the required Content Claim";
        }
        try {
            ResourceClaim resourceClaim = this.resourceClaimManager.newResourceClaim(contentClaimContainer, contentClaimSection, contentClaimId, false, false);
            StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, event.getPreviousContentClaimOffset().longValue());
            if (!this.contentRepository.isAccessible((ContentClaim)contentClaim)) {
                return "Content is no longer available in Content Repository";
            }
        }
        catch (IOException ioe) {
            return "Failed to determine whether or not content was available in Content Repository due to " + ioe.toString();
        }
        if (event.getSourceQueueIdentifier() == null) {
            return "Cannot replay data from Provenance Event because the event does not specify the Source FlowFile Queue";
        }
        Set<Connection> connections = this.flowManager.findAllConnections();
        FlowFileQueue queue = null;
        for (Connection connection : connections) {
            if (!event.getSourceQueueIdentifier().equals(connection.getIdentifier())) continue;
            queue = connection.getFlowFileQueue();
            break;
        }
        if (queue == null) {
            return "Cannot replay data from Provenance Event because the Source FlowFile Queue with ID " + event.getSourceQueueIdentifier() + " no longer exists";
        }
        return null;
    }

    public ProvenanceEventRecord replayFlowFile(long provenanceEventRecordId, NiFiUser user) throws IOException {
        ProvenanceEventRecord record = this.provenanceRepository.getEvent(provenanceEventRecordId, user);
        if (record == null) {
            throw new IllegalStateException("Cannot find Provenance Event with ID " + provenanceEventRecordId);
        }
        return this.replayFlowFile(record, user);
    }

    public ProvenanceEventRecord replayFlowFile(ProvenanceEventRecord event, NiFiUser user) throws IOException {
        if (event == null) {
            throw new NullPointerException();
        }
        ProvenanceEventType type = event.getEventType();
        if (type == ProvenanceEventType.JOIN) {
            throw new IllegalArgumentException("Cannot replay events that are created from multiple parents");
        }
        Long contentSize = event.getPreviousFileSize();
        String contentClaimId = event.getPreviousContentClaimIdentifier();
        String contentClaimSection = event.getPreviousContentClaimSection();
        String contentClaimContainer = event.getPreviousContentClaimContainer();
        if (contentSize == null || contentClaimId == null || contentClaimSection == null || contentClaimContainer == null) {
            throw new IllegalArgumentException("Cannot replay data from Provenance Event because the event does not contain the required Content Claim");
        }
        if (event.getSourceQueueIdentifier() == null) {
            throw new IllegalArgumentException("Cannot replay data from Provenance Event because the event does not specify the Source FlowFile Queue");
        }
        Set<Connection> connections = this.flowManager.findAllConnections();
        FlowFileQueue queue = null;
        for (Connection connection : connections) {
            if (!event.getSourceQueueIdentifier().equals(connection.getIdentifier())) continue;
            queue = connection.getFlowFileQueue();
            break;
        }
        if (queue == null) {
            throw new IllegalStateException("Cannot replay data from Provenance Event because the Source FlowFile Queue with ID " + event.getSourceQueueIdentifier() + " no longer exists");
        }
        ResourceClaim resourceClaim = this.resourceClaimManager.getResourceClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier());
        if (resourceClaim == null) {
            resourceClaim = this.resourceClaimManager.newResourceClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), false, false);
        }
        this.resourceClaimManager.incrementClaimantCount(resourceClaim);
        long claimOffset = event.getPreviousContentClaimOffset() == null ? 0L : event.getPreviousContentClaimOffset();
        StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, claimOffset);
        contentClaim.setLength(event.getPreviousFileSize() == null ? -1L : event.getPreviousFileSize());
        if (!this.contentRepository.isAccessible((ContentClaim)contentClaim)) {
            this.resourceClaimManager.decrementClaimantCount(resourceClaim);
            throw new IllegalStateException("Cannot replay data from Provenance Event because the data is no longer available in the Content Repository");
        }
        String parentUUID = event.getFlowFileUuid();
        String newFlowFileUUID = UUID.randomUUID().toString();
        FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().addAttributes(event.getPreviousAttributes()).contentClaim((ContentClaim)contentClaim).contentClaimOffset(0L).entryDate(System.currentTimeMillis()).id(this.flowFileRepository.getNextFlowFileSequence()).lineageStart(event.getLineageStartDate(), 0L).size(contentSize.longValue()).addAttribute("flowfile.replay", "true").addAttribute("flowfile.replay.timestamp", String.valueOf(new Date())).addAttribute(CoreAttributes.UUID.key(), newFlowFileUUID).removeAttributes(new String[]{CoreAttributes.DISCARD_REASON.key(), CoreAttributes.ALTERNATE_IDENTIFIER.key()}).build();
        StandardProvenanceEventRecord replayEvent = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.REPLAY).addChildUuid(newFlowFileUUID).addParentUuid(parentUUID).setFlowFileUUID(parentUUID).setAttributes(Collections.emptyMap(), flowFileRecord.getAttributes()).setCurrentContentClaim(event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset(), event.getFileSize()).setDetails("Replay requested by " + user.getIdentity()).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(System.currentTimeMillis()).setLineageStartDate(event.getLineageStartDate()).setComponentType(event.getComponentType()).setComponentId(event.getComponentId()).build();
        this.provenanceRepository.registerEvent((ProvenanceEventRecord)replayEvent);
        StandardRepositoryRecord record = new StandardRepositoryRecord(queue);
        record.setWorking(flowFileRecord, false);
        record.setDestination(queue);
        this.flowFileRepository.updateRepository(Collections.singleton(record));
        queue.put(flowFileRecord);
        return replayEvent;
    }

    public ResourceClaimManager getResourceClaimManager() {
        return this.resourceClaimManager;
    }

    public boolean isConnected() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.connectionStatus != null && this.connectionStatus.getState() == NodeConnectionState.CONNECTED;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setConnectionStatus(NodeConnectionStatus connectionStatus) {
        this.rwLock.writeLock().lock();
        try {
            this.connectionStatus = connectionStatus;
            this.heartbeatBeanRef.set(new HeartbeatBean(this.flowManager.getRootGroup(), this.isPrimary()));
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void heartbeat() {
        if (!this.isClustered()) {
            return;
        }
        if (this.shutdown) {
            return;
        }
        HeartbeatSendTask task = this.heartbeatSendTask.get();
        if (task != null) {
            this.clusterTaskExecutor.submit(task);
        }
    }

    HeartbeatMessage createHeartbeatMessage() {
        try {
            HeartbeatBean bean = this.heartbeatBeanRef.get();
            if (bean == null) {
                this.readLock.lock();
                try {
                    bean = new HeartbeatBean(this.flowManager.getRootGroup(), this.isPrimary());
                }
                finally {
                    this.readLock.unlock("createHeartbeatMessage");
                }
            }
            HeartbeatPayload hbPayload = new HeartbeatPayload();
            hbPayload.setSystemStartTime(this.systemStartTime);
            hbPayload.setActiveThreadCount(this.getActiveThreadCount());
            QueueSize queueSize = this.getTotalFlowFileCount(bean.getRootGroup());
            hbPayload.setTotalFlowFileCount((long)queueSize.getObjectCount());
            hbPayload.setTotalFlowFileBytes(queueSize.getByteCount());
            hbPayload.setClusterStatus(this.clusterCoordinator.getConnectionStatuses());
            NodeIdentifier nodeId = this.getNodeId();
            if (nodeId == null) {
                LOG.warn("Cannot create Heartbeat Message because node's identifier is not known at this time");
                return null;
            }
            Heartbeat heartbeat = new Heartbeat(nodeId, this.connectionStatus, hbPayload.marshal());
            HeartbeatMessage message = new HeartbeatMessage();
            message.setHeartbeat(heartbeat);
            LOG.debug("Generated heartbeat");
            return message;
        }
        catch (Throwable ex) {
            LOG.warn("Failed to create heartbeat due to: " + ex, ex);
            return null;
        }
    }

    private void updateRemoteProcessGroups() {
        List remoteGroups = this.flowManager.getRootGroup().findAllRemoteProcessGroups();
        for (RemoteProcessGroup remoteGroup : remoteGroups) {
            try {
                remoteGroup.refreshFlowContents();
            }
            catch (CommunicationsException e) {
                LOG.warn("Unable to communicate with remote instance {} due to {}", (Object)remoteGroup, (Object)e.toString());
                if (!LOG.isDebugEnabled()) continue;
                LOG.warn("", (Throwable)e);
            }
        }
    }

    public Integer getRemoteSiteListeningPort() {
        return this.remoteInputSocketPort;
    }

    public Integer getRemoteSiteListeningHttpPort() {
        return this.remoteInputHttpPort;
    }

    public Boolean isRemoteSiteCommsSecure() {
        return this.isSiteToSiteSecure;
    }

    public StandardProcessScheduler getProcessScheduler() {
        return this.processScheduler;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public ProvenanceRepository getProvenanceRepository() {
        return this.provenanceRepository;
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId) {
        return this.getConnectionStatusHistory(connectionId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getConnectionStatusHistory(connectionId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId, boolean includeCounters) {
        return this.getProcessorStatusHistory(processorId, null, null, Integer.MAX_VALUE, includeCounters);
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId, Date startTime, Date endTime, int preferredDataPoints, boolean includeCounters) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getProcessorStatusHistory(processorId, startTime, endTime, preferredDataPoints, includeCounters));
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String processGroupId) {
        return this.getProcessGroupStatusHistory(processGroupId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String processGroupId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getProcessGroupStatusHistory(processGroupId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId) {
        return this.getRemoteProcessGroupStatusHistory(remoteGroupId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getRemoteProcessGroupStatusHistory(remoteGroupId, startTime, endTime, preferredDataPoints));
    }

    private static class HeartbeatBean {
        private final ProcessGroup rootGroup;
        private final boolean primary;

        public HeartbeatBean(ProcessGroup rootGroup, boolean primary) {
            this.rootGroup = rootGroup;
            this.primary = primary;
        }

        public ProcessGroup getRootGroup() {
            return this.rootGroup;
        }

        public boolean isPrimary() {
            return this.primary;
        }
    }

    private class HeartbeatSendTask
    implements Runnable {
        private HeartbeatSendTask() {
        }

        @Override
        public void run() {
            block24: {
                try (NarCloseable narCloseable = NarCloseable.withFrameworkNar();){
                    if (FlowController.this.heartbeatsSuspended.get()) {
                        return;
                    }
                    HeartbeatMessage message = FlowController.this.createHeartbeatMessage();
                    if (message == null) {
                        LOG.debug("No heartbeat to send");
                        return;
                    }
                    FlowController.this.heartbeater.send(message);
                }
                catch (UnknownServiceAddressException usae) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(usae.getMessage());
                    }
                }
                catch (Throwable ex) {
                    LOG.warn("Failed to send heartbeat due to: " + ex);
                    if (!LOG.isDebugEnabled()) break block24;
                    LOG.warn("", ex);
                }
            }
        }
    }

    public class GroupStatusCounts {
        private int queuedCount = 0;
        private long queuedContentSize = 0L;
        private int activeThreadCount = 0;
        private int terminatedThreadCount = 0;

        public GroupStatusCounts(ProcessGroup group) {
            this.calculateCounts(group);
        }

        private void calculateCounts(ProcessGroup group) {
            for (Connection connection : group.getConnections()) {
                Connectable destination;
                QueueSize size = connection.getFlowFileQueue().size();
                this.queuedCount += size.getObjectCount();
                this.queuedContentSize += size.getByteCount();
                Connectable source = connection.getSource();
                if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)source.getConnectableType())) {
                    RemoteGroupPort remoteOutputPort = (RemoteGroupPort)source;
                    this.activeThreadCount += FlowController.this.processScheduler.getActiveThreadCount(remoteOutputPort);
                }
                if (!ConnectableType.REMOTE_INPUT_PORT.equals((Object)(destination = connection.getDestination()).getConnectableType())) continue;
                RemoteGroupPort remoteInputPort = (RemoteGroupPort)destination;
                this.activeThreadCount += FlowController.this.processScheduler.getActiveThreadCount(remoteInputPort);
            }
            for (ProcessorNode processor : group.getProcessors()) {
                this.activeThreadCount += FlowController.this.processScheduler.getActiveThreadCount(processor);
                this.terminatedThreadCount += processor.getTerminatedThreadCount();
            }
            for (Port port : group.getInputPorts()) {
                this.activeThreadCount += FlowController.this.processScheduler.getActiveThreadCount(port);
            }
            for (Port port : group.getOutputPorts()) {
                this.activeThreadCount += FlowController.this.processScheduler.getActiveThreadCount(port);
            }
            for (Funnel funnel : group.getFunnels()) {
                this.activeThreadCount += FlowController.this.processScheduler.getActiveThreadCount(funnel);
            }
            for (ProcessGroup childGroup : group.getProcessGroups()) {
                this.calculateCounts(childGroup);
            }
        }

        public int getQueuedCount() {
            return this.queuedCount;
        }

        public long getQueuedContentSize() {
            return this.queuedContentSize;
        }

        public int getActiveThreadCount() {
            return this.activeThreadCount;
        }

        public int getTerminatedThreadCount() {
            return this.terminatedThreadCount;
        }
    }
}

