/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.persistence.StandardSnippetDeserializer;
import org.apache.nifi.stream.io.StreamUtils;

public class SnippetManager {
    private final Cache<String, StandardSnippet> snippetMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public synchronized void addSnippet(StandardSnippet snippet) {
        if (this.snippetMap.getIfPresent((Object)snippet.getId()) != null) {
            throw new IllegalStateException("Snippet with ID " + snippet.getId() + " already exists");
        }
        this.snippetMap.put((Object)snippet.getId(), (Object)snippet);
    }

    public synchronized void removeSnippet(StandardSnippet snippet) {
        if (this.snippetMap.getIfPresent((Object)snippet.getId()) == null) {
            throw new IllegalStateException("Snippet is not contained in this SnippetManager");
        }
        this.snippetMap.invalidate((Object)snippet.getId());
    }

    public synchronized StandardSnippet getSnippet(String identifier) {
        return (StandardSnippet)this.snippetMap.getIfPresent((Object)identifier);
    }

    public synchronized Collection<StandardSnippet> getSnippets() {
        return Collections.unmodifiableCollection(this.snippetMap.asMap().values());
    }

    public synchronized void clear() {
        this.snippetMap.invalidateAll();
    }

    public static List<StandardSnippet> parseBytes(byte[] bytes) {
        ArrayList<StandardSnippet> snippets = new ArrayList<StandardSnippet>();
        try (ByteArrayInputStream rawIn = new ByteArrayInputStream(bytes);
             DataInputStream in = new DataInputStream(rawIn);){
            int length = in.readInt();
            byte[] buffer = new byte[length];
            StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)true);
            StandardSnippet snippet = StandardSnippetDeserializer.deserialize(new ByteArrayInputStream(buffer));
            snippets.add(snippet);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse bytes", e);
        }
        return snippets;
    }

    /*
     * Exception decompiling
     */
    public byte[] export() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

