/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleCompatibilityCheck
implements FlowInheritabilityCheck {
    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        Document configuration = proposedFlow.getFlowDocument();
        if (configuration == null) {
            return FlowInheritability.inheritable();
        }
        ExtensionManager extensionManager = flowController.getExtensionManager();
        NodeList bundleNodes = configuration.getElementsByTagName("bundle");
        for (int i = 0; i < bundleNodes.getLength(); ++i) {
            Element componentElement;
            Element bundleElement;
            Node componentNode;
            Node bundleNode = bundleNodes.item(i);
            if (!(bundleNode instanceof Element) || !((componentNode = (bundleElement = (Element)bundleNode).getParentNode()) instanceof Element) || this.withinTemplate(componentElement = (Element)componentNode)) continue;
            String componentType = DomUtils.getChildText(componentElement, "class");
            BundleDTO bundleDto = FlowFromDOMFactory.getBundle(bundleElement);
            try {
                BundleUtils.getBundle(extensionManager, componentType, bundleDto);
                continue;
            }
            catch (IllegalStateException e) {
                String bundleDescription = bundleDto.getGroup() + ":" + bundleDto.getArtifact() + ":" + bundleDto.getVersion();
                return FlowInheritability.notInheritable("Could not find Bundle " + bundleDescription + ": " + e.getMessage());
            }
        }
        return FlowInheritability.inheritable();
    }

    private boolean withinTemplate(Element element) {
        if ("template".equals(element.getTagName())) {
            return true;
        }
        Node parentNode = element.getParentNode();
        if (parentNode instanceof Element) {
            return this.withinTemplate((Element)parentNode);
        }
        return false;
    }
}

