/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.parameter.StandardParameterUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardParameterContext
implements ParameterContext {
    private static final Logger logger = LoggerFactory.getLogger(StandardParameterContext.class);
    private final String id;
    private final ParameterReferenceManager parameterReferenceManager;
    private final Authorizable parentAuthorizable;
    private String name;
    private long version = 0L;
    private final Map<ParameterDescriptor, Parameter> parameters = new LinkedHashMap<ParameterDescriptor, Parameter>();
    private volatile String description;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public StandardParameterContext(String id, String name, ParameterReferenceManager parameterReferenceManager, Authorizable parentAuthorizable) {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.parameterReferenceManager = parameterReferenceManager;
        this.parentAuthorizable = parentAuthorizable;
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public String getName() {
        this.readLock.lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setName(String name) {
        this.writeLock.lock();
        try {
            ++this.version;
            this.name = name;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(Map<String, Parameter> updatedParameters) {
        this.writeLock.lock();
        try {
            ++this.version;
            this.verifyCanSetParameters(updatedParameters);
            HashMap<String, StandardParameterUpdate> parameterUpdates = new HashMap<String, StandardParameterUpdate>();
            boolean changeAffectingComponents = false;
            for (Map.Entry<String, Parameter> entry : updatedParameters.entrySet()) {
                Parameter oldParameter;
                String parameterName = entry.getKey();
                Parameter parameter = entry.getValue();
                if (parameter == null) {
                    changeAffectingComponents = true;
                    ParameterDescriptor parameterDescriptor = new ParameterDescriptor.Builder().name(parameterName).build();
                    oldParameter = this.parameters.remove(parameterDescriptor);
                    parameterUpdates.put(parameterName, new StandardParameterUpdate(parameterName, oldParameter.getValue(), null, parameterDescriptor.isSensitive()));
                    continue;
                }
                Parameter updatedParameter = this.createFullyPopulatedParameter(parameter);
                oldParameter = this.parameters.put(updatedParameter.getDescriptor(), updatedParameter);
                if (oldParameter != null && Objects.equals(oldParameter.getValue(), updatedParameter.getValue())) continue;
                changeAffectingComponents = true;
                String previousValue = oldParameter == null ? null : oldParameter.getValue();
                parameterUpdates.put(parameterName, new StandardParameterUpdate(parameterName, previousValue, updatedParameter.getValue(), updatedParameter.getDescriptor().isSensitive()));
            }
            if (changeAffectingComponents) {
                logger.debug("Parameter Context {} was updated. {} parameters changed ({}). Notifying all affected components.", new Object[]{this, parameterUpdates.size(), parameterUpdates});
                for (ProcessGroup processGroup : this.parameterReferenceManager.getProcessGroupsBound((ParameterContext)this)) {
                    try {
                        processGroup.onParameterContextUpdated(parameterUpdates);
                    }
                    catch (Exception e) {
                        logger.error("Failed to notify {} that Parameter Context was updated", (Object)processGroup, (Object)e);
                    }
                }
            } else {
                logger.debug("Parameter Context {} was updated. {} parameters changed ({}). No existing components are affected.", new Object[]{this, parameterUpdates.size(), parameterUpdates});
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Parameter createFullyPopulatedParameter(Parameter proposedParameter) {
        ParameterDescriptor descriptor = this.getFullyPopulatedDescriptor(proposedParameter);
        String value = this.getFullyPopulatedValue(proposedParameter);
        return new Parameter(descriptor, value);
    }

    private String getFullyPopulatedValue(Parameter proposedParameter) {
        if (proposedParameter.getValue() != null) {
            return proposedParameter.getValue();
        }
        Parameter oldParameter = this.parameters.get(proposedParameter.getDescriptor());
        return oldParameter == null ? null : oldParameter.getValue();
    }

    private ParameterDescriptor getFullyPopulatedDescriptor(Parameter proposedParameter) {
        ParameterDescriptor descriptor = proposedParameter.getDescriptor();
        if (descriptor.getDescription() != null) {
            return descriptor;
        }
        Parameter oldParameter = this.parameters.get(proposedParameter.getDescriptor());
        return oldParameter == null ? descriptor : oldParameter.getDescriptor();
    }

    public long getVersion() {
        this.readLock.lock();
        try {
            long l = this.version;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Parameter> getParameter(String parameterName) {
        this.readLock.lock();
        try {
            ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(parameterName).build();
            Optional<Parameter> optional = this.getParameter(descriptor);
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.parameters.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Optional<Parameter> getParameter(ParameterDescriptor parameterDescriptor) {
        this.readLock.lock();
        try {
            Optional<Parameter> optional = Optional.ofNullable(this.parameters.get(parameterDescriptor));
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<ParameterDescriptor, Parameter> getParameters() {
        this.readLock.lock();
        try {
            LinkedHashMap<ParameterDescriptor, Parameter> linkedHashMap = new LinkedHashMap<ParameterDescriptor, Parameter>(this.parameters);
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ParameterReferenceManager getParameterReferenceManager() {
        return this.parameterReferenceManager;
    }

    public void verifyCanSetParameters(Map<String, Parameter> updatedParameters) {
        for (Map.Entry<String, Parameter> entry : updatedParameters.entrySet()) {
            String parameterName = entry.getKey();
            Parameter parameter = entry.getValue();
            if (parameter == null) {
                this.validateReferencingComponents(parameterName, null, "remove");
                continue;
            }
            if (!Objects.equals(parameterName, parameter.getDescriptor().getName())) {
                throw new IllegalArgumentException("Parameter '" + parameterName + "' was specified with the wrong key in the Map");
            }
            this.validateSensitiveFlag(parameter);
            this.validateReferencingComponents(parameterName, parameter, "update");
        }
    }

    private void validateSensitiveFlag(Parameter updatedParameter) {
        ParameterDescriptor updatedDescriptor = updatedParameter.getDescriptor();
        Parameter existingParameter = this.parameters.get(updatedDescriptor);
        if (existingParameter == null) {
            return;
        }
        ParameterDescriptor existingDescriptor = existingParameter.getDescriptor();
        if (existingDescriptor.isSensitive() != updatedDescriptor.isSensitive() && updatedParameter.getValue() != null) {
            String existingSensitiveDescription = existingDescriptor.isSensitive() ? "sensitive" : "not sensitive";
            String updatedSensitiveDescription = updatedDescriptor.isSensitive() ? "sensitive" : "not sensitive";
            throw new IllegalStateException("Cannot update Parameters because doing so would change Parameter '" + existingDescriptor.getName() + "' from " + existingSensitiveDescription + " to " + updatedSensitiveDescription);
        }
    }

    private void validateReferencingComponents(String parameterName, Parameter parameter, String parameterAction) {
        for (ProcessorNode procNode : this.parameterReferenceManager.getProcessorsReferencing((ParameterContext)this, parameterName)) {
            if (procNode.isRunning()) {
                throw new IllegalStateException("Cannot " + parameterAction + " parameter '" + parameterName + "' because it is referenced by " + procNode + ", which is currently running");
            }
            if (parameter == null) continue;
            this.validateParameterSensitivity(parameter, (ComponentNode)procNode);
        }
        for (ControllerServiceNode serviceNode : this.parameterReferenceManager.getControllerServicesReferencing((ParameterContext)this, parameterName)) {
            ControllerServiceState serviceState = serviceNode.getState();
            if (serviceState != ControllerServiceState.DISABLED) {
                throw new IllegalStateException("Cannot " + parameterAction + " parameter '" + parameterName + "' because it is referenced by " + serviceNode + ", which currently has a state of " + serviceState);
            }
            if (parameter == null) continue;
            this.validateParameterSensitivity(parameter, (ComponentNode)serviceNode);
        }
    }

    private void validateParameterSensitivity(Parameter parameter, ComponentNode componentNode) {
        String paramName = parameter.getDescriptor().getName();
        for (Map.Entry entry : componentNode.getProperties().entrySet()) {
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            if (configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                if (!parameter.getDescriptor().getName().equals(reference.getParameterName())) continue;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
                if (propertyDescriptor.isSensitive() && !parameter.getDescriptor().isSensitive()) {
                    throw new IllegalStateException("Cannot add Parameter with name '" + paramName + "' unless that Parameter is Sensitive because a Parameter with that name is already referenced from a Sensitive Property");
                }
                if (propertyDescriptor.isSensitive() || !parameter.getDescriptor().isSensitive()) continue;
                throw new IllegalStateException("Cannot add Parameter with name '" + paramName + "' unless that Parameter is Not Sensitive because a Parameter with that name is already referenced from a Property that is not Sensitive");
            }
        }
    }

    public String toString() {
        return "StandardParameterContext[name=" + this.name + "]";
    }

    public Authorizable getParentAuthorizable() {
        return new Authorizable(){

            public Authorizable getParentAuthorizable() {
                return StandardParameterContext.this.parentAuthorizable;
            }

            public Resource getResource() {
                return ResourceFactory.getParameterContextsResource();
            }
        };
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ParameterContext, (String)this.getIdentifier(), (String)this.getName());
    }
}

