/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.tasks;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.lifecycle.TaskTerminationAwareStateManager;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.RepositoryContext;
import org.apache.nifi.controller.repository.scheduling.ConnectableProcessContext;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.tasks.InvocationResult;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.util.Connectables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectableTask {
    private static final Logger logger = LoggerFactory.getLogger(ConnectableTask.class);
    private final SchedulingAgent schedulingAgent;
    private final Connectable connectable;
    private final RepositoryContext repositoryContext;
    private final LifecycleState scheduleState;
    private final ProcessContext processContext;
    private final FlowController flowController;
    private final int numRelationships;

    public ConnectableTask(SchedulingAgent schedulingAgent, Connectable connectable, FlowController flowController, RepositoryContextFactory contextFactory, LifecycleState scheduleState, StringEncryptor encryptor) {
        this.schedulingAgent = schedulingAgent;
        this.connectable = connectable;
        this.scheduleState = scheduleState;
        this.numRelationships = connectable.getRelationships().size();
        this.flowController = flowController;
        TaskTerminationAwareStateManager stateManager = new TaskTerminationAwareStateManager(flowController.getStateManagerProvider().getStateManager(connectable.getIdentifier()), () -> ((LifecycleState)scheduleState).isTerminated());
        this.processContext = connectable instanceof ProcessorNode ? new StandardProcessContext((ProcessorNode)connectable, flowController.getControllerServiceProvider(), encryptor, (StateManager)stateManager, () -> ((LifecycleState)scheduleState).isTerminated(), (NodeTypeProvider)flowController) : new ConnectableProcessContext(connectable, encryptor, (StateManager)stateManager);
        this.repositoryContext = contextFactory.newProcessContext(connectable, new AtomicLong(0L));
    }

    public Connectable getConnectable() {
        return this.connectable;
    }

    private boolean isRunOnCluster(FlowController flowController) {
        return !this.connectable.isIsolated() || !flowController.isConfiguredForClustering() || flowController.isPrimary();
    }

    private boolean isYielded() {
        return this.connectable.getYieldExpiration() > System.currentTimeMillis();
    }

    private boolean isWorkToDo() {
        boolean hasNonLoopConnection = Connectables.hasNonLoopConnection((Connectable)this.connectable);
        if (this.connectable.getConnectableType() == ConnectableType.FUNNEL) {
            return this.connectable.hasIncomingConnection() && hasNonLoopConnection && !this.connectable.getConnections().isEmpty() && Connectables.flowFilesQueued((Connectable)this.connectable);
        }
        boolean isSourceComponent = this.connectable.isTriggerWhenEmpty() || !this.connectable.hasIncomingConnection() || !hasNonLoopConnection;
        return isSourceComponent || Connectables.flowFilesQueued((Connectable)this.connectable);
    }

    private boolean isBackPressureEngaged() {
        return this.connectable.getIncomingConnections().stream().filter(con -> con.getSource() == this.connectable).map(Connection::getFlowFileQueue).anyMatch(FlowFileQueue::isFull);
    }

    /*
     * Exception decompiling
     */
    public InvocationResult invoke() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 71[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

