/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.revision.RevisionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowControllerFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private FlowController flowController;
    private NiFiProperties properties;
    private Authorizer authorizer;
    private AuditService auditService;
    private StringEncryptor encryptor;
    private BulletinRepository bulletinRepository;
    private ClusterCoordinator clusterCoordinator;
    private VariableRegistry variableRegistry;
    private LeaderElectionManager leaderElectionManager;
    private FlowRegistryClient flowRegistryClient;
    private ExtensionManager extensionManager;
    private RevisionManager revisionManager;

    public Object getObject() throws Exception {
        if (this.flowController == null) {
            FlowFileEventRepository flowFileEventRepository = (FlowFileEventRepository)this.applicationContext.getBean("flowFileEventRepository", FlowFileEventRepository.class);
            if (this.properties.isNode()) {
                NodeProtocolSender nodeProtocolSender = (NodeProtocolSender)this.applicationContext.getBean("nodeProtocolSender", NodeProtocolSender.class);
                HeartbeatMonitor heartbeatMonitor = (HeartbeatMonitor)this.applicationContext.getBean("heartbeatMonitor", HeartbeatMonitor.class);
                this.flowController = FlowController.createClusteredInstance(flowFileEventRepository, this.properties, this.authorizer, this.auditService, this.encryptor, nodeProtocolSender, this.bulletinRepository, this.clusterCoordinator, heartbeatMonitor, this.leaderElectionManager, this.variableRegistry, this.flowRegistryClient, this.extensionManager, this.revisionManager);
            } else {
                this.flowController = FlowController.createStandaloneInstance(flowFileEventRepository, this.properties, this.authorizer, this.auditService, this.encryptor, this.bulletinRepository, this.variableRegistry, this.flowRegistryClient, this.extensionManager);
            }
        }
        return this.flowController;
    }

    public Class getObjectType() {
        return FlowController.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setEncryptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public void setVariableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    public void setFlowRegistryClient(FlowRegistryClient flowRegistryClient) {
        this.flowRegistryClient = flowRegistryClient;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }
}

