/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.client.async.nio;

import javax.net.ssl.SSLContext;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.clustered.FlowFileContentAccess;
import org.apache.nifi.controller.queue.clustered.client.LoadBalanceFlowFileCodec;
import org.apache.nifi.controller.queue.clustered.client.StandardLoadBalanceFlowFileCodec;
import org.apache.nifi.controller.queue.clustered.client.async.AsyncLoadBalanceClientFactory;
import org.apache.nifi.controller.queue.clustered.client.async.nio.NioAsyncLoadBalanceClient;
import org.apache.nifi.events.EventReporter;

public class NioAsyncLoadBalanceClientFactory
implements AsyncLoadBalanceClientFactory {
    private final SSLContext sslContext;
    private final int timeoutMillis;
    private final FlowFileContentAccess flowFileContentAccess;
    private final EventReporter eventReporter;
    private final LoadBalanceFlowFileCodec flowFileCodec;

    public NioAsyncLoadBalanceClientFactory(SSLContext sslContext, int timeoutMillis, FlowFileContentAccess flowFileContentAccess, EventReporter eventReporter, LoadBalanceFlowFileCodec loadBalanceFlowFileCodec) {
        this.sslContext = sslContext;
        this.timeoutMillis = timeoutMillis;
        this.flowFileContentAccess = flowFileContentAccess;
        this.eventReporter = eventReporter;
        this.flowFileCodec = loadBalanceFlowFileCodec;
    }

    @Override
    public NioAsyncLoadBalanceClient createClient(NodeIdentifier nodeIdentifier) {
        return new NioAsyncLoadBalanceClient(nodeIdentifier, this.sslContext, this.timeoutMillis, this.flowFileContentAccess, new StandardLoadBalanceFlowFileCodec(), this.eventReporter);
    }
}

