/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.StandardProcessSession;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.provenance.ProvenanceReporter;

public class BatchingSessionFactory
implements ProcessSessionFactory {
    private final HighThroughputSession highThroughputSession;

    public BatchingSessionFactory(StandardProcessSession standardProcessSession) {
        this.highThroughputSession = new HighThroughputSession(standardProcessSession);
    }

    public ProcessSession createSession() {
        return this.highThroughputSession;
    }

    private class HighThroughputSession
    implements ProcessSession {
        private final StandardProcessSession session;

        public HighThroughputSession(StandardProcessSession session) {
            this.session = session;
        }

        public void commit() {
            this.session.checkpoint();
        }

        public void rollback() {
            this.session.rollback();
        }

        public void rollback(boolean penalize) {
            this.session.rollback(penalize);
        }

        public void migrate(ProcessSession newOwner, Collection<FlowFile> flowFiles) {
            this.session.migrate(newOwner, flowFiles);
        }

        public void adjustCounter(String name, long delta, boolean immediate) {
            this.session.adjustCounter(name, delta, immediate);
        }

        public FlowFile get() {
            return this.session.get();
        }

        public List<FlowFile> get(int maxResults) {
            return this.session.get(maxResults);
        }

        public List<FlowFile> get(FlowFileFilter filter) {
            return this.session.get(filter);
        }

        public QueueSize getQueueSize() {
            return this.session.getQueueSize();
        }

        public FlowFile create() {
            return this.session.create();
        }

        public FlowFile create(FlowFile parent) {
            return this.session.create(parent);
        }

        public FlowFile create(Collection<FlowFile> parents) {
            return this.session.create(parents);
        }

        public FlowFile clone(FlowFile example) {
            return this.session.clone(example);
        }

        public FlowFile clone(FlowFile example, long offset, long size) {
            return this.session.clone(example, offset, size);
        }

        public FlowFile penalize(FlowFile flowFile) {
            return this.session.penalize(flowFile);
        }

        public FlowFile putAttribute(FlowFile flowFile, String key, String value) {
            return this.session.putAttribute(flowFile, key, value);
        }

        public FlowFile putAllAttributes(FlowFile flowFile, Map<String, String> attributes) {
            return this.session.putAllAttributes(flowFile, attributes);
        }

        public FlowFile removeAttribute(FlowFile flowFile, String key) {
            return this.session.removeAttribute(flowFile, key);
        }

        public FlowFile removeAllAttributes(FlowFile flowFile, Set<String> keys) {
            return this.session.removeAllAttributes(flowFile, keys);
        }

        public FlowFile removeAllAttributes(FlowFile flowFile, Pattern keyPattern) {
            return this.session.removeAllAttributes(flowFile, keyPattern);
        }

        public void transfer(FlowFile flowFile, Relationship relationship) {
            this.session.transfer(flowFile, relationship);
        }

        public void transfer(FlowFile flowFile) {
            this.session.transfer(flowFile);
        }

        public void transfer(Collection<FlowFile> flowFiles) {
            this.session.transfer(flowFiles);
        }

        public void transfer(Collection<FlowFile> flowFiles, Relationship relationship) {
            this.session.transfer(flowFiles, relationship);
        }

        public void remove(FlowFile flowFile) {
            this.session.remove(flowFile);
        }

        public void remove(Collection<FlowFile> flowFiles) {
            this.session.remove(flowFiles);
        }

        public void read(FlowFile source, InputStreamCallback reader) {
            this.session.read(source, reader);
        }

        public void read(FlowFile source, boolean allowSessionStreamManagement, InputStreamCallback reader) {
            this.session.read(source, allowSessionStreamManagement, reader);
        }

        public InputStream read(FlowFile flowFile) {
            return this.session.read(flowFile);
        }

        public FlowFile merge(Collection<FlowFile> sources, FlowFile destination) {
            return this.session.merge(sources, destination);
        }

        public FlowFile merge(Collection<FlowFile> sources, FlowFile destination, byte[] header, byte[] footer, byte[] demarcator) {
            return this.session.merge(sources, destination, header, footer, demarcator);
        }

        public FlowFile write(FlowFile source, OutputStreamCallback writer) {
            return this.session.write(source, writer);
        }

        public FlowFile write(FlowFile source, StreamCallback writer) {
            return this.session.write(source, writer);
        }

        public FlowFile append(FlowFile source, OutputStreamCallback writer) {
            return this.session.append(source, writer);
        }

        public FlowFile importFrom(Path source, boolean keepSourceFile, FlowFile destination) {
            return this.session.importFrom(source, keepSourceFile, destination);
        }

        public FlowFile importFrom(InputStream source, FlowFile destination) {
            return this.session.importFrom(source, destination);
        }

        public void exportTo(FlowFile flowFile, Path destination, boolean append) {
            this.session.exportTo(flowFile, destination, append);
        }

        public void exportTo(FlowFile flowFile, OutputStream destination) {
            this.session.exportTo(flowFile, destination);
        }

        public ProvenanceReporter getProvenanceReporter() {
            return this.session.getProvenanceReporter();
        }

        public void setState(Map<String, String> state, Scope scope) throws IOException {
            this.session.setState(state, scope);
        }

        public StateMap getState(Scope scope) throws IOException {
            return this.session.getState(scope);
        }

        public boolean replaceState(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
            return this.session.replaceState(oldValue, newValue, scope);
        }

        public void clearState(Scope scope) {
            this.session.clearState(scope);
        }

        public OutputStream write(FlowFile source) {
            return this.session.write(source);
        }
    }
}

