/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FlowFromDOMFactory {
    private static final Logger logger = LoggerFactory.getLogger(FlowFromDOMFactory.class);

    public static BundleDTO getBundle(Element bundleElement) {
        if (bundleElement == null) {
            return null;
        }
        Element groupElement = DomUtils.getChild((Element)bundleElement, (String)"group");
        Element artifactElement = DomUtils.getChild((Element)bundleElement, (String)"artifact");
        Element versionElement = DomUtils.getChild((Element)bundleElement, (String)"version");
        return new BundleDTO(groupElement.getTextContent(), artifactElement.getTextContent(), versionElement.getTextContent());
    }

    public static PositionDTO getPosition(Element positionElement) {
        if (positionElement == null) {
            throw new IllegalArgumentException("Invalid Flow: Found no 'position' element");
        }
        return new PositionDTO(Double.valueOf(Double.parseDouble(positionElement.getAttribute("x"))), Double.valueOf(Double.parseDouble(positionElement.getAttribute("y"))));
    }

    public static Size getSize(Element sizeElement) {
        if (sizeElement == null) {
            throw new IllegalArgumentException("Invalid Flow: Found no 'size' element");
        }
        return new Size(Double.parseDouble(sizeElement.getAttribute("width")), Double.parseDouble(sizeElement.getAttribute("height")));
    }

    public static Map<String, String> getStyle(Element stylesElement) {
        HashMap<String, String> styles = new HashMap<String, String>();
        if (stylesElement == null) {
            return styles;
        }
        for (Element styleElement : FlowFromDOMFactory.getChildrenByTagName(stylesElement, "style")) {
            String styleName = styleElement.getAttribute("name");
            String styleValue = styleElement.getTextContent();
            styles.put(styleName, styleValue);
        }
        return styles;
    }

    public static ControllerServiceDTO getControllerService(Element element, StringEncryptor encryptor, FlowEncodingVersion flowEncodingVersion) {
        ControllerServiceDTO dto = new ControllerServiceDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setComments(FlowFromDOMFactory.getString(element, "comment"));
        dto.setType(FlowFromDOMFactory.getString(element, "class"));
        dto.setBundle(FlowFromDOMFactory.getBundle(DomUtils.getChild((Element)element, (String)"bundle")));
        boolean enabled = FlowFromDOMFactory.getBoolean(element, "enabled");
        dto.setState(enabled ? ControllerServiceState.ENABLED.name() : ControllerServiceState.DISABLED.name());
        dto.setProperties(FlowFromDOMFactory.getProperties(element, encryptor, flowEncodingVersion));
        dto.setAnnotationData(FlowFromDOMFactory.getString(element, "annotationData"));
        return dto;
    }

    public static ReportingTaskDTO getReportingTask(Element element, StringEncryptor encryptor, FlowEncodingVersion flowEncodingVersion) {
        ReportingTaskDTO dto = new ReportingTaskDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setComments(FlowFromDOMFactory.getString(element, "comment"));
        dto.setType(FlowFromDOMFactory.getString(element, "class"));
        dto.setBundle(FlowFromDOMFactory.getBundle(DomUtils.getChild((Element)element, (String)"bundle")));
        dto.setSchedulingPeriod(FlowFromDOMFactory.getString(element, "schedulingPeriod"));
        dto.setState(FlowFromDOMFactory.getString(element, "scheduledState"));
        dto.setSchedulingStrategy(FlowFromDOMFactory.getString(element, "schedulingStrategy"));
        dto.setProperties(FlowFromDOMFactory.getProperties(element, encryptor, flowEncodingVersion));
        dto.setAnnotationData(FlowFromDOMFactory.getString(element, "annotationData"));
        return dto;
    }

    public static ParameterContextDTO getParameterContext(Element element, StringEncryptor encryptor) {
        ParameterContextDTO dto = new ParameterContextDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setDescription(FlowFromDOMFactory.getString(element, "description"));
        LinkedHashSet<ParameterEntity> parameterDtos = new LinkedHashSet<ParameterEntity>();
        List<Element> parameterElements = FlowFromDOMFactory.getChildrenByTagName(element, "parameter");
        for (Element parameterElement : parameterElements) {
            ParameterDTO parameterDto = new ParameterDTO();
            parameterDto.setName(FlowFromDOMFactory.getString(parameterElement, "name"));
            parameterDto.setDescription(FlowFromDOMFactory.getString(parameterElement, "description"));
            parameterDto.setSensitive(Boolean.valueOf(FlowFromDOMFactory.getBoolean(parameterElement, "sensitive")));
            String value = FlowFromDOMFactory.decrypt(FlowFromDOMFactory.getString(parameterElement, "value"), encryptor);
            parameterDto.setValue(value);
            ParameterEntity parameterEntity = new ParameterEntity();
            parameterEntity.setParameter(parameterDto);
            parameterDtos.add(parameterEntity);
        }
        dto.setParameters(parameterDtos);
        return dto;
    }

    public static ProcessGroupDTO getProcessGroup(String parentId, Element element, StringEncryptor encryptor, FlowEncodingVersion encodingVersion) {
        int i;
        ProcessGroupDTO dto = new ProcessGroupDTO();
        String groupId = FlowFromDOMFactory.getString(element, "id");
        dto.setId(groupId);
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        dto.setParentGroupId(parentId);
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setPosition(FlowFromDOMFactory.getPosition(DomUtils.getChild((Element)element, (String)"position")));
        dto.setComments(FlowFromDOMFactory.getString(element, "comment"));
        dto.setFlowfileConcurrency(FlowFromDOMFactory.getString(element, "flowfileConcurrency"));
        dto.setFlowfileOutboundPolicy(FlowFromDOMFactory.getString(element, "flowfileOutboundPolicy"));
        HashMap<String, String> variables = new HashMap<String, String>();
        NodeList variableList = DomUtils.getChildNodesByTagName((Element)element, (String)"variable");
        for (int i2 = 0; i2 < variableList.getLength(); ++i2) {
            Element variableElement = (Element)variableList.item(i2);
            String name = variableElement.getAttribute("name");
            String value = variableElement.getAttribute("value");
            variables.put(name, value);
        }
        dto.setVariables(variables);
        Element versionControlInfoElement = DomUtils.getChild((Element)element, (String)"versionControlInformation");
        dto.setVersionControlInformation(FlowFromDOMFactory.getVersionControlInformation(versionControlInfoElement));
        String parameterContextId = FlowFromDOMFactory.getString(element, "parameterContextId");
        ParameterContextReferenceEntity parameterContextReference = new ParameterContextReferenceEntity();
        parameterContextReference.setId(parameterContextId);
        dto.setParameterContext(parameterContextReference);
        HashSet<ProcessorDTO> processors = new HashSet<ProcessorDTO>();
        HashSet<ConnectionDTO> connections = new HashSet<ConnectionDTO>();
        HashSet<FunnelDTO> funnels = new HashSet<FunnelDTO>();
        HashSet<PortDTO> inputPorts = new HashSet<PortDTO>();
        HashSet<PortDTO> outputPorts = new HashSet<PortDTO>();
        HashSet<LabelDTO> labels = new HashSet<LabelDTO>();
        HashSet<ProcessGroupDTO> processGroups = new HashSet<ProcessGroupDTO>();
        HashSet<RemoteProcessGroupDTO> remoteProcessGroups = new HashSet<RemoteProcessGroupDTO>();
        NodeList nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"processor");
        for (i = 0; i < nodeList.getLength(); ++i) {
            processors.add(FlowFromDOMFactory.getProcessor((Element)nodeList.item(i), encryptor, encodingVersion));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"funnel");
        for (i = 0; i < nodeList.getLength(); ++i) {
            funnels.add(FlowFromDOMFactory.getFunnel((Element)nodeList.item(i)));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"inputPort");
        for (i = 0; i < nodeList.getLength(); ++i) {
            inputPorts.add(FlowFromDOMFactory.getPort((Element)nodeList.item(i)));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"outputPort");
        for (i = 0; i < nodeList.getLength(); ++i) {
            outputPorts.add(FlowFromDOMFactory.getPort((Element)nodeList.item(i)));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"label");
        for (i = 0; i < nodeList.getLength(); ++i) {
            labels.add(FlowFromDOMFactory.getLabel((Element)nodeList.item(i)));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"processGroup");
        for (i = 0; i < nodeList.getLength(); ++i) {
            processGroups.add(FlowFromDOMFactory.getProcessGroup(groupId, (Element)nodeList.item(i), encryptor, encodingVersion));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"remoteProcessGroup");
        for (i = 0; i < nodeList.getLength(); ++i) {
            remoteProcessGroups.add(FlowFromDOMFactory.getRemoteProcessGroup((Element)nodeList.item(i), encryptor));
        }
        nodeList = DomUtils.getChildNodesByTagName((Element)element, (String)"connection");
        for (i = 0; i < nodeList.getLength(); ++i) {
            connections.add(FlowFromDOMFactory.getConnection((Element)nodeList.item(i)));
        }
        FlowSnippetDTO groupContents = new FlowSnippetDTO();
        groupContents.setConnections(connections);
        groupContents.setFunnels(funnels);
        groupContents.setInputPorts(inputPorts);
        groupContents.setLabels(labels);
        groupContents.setOutputPorts(outputPorts);
        groupContents.setProcessGroups(processGroups);
        groupContents.setProcessors(processors);
        groupContents.setRemoteProcessGroups(remoteProcessGroups);
        dto.setContents(groupContents);
        return dto;
    }

    private static VersionControlInformationDTO getVersionControlInformation(Element versionControlInfoElement) {
        if (versionControlInfoElement == null) {
            return null;
        }
        VersionControlInformationDTO dto = new VersionControlInformationDTO();
        dto.setRegistryId(FlowFromDOMFactory.getString(versionControlInfoElement, "registryId"));
        dto.setBucketId(FlowFromDOMFactory.getString(versionControlInfoElement, "bucketId"));
        dto.setBucketName(FlowFromDOMFactory.getString(versionControlInfoElement, "bucketName"));
        dto.setFlowId(FlowFromDOMFactory.getString(versionControlInfoElement, "flowId"));
        dto.setFlowName(FlowFromDOMFactory.getString(versionControlInfoElement, "flowName"));
        dto.setFlowDescription(FlowFromDOMFactory.getString(versionControlInfoElement, "flowDescription"));
        dto.setVersion(Integer.valueOf(FlowFromDOMFactory.getInt(versionControlInfoElement, "version")));
        return dto;
    }

    public static ConnectionDTO getConnection(Element element) {
        String expiration;
        ConnectionDTO dto = new ConnectionDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setLabelIndex(FlowFromDOMFactory.getOptionalInt(element, "labelIndex"));
        dto.setzIndex(FlowFromDOMFactory.getOptionalLong(element, "zIndex"));
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        ArrayList<PositionDTO> bends = new ArrayList<PositionDTO>();
        Element bendPointsElement = DomUtils.getChild((Element)element, (String)"bendPoints");
        if (bendPointsElement != null) {
            for (Element bendPointElement : FlowFromDOMFactory.getChildrenByTagName(bendPointsElement, "bendPoint")) {
                PositionDTO bend = FlowFromDOMFactory.getPosition(bendPointElement);
                bends.add(bend);
            }
        }
        dto.setBends(bends);
        ConnectableDTO sourceConnectable = new ConnectableDTO();
        dto.setSource(sourceConnectable);
        sourceConnectable.setId(FlowFromDOMFactory.getString(element, "sourceId"));
        sourceConnectable.setGroupId(FlowFromDOMFactory.getString(element, "sourceGroupId"));
        sourceConnectable.setType(FlowFromDOMFactory.getString(element, "sourceType"));
        ConnectableDTO destConnectable = new ConnectableDTO();
        dto.setDestination(destConnectable);
        destConnectable.setId(FlowFromDOMFactory.getString(element, "destinationId"));
        destConnectable.setGroupId(FlowFromDOMFactory.getString(element, "destinationGroupId"));
        destConnectable.setType(FlowFromDOMFactory.getString(element, "destinationType"));
        HashSet<String> relationships = new HashSet<String>();
        List<Element> relationshipNodeList = FlowFromDOMFactory.getChildrenByTagName(element, "relationship");
        for (Element relationshipElem : relationshipNodeList) {
            relationships.add(relationshipElem.getTextContent());
        }
        dto.setSelectedRelationships(relationships);
        dto.setBackPressureObjectThreshold(Long.valueOf(FlowFromDOMFactory.getLong(element, "maxWorkQueueSize")));
        String maxDataSize = FlowFromDOMFactory.getString(element, "maxWorkQueueDataSize");
        if (maxDataSize != null && !maxDataSize.trim().isEmpty()) {
            dto.setBackPressureDataSizeThreshold(maxDataSize);
        }
        if ((expiration = FlowFromDOMFactory.getString(element, "flowFileExpiration")) == null) {
            expiration = "0 sec";
        }
        dto.setFlowFileExpiration(expiration);
        ArrayList<String> prioritizerClasses = new ArrayList<String>();
        List<Element> prioritizerNodeList = FlowFromDOMFactory.getChildrenByTagName(element, "queuePrioritizerClass");
        for (Element prioritizerElement : prioritizerNodeList) {
            prioritizerClasses.add(prioritizerElement.getTextContent().trim());
        }
        dto.setPrioritizers(prioritizerClasses);
        dto.setLoadBalanceStrategy(FlowFromDOMFactory.getString(element, "loadBalanceStrategy"));
        dto.setLoadBalancePartitionAttribute(FlowFromDOMFactory.getString(element, "partitioningAttribute"));
        dto.setLoadBalanceCompression(FlowFromDOMFactory.getString(element, "loadBalanceCompression"));
        return dto;
    }

    public static RemoteProcessGroupDTO getRemoteProcessGroup(Element element, StringEncryptor encryptor) {
        RemoteProcessGroupDTO dto = new RemoteProcessGroupDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setTargetUri(FlowFromDOMFactory.getString(element, "url"));
        dto.setTargetUris(FlowFromDOMFactory.getString(element, "urls"));
        dto.setTransmitting(Boolean.valueOf(FlowFromDOMFactory.getBoolean(element, "transmitting")));
        dto.setPosition(FlowFromDOMFactory.getPosition(DomUtils.getChild((Element)element, (String)"position")));
        dto.setCommunicationsTimeout(FlowFromDOMFactory.getString(element, "timeout"));
        dto.setComments(FlowFromDOMFactory.getString(element, "comment"));
        dto.setYieldDuration(FlowFromDOMFactory.getString(element, "yieldPeriod"));
        dto.setTransportProtocol(FlowFromDOMFactory.getString(element, "transportProtocol"));
        dto.setProxyHost(FlowFromDOMFactory.getString(element, "proxyHost"));
        dto.setProxyPort(FlowFromDOMFactory.getOptionalInt(element, "proxyPort"));
        dto.setProxyUser(FlowFromDOMFactory.getString(element, "proxyUser"));
        dto.setLocalNetworkInterface(FlowFromDOMFactory.getString(element, "networkInterface"));
        String rawPassword = FlowFromDOMFactory.getString(element, "proxyPassword");
        String proxyPassword = encryptor == null ? rawPassword : FlowFromDOMFactory.decrypt(rawPassword, encryptor);
        dto.setProxyPassword(proxyPassword);
        return dto;
    }

    public static LabelDTO getLabel(Element element) {
        LabelDTO dto = new LabelDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        dto.setLabel(FlowFromDOMFactory.getString(element, "value"));
        dto.setPosition(FlowFromDOMFactory.getPosition(DomUtils.getChild((Element)element, (String)"position")));
        Size size = FlowFromDOMFactory.getSize(DomUtils.getChild((Element)element, (String)"size"));
        dto.setWidth(Double.valueOf(size.getWidth()));
        dto.setHeight(Double.valueOf(size.getHeight()));
        dto.setStyle(FlowFromDOMFactory.getStyle(DomUtils.getChild((Element)element, (String)"styles")));
        return dto;
    }

    public static FunnelDTO getFunnel(Element element) {
        FunnelDTO dto = new FunnelDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        dto.setPosition(FlowFromDOMFactory.getPosition(DomUtils.getChild((Element)element, (String)"position")));
        return dto;
    }

    public static PortDTO getPort(Element element) {
        List<Element> groupAccessControls;
        List<Element> userAccessControls;
        PortDTO portDTO = new PortDTO();
        portDTO.setId(FlowFromDOMFactory.getString(element, "id"));
        portDTO.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        portDTO.setPosition(FlowFromDOMFactory.getPosition(DomUtils.getChild((Element)element, (String)"position")));
        portDTO.setName(FlowFromDOMFactory.getString(element, "name"));
        portDTO.setComments(FlowFromDOMFactory.getString(element, "comments"));
        portDTO.setAllowRemoteAccess(Boolean.valueOf(FlowFromDOMFactory.getBoolean(element, "allowRemoteAccess")));
        ScheduledState scheduledState = FlowFromDOMFactory.getScheduledState(element);
        portDTO.setState(scheduledState.toString());
        List<Element> maxTasksElements = FlowFromDOMFactory.getChildrenByTagName(element, "maxConcurrentTasks");
        if (!maxTasksElements.isEmpty()) {
            portDTO.setConcurrentlySchedulableTaskCount(Integer.valueOf(Integer.parseInt(maxTasksElements.get(0).getTextContent())));
        }
        if ((userAccessControls = FlowFromDOMFactory.getChildrenByTagName(element, "userAccessControl")) != null && !userAccessControls.isEmpty()) {
            HashSet<String> users = new HashSet<String>();
            portDTO.setUserAccessControl(users);
            for (Element userElement : userAccessControls) {
                users.add(userElement.getTextContent());
            }
        }
        if ((groupAccessControls = FlowFromDOMFactory.getChildrenByTagName(element, "groupAccessControl")) != null && !groupAccessControls.isEmpty()) {
            HashSet<String> groups = new HashSet<String>();
            portDTO.setGroupAccessControl(groups);
            for (Element groupElement : groupAccessControls) {
                groups.add(groupElement.getTextContent());
            }
        }
        return portDTO;
    }

    public static RemoteProcessGroupPortDescriptor getRemoteProcessGroupPort(Element element) {
        StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
        String id = FlowFromDOMFactory.getString(element, "id");
        if (id.length() > 37) {
            id = id.substring(37);
        }
        descriptor.setId(id);
        String targetId = FlowFromDOMFactory.getString(element, "targetId");
        descriptor.setTargetId(targetId == null ? id : targetId);
        descriptor.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        descriptor.setName(FlowFromDOMFactory.getString(element, "name"));
        descriptor.setComments(FlowFromDOMFactory.getString(element, "comments"));
        descriptor.setConcurrentlySchedulableTaskCount(Integer.valueOf(FlowFromDOMFactory.getInt(element, "maxConcurrentTasks")));
        descriptor.setUseCompression(Boolean.valueOf(FlowFromDOMFactory.getBoolean(element, "useCompression")));
        descriptor.setBatchCount(FlowFromDOMFactory.getOptionalInt(element, "batchCount"));
        descriptor.setBatchSize(FlowFromDOMFactory.getString(element, "batchSize"));
        descriptor.setBatchDuration(FlowFromDOMFactory.getString(element, "batchDuration"));
        descriptor.setTransmitting(Boolean.valueOf("RUNNING".equalsIgnoreCase(FlowFromDOMFactory.getString(element, "scheduledState"))));
        return descriptor;
    }

    public static ProcessorDTO getProcessor(Element element, StringEncryptor encryptor, FlowEncodingVersion flowEncodingVersion) {
        ProcessorDTO dto = new ProcessorDTO();
        dto.setId(FlowFromDOMFactory.getString(element, "id"));
        dto.setVersionedComponentId(FlowFromDOMFactory.getString(element, "versionedComponentId"));
        dto.setName(FlowFromDOMFactory.getString(element, "name"));
        dto.setType(FlowFromDOMFactory.getString(element, "class"));
        dto.setBundle(FlowFromDOMFactory.getBundle(DomUtils.getChild((Element)element, (String)"bundle")));
        dto.setPosition(FlowFromDOMFactory.getPosition(DomUtils.getChild((Element)element, (String)"position")));
        dto.setStyle(FlowFromDOMFactory.getStyle(DomUtils.getChild((Element)element, (String)"styles")));
        ProcessorConfigDTO configDto = new ProcessorConfigDTO();
        dto.setConfig(configDto);
        configDto.setComments(FlowFromDOMFactory.getString(element, "comment"));
        configDto.setConcurrentlySchedulableTaskCount(Integer.valueOf(FlowFromDOMFactory.getInt(element, "maxConcurrentTasks")));
        String schedulingPeriod = FlowFromDOMFactory.getString(element, "schedulingPeriod");
        configDto.setSchedulingPeriod(schedulingPeriod);
        configDto.setPenaltyDuration(FlowFromDOMFactory.getString(element, "penalizationPeriod"));
        configDto.setYieldDuration(FlowFromDOMFactory.getString(element, "yieldPeriod"));
        configDto.setBulletinLevel(FlowFromDOMFactory.getString(element, "bulletinLevel"));
        configDto.setLossTolerant(Boolean.valueOf(FlowFromDOMFactory.getBoolean(element, "lossTolerant")));
        ScheduledState scheduledState = FlowFromDOMFactory.getScheduledState(element);
        dto.setState(scheduledState.toString());
        String schedulingStrategyName = FlowFromDOMFactory.getString(element, "schedulingStrategy");
        if (schedulingStrategyName == null || schedulingStrategyName.trim().isEmpty()) {
            configDto.setSchedulingStrategy(SchedulingStrategy.TIMER_DRIVEN.name());
        } else {
            configDto.setSchedulingStrategy(schedulingStrategyName.trim());
        }
        String executionNode = FlowFromDOMFactory.getString(element, "executionNode");
        if (executionNode == null || executionNode.trim().isEmpty()) {
            configDto.setExecutionNode(ExecutionNode.ALL.name());
        } else {
            configDto.setExecutionNode(executionNode.trim());
        }
        Long runDurationNanos = FlowFromDOMFactory.getOptionalLong(element, "runDurationNanos");
        if (runDurationNanos != null) {
            configDto.setRunDurationMillis(Long.valueOf(TimeUnit.NANOSECONDS.toMillis(runDurationNanos)));
        }
        configDto.setProperties(FlowFromDOMFactory.getProperties(element, encryptor, flowEncodingVersion));
        configDto.setAnnotationData(FlowFromDOMFactory.getString(element, "annotationData"));
        HashSet<String> autoTerminatedRelationships = new HashSet<String>();
        List<Element> autoTerminateList = FlowFromDOMFactory.getChildrenByTagName(element, "autoTerminatedRelationship");
        for (Element autoTerminateElement : autoTerminateList) {
            autoTerminatedRelationships.add(autoTerminateElement.getTextContent());
        }
        configDto.setAutoTerminatedRelationships(autoTerminatedRelationships);
        return dto;
    }

    private static LinkedHashMap<String, String> getProperties(Element element, StringEncryptor encryptor, FlowEncodingVersion flowEncodingVersion) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        List<Element> propertyNodeList = FlowFromDOMFactory.getChildrenByTagName(element, "property");
        ExpressionLanguageAwareParameterParser parameterParser = new ExpressionLanguageAwareParameterParser();
        for (Element propertyElement : propertyNodeList) {
            String value;
            String name = FlowFromDOMFactory.getString(propertyElement, "name");
            String rawPropertyValue = FlowFromDOMFactory.getString(propertyElement, "value");
            String string = value = encryptor == null ? rawPropertyValue : FlowFromDOMFactory.decrypt(rawPropertyValue, encryptor);
            if (flowEncodingVersion == null || flowEncodingVersion.getMajorVersion() <= 1 && flowEncodingVersion.getMinorVersion() < 4) {
                ParameterTokenList parameterTokenList = parameterParser.parseTokens(value);
                String escaped = parameterTokenList.escape();
                properties.put(name, escaped);
                continue;
            }
            properties.put(name, value);
        }
        return properties;
    }

    private static String getString(Element element, String childElementName) {
        List<Element> nodeList = FlowFromDOMFactory.getChildrenByTagName(element, childElementName);
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        Element childElement = nodeList.get(0);
        return childElement.getTextContent();
    }

    private static Integer getOptionalInt(Element element, String childElementName) {
        List<Element> nodeList = FlowFromDOMFactory.getChildrenByTagName(element, childElementName);
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        Element childElement = nodeList.get(0);
        String val = childElement.getTextContent();
        if (val == null) {
            return null;
        }
        return Integer.parseInt(val);
    }

    private static Long getOptionalLong(Element element, String childElementName) {
        List<Element> nodeList = FlowFromDOMFactory.getChildrenByTagName(element, childElementName);
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        Element childElement = nodeList.get(0);
        String val = childElement.getTextContent();
        if (val == null) {
            return null;
        }
        return Long.parseLong(val);
    }

    private static int getInt(Element element, String childElementName) {
        return Integer.parseInt(FlowFromDOMFactory.getString(element, childElementName));
    }

    private static long getLong(Element element, String childElementName) {
        return Long.parseLong(FlowFromDOMFactory.getString(element, childElementName));
    }

    private static boolean getBoolean(Element element, String childElementName) {
        return Boolean.parseBoolean(FlowFromDOMFactory.getString(element, childElementName));
    }

    private static ScheduledState getScheduledState(Element element) {
        return ScheduledState.valueOf((String)FlowFromDOMFactory.getString(element, "scheduledState"));
    }

    private static List<Element> getChildrenByTagName(Element element, String childElementName) {
        return DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
    }

    private static String decrypt(String value, StringEncryptor encryptor) {
        if (value != null && value.startsWith("enc{") && value.endsWith("}")) {
            try {
                return encryptor.decrypt(value.substring("enc{".length(), value.length() - "}".length()));
            }
            catch (EncryptionException e) {
                String moreDescriptiveMessage = "There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.xml.gz file";
                logger.error("There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.xml.gz file", (Throwable)e);
                throw new EncryptionException("There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.xml.gz file", (Throwable)e);
            }
        }
        return value;
    }
}

