/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.diagnostics.StandardDiagnosticsDump;
import org.apache.nifi.diagnostics.ThreadDumpTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.ClusterDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.ComponentCountTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.ContentRepositoryScanTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.DataValveDiagnosticsTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.DiagnosticAnalysisTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.FlowConfigurationDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.GarbageCollectionDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.JVMDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.LongRunningProcessorTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.MemoryPoolPeakUsageTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.NarsDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.NiFiPropertiesDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.OperatingSystemDiagnosticTask;
import org.apache.nifi.diagnostics.bootstrap.tasks.RepositoryDiagnosticTask;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapDiagnosticsFactory
implements DiagnosticsFactory {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapDiagnosticsFactory.class);
    private FlowController flowController;
    private NiFiProperties nifiProperties;

    public DiagnosticsDump create(boolean verbose) {
        ArrayList<DiagnosticsDumpElement> dumpElements = new ArrayList<DiagnosticsDumpElement>();
        for (DiagnosticTask dumpTask : this.getDiagnosticTasks()) {
            try {
                DiagnosticsDumpElement dumpElement = dumpTask.captureDump(verbose);
                if (dumpElement == null) continue;
                dumpElements.add(dumpElement);
            }
            catch (Exception e) {
                logger.error("Failed to obtain diagnostics information from " + dumpTask.getClass(), (Throwable)e);
            }
        }
        return new StandardDiagnosticsDump(dumpElements, System.currentTimeMillis());
    }

    public List<DiagnosticTask> getDiagnosticTasks() {
        ArrayList<DiagnosticTask> tasks = new ArrayList<DiagnosticTask>();
        tasks.add(new DiagnosticAnalysisTask(this.flowController));
        tasks.add(new JVMDiagnosticTask());
        tasks.add(new OperatingSystemDiagnosticTask());
        tasks.add(new NarsDiagnosticTask(this.flowController.getExtensionManager()));
        tasks.add(new FlowConfigurationDiagnosticTask(this.flowController));
        tasks.add(new LongRunningProcessorTask(this.flowController));
        tasks.add(new ClusterDiagnosticTask(this.flowController));
        tasks.add(new GarbageCollectionDiagnosticTask(this.flowController));
        tasks.add(new MemoryPoolPeakUsageTask());
        tasks.add(new RepositoryDiagnosticTask(this.flowController));
        tasks.add(new ComponentCountTask(this.flowController));
        tasks.add(new NiFiPropertiesDiagnosticTask(this.nifiProperties));
        tasks.add(new ContentRepositoryScanTask(this.flowController));
        tasks.add(new DataValveDiagnosticsTask(this.flowController.getFlowManager()));
        tasks.add((DiagnosticTask)new ThreadDumpTask());
        return tasks;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setNifiProperties(NiFiProperties nifiProperties) {
        this.nifiProperties = nifiProperties;
    }
}

