/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.client;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.nifi.controller.queue.clustered.client.LoadBalanceFlowFileCodec;
import org.apache.nifi.controller.repository.FlowFileRecord;

public class StandardLoadBalanceFlowFileCodec
implements LoadBalanceFlowFileCodec {
    @Override
    public void encode(FlowFileRecord flowFile, OutputStream destination) throws IOException {
        DataOutputStream out = new DataOutputStream(destination);
        out.writeInt(flowFile.getAttributes().size());
        for (Map.Entry entry : flowFile.getAttributes().entrySet()) {
            this.writeString((String)entry.getKey(), out);
            this.writeString((String)entry.getValue(), out);
        }
        out.writeLong(flowFile.getLineageStartDate());
        out.writeLong(flowFile.getEntryDate());
    }

    private void writeString(String value, DataOutputStream out) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
    }
}

