/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.partition;

import com.google.common.hash.Hashing;
import java.util.ArrayList;
import org.apache.nifi.controller.queue.clustered.partition.FlowFilePartitioner;
import org.apache.nifi.controller.queue.clustered.partition.QueuePartition;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationAttributePartitioner
implements FlowFilePartitioner {
    private static final Logger logger = LoggerFactory.getLogger(CorrelationAttributePartitioner.class);
    private final String partitioningAttribute;

    public CorrelationAttributePartitioner(String partitioningAttribute) {
        this.partitioningAttribute = partitioningAttribute;
    }

    @Override
    public QueuePartition getPartition(FlowFileRecord flowFile, QueuePartition[] partitions, QueuePartition localPartition) {
        int hash = this.hash(flowFile);
        int index = partitions.length < 3 ? Math.floorMod(hash, partitions.length) : Hashing.consistentHash((long)hash, (int)partitions.length);
        if (logger.isDebugEnabled()) {
            ArrayList<String> partitionDescriptions = new ArrayList<String>(partitions.length);
            for (QueuePartition partition : partitions) {
                partitionDescriptions.add(partition.getSwapPartitionName());
            }
            logger.debug("Assigning Partition {} to {} based on {}", new Object[]{index, flowFile.getAttribute(CoreAttributes.UUID.key()), partitionDescriptions});
        }
        return partitions[index];
    }

    protected int hash(FlowFileRecord flowFile) {
        String partitionAttributeValue = flowFile.getAttribute(this.partitioningAttribute);
        return partitionAttributeValue == null ? 0 : partitionAttributeValue.hashCode();
    }

    @Override
    public boolean isRebalanceOnClusterResize() {
        return true;
    }

    @Override
    public boolean isRebalanceOnFailure() {
        return false;
    }
}

