/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flow;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ExtensionBuilder;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.StandardFlowSnippet;
import org.apache.nifi.controller.StandardFunnel;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flow.AbstractFlowManager;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.label.StandardLabel;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.StandardProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ControllerServiceLogObserver;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.ProcessorLogObserver;
import org.apache.nifi.logging.ReportingTaskLogObserver;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.variable.MutableVariableRegistry;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.StandardPublicPort;
import org.apache.nifi.remote.StandardRemoteProcessGroup;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFlowManager
extends AbstractFlowManager
implements FlowManager {
    static final String MAX_CONCURRENT_TASKS_PROP_NAME = "_nifi.funnel.max.concurrent.tasks";
    static final String MAX_TRANSFERRED_FLOWFILES_PROP_NAME = "_nifi.funnel.max.transferred.flowfiles";
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowManager.class);
    private final NiFiProperties nifiProperties;
    private final BulletinRepository bulletinRepository;
    private final StandardProcessScheduler processScheduler;
    private final Authorizer authorizer;
    private final SSLContext sslContext;
    private final FlowController flowController;
    private final ConcurrentMap<String, ControllerServiceNode> rootControllerServices = new ConcurrentHashMap<String, ControllerServiceNode>();
    private final boolean isSiteToSiteSecure;

    public StandardFlowManager(NiFiProperties nifiProperties, SSLContext sslContext, FlowController flowController, FlowFileEventRepository flowFileEventRepository, ParameterContextManager parameterContextManager) {
        super(flowFileEventRepository, parameterContextManager, flowController.getFlowRegistryClient(), flowController::isInitialized);
        this.nifiProperties = nifiProperties;
        this.flowController = flowController;
        this.bulletinRepository = flowController.getBulletinRepository();
        this.processScheduler = flowController.getProcessScheduler();
        this.authorizer = flowController.getAuthorizer();
        this.sslContext = sslContext;
        this.isSiteToSiteSecure = Boolean.TRUE.equals(nifiProperties.isSiteToSiteSecure());
    }

    public Port createPublicInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardPublicPort(id, name, TransferDirection.RECEIVE, ConnectableType.INPUT_PORT, this.authorizer, this.bulletinRepository, (ProcessScheduler)this.processScheduler, this.isSiteToSiteSecure, this.nifiProperties.getBoredYieldDuration(), IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.nifiProperties));
    }

    public Port createPublicOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardPublicPort(id, name, TransferDirection.SEND, ConnectableType.OUTPUT_PORT, this.authorizer, this.bulletinRepository, (ProcessScheduler)this.processScheduler, this.isSiteToSiteSecure, this.nifiProperties.getBoredYieldDuration(), IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.nifiProperties));
    }

    public Set<Port> getPublicInputPorts() {
        return this.getPublicPorts(ProcessGroup::getInputPorts);
    }

    public Set<Port> getPublicOutputPorts() {
        return this.getPublicPorts(ProcessGroup::getOutputPorts);
    }

    private Set<Port> getPublicPorts(Function<ProcessGroup, Set<Port>> getPorts) {
        HashSet<Port> publicPorts = new HashSet<Port>();
        ProcessGroup rootGroup = this.getRootGroup();
        this.getPublicPorts(publicPorts, rootGroup, getPorts);
        return publicPorts;
    }

    private void getPublicPorts(Set<Port> publicPorts, ProcessGroup group, Function<ProcessGroup, Set<Port>> getPorts) {
        for (Port port : getPorts.apply(group)) {
            if (!(port instanceof PublicPort)) continue;
            publicPorts.add(port);
        }
        group.getProcessGroups().forEach(childGroup -> this.getPublicPorts(publicPorts, (ProcessGroup)childGroup, getPorts));
    }

    public Optional<Port> getPublicInputPort(String name) {
        return this.findPort(name, this.getPublicInputPorts());
    }

    public Optional<Port> getPublicOutputPort(String name) {
        return this.findPort(name, this.getPublicOutputPorts());
    }

    private Optional<Port> findPort(String portName, Set<Port> ports) {
        if (ports != null) {
            for (Port port : ports) {
                if (!portName.equals(port.getName())) continue;
                return Optional.of(port);
            }
        }
        return Optional.empty();
    }

    public RemoteProcessGroup createRemoteProcessGroup(String id, String uris) {
        String expirationPeriod = this.nifiProperties.getProperty("nifi.remote.contents.cache.expiration", "30 secs");
        long remoteContentsCacheExpirationMillis = FormatUtils.getTimeDuration((String)expirationPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
        return new StandardRemoteProcessGroup(Objects.requireNonNull(id), uris, null, (ProcessScheduler)this.processScheduler, this.bulletinRepository, this.sslContext, this.flowController.getStateManagerProvider().getStateManager(id), remoteContentsCacheExpirationMillis);
    }

    private void verifyPortIdDoesNotExist(String id) {
        ProcessGroup rootGroup = this.getRootGroup();
        Port port = rootGroup.findOutputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Output Port already exists with ID " + id);
        }
        port = rootGroup.findInputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
    }

    public Label createLabel(String id, String text) {
        return new StandardLabel(Objects.requireNonNull(id).intern(), text);
    }

    public Funnel createFunnel(String id) {
        int maxConcurrentTasks = Integer.parseInt(this.nifiProperties.getProperty(MAX_CONCURRENT_TASKS_PROP_NAME, "1"));
        int maxBatchSize = Integer.parseInt(this.nifiProperties.getProperty(MAX_TRANSFERRED_FLOWFILES_PROP_NAME, "10000"));
        return new StandardFunnel(id.intern(), maxConcurrentTasks, maxBatchSize);
    }

    public Port createLocalInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        int maxConcurrentTasks = Integer.parseInt(this.nifiProperties.getProperty(MAX_CONCURRENT_TASKS_PROP_NAME, "1"));
        int maxTransferredFlowFiles = Integer.parseInt(this.nifiProperties.getProperty(MAX_TRANSFERRED_FLOWFILES_PROP_NAME, "10000"));
        String boredYieldDuration = this.nifiProperties.getBoredYieldDuration();
        return new LocalPort(id, name, ConnectableType.INPUT_PORT, (ProcessScheduler)this.processScheduler, maxConcurrentTasks, maxTransferredFlowFiles, boredYieldDuration);
    }

    public Port createLocalOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        int maxConcurrentTasks = Integer.parseInt(this.nifiProperties.getProperty(MAX_CONCURRENT_TASKS_PROP_NAME, "1"));
        int maxTransferredFlowFiles = Integer.parseInt(this.nifiProperties.getProperty(MAX_TRANSFERRED_FLOWFILES_PROP_NAME, "10000"));
        String boredYieldDuration = this.nifiProperties.getBoredYieldDuration();
        return new LocalPort(id, name, ConnectableType.OUTPUT_PORT, (ProcessScheduler)this.processScheduler, maxConcurrentTasks, maxTransferredFlowFiles, boredYieldDuration);
    }

    public ProcessGroup createProcessGroup(String id) {
        MutableVariableRegistry mutableVariableRegistry = new MutableVariableRegistry(this.flowController.getVariableRegistry());
        StandardProcessGroup group = new StandardProcessGroup(Objects.requireNonNull(id), this.flowController.getControllerServiceProvider(), (ProcessScheduler)this.processScheduler, this.flowController.getEncryptor(), this.flowController.getExtensionManager(), this.flowController.getStateManagerProvider(), (FlowManager)this, this.flowController.getFlowRegistryClient(), this.flowController.getReloadComponent(), mutableVariableRegistry, (NodeTypeProvider)this.flowController, this.nifiProperties);
        this.onProcessGroupAdded((ProcessGroup)group);
        return group;
    }

    public void instantiateSnippet(ProcessGroup group, FlowSnippetDTO dto) throws ProcessorInstantiationException {
        Objects.requireNonNull(group);
        Objects.requireNonNull(dto);
        StandardFlowSnippet snippet = new StandardFlowSnippet(dto, this.flowController.getExtensionManager());
        snippet.validate(group);
        snippet.instantiate(this, this.flowController, group);
        group.findAllRemoteProcessGroups().forEach(RemoteProcessGroup::initialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFilePrioritizer createPrioritizer(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FlowFilePrioritizer prioritizer;
            List prioritizerBundles = this.flowController.getExtensionManager().getBundles(type);
            if (prioritizerBundles.size() == 0) {
                throw new IllegalStateException(String.format("The specified class '%s' is not known to this nifi.", type));
            }
            if (prioritizerBundles.size() > 1) {
                throw new IllegalStateException(String.format("Multiple bundles found for the specified class '%s', only one is allowed.", type));
            }
            Bundle bundle = (Bundle)prioritizerBundles.get(0);
            ClassLoader detectedClassLoaderForType = bundle.getClassLoader();
            Class<?> rawClass = Class.forName(type, true, detectedClassLoaderForType);
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<FlowFilePrioritizer> prioritizerClass = rawClass.asSubclass(FlowFilePrioritizer.class);
            FlowFilePrioritizer processorObj = prioritizerClass.newInstance();
            FlowFilePrioritizer flowFilePrioritizer = prioritizer = prioritizerClass.cast(processorObj);
            return flowFilePrioritizer;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver) {
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ProcessorNode procNode = new ExtensionBuilder().identifier(id).type(type).bundleCoordinate(coordinate).controllerServiceProvider(this.flowController.getControllerServiceProvider()).processScheduler(this.processScheduler).nodeTypeProvider(this.flowController).validationTrigger(this.flowController.getValidationTrigger()).reloadComponent(this.flowController.getReloadComponent()).variableRegistry(this.flowController.getVariableRegistry()).addClasspathUrls(additionalUrls).kerberosConfig(this.flowController.createKerberosConfig(this.nifiProperties)).extensionManager(extensionManager).buildProcessor();
        LogRepositoryFactory.getRepository((String)procNode.getIdentifier()).setLogger((ComponentLog)procNode.getLogger());
        if (registerLogObserver) {
            logRepository.addObserver("bulletin-observer", procNode.getBulletinLevel(), (LogObserver)new ProcessorLogObserver(this.bulletinRepository, procNode));
        }
        if (firstTimeAdded) {
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, procNode.getProcessor().getClass(), (String)procNode.getProcessor().getIdentifier());){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)procNode.getProcessor(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                if (registerLogObserver) {
                    logRepository.removeObserver("bulletin-observer");
                }
                throw new ComponentLifeCycleException("Failed to invoke @OnAdded methods of " + procNode.getProcessor(), (Throwable)e);
            }
        }
        return procNode;
    }

    public Connection createConnection(String id, String name, Connectable source, Connectable destination, Collection<String> relationshipNames) {
        return this.flowController.createConnection(id, name, source, destination, relationshipNames);
    }

    public ReportingTaskNode createReportingTask(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean register) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(id);
        Objects.requireNonNull(bundleCoordinate);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ReportingTaskNode taskNode = new ExtensionBuilder().identifier(id).type(type).bundleCoordinate(bundleCoordinate).controllerServiceProvider(this.flowController.getControllerServiceProvider()).processScheduler(this.processScheduler).nodeTypeProvider(this.flowController).validationTrigger(this.flowController.getValidationTrigger()).reloadComponent(this.flowController.getReloadComponent()).variableRegistry(this.flowController.getVariableRegistry()).addClasspathUrls(additionalUrls).kerberosConfig(this.flowController.createKerberosConfig(this.nifiProperties)).flowController(this.flowController).extensionManager(extensionManager).buildReportingTask();
        LogRepositoryFactory.getRepository((String)taskNode.getIdentifier()).setLogger((ComponentLog)taskNode.getLogger());
        if (firstTimeAdded) {
            Class<?> taskClass = taskNode.getReportingTask().getClass();
            String identifier = taskNode.getReportingTask().getIdentifier();
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), taskClass, (String)identifier);){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)taskNode.getReportingTask(), (Object[])new Object[0]);
                if (this.flowController.isInitialized()) {
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)taskNode.getReportingTask(), (Object[])new Object[]{taskNode.getConfigurationContext()});
                }
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + taskNode.getReportingTask(), (Throwable)e);
            }
        }
        if (register) {
            this.onReportingTaskAdded(taskNode);
            logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ReportingTaskLogObserver(this.bulletinRepository, taskNode));
        }
        return taskNode;
    }

    public Set<ControllerServiceNode> getRootControllerServices() {
        return new HashSet<ControllerServiceNode>(this.rootControllerServices.values());
    }

    public void addRootControllerService(ControllerServiceNode serviceNode) {
        ControllerServiceNode existing = this.rootControllerServices.putIfAbsent(serviceNode.getIdentifier(), serviceNode);
        if (existing != null) {
            throw new IllegalStateException("Controller Service with ID " + serviceNode.getIdentifier() + " already exists at the Controller level");
        }
    }

    public ControllerServiceNode getRootControllerService(String serviceIdentifier) {
        return (ControllerServiceNode)this.rootControllerServices.get(serviceIdentifier);
    }

    public void removeRootControllerService(ControllerServiceNode service) {
        ControllerServiceNode existing = (ControllerServiceNode)this.rootControllerServices.get(Objects.requireNonNull(service).getIdentifier());
        if (existing == null) {
            throw new IllegalStateException(service + " is not a member of this Process Group");
        }
        service.verifyCanDelete();
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        VariableRegistry variableRegistry = this.flowController.getVariableRegistry();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, service.getControllerServiceImplementation().getClass(), (String)service.getIdentifier());){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)service, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), null, variableRegistry);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)service.getControllerServiceImplementation(), (Object[])new Object[]{configurationContext});
        }
        for (Map.Entry entry : service.getEffectivePropertyValues().entrySet()) {
            ControllerServiceNode referencedNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (referencedNode = this.getRootControllerService(value)) == null) continue;
            referencedNode.removeReference((ComponentNode)service, descriptor);
        }
        this.rootControllerServices.remove(service.getIdentifier());
        this.flowController.getStateManagerProvider().onComponentRemoved(service.getIdentifier());
        extensionManager.removeInstanceClassLoader(service.getIdentifier());
        logger.info("{} removed from Flow Controller", (Object)service);
    }

    public ControllerServiceNode createControllerService(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver) {
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ControllerServiceProvider controllerServiceProvider = this.flowController.getControllerServiceProvider();
        ControllerServiceNode serviceNode = new ExtensionBuilder().identifier(id).type(type).bundleCoordinate(bundleCoordinate).controllerServiceProvider(this.flowController.getControllerServiceProvider()).processScheduler(this.processScheduler).nodeTypeProvider(this.flowController).validationTrigger(this.flowController.getValidationTrigger()).reloadComponent(this.flowController.getReloadComponent()).variableRegistry(this.flowController.getVariableRegistry()).addClasspathUrls(additionalUrls).kerberosConfig(this.flowController.createKerberosConfig(this.nifiProperties)).stateManagerProvider(this.flowController.getStateManagerProvider()).extensionManager(extensionManager).buildControllerService();
        LogRepositoryFactory.getRepository((String)serviceNode.getIdentifier()).setLogger((ComponentLog)serviceNode.getLogger());
        if (registerLogObserver) {
            logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ControllerServiceLogObserver(this.bulletinRepository, serviceNode));
        }
        if (firstTimeAdded) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            if (this.flowController.isInitialized()) {
                try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, service.getClass(), (String)service.getIdentifier());){
                    StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)serviceNode, (ControllerServiceLookup)controllerServiceProvider, null, this.flowController.getVariableRegistry());
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, (Object[])new Object[]{configurationContext});
                }
            }
            ControllerService serviceImpl = serviceNode.getControllerServiceImplementation();
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, serviceImpl.getClass(), (String)serviceImpl.getIdentifier());){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)serviceImpl, (Object[])new Object[0]);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + serviceImpl, (Throwable)e);
            }
        }
        controllerServiceProvider.onControllerServiceAdded(serviceNode);
        return serviceNode;
    }

    protected ExtensionManager getExtensionManager() {
        return this.flowController.getExtensionManager();
    }

    protected ProcessScheduler getProcessScheduler() {
        return this.flowController.getProcessScheduler();
    }

    protected Authorizable getParameterContextParent() {
        return this.flowController;
    }
}

