/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.partition;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.DropFlowFileAction;
import org.apache.nifi.controller.queue.DropFlowFileRequest;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueueContents;
import org.apache.nifi.controller.queue.LocalQueuePartitionDiagnostics;
import org.apache.nifi.controller.queue.PollStrategy;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.SwappablePriorityQueue;
import org.apache.nifi.controller.queue.clustered.partition.FlowFilePartitioner;
import org.apache.nifi.controller.queue.clustered.partition.LocalQueuePartition;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.processor.FlowFileFilter;

public class SwappablePriorityQueueLocalPartition
implements LocalQueuePartition {
    private static final String SWAP_PARTITION_NAME = "local";
    private final SwappablePriorityQueue priorityQueue;
    private final FlowFileQueue flowFileQueue;
    private final String description;

    public SwappablePriorityQueueLocalPartition(FlowFileSwapManager swapManager, int swapThreshold, EventReporter eventReporter, FlowFileQueue flowFileQueue, DropFlowFileAction dropAction) {
        this.priorityQueue = new SwappablePriorityQueue(swapManager, swapThreshold, eventReporter, flowFileQueue, dropAction, SWAP_PARTITION_NAME);
        this.flowFileQueue = flowFileQueue;
        this.description = "SwappablePriorityQueueLocalPartition[queueId=" + flowFileQueue.getIdentifier() + "]";
    }

    @Override
    public String getSwapPartitionName() {
        return SWAP_PARTITION_NAME;
    }

    @Override
    public QueueSize size() {
        return this.priorityQueue.size();
    }

    @Override
    public long getTotalActiveQueuedDuration(long fromTimestamp) {
        return this.priorityQueue.getTotalQueuedDuration(fromTimestamp);
    }

    @Override
    public long getMinLastQueueDate() {
        return this.priorityQueue.getMinLastQueueDate();
    }

    @Override
    public boolean isUnacknowledgedFlowFile() {
        return this.priorityQueue.isUnacknowledgedFlowFile();
    }

    @Override
    public Optional<NodeIdentifier> getNodeIdentifier() {
        return Optional.empty();
    }

    @Override
    public void put(FlowFileRecord flowFile) {
        this.priorityQueue.put(flowFile);
    }

    @Override
    public void putAll(Collection<FlowFileRecord> flowFiles) {
        this.priorityQueue.putAll(flowFiles);
    }

    @Override
    public boolean isActiveQueueEmpty() {
        return this.priorityQueue.isActiveQueueEmpty();
    }

    @Override
    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        return this.priorityQueue.poll(expiredRecords, this.getExpiration(), pollStrategy);
    }

    @Override
    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords) {
        return this.poll(expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    @Override
    public List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        return this.priorityQueue.poll(maxResults, expiredRecords, (long)this.getExpiration(), pollStrategy);
    }

    @Override
    public List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords) {
        return this.poll(maxResults, expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    @Override
    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        return this.priorityQueue.poll(filter, expiredRecords, (long)this.getExpiration(), pollStrategy);
    }

    @Override
    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords) {
        return this.poll(filter, expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    private int getExpiration() {
        return this.flowFileQueue.getFlowFileExpiration(TimeUnit.MILLISECONDS);
    }

    @Override
    public FlowFileRecord getFlowFile(String flowFileUuid) throws IOException {
        return this.priorityQueue.getFlowFile(flowFileUuid);
    }

    @Override
    public List<FlowFileRecord> getListableFlowFiles() {
        return this.priorityQueue.getActiveFlowFiles();
    }

    @Override
    public void dropFlowFiles(DropFlowFileRequest dropRequest, String requestor) {
        this.priorityQueue.dropFlowFiles(dropRequest, requestor);
    }

    @Override
    public SwapSummary recoverSwappedFlowFiles() {
        return this.priorityQueue.recoverSwappedFlowFiles();
    }

    @Override
    public void setPriorities(List<FlowFilePrioritizer> newPriorities) {
        this.priorityQueue.setPriorities(newPriorities);
    }

    @Override
    public void acknowledge(FlowFileRecord flowFile) {
        this.priorityQueue.acknowledge(flowFile);
    }

    @Override
    public void acknowledge(Collection<FlowFileRecord> flowFiles) {
        this.priorityQueue.acknowledge(flowFiles);
    }

    @Override
    public LocalQueuePartitionDiagnostics getQueueDiagnostics() {
        return this.priorityQueue.getQueueDiagnostics();
    }

    @Override
    public FlowFileQueueContents packageForRebalance(String newPartitionName) {
        return this.priorityQueue.packageForRebalance(newPartitionName);
    }

    @Override
    public void start(FlowFilePartitioner partitionerUsed) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void inheritQueueContents(FlowFileQueueContents queueContents) {
        this.priorityQueue.inheritQueueContents(queueContents);
    }

    public String toString() {
        return this.description;
    }
}

