/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSerializer;
import org.apache.nifi.controller.serialization.ScheduledStateLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.persistence.TemplateSerializer;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardFlowSerializer
implements FlowSerializer<Document> {
    private static final String MAX_ENCODING_VERSION = "1.4";
    private final PropertyEncryptor encryptor;

    public StandardFlowSerializer(PropertyEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public Document transform(FlowController controller, ScheduledStateLookup scheduledStateLookup) throws FlowSerializationException {
        try {
            DocumentBuilder docBuilder = XmlUtils.createSafeDocumentBuilder((boolean)true);
            Document doc = docBuilder.newDocument();
            Element rootNode = doc.createElement("flowController");
            rootNode.setAttribute("encoding-version", MAX_ENCODING_VERSION);
            doc.appendChild(rootNode);
            StandardFlowSerializer.addTextElement(rootNode, "maxTimerDrivenThreadCount", controller.getMaxTimerDrivenThreadCount());
            StandardFlowSerializer.addTextElement(rootNode, "maxEventDrivenThreadCount", controller.getMaxEventDrivenThreadCount());
            Element registriesElement = doc.createElement("registries");
            rootNode.appendChild(registriesElement);
            this.addFlowRegistries(registriesElement, controller.getFlowRegistryClient());
            Element parameterContextsElement = doc.createElement("parameterContexts");
            rootNode.appendChild(parameterContextsElement);
            this.addParameterContexts(parameterContextsElement, controller.getFlowManager().getParameterContextManager());
            this.addProcessGroup(rootNode, controller.getFlowManager().getRootGroup(), "rootGroup", scheduledStateLookup);
            Element controllerServicesNode = doc.createElement("controllerServices");
            rootNode.appendChild(controllerServicesNode);
            for (ControllerServiceNode serviceNode : controller.getFlowManager().getRootControllerServices()) {
                this.addControllerService(controllerServicesNode, serviceNode);
            }
            Element reportingTasksNode = doc.createElement("reportingTasks");
            rootNode.appendChild(reportingTasksNode);
            for (ReportingTaskNode taskNode : controller.getAllReportingTasks()) {
                StandardFlowSerializer.addReportingTask(reportingTasksNode, taskNode, this.encryptor);
            }
            return doc;
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerFactoryConfigurationError | DOMException e) {
            throw new FlowSerializationException(e);
        }
    }

    @Override
    public void serialize(Document flowConfiguration, OutputStream os) throws FlowSerializationException {
        try {
            DOMSource domSource = new DOMSource(flowConfiguration);
            StreamResult streamResult = new StreamResult(new BufferedOutputStream(os));
            TransformerFactory transformFactory = TransformerFactory.newInstance();
            Transformer transformer = transformFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, streamResult);
        }
        catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError | DOMException e) {
            throw new FlowSerializationException(e);
        }
    }

    private void addParameterContexts(Element parentElement, ParameterContextManager parameterContextManager) {
        for (ParameterContext parameterContext : parameterContextManager.getParameterContexts()) {
            Element parameterContextElement = parentElement.getOwnerDocument().createElement("parameterContext");
            parentElement.appendChild(parameterContextElement);
            this.addStringElement(parameterContextElement, "id", parameterContext.getIdentifier());
            this.addStringElement(parameterContextElement, "name", parameterContext.getName());
            this.addStringElement(parameterContextElement, "description", parameterContext.getDescription());
            for (ParameterContext childContext : parameterContext.getInheritedParameterContexts()) {
                this.addStringElement(parameterContextElement, "inheritedParameterContextId", childContext.getIdentifier());
            }
            for (Parameter parameter : parameterContext.getParameters().values()) {
                this.addParameter(parameterContextElement, parameter);
            }
        }
    }

    private void addParameter(Element parentElement, Parameter parameter) {
        Element parameterElement = parentElement.getOwnerDocument().createElement("parameter");
        parentElement.appendChild(parameterElement);
        ParameterDescriptor descriptor = parameter.getDescriptor();
        this.addStringElement(parameterElement, "name", descriptor.getName());
        this.addStringElement(parameterElement, "description", descriptor.getDescription());
        this.addStringElement(parameterElement, "sensitive", String.valueOf(descriptor.isSensitive()));
        if (parameter.getValue() != null) {
            if (descriptor.isSensitive()) {
                String parameterValue = parameter.getValue();
                this.addStringElement(parameterElement, "value", parameterValue == null ? null : "enc{" + this.encryptor.encrypt(parameterValue) + "}");
            } else {
                this.addStringElement(parameterElement, "value", parameter.getValue());
            }
        }
    }

    private void addFlowRegistries(Element parentElement, FlowRegistryClient registryClient) {
        for (String registryId : registryClient.getRegistryIdentifiers()) {
            FlowRegistry flowRegistry = registryClient.getFlowRegistry(registryId);
            Element registryElement = parentElement.getOwnerDocument().createElement("flowRegistry");
            parentElement.appendChild(registryElement);
            this.addStringElement(registryElement, "id", flowRegistry.getIdentifier());
            this.addStringElement(registryElement, "name", flowRegistry.getName());
            this.addStringElement(registryElement, "url", flowRegistry.getURL());
            this.addStringElement(registryElement, "description", flowRegistry.getDescription());
        }
    }

    private void addStringElement(Element parentElement, String elementName, String value) {
        Element childElement = parentElement.getOwnerDocument().createElement(elementName);
        childElement.setTextContent(CharacterFilterUtils.filterInvalidXmlCharacters((String)value));
        parentElement.appendChild(childElement);
    }

    private void addSize(Element parentElement, Size size) {
        Element element = parentElement.getOwnerDocument().createElement("size");
        element.setAttribute("width", String.valueOf(size.getWidth()));
        element.setAttribute("height", String.valueOf(size.getHeight()));
        parentElement.appendChild(element);
    }

    private void addPosition(Element parentElement, Position position) {
        this.addPosition(parentElement, position, "position");
    }

    private void addPosition(Element parentElement, Position position, String elementName) {
        Element element = parentElement.getOwnerDocument().createElement(elementName);
        element.setAttribute("x", String.valueOf(position.getX()));
        element.setAttribute("y", String.valueOf(position.getY()));
        parentElement.appendChild(element);
    }

    private void addProcessGroup(Element parentElement, ProcessGroup group, String elementName, ScheduledStateLookup scheduledStateLookup) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", group.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", group.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", group.getName());
        this.addPosition(element, group.getPosition());
        StandardFlowSerializer.addTextElement(element, "comment", group.getComments());
        StandardFlowSerializer.addTextElement(element, "flowfileConcurrency", group.getFlowFileConcurrency().name());
        StandardFlowSerializer.addTextElement(element, "flowfileOutboundPolicy", group.getFlowFileOutboundPolicy().name());
        StandardFlowSerializer.addTextElement(element, "defaultFlowFileExpiration", group.getDefaultFlowFileExpiration());
        StandardFlowSerializer.addTextElement(element, "defaultBackPressureObjectThreshold", group.getDefaultBackPressureObjectThreshold());
        StandardFlowSerializer.addTextElement(element, "defaultBackPressureDataSizeThreshold", group.getDefaultBackPressureDataSizeThreshold());
        VersionControlInformation versionControlInfo = group.getVersionControlInformation();
        if (versionControlInfo != null) {
            Iterator versionControlInfoElement = doc.createElement("versionControlInformation");
            StandardFlowSerializer.addTextElement((Element)((Object)versionControlInfoElement), "registryId", versionControlInfo.getRegistryIdentifier());
            StandardFlowSerializer.addTextElement(versionControlInfoElement, "bucketId", versionControlInfo.getBucketIdentifier());
            StandardFlowSerializer.addTextElement(versionControlInfoElement, "bucketName", versionControlInfo.getBucketName());
            StandardFlowSerializer.addTextElement(versionControlInfoElement, "flowId", versionControlInfo.getFlowIdentifier());
            StandardFlowSerializer.addTextElement(versionControlInfoElement, "flowName", versionControlInfo.getFlowName());
            StandardFlowSerializer.addTextElement(versionControlInfoElement, "flowDescription", versionControlInfo.getFlowDescription());
            StandardFlowSerializer.addTextElement(versionControlInfoElement, "version", versionControlInfo.getVersion());
            element.appendChild((Node)((Object)versionControlInfoElement));
        }
        for (ProcessorNode processor : group.getProcessors()) {
            this.addProcessor(element, processor, scheduledStateLookup);
        }
        for (Port port : group.getInputPorts()) {
            if (port instanceof PublicPort) {
                this.addPublicPort(element, (PublicPort)port, "inputPort", scheduledStateLookup);
                continue;
            }
            this.addPort(element, port, "inputPort", scheduledStateLookup);
        }
        for (Port port : group.getOutputPorts()) {
            if (port instanceof PublicPort) {
                this.addPublicPort(element, (PublicPort)port, "outputPort", scheduledStateLookup);
                continue;
            }
            this.addPort(element, port, "outputPort", scheduledStateLookup);
        }
        for (Label label : group.getLabels()) {
            this.addLabel(element, label);
        }
        for (Funnel funnel : group.getFunnels()) {
            this.addFunnel(element, funnel);
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            this.addProcessGroup(element, childGroup, "processGroup", scheduledStateLookup);
        }
        for (RemoteProcessGroup remoteRef : group.getRemoteProcessGroups()) {
            this.addRemoteProcessGroup(element, remoteRef, scheduledStateLookup);
        }
        for (Connection connection : group.getConnections()) {
            this.addConnection(element, connection);
        }
        for (ControllerServiceNode service : group.getControllerServices(false)) {
            this.addControllerService(element, service);
        }
        for (Object template : group.getTemplates()) {
            StandardFlowSerializer.addTemplate(element, (Template)template);
        }
        ComponentVariableRegistry variableRegistry = group.getVariableRegistry();
        for (Map.Entry entry : variableRegistry.getVariableMap().entrySet()) {
            StandardFlowSerializer.addVariable(element, ((VariableDescriptor)entry.getKey()).getName(), (String)entry.getValue());
        }
        ParameterContext parameterContext = group.getParameterContext();
        if (parameterContext != null) {
            StandardFlowSerializer.addTextElement(element, "parameterContextId", parameterContext.getIdentifier());
        }
    }

    private static void addVariable(Element parentElement, String variableName, String variableValue) {
        Element variableElement = parentElement.getOwnerDocument().createElement("variable");
        variableElement.setAttribute("name", CharacterFilterUtils.filterInvalidXmlCharacters((String)variableName));
        variableElement.setAttribute("value", CharacterFilterUtils.filterInvalidXmlCharacters((String)variableValue));
        parentElement.appendChild(variableElement);
    }

    private static void addBundle(Element parentElement, BundleCoordinate coordinate) {
        Element groupElement = parentElement.getOwnerDocument().createElement("group");
        groupElement.setTextContent(CharacterFilterUtils.filterInvalidXmlCharacters((String)coordinate.getGroup()));
        Element artifactElement = parentElement.getOwnerDocument().createElement("artifact");
        artifactElement.setTextContent(CharacterFilterUtils.filterInvalidXmlCharacters((String)coordinate.getId()));
        Element versionElement = parentElement.getOwnerDocument().createElement("version");
        versionElement.setTextContent(CharacterFilterUtils.filterInvalidXmlCharacters((String)coordinate.getVersion()));
        Element bundleElement = parentElement.getOwnerDocument().createElement("bundle");
        bundleElement.appendChild(groupElement);
        bundleElement.appendChild(artifactElement);
        bundleElement.appendChild(versionElement);
        parentElement.appendChild(bundleElement);
    }

    private void addStyle(Element parentElement, Map<String, String> style) {
        Element element = parentElement.getOwnerDocument().createElement("styles");
        for (Map.Entry<String, String> entry : style.entrySet()) {
            Element styleElement = parentElement.getOwnerDocument().createElement("style");
            styleElement.setAttribute("name", entry.getKey());
            styleElement.setTextContent(entry.getValue());
            element.appendChild(styleElement);
        }
        parentElement.appendChild(element);
    }

    private void addLabel(Element parentElement, Label label) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("label");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", label.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", label.getVersionedComponentId());
        this.addPosition(element, label.getPosition());
        this.addSize(element, label.getSize());
        this.addStyle(element, label.getStyle());
        StandardFlowSerializer.addTextElement(element, "value", label.getValue());
        parentElement.appendChild(element);
    }

    private void addFunnel(Element parentElement, Funnel funnel) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("funnel");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", funnel.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", funnel.getVersionedComponentId());
        this.addPosition(element, funnel.getPosition());
    }

    private void addRemoteProcessGroup(Element parentElement, RemoteProcessGroup remoteRef, ScheduledStateLookup scheduledStateLookup) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("remoteProcessGroup");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", remoteRef.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", remoteRef.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", remoteRef.getName());
        this.addPosition(element, remoteRef.getPosition());
        StandardFlowSerializer.addTextElement(element, "comment", remoteRef.getComments());
        StandardFlowSerializer.addTextElement(element, "url", remoteRef.getTargetUri());
        StandardFlowSerializer.addTextElement(element, "urls", remoteRef.getTargetUris());
        StandardFlowSerializer.addTextElement(element, "timeout", remoteRef.getCommunicationsTimeout());
        StandardFlowSerializer.addTextElement(element, "yieldPeriod", remoteRef.getYieldDuration());
        StandardFlowSerializer.addTextElement(element, "transmitting", String.valueOf(remoteRef.isTransmitting()));
        StandardFlowSerializer.addTextElement(element, "transportProtocol", remoteRef.getTransportProtocol().name());
        StandardFlowSerializer.addTextElement(element, "proxyHost", remoteRef.getProxyHost());
        if (remoteRef.getProxyPort() != null) {
            StandardFlowSerializer.addTextElement(element, "proxyPort", remoteRef.getProxyPort().intValue());
        }
        StandardFlowSerializer.addTextElement(element, "proxyUser", remoteRef.getProxyUser());
        if (!StringUtils.isEmpty((String)remoteRef.getProxyPassword())) {
            String value = "enc{" + this.encryptor.encrypt(remoteRef.getProxyPassword()) + "}";
            StandardFlowSerializer.addTextElement(element, "proxyPassword", value);
        }
        if (remoteRef.getNetworkInterface() != null) {
            StandardFlowSerializer.addTextElement(element, "networkInterface", remoteRef.getNetworkInterface());
        }
        for (RemoteGroupPort port : remoteRef.getInputPorts()) {
            if (!port.hasIncomingConnection()) continue;
            this.addRemoteGroupPort(element, port, "inputPort", scheduledStateLookup);
        }
        for (RemoteGroupPort port : remoteRef.getOutputPorts()) {
            if (port.getConnections().isEmpty()) continue;
            this.addRemoteGroupPort(element, port, "outputPort", scheduledStateLookup);
        }
        parentElement.appendChild(element);
    }

    private void addRemoteGroupPort(Element parentElement, RemoteGroupPort port, String elementName, ScheduledStateLookup scheduledStateLookup) {
        String batchDuration;
        String batchSize;
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", port.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", port.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        StandardFlowSerializer.addTextElement(element, "comments", port.getComments());
        StandardFlowSerializer.addTextElement(element, "scheduledState", scheduledStateLookup.getScheduledState((Port)port).name());
        StandardFlowSerializer.addTextElement(element, "targetId", port.getTargetIdentifier());
        StandardFlowSerializer.addTextElement(element, "maxConcurrentTasks", port.getMaxConcurrentTasks());
        StandardFlowSerializer.addTextElement(element, "useCompression", String.valueOf(port.isUseCompression()));
        Integer batchCount = port.getBatchCount();
        if (batchCount != null && batchCount > 0) {
            StandardFlowSerializer.addTextElement(element, "batchCount", batchCount.intValue());
        }
        if ((batchSize = port.getBatchSize()) != null && batchSize.length() > 0) {
            StandardFlowSerializer.addTextElement(element, "batchSize", batchSize);
        }
        if ((batchDuration = port.getBatchDuration()) != null && batchDuration.length() > 0) {
            StandardFlowSerializer.addTextElement(element, "batchDuration", batchDuration);
        }
        parentElement.appendChild(element);
    }

    private void addPort(Element parentElement, Port port, String elementName, ScheduledStateLookup scheduledStateLookup) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", port.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", port.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        StandardFlowSerializer.addTextElement(element, "comments", port.getComments());
        StandardFlowSerializer.addTextElement(element, "scheduledState", scheduledStateLookup.getScheduledState(port).name());
        parentElement.appendChild(element);
    }

    private void addPublicPort(Element parentElement, PublicPort port, String elementName, ScheduledStateLookup scheduledStateLookup) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", port.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", port.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        StandardFlowSerializer.addTextElement(element, "comments", port.getComments());
        StandardFlowSerializer.addTextElement(element, "scheduledState", scheduledStateLookup.getScheduledState((Port)port).name());
        StandardFlowSerializer.addTextElement(element, "maxConcurrentTasks", String.valueOf(port.getMaxConcurrentTasks()));
        StandardFlowSerializer.addTextElement(element, "allowRemoteAccess", Boolean.TRUE.toString());
        for (String user : port.getUserAccessControl()) {
            StandardFlowSerializer.addTextElement(element, "userAccessControl", user);
        }
        for (String group : port.getGroupAccessControl()) {
            StandardFlowSerializer.addTextElement(element, "groupAccessControl", group);
        }
        parentElement.appendChild(element);
    }

    private void addProcessor(Element parentElement, ProcessorNode processor, ScheduledStateLookup scheduledStateLookup) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("processor");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", processor.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", processor.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", processor.getName());
        this.addPosition(element, processor.getPosition());
        this.addStyle(element, processor.getStyle());
        StandardFlowSerializer.addTextElement(element, "comment", processor.getComments());
        StandardFlowSerializer.addTextElement(element, "class", processor.getCanonicalClassName());
        StandardFlowSerializer.addBundle(element, processor.getBundleCoordinate());
        StandardFlowSerializer.addTextElement(element, "maxConcurrentTasks", processor.getMaxConcurrentTasks());
        StandardFlowSerializer.addTextElement(element, "schedulingPeriod", processor.getSchedulingPeriod());
        StandardFlowSerializer.addTextElement(element, "penalizationPeriod", processor.getPenalizationPeriod());
        StandardFlowSerializer.addTextElement(element, "yieldPeriod", processor.getYieldPeriod());
        StandardFlowSerializer.addTextElement(element, "bulletinLevel", processor.getBulletinLevel().toString());
        StandardFlowSerializer.addTextElement(element, "lossTolerant", String.valueOf(processor.isLossTolerant()));
        StandardFlowSerializer.addTextElement(element, "scheduledState", scheduledStateLookup.getScheduledState(processor).name());
        StandardFlowSerializer.addTextElement(element, "schedulingStrategy", processor.getSchedulingStrategy().name());
        StandardFlowSerializer.addTextElement(element, "executionNode", processor.getExecutionNode().name());
        StandardFlowSerializer.addTextElement(element, "runDurationNanos", processor.getRunDuration(TimeUnit.NANOSECONDS));
        StandardFlowSerializer.addConfiguration(element, processor.getRawPropertyValues(), processor.getAnnotationData(), this.encryptor);
        for (Relationship rel : processor.getAutoTerminatedRelationships()) {
            StandardFlowSerializer.addTextElement(element, "autoTerminatedRelationship", rel.getName());
        }
    }

    private static void addConfiguration(Element element, Map<PropertyDescriptor, String> properties, String annotationData, PropertyEncryptor encryptor) {
        Document doc = element.getOwnerDocument();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor descriptor = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            if (value != null && descriptor.isSensitive()) {
                value = "enc{" + encryptor.encrypt(value) + "}";
            }
            Element propElement = doc.createElement("property");
            StandardFlowSerializer.addTextElement(propElement, "name", descriptor.getName());
            if (value != null) {
                StandardFlowSerializer.addTextElement(propElement, "value", value);
            }
            element.appendChild(propElement);
        }
        if (annotationData != null) {
            StandardFlowSerializer.addTextElement(element, "annotationData", annotationData);
        }
    }

    private void addConnection(Element parentElement, Connection connection) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("connection");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", connection.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "versionedComponentId", connection.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(element, "name", connection.getName());
        Element bendPointsElement = doc.createElement("bendPoints");
        element.appendChild(bendPointsElement);
        for (Position bendPoint : connection.getBendPoints()) {
            this.addPosition(bendPointsElement, bendPoint, "bendPoint");
        }
        StandardFlowSerializer.addTextElement(element, "labelIndex", connection.getLabelIndex());
        StandardFlowSerializer.addTextElement(element, "zIndex", connection.getZIndex());
        String sourceId = connection.getSource().getIdentifier();
        ConnectableType sourceType = connection.getSource().getConnectableType();
        String sourceGroupId = sourceType == ConnectableType.REMOTE_OUTPUT_PORT ? ((RemoteGroupPort)connection.getSource()).getRemoteProcessGroup().getIdentifier() : connection.getSource().getProcessGroup().getIdentifier();
        ConnectableType destinationType = connection.getDestination().getConnectableType();
        String destinationId = connection.getDestination().getIdentifier();
        String destinationGroupId = destinationType == ConnectableType.REMOTE_INPUT_PORT ? ((RemoteGroupPort)connection.getDestination()).getRemoteProcessGroup().getIdentifier() : connection.getDestination().getProcessGroup().getIdentifier();
        StandardFlowSerializer.addTextElement(element, "sourceId", sourceId);
        StandardFlowSerializer.addTextElement(element, "sourceGroupId", sourceGroupId);
        StandardFlowSerializer.addTextElement(element, "sourceType", sourceType.toString());
        StandardFlowSerializer.addTextElement(element, "destinationId", destinationId);
        StandardFlowSerializer.addTextElement(element, "destinationGroupId", destinationGroupId);
        StandardFlowSerializer.addTextElement(element, "destinationType", destinationType.toString());
        for (Relationship relationship : connection.getRelationships()) {
            StandardFlowSerializer.addTextElement(element, "relationship", relationship.getName());
        }
        StandardFlowSerializer.addTextElement(element, "maxWorkQueueSize", connection.getFlowFileQueue().getBackPressureObjectThreshold());
        StandardFlowSerializer.addTextElement(element, "maxWorkQueueDataSize", connection.getFlowFileQueue().getBackPressureDataSizeThreshold());
        StandardFlowSerializer.addTextElement(element, "flowFileExpiration", connection.getFlowFileQueue().getFlowFileExpiration());
        for (FlowFilePrioritizer comparator : connection.getFlowFileQueue().getPriorities()) {
            String className = comparator.getClass().getCanonicalName();
            StandardFlowSerializer.addTextElement(element, "queuePrioritizerClass", className);
        }
        StandardFlowSerializer.addTextElement(element, "loadBalanceStrategy", connection.getFlowFileQueue().getLoadBalanceStrategy().name());
        StandardFlowSerializer.addTextElement(element, "partitioningAttribute", connection.getFlowFileQueue().getPartitioningAttribute());
        StandardFlowSerializer.addTextElement(element, "loadBalanceCompression", connection.getFlowFileQueue().getLoadBalanceCompression().name());
        parentElement.appendChild(element);
    }

    public void addControllerService(Element element, ControllerServiceNode serviceNode) {
        Element serviceElement = element.getOwnerDocument().createElement("controllerService");
        StandardFlowSerializer.addTextElement(serviceElement, "id", serviceNode.getIdentifier());
        StandardFlowSerializer.addTextElement(serviceElement, "versionedComponentId", serviceNode.getVersionedComponentId());
        StandardFlowSerializer.addTextElement(serviceElement, "name", serviceNode.getName());
        StandardFlowSerializer.addTextElement(serviceElement, "comment", serviceNode.getComments());
        StandardFlowSerializer.addTextElement(serviceElement, "class", serviceNode.getCanonicalClassName());
        StandardFlowSerializer.addBundle(serviceElement, serviceNode.getBundleCoordinate());
        ControllerServiceState state = serviceNode.getState();
        boolean enabled = state == ControllerServiceState.ENABLED || state == ControllerServiceState.ENABLING;
        StandardFlowSerializer.addTextElement(serviceElement, "enabled", String.valueOf(enabled));
        StandardFlowSerializer.addConfiguration(serviceElement, serviceNode.getRawPropertyValues(), serviceNode.getAnnotationData(), this.encryptor);
        element.appendChild(serviceElement);
    }

    public static void addReportingTask(Element element, ReportingTaskNode taskNode, PropertyEncryptor encryptor) {
        Element taskElement = element.getOwnerDocument().createElement("reportingTask");
        StandardFlowSerializer.addTextElement(taskElement, "id", taskNode.getIdentifier());
        StandardFlowSerializer.addTextElement(taskElement, "name", taskNode.getName());
        StandardFlowSerializer.addTextElement(taskElement, "comment", taskNode.getComments());
        StandardFlowSerializer.addTextElement(taskElement, "class", taskNode.getCanonicalClassName());
        StandardFlowSerializer.addBundle(taskElement, taskNode.getBundleCoordinate());
        StandardFlowSerializer.addTextElement(taskElement, "schedulingPeriod", taskNode.getSchedulingPeriod());
        StandardFlowSerializer.addTextElement(taskElement, "scheduledState", taskNode.getScheduledState().name());
        StandardFlowSerializer.addTextElement(taskElement, "schedulingStrategy", taskNode.getSchedulingStrategy().name());
        StandardFlowSerializer.addConfiguration(taskElement, taskNode.getRawPropertyValues(), taskNode.getAnnotationData(), encryptor);
        element.appendChild(taskElement);
    }

    private static void addTextElement(Element element, String name, long value) {
        StandardFlowSerializer.addTextElement(element, name, String.valueOf(value));
    }

    private static void addTextElement(Element element, String name, String value) {
        Document doc = element.getOwnerDocument();
        Element toAdd = doc.createElement(name);
        toAdd.setTextContent(CharacterFilterUtils.filterInvalidXmlCharacters((String)value));
        element.appendChild(toAdd);
    }

    private static void addTextElement(Element element, String name, Optional<String> value) {
        if (!value.isPresent()) {
            return;
        }
        Document doc = element.getOwnerDocument();
        Element toAdd = doc.createElement(name);
        toAdd.setTextContent(CharacterFilterUtils.filterInvalidXmlCharacters((String)value.get()));
        element.appendChild(toAdd);
    }

    public static void addTemplate(Element element, Template template) {
        try {
            Document document;
            byte[] serialized = TemplateSerializer.serialize(template.getDetails());
            DocumentBuilder docBuilder = XmlUtils.createSafeDocumentBuilder((boolean)true);
            try (ByteArrayInputStream in = new ByteArrayInputStream(serialized);){
                document = docBuilder.parse(in);
            }
            Node templateNode = element.getOwnerDocument().importNode(document.getDocumentElement(), true);
            element.appendChild(templateNode);
        }
        catch (Exception e) {
            throw new FlowSerializationException((Throwable)e);
        }
    }
}

