/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.ValueMapper;

public enum ProcessGroupStatusDescriptor {
    BYTES_READ("bytesRead", "Bytes Read (5 mins)", "The total number of bytes read from Content Repository by Processors in this Process Group in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ProcessGroupStatus>)((ValueMapper)ProcessGroupStatus::getBytesRead)),
    BYTES_WRITTEN("bytesWritten", "Bytes Written (5 mins)", "The total number of bytes written to Content Repository by Processors in this Process Group in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ProcessGroupStatus>)((ValueMapper)ProcessGroupStatus::getBytesWritten)),
    BYTES_TRANSFERRED("bytesTransferred", "Bytes Transferred (5 mins)", "The total number of bytes read from or written to Content Repository by Processors in this Process Group in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ProcessGroupStatus>)((ValueMapper)s -> s.getBytesRead() + s.getBytesWritten())),
    INPUT_BYTES("inputBytes", "Bytes In (5 mins)", "The cumulative size of all FlowFiles that have entered this Process Group via its Input Ports in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ProcessGroupStatus>)((ValueMapper)ProcessGroupStatus::getInputContentSize)),
    INPUT_COUNT("inputCount", "FlowFiles In (5 mins)", "The number of FlowFiles that have entered this Process Group via its Input Ports in the past 5 minutes", MetricDescriptor.Formatter.COUNT, (ValueMapper<ProcessGroupStatus>)((ValueMapper)s -> s.getInputCount().longValue())),
    OUTPUT_BYTES("outputBytes", "Bytes Out (5 mins)", "The cumulative size of all FlowFiles that have exited this Process Group via its Output Ports in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ProcessGroupStatus>)((ValueMapper)ProcessGroupStatus::getOutputContentSize)),
    OUTPUT_COUNT("outputCount", "FlowFiles Out (5 mins)", "The number of FlowFiles that have exited this Process Group via its Output Ports in the past 5 minutes", MetricDescriptor.Formatter.COUNT, (ValueMapper<ProcessGroupStatus>)((ValueMapper)s -> s.getOutputCount().longValue())),
    QUEUED_BYTES("queuedBytes", "Queued Bytes", "The cumulative size of all FlowFiles queued in all Connections of this Process Group", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<ProcessGroupStatus>)((ValueMapper)ProcessGroupStatus::getQueuedContentSize)),
    QUEUED_COUNT("queuedCount", "Queued Count", "The number of FlowFiles queued in all Connections of this Process Group", MetricDescriptor.Formatter.COUNT, (ValueMapper<ProcessGroupStatus>)((ValueMapper)s -> s.getQueuedCount().longValue())),
    TASK_MILLIS("taskMillis", "Total Task Duration (5 mins)", "The total number of thread-milliseconds that the Processors within this ProcessGroup have used to complete their tasks in the past 5 minutes", MetricDescriptor.Formatter.DURATION, (ValueMapper<ProcessGroupStatus>)((ValueMapper)ProcessGroupStatusDescriptor::calculateTaskMillis));

    private MetricDescriptor<ProcessGroupStatus> descriptor;

    private ProcessGroupStatusDescriptor(String field, String label, String description, MetricDescriptor.Formatter formatter, ValueMapper<ProcessGroupStatus> valueFunction) {
        this.descriptor = new StandardMetricDescriptor<ProcessGroupStatus>(this::ordinal, field, label, description, formatter, valueFunction);
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<ProcessGroupStatus> getDescriptor() {
        return this.descriptor;
    }

    private static long calculateTaskMillis(ProcessGroupStatus status) {
        return TimeUnit.MILLISECONDS.convert(ProcessGroupStatusDescriptor.calculateTaskNanos(status), TimeUnit.NANOSECONDS);
    }

    private static long calculateTaskNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStatus : status.getProcessorStatus()) {
            nanos += procStatus.getProcessingNanos();
        }
        for (ProcessGroupStatus childStatus : status.getProcessGroupStatus()) {
            nanos += ProcessGroupStatusDescriptor.calculateTaskNanos(childStatus);
        }
        return nanos;
    }
}

