/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.StandardFlowSynchronizer;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.StandardFlowSerializer;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.persistence.FlowConfigurationArchiveManager;
import org.apache.nifi.persistence.FlowConfigurationDAO;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardXMLFlowConfigurationDAO
implements FlowConfigurationDAO {
    private final Path flowXmlPath;
    private final PropertyEncryptor encryptor;
    private final FlowConfigurationArchiveManager archiveManager;
    private final NiFiProperties nifiProperties;
    private final ExtensionManager extensionManager;
    private static final Logger LOG = LoggerFactory.getLogger(StandardXMLFlowConfigurationDAO.class);

    public StandardXMLFlowConfigurationDAO(Path flowXml, PropertyEncryptor encryptor, NiFiProperties nifiProperties, ExtensionManager extensionManager) throws IOException {
        this.nifiProperties = nifiProperties;
        File flowXmlFile = flowXml.toFile();
        if (!flowXmlFile.exists()) {
            if (Files.notExists(flowXml.getParent(), new LinkOption[0])) {
                Files.createDirectories(flowXml.getParent(), new FileAttribute[0]);
            }
            Files.createFile(flowXml, new FileAttribute[0]);
        } else if (!flowXmlFile.canRead() || !flowXmlFile.canWrite()) {
            throw new IOException(flowXml + " exists but you have insufficient read/write privileges");
        }
        this.flowXmlPath = flowXml;
        this.encryptor = encryptor;
        this.extensionManager = extensionManager;
        this.archiveManager = new FlowConfigurationArchiveManager(this.flowXmlPath, nifiProperties);
    }

    @Override
    public boolean isFlowPresent() {
        File flowXmlFile = this.flowXmlPath.toFile();
        return flowXmlFile.exists() && flowXmlFile.length() > 0L;
    }

    @Override
    public synchronized void load(FlowController controller, DataFlow dataFlow, FlowService flowService) throws IOException, FlowSerializationException, FlowSynchronizationException, UninheritableFlowException, MissingBundleException {
        StandardFlowSynchronizer flowSynchronizer = new StandardFlowSynchronizer(this.encryptor, this.nifiProperties, this.extensionManager);
        controller.synchronize(flowSynchronizer, dataFlow, flowService);
        if (StandardFlowSynchronizer.isEmpty(dataFlow)) {
            this.save(controller);
        }
    }

    @Override
    public synchronized void load(OutputStream os) throws IOException {
        if (!this.isFlowPresent()) {
            return;
        }
        try (InputStream inStream = Files.newInputStream(this.flowXmlPath, StandardOpenOption.READ);
             GZIPInputStream gzipIn = new GZIPInputStream(inStream);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)os);
        }
    }

    @Override
    public void load(OutputStream os, boolean compressed) throws IOException {
        if (compressed) {
            Files.copy(this.flowXmlPath, os);
        } else {
            this.load(os);
        }
    }

    @Override
    public synchronized void save(InputStream is) throws IOException {
        try (OutputStream outStream = Files.newOutputStream(this.flowXmlPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             GZIPOutputStream gzipOut = new GZIPOutputStream(outStream);){
            FileUtils.copy((InputStream)is, (OutputStream)gzipOut);
        }
    }

    @Override
    public void save(FlowController flow) throws IOException {
        LOG.trace("Saving flow to disk");
        try (OutputStream outStream = Files.newOutputStream(this.flowXmlPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             GZIPOutputStream gzipOut = new GZIPOutputStream(outStream);){
            this.save(flow, gzipOut);
        }
        LOG.debug("Finished saving flow to disk");
    }

    @Override
    public synchronized void save(FlowController flow, OutputStream os) throws IOException {
        try {
            StandardFlowSerializer xmlTransformer = new StandardFlowSerializer(this.encryptor);
            flow.serialize(xmlTransformer, os);
        }
        catch (FlowSerializationException fse) {
            throw new IOException(fse);
        }
    }

    @Override
    public synchronized void save(FlowController controller, boolean archive) throws IOException {
        block34: {
            if (null == controller) {
                throw new NullPointerException();
            }
            Path configFile = this.flowXmlPath;
            Path tempFile = configFile.getParent().resolve(configFile.toFile().getName() + ".new.xml.gz");
            try (OutputStream fileOut = Files.newOutputStream(tempFile, new OpenOption[0]);
                 GZIPOutputStream outStream = new GZIPOutputStream(fileOut);){
                StandardFlowSerializer xmlTransformer = new StandardFlowSerializer(this.encryptor);
                controller.serialize(xmlTransformer, outStream);
                Files.deleteIfExists(configFile);
                FileUtils.renameFile((File)tempFile.toFile(), (File)configFile.toFile(), (int)5, (boolean)true);
            }
            catch (FlowSerializationException fse) {
                throw new IOException(fse);
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
            if (archive) {
                try {
                    this.archiveManager.archive();
                }
                catch (Exception ex) {
                    LOG.error("Unable to archive flow configuration as requested due to " + ex);
                    if (!LOG.isDebugEnabled()) break block34;
                    LOG.error("", (Throwable)ex);
                }
            }
        }
    }
}

