/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;

public class FlowConfigurationDiagnosticTask
implements DiagnosticTask {
    private final FlowController flowController;

    public FlowConfigurationDiagnosticTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        FlowController.GroupStatusCounts statusCounts = this.flowController.getGroupStatusCounts(rootGroup);
        details.add("Active Thread Count: " + statusCounts.getActiveThreadCount());
        details.add("Terminated Thread Count: " + statusCounts.getTerminatedThreadCount());
        details.add("Queued FlowFiles: " + statusCounts.getQueuedCount());
        details.add("Queued Bytes: " + statusCounts.getQueuedContentSize());
        ProcessGroupCounts counts = rootGroup.getCounts();
        details.add("Running Components: " + counts.getRunningCount());
        details.add("Stopped Components: " + counts.getStoppedCount());
        details.add("Invalid Components: " + counts.getInvalidCount());
        details.add("Disabled Components: " + counts.getDisabledCount());
        details.add("Local Input Ports: " + counts.getLocalInputPortCount());
        details.add("Local Output Ports: " + counts.getLocalOutputPortCount());
        details.add("Site-to-Site Input Ports: " + counts.getPublicInputPortCount());
        details.add("Site-to-Site Input Ports: " + counts.getPublicOutputPortCount());
        details.add("Active RPG Ports: " + counts.getActiveRemotePortCount());
        details.add("Inactive RPG Ports: " + counts.getInactiveRemotePortCount());
        details.add("");
        details.add("Total Process Groups: " + rootGroup.findAllProcessGroups().size());
        details.add("Locally Modified and Stale Count: " + counts.getLocallyModifiedAndStaleCount());
        details.add("Locally Modified Count: " + counts.getLocallyModifiedCount());
        details.add("Stale Count: " + counts.getStaleCount());
        details.add("Sync Failure Count: " + counts.getSyncFailureCount());
        details.add("Up-to-Date Count: " + counts.getUpToDateCount());
        return new StandardDiagnosticsDumpElement("Flow Configuration", details);
    }
}

