/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.serialization.ComponentSetFilter;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.ConnectableComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.remote.RemoteGroupPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffectedComponentSet {
    private static final Logger logger = LoggerFactory.getLogger(AffectedComponentSet.class);
    private final FlowController flowController;
    private final FlowManager flowManager;
    private final Set<Port> inputPorts = new HashSet<Port>();
    private final Set<Port> outputPorts = new HashSet<Port>();
    private final Set<RemoteGroupPort> remoteInputPorts = new HashSet<RemoteGroupPort>();
    private final Set<RemoteGroupPort> remoteOutputPorts = new HashSet<RemoteGroupPort>();
    private final Set<ProcessorNode> processors = new HashSet<ProcessorNode>();
    private final Set<ControllerServiceNode> controllerServices = new HashSet<ControllerServiceNode>();
    private final Set<ReportingTaskNode> reportingTasks = new HashSet<ReportingTaskNode>();

    public AffectedComponentSet(FlowController flowController) {
        this.flowController = flowController;
        this.flowManager = flowController.getFlowManager();
    }

    public void addInputPort(Port port) {
        if (port == null) {
            return;
        }
        this.inputPorts.add(port);
    }

    public void addOutputPort(Port port) {
        if (port == null) {
            return;
        }
        this.outputPorts.add(port);
    }

    public void addRemoteInputPort(RemoteGroupPort port) {
        if (port == null) {
            return;
        }
        this.remoteInputPorts.add(port);
    }

    public void addRemoteOutputPort(RemoteGroupPort port) {
        if (port == null) {
            return;
        }
        this.remoteOutputPorts.add(port);
    }

    public void addRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup) {
        if (remoteProcessGroup == null) {
            return;
        }
        remoteProcessGroup.getInputPorts().forEach(this::addRemoteInputPort);
        remoteProcessGroup.getOutputPorts().forEach(this::addRemoteOutputPort);
    }

    public void addProcessor(ProcessorNode processor) {
        if (processor == null) {
            return;
        }
        this.processors.add(processor);
    }

    public void addControllerService(ControllerServiceNode controllerService) {
        if (controllerService == null) {
            return;
        }
        this.controllerServices.add(controllerService);
        List referencingComponents = controllerService.getReferences().findRecursiveReferences(ComponentNode.class);
        for (ComponentNode reference : referencingComponents) {
            if (reference instanceof ControllerServiceNode) {
                this.addControllerService((ControllerServiceNode)reference);
                continue;
            }
            if (reference instanceof ProcessorNode) {
                this.addProcessor((ProcessorNode)reference);
                continue;
            }
            if (!(reference instanceof ReportingTaskNode)) continue;
            this.addReportingTask((ReportingTaskNode)reference);
        }
    }

    public boolean isControllerServiceAffected(String serviceId) {
        for (ControllerServiceNode serviceNode : this.controllerServices) {
            if (!serviceNode.getIdentifier().equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    private void addControllerServiceWithoutReferences(ControllerServiceNode controllerService) {
        if (controllerService == null) {
            return;
        }
        this.controllerServices.add(controllerService);
    }

    public void addReportingTask(ReportingTaskNode task) {
        if (task == null) {
            return;
        }
        this.reportingTasks.add(task);
    }

    public boolean isReportingTaskAffected(String reportingTaskId) {
        for (ReportingTaskNode taskNode : this.reportingTasks) {
            if (!taskNode.getIdentifier().equals(reportingTaskId)) continue;
            return true;
        }
        return false;
    }

    public void addConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.addConnectable(connection.getSource());
        this.addConnectable(connection.getDestination());
    }

    public void addConnectable(Connectable connectable) {
        if (connectable == null) {
            return;
        }
        switch (connectable.getConnectableType()) {
            case INPUT_PORT: {
                this.addInputPort((Port)connectable);
                break;
            }
            case OUTPUT_PORT: {
                this.addOutputPort((Port)connectable);
                break;
            }
            case PROCESSOR: {
                this.addProcessor((ProcessorNode)connectable);
                break;
            }
            case REMOTE_INPUT_PORT: {
                this.addRemoteInputPort((RemoteGroupPort)connectable);
                break;
            }
            case REMOTE_OUTPUT_PORT: {
                this.addRemoteOutputPort((RemoteGroupPort)connectable);
            }
        }
    }

    public void addAffectedComponents(FlowDifference difference) {
        DifferenceType differenceType = difference.getDifferenceType();
        if (differenceType == DifferenceType.COMPONENT_ADDED) {
            if (difference.getComponentB().getComponentType() == ComponentType.CONNECTION) {
                this.addComponentsForNewConnection((VersionedConnection)difference.getComponentB());
            }
            return;
        }
        if (differenceType == DifferenceType.PARAMETER_VALUE_CHANGED || differenceType == DifferenceType.PARAMETER_DESCRIPTION_CHANGED || differenceType == DifferenceType.PARAMETER_REMOVED) {
            this.addComponentsForParameterUpdate(difference);
            return;
        }
        if (differenceType == DifferenceType.PARAMETER_CONTEXT_CHANGED) {
            this.addComponentsForParameterContextChange(difference);
            return;
        }
        if (differenceType == DifferenceType.INHERITED_CONTEXTS_CHANGED) {
            this.addComponentsForInheritedParameterContextChange(difference);
        }
        if (differenceType == DifferenceType.VARIABLE_CHANGED || differenceType == DifferenceType.VARIABLE_ADDED || differenceType == DifferenceType.VARIABLE_REMOVED) {
            this.addComponentsForVariableChange(difference.getComponentA().getInstanceIdentifier(), difference.getFieldName().orElse(null));
            return;
        }
        if (differenceType == DifferenceType.RPG_URL_CHANGED) {
            String instanceId = difference.getComponentA().getInstanceIdentifier();
            RemoteProcessGroup rpg = this.flowManager.getRootGroup().findRemoteProcessGroup(instanceId);
            if (rpg != null) {
                this.addRemoteProcessGroup(rpg);
            }
        }
        if (differenceType == DifferenceType.COMPONENT_REMOVED && difference.getComponentA().getComponentType() == ComponentType.PROCESS_GROUP) {
            this.addAllComponentsWithinGroup(difference.getComponentA().getInstanceIdentifier());
        }
        this.addAffectedComponents(difference.getComponentA());
    }

    private void addAllComponentsWithinGroup(String groupId) {
        ProcessGroup processGroup = this.flowManager.getGroup(groupId);
        if (processGroup == null) {
            return;
        }
        processGroup.getProcessors().forEach(this::addProcessor);
        processGroup.getControllerServices(false).forEach(this::addControllerServiceWithoutReferences);
        processGroup.getInputPorts().forEach(this::addInputPort);
        processGroup.getOutputPorts().forEach(this::addOutputPort);
        processGroup.getRemoteProcessGroups().forEach(this::addRemoteProcessGroup);
        processGroup.getProcessGroups().forEach(child -> this.addAllComponentsWithinGroup(child.getIdentifier()));
    }

    private void addComponentsForVariableChange(String groupId, String variableName) {
        if (groupId == null || variableName == null) {
            return;
        }
        ProcessGroup group = this.flowManager.getGroup(groupId);
        if (group == null) {
            return;
        }
        Set affectedComponents = group.getComponentsAffectedByVariable(variableName);
        for (ComponentNode component : affectedComponents) {
            if (component instanceof ProcessorNode) {
                this.addProcessor((ProcessorNode)component);
                continue;
            }
            if (!(component instanceof ControllerServiceNode)) continue;
            this.addControllerService((ControllerServiceNode)component);
        }
    }

    private void addComponentsForInheritedParameterContextChange(FlowDifference difference) {
        String parameterContextId = difference.getComponentA().getInstanceIdentifier();
        ParameterContext context = this.flowManager.getParameterContextManager().getParameterContext(parameterContextId);
        if (context == null) {
            return;
        }
        Set boundGroups = context.getParameterReferenceManager().getProcessGroupsBound(context);
        for (ProcessGroup group : boundGroups) {
            group.getProcessors().stream().filter(AbstractComponentNode::isReferencingParameter).forEach(this::addProcessor);
            group.getControllerServices(false).stream().filter(ComponentNode::isReferencingParameter).forEach(this::addControllerService);
        }
    }

    private void addComponentsForParameterContextChange(FlowDifference difference) {
        String groupId = difference.getComponentA().getInstanceIdentifier();
        ProcessGroup group = this.flowManager.getGroup(groupId);
        if (group == null) {
            return;
        }
        group.getProcessors().stream().filter(AbstractComponentNode::isReferencingParameter).forEach(this::addProcessor);
        group.getControllerServices(false).stream().filter(ComponentNode::isReferencingParameter).forEach(this::addControllerService);
    }

    private void addComponentsForParameterUpdate(FlowDifference difference) {
        DifferenceType differenceType = difference.getDifferenceType();
        Optional optionalParameterName = difference.getFieldName();
        if (!optionalParameterName.isPresent()) {
            logger.warn("Encountered a Flow Difference {} with Difference Type of {} but no indication as to which parameter was updated.", (Object)difference, (Object)differenceType);
            return;
        }
        String parameterName = (String)optionalParameterName.get();
        String contextId = difference.getComponentA().getInstanceIdentifier();
        ParameterContext parameterContext = this.flowManager.getParameterContextManager().getParameterContext(contextId);
        if (parameterContext == null) {
            logger.warn("Encountered a Flow Difference {} with a Difference Type of {} but found no Parameter Context with Instance ID {}", new Object[]{difference, differenceType, contextId});
            return;
        }
        Set referencingServices = parameterContext.getParameterReferenceManager().getControllerServicesReferencing(parameterContext, parameterName);
        Set referencingProcessors = parameterContext.getParameterReferenceManager().getProcessorsReferencing(parameterContext, parameterName);
        referencingServices.forEach(this::addControllerService);
        referencingProcessors.forEach(this::addProcessor);
    }

    private void addComponentsForNewConnection(VersionedConnection connection) {
        ConnectableComponent destinationComponent;
        Connectable destinationConnectable;
        ConnectableComponent sourceComponent = connection.getSource();
        Connectable sourceConnectable = this.getConnectable(sourceComponent.getType(), sourceComponent.getInstanceIdentifier());
        if (sourceConnectable != null) {
            this.addConnectable(sourceConnectable);
        }
        if ((destinationConnectable = this.getConnectable((destinationComponent = connection.getDestination()).getType(), destinationComponent.getInstanceIdentifier())) != null) {
            this.addConnectable(destinationConnectable);
        }
    }

    private Connectable getConnectable(ConnectableComponentType type, String identifier) {
        switch (type) {
            case FUNNEL: {
                return this.flowManager.getFunnel(identifier);
            }
            case INPUT_PORT: {
                return this.flowManager.getInputPort(identifier);
            }
            case OUTPUT_PORT: {
                return this.flowManager.getOutputPort(identifier);
            }
            case PROCESSOR: {
                return this.flowManager.getProcessorNode(identifier);
            }
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                return this.flowManager.getRootGroup().findRemoteGroupPort(identifier);
            }
        }
        return null;
    }

    private void addAffectedComponents(VersionedComponent versionedComponent) {
        String componentId = versionedComponent.getInstanceIdentifier();
        switch (versionedComponent.getComponentType()) {
            case CONNECTION: {
                this.addConnection(this.flowManager.getConnection(componentId));
                break;
            }
            case CONTROLLER_SERVICE: {
                this.addControllerService(this.flowManager.getControllerServiceNode(componentId));
                break;
            }
            case INPUT_PORT: {
                this.addInputPort(this.flowManager.getInputPort(componentId));
                break;
            }
            case OUTPUT_PORT: {
                this.addOutputPort(this.flowManager.getOutputPort(componentId));
                break;
            }
            case PROCESS_GROUP: {
                break;
            }
            case PROCESSOR: {
                this.addProcessor(this.flowManager.getProcessorNode(componentId));
                break;
            }
            case REMOTE_INPUT_PORT: {
                RemoteGroupPort remoteInputPort = this.flowManager.getRootGroup().findRemoteGroupPort(componentId);
                if (remoteInputPort == null) break;
                this.addRemoteInputPort(remoteInputPort);
                break;
            }
            case REMOTE_OUTPUT_PORT: {
                RemoteGroupPort remoteOutputPort = this.flowManager.getRootGroup().findRemoteGroupPort(componentId);
                if (remoteOutputPort == null) break;
                this.addRemoteOutputPort(remoteOutputPort);
                break;
            }
            case REMOTE_PROCESS_GROUP: {
                this.addRemoteProcessGroup(this.flowManager.getRootGroup().findRemoteProcessGroup(componentId));
                break;
            }
            case REPORTING_TASK: {
                this.addReportingTask(this.flowManager.getReportingTaskNode(componentId));
            }
        }
    }

    public AffectedComponentSet toActiveSet() {
        AffectedComponentSet active = new AffectedComponentSet(this.flowController);
        this.inputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addInputPort);
        this.outputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addOutputPort);
        this.remoteInputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addRemoteInputPort);
        this.remoteOutputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addRemoteOutputPort);
        this.processors.stream().filter(this::isActive).forEach(active::addProcessor);
        this.reportingTasks.stream().filter(task -> task.getScheduledState() == ScheduledState.STARTING || task.getScheduledState() == ScheduledState.RUNNING || task.isRunning()).forEach(active::addReportingTask);
        this.controllerServices.stream().filter(service -> service.getState() == ControllerServiceState.ENABLING || service.getState() == ControllerServiceState.ENABLED).forEach(active::addControllerServiceWithoutReferences);
        return active;
    }

    private boolean isActive(ProcessorNode processor) {
        ScheduledState scheduledState = processor.getPhysicalScheduledState();
        return scheduledState == ScheduledState.STARTING || scheduledState == ScheduledState.RUNNING || processor.isRunning();
    }

    private boolean isStopped(ProcessorNode processor) {
        ScheduledState state = processor.getPhysicalScheduledState();
        boolean stateCorrect = state == ScheduledState.STOPPED || state == ScheduledState.DISABLED;
        return stateCorrect && !processor.isRunning();
    }

    public void start() {
        logger.info("Starting the following components: {}", (Object)this);
        this.flowController.getControllerServiceProvider().enableControllerServices(this.controllerServices);
        this.inputPorts.forEach(port -> port.getProcessGroup().startInputPort(port));
        this.outputPorts.forEach(port -> port.getProcessGroup().startOutputPort(port));
        this.remoteInputPorts.forEach(port -> port.getRemoteProcessGroup().startTransmitting(port));
        this.remoteOutputPorts.forEach(port -> port.getRemoteProcessGroup().startTransmitting(port));
        this.processors.forEach(processor -> processor.getProcessGroup().startProcessor(processor, false));
        this.reportingTasks.forEach(this.flowController::startReportingTask);
    }

    public void removeComponents(ComponentSetFilter filter) {
        this.inputPorts.removeIf(filter::testInputPort);
        this.outputPorts.removeIf(filter::testOutputPort);
        this.remoteInputPorts.removeIf(filter::testRemoteInputPort);
        this.remoteOutputPorts.removeIf(filter::testRemoteOutputPort);
        this.processors.removeIf(filter::testProcessor);
        this.controllerServices.removeIf(filter::testControllerService);
        this.reportingTasks.removeIf(filter::testReportingTask);
    }

    public AffectedComponentSet toExistingSet() {
        ControllerServiceProvider serviceProvider = this.flowController.getControllerServiceProvider();
        AffectedComponentSet existing = new AffectedComponentSet(this.flowController);
        this.inputPorts.stream().filter(port -> port.getProcessGroup().getInputPort(port.getIdentifier()) != null).forEach(existing::addInputPort);
        this.outputPorts.stream().filter(port -> port.getProcessGroup().getOutputPort(port.getIdentifier()) != null).forEach(existing::addOutputPort);
        this.remoteInputPorts.stream().filter(port -> port.getProcessGroup().findRemoteGroupPort(port.getIdentifier()) != null).forEach(existing::addRemoteInputPort);
        this.remoteOutputPorts.stream().filter(port -> port.getProcessGroup().findRemoteGroupPort(port.getIdentifier()) != null).forEach(existing::addRemoteOutputPort);
        this.processors.stream().filter(processor -> processor.getProcessGroup().getProcessor(processor.getIdentifier()) != null).forEach(existing::addProcessor);
        this.reportingTasks.stream().filter(task -> this.flowController.getReportingTaskNode(task.getIdentifier()) != null).forEach(existing::addReportingTask);
        this.controllerServices.stream().filter(service -> serviceProvider.getControllerServiceNode(service.getIdentifier()) != null).forEach(existing::addControllerServiceWithoutReferences);
        return existing;
    }

    public AffectedComponentSet toStartableSet() {
        AffectedComponentSet startable = new AffectedComponentSet(this.flowController);
        this.inputPorts.stream().filter(this::isStartable).forEach(startable::addInputPort);
        this.outputPorts.stream().filter(this::isStartable).forEach(startable::addOutputPort);
        this.remoteInputPorts.stream().filter(this::isStartable).forEach(startable::addRemoteInputPort);
        this.remoteOutputPorts.stream().filter(this::isStartable).forEach(startable::addRemoteOutputPort);
        this.processors.stream().filter(this::isStartable).forEach(startable::addProcessor);
        this.reportingTasks.stream().filter(this::isStartable).forEach(startable::addReportingTask);
        this.controllerServices.stream().filter(this::isStartable).forEach(startable::addControllerServiceWithoutReferences);
        return startable;
    }

    private boolean isStartable(ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        if (componentNode instanceof ProcessorNode) {
            return ((ProcessorNode)componentNode).getScheduledState() != ScheduledState.DISABLED;
        }
        if (componentNode instanceof ReportingTaskNode) {
            return ((ReportingTaskNode)componentNode).getScheduledState() != ScheduledState.DISABLED;
        }
        return true;
    }

    private boolean isStartable(Port port) {
        if (port == null) {
            return false;
        }
        return port.getScheduledState() != ScheduledState.DISABLED;
    }

    public void stop() {
        logger.info("Stopping the following components: {}", (Object)this);
        long start = System.currentTimeMillis();
        this.inputPorts.forEach(port -> port.getProcessGroup().stopInputPort(port));
        this.outputPorts.forEach(port -> port.getProcessGroup().stopOutputPort(port));
        this.remoteInputPorts.forEach(port -> port.getRemoteProcessGroup().stopTransmitting(port));
        this.remoteOutputPorts.forEach(port -> port.getRemoteProcessGroup().stopTransmitting(port));
        this.processors.forEach(processor -> processor.getProcessGroup().stopProcessor(processor));
        this.reportingTasks.forEach(this.flowController::stopReportingTask);
        this.waitForConnectablesStopped();
        if (!this.controllerServices.isEmpty()) {
            Future disableFuture = this.flowController.getControllerServiceProvider().disableControllerServicesAsync(this.controllerServices);
            this.waitForControllerServicesStopped(disableFuture);
        }
        long millis = System.currentTimeMillis() - start;
        logger.info("Successfully stopped all components in {} milliseconds", (Object)millis);
    }

    private void waitForControllerServicesStopped(Future<Void> future) {
        try {
            while (true) {
                logger.info("Waiting for all Controller Services to become disabled...");
                if (logger.isDebugEnabled()) {
                    Set activeServices = this.controllerServices.stream().filter(ControllerServiceNode::isActive).collect(Collectors.toSet());
                    logger.debug("There are currently {} active Controller Services: {}", (Object)activeServices.size(), activeServices);
                }
                try {
                    future.get(10L, TimeUnit.SECONDS);
                    return;
                }
                catch (TimeoutException activeServices) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new UninheritableFlowException("Could not disable all affected Controller Services", e);
        }
    }

    private void waitForConnectablesStopped() {
        long count = 0L;
        try {
            while (!this.componentsStopped()) {
                if (count++ % 1000L == 0L) {
                    logger.info("Waiting for all required Processors and Reporting Tasks to stop...");
                    if (this.reportingTasks.isEmpty() && this.processors.isEmpty()) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        Set activeReportingTasks = this.reportingTasks.stream().filter(ReportingTaskNode::isRunning).collect(Collectors.toSet());
                        logger.debug("There are currently {} active Reporting Tasks: {}", (Object)activeReportingTasks.size(), activeReportingTasks);
                        Set activeProcessors = this.processors.stream().filter(processor -> !this.isStopped((ProcessorNode)processor)).collect(Collectors.toSet());
                        logger.debug("There are currently {} active Processors: {}", (Object)activeProcessors.size(), activeProcessors);
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            throw new UninheritableFlowException("Could not stop all affected components", e);
        }
    }

    private boolean componentsStopped() {
        if (this.processors.stream().anyMatch(processor -> !this.isStopped((ProcessorNode)processor))) {
            return false;
        }
        return !this.reportingTasks.stream().anyMatch(ReportingTaskNode::isRunning);
    }

    public String toString() {
        return "AffectedComponentSet[inputPorts=" + this.inputPorts + ", outputPorts=" + this.outputPorts + ", remoteInputPorts=" + this.remoteInputPorts + ", remoteOutputPorts=" + this.remoteOutputPorts + ", processors=" + this.processors + ", controllerServices=" + this.controllerServices + ", reportingTasks=" + this.reportingTasks + "]";
    }
}

