/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.serialization.ComponentSetFilter;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.remote.RemoteGroupPort;

public class RunningComponentSetFilter
implements ComponentSetFilter {
    private final Map<String, VersionedControllerService> controllerServices = new HashMap<String, VersionedControllerService>();
    private final Map<String, VersionedProcessor> processors = new HashMap<String, VersionedProcessor>();
    private final Map<String, VersionedReportingTask> reportingTasks = new HashMap<String, VersionedReportingTask>();
    private final Map<String, VersionedPort> inputPorts = new HashMap<String, VersionedPort>();
    private final Map<String, VersionedPort> outputPorts = new HashMap<String, VersionedPort>();
    private final Map<String, VersionedRemoteGroupPort> remoteInputPorts = new HashMap<String, VersionedRemoteGroupPort>();
    private final Map<String, VersionedRemoteGroupPort> remoteOutputPorts = new HashMap<String, VersionedRemoteGroupPort>();

    public RunningComponentSetFilter(VersionedDataflow dataflow) {
        dataflow.getControllerServices().forEach(service -> this.controllerServices.put(service.getInstanceIdentifier(), (VersionedControllerService)service));
        dataflow.getReportingTasks().forEach(task -> this.reportingTasks.put(task.getInstanceIdentifier(), (VersionedReportingTask)task));
        this.flatten(dataflow.getRootGroup());
    }

    private void flatten(VersionedProcessGroup group) {
        group.getInputPorts().forEach(port -> this.inputPorts.put(port.getInstanceIdentifier(), (VersionedPort)port));
        group.getOutputPorts().forEach(port -> this.outputPorts.put(port.getInstanceIdentifier(), (VersionedPort)port));
        group.getControllerServices().forEach(service -> this.controllerServices.put(service.getInstanceIdentifier(), (VersionedControllerService)service));
        group.getProcessors().forEach(processor -> this.processors.put(processor.getInstanceIdentifier(), (VersionedProcessor)processor));
        for (VersionedRemoteProcessGroup rpg : group.getRemoteProcessGroups()) {
            rpg.getInputPorts().forEach(port -> {
                if (port.getInstanceIdentifier() != null) {
                    this.remoteInputPorts.put(port.getInstanceIdentifier(), (VersionedRemoteGroupPort)port);
                }
            });
            rpg.getOutputPorts().forEach(port -> {
                if (port.getInstanceIdentifier() != null) {
                    this.remoteOutputPorts.put(port.getInstanceIdentifier(), (VersionedRemoteGroupPort)port);
                }
            });
        }
        group.getProcessGroups().forEach(this::flatten);
    }

    @Override
    public boolean testProcessor(ProcessorNode processor) {
        VersionedProcessor versionedProcessor = this.processors.get(processor.getIdentifier());
        return versionedProcessor != null && versionedProcessor.getScheduledState() == ScheduledState.RUNNING;
    }

    @Override
    public boolean testReportingTask(ReportingTaskNode reportingTask) {
        VersionedReportingTask versionedReportingTask = this.reportingTasks.get(reportingTask.getIdentifier());
        return versionedReportingTask != null && versionedReportingTask.getScheduledState() == ScheduledState.RUNNING;
    }

    @Override
    public boolean testControllerService(ControllerServiceNode controllerService) {
        VersionedControllerService versionedService = this.controllerServices.get(controllerService.getIdentifier());
        return versionedService != null && versionedService.getScheduledState() == ScheduledState.ENABLED;
    }

    @Override
    public boolean testInputPort(Port port) {
        VersionedPort versionedPort = this.inputPorts.get(port.getIdentifier());
        return versionedPort != null && versionedPort.getScheduledState() == ScheduledState.RUNNING;
    }

    @Override
    public boolean testOutputPort(Port port) {
        VersionedPort versionedPort = this.outputPorts.get(port.getIdentifier());
        return versionedPort != null && versionedPort.getScheduledState() == ScheduledState.RUNNING;
    }

    @Override
    public boolean testRemoteInputPort(RemoteGroupPort port) {
        VersionedRemoteGroupPort versionedPort = this.remoteInputPorts.get(port.getIdentifier());
        return versionedPort != null && versionedPort.getScheduledState() == ScheduledState.RUNNING;
    }

    @Override
    public boolean testRemoteOutputPort(RemoteGroupPort port) {
        VersionedRemoteGroupPort versionedPort = this.remoteOutputPorts.get(port.getIdentifier());
        return versionedPort != null && versionedPort.getScheduledState() == ScheduledState.RUNNING;
    }
}

