/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.util.FlowInfo;
import org.apache.nifi.util.LoggingXmlParserErrorHandler;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FlowParser {
    private static final Logger logger = LoggerFactory.getLogger(FlowParser.class);
    private static final String FLOW_XSD = "/FlowConfiguration.xsd";
    private static final byte XML_FIRST_CHARACTER = 60;
    private final Schema flowSchema;

    public FlowParser() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.flowSchema = schemaFactory.newSchema(FlowParser.class.getResource(FLOW_XSD));
    }

    /*
     * Exception decompiling
     */
    public FlowInfo parse(File flowConfigurationFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isXml(byte[] contents) {
        if (contents == null || contents.length == 0) {
            return false;
        }
        byte firstByte = contents[0];
        return firstByte == 60;
    }

    private FlowInfo parseXml(byte[] flowBytes) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder docBuilder = XmlUtils.createSafeDocumentBuilder((Schema)this.flowSchema);
        docBuilder.setErrorHandler(new LoggingXmlParserErrorHandler("Flow Configuration", logger));
        Document document = docBuilder.parse(new ByteArrayInputStream(flowBytes));
        Element rootElement = document.getDocumentElement();
        Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
        if (rootGroupElement == null) {
            logger.warn("rootGroup element not found in Flow Configuration file");
            return null;
        }
        Element rootGroupIdElement = (Element)rootGroupElement.getElementsByTagName("id").item(0);
        if (rootGroupIdElement == null) {
            logger.warn("id element not found under rootGroup in Flow Configuration file");
            return null;
        }
        String rootGroupId = rootGroupIdElement.getTextContent();
        ArrayList<PortDTO> ports = new ArrayList<PortDTO>();
        ports.addAll(this.getPorts(rootGroupElement, "inputPort"));
        ports.addAll(this.getPorts(rootGroupElement, "outputPort"));
        return new FlowInfo(rootGroupId, ports);
    }

    private FlowInfo parseJson(byte[] flowBytes) {
        StandardDataFlow standardDataFlow = new StandardDataFlow(flowBytes, new byte[0], null, Collections.emptySet());
        VersionedDataflow dataflow = standardDataFlow.getVersionedDataflow();
        VersionedProcessGroup rootGroup = dataflow.getRootGroup();
        if (rootGroup == null) {
            return null;
        }
        ArrayList<PortDTO> ports = new ArrayList<PortDTO>();
        this.mapPorts(rootGroup.getInputPorts(), ports);
        this.mapPorts(rootGroup.getOutputPorts(), ports);
        return new FlowInfo(rootGroup.getIdentifier(), ports);
    }

    private void mapPorts(Set<VersionedPort> versionedPorts, List<PortDTO> portDtos) {
        if (versionedPorts == null || versionedPorts.isEmpty()) {
            return;
        }
        for (VersionedPort port : versionedPorts) {
            PortDTO portDto = this.mapPort(port);
            portDtos.add(portDto);
        }
    }

    private PortDTO mapPort(VersionedPort port) {
        PortDTO dto = new PortDTO();
        dto.setAllowRemoteAccess(port.isAllowRemoteAccess());
        dto.setComments(port.getComments());
        dto.setConcurrentlySchedulableTaskCount(port.getConcurrentlySchedulableTaskCount());
        dto.setId(port.getIdentifier());
        dto.setName(port.getName());
        dto.setParentGroupId(port.getGroupIdentifier());
        dto.setPosition(new PositionDTO(Double.valueOf(port.getPosition().getX()), Double.valueOf(port.getPosition().getY())));
        dto.setState(port.getScheduledState().name());
        dto.setType(port.getType().name());
        return dto;
    }

    /*
     * Exception decompiling
     */
    public Document parseDocument(File flowConfigurationFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<PortDTO> getPorts(Element element, String type) {
        ArrayList<PortDTO> ports = new ArrayList<PortDTO>();
        List<Element> portNodeList = FlowParser.getChildrenByTagName(element, type);
        for (Element portElement : portNodeList) {
            PortDTO portDTO = FlowFromDOMFactory.getPort(portElement);
            portDTO.setType(type);
            ports.add(portDTO);
        }
        return ports;
    }

    public void writeFlow(Document flowDocument, Path flowXmlPath) throws IOException, TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(flowDocument);
        StreamResult outputTarget = new StreamResult(outputStream);
        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
        try (OutputStream output = Files.newOutputStream(flowXmlPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             GZIPOutputStream gzipOut = new GZIPOutputStream(output);){
            FileUtils.copy((InputStream)is, (OutputStream)gzipOut);
        }
    }

    public static List<Element> getChildrenByTagName(Element element, String tagName) {
        ArrayList<Element> matches = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(child = (Element)nodeList.item(i)).getNodeName().equals(tagName)) continue;
            matches.add(child);
        }
        return matches;
    }
}

