/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.nifi.controller.GarbageCollectionEvent;
import org.apache.nifi.controller.GarbageCollectionLog;
import org.apache.nifi.controller.StandardGarbageCollectionEvent;
import org.apache.nifi.util.RingBuffer;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingBufferGarbageCollectionLog
implements GarbageCollectionLog,
NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(RingBufferGarbageCollectionLog.class);
    private final RingBuffer<GarbageCollectionEvent> events;
    private final long minDurationThreshold;
    private final long jvmStartTime;
    private GarbageCollectionEvent maxDurationEvent;
    private final Map<String, Tuple<Long, Long>> timeAndCountPerAction = new HashMap<String, Tuple<Long, Long>>();

    public RingBufferGarbageCollectionLog(int eventCount, long minDurationThreshold) {
        this.events = new RingBuffer(eventCount);
        this.minDurationThreshold = minDurationThreshold;
        this.jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    @Override
    public long getMinDurationThreshold() {
        return this.minDurationThreshold;
    }

    @Override
    public List<GarbageCollectionEvent> getGarbageCollectionEvents() {
        return this.events.asList();
    }

    @Override
    public synchronized Map<String, Long> getGarbageCollectionCounts() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        this.timeAndCountPerAction.forEach((action, tuple) -> {
            Long cfr_ignored_0 = (Long)counts.put((String)action, (Long)tuple.getValue());
        });
        return counts;
    }

    @Override
    public synchronized Map<String, Long> getAverageGarbageCollectionDurations() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        this.timeAndCountPerAction.forEach((action, tuple) -> counts.put((String)action, (Long)tuple.getKey() / (Long)tuple.getValue()));
        return counts;
    }

    @Override
    public synchronized GarbageCollectionEvent getLongestGarbageCollectionEvent() {
        return this.maxDurationEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!notification.getType().equals("com.sun.management.gc.notification")) {
            return;
        }
        CompositeData compositeData = (CompositeData)notification.getUserData();
        GarbageCollectionNotificationInfo gcNotification = GarbageCollectionNotificationInfo.from(compositeData);
        GcInfo gcInfo = gcNotification.getGcInfo();
        String gcName = gcNotification.getGcName();
        String action = gcNotification.getGcAction();
        String cause = gcNotification.getGcCause();
        long startTime = this.jvmStartTime + gcInfo.getStartTime();
        long endTime = this.jvmStartTime + gcInfo.getEndTime();
        Map<String, MemoryUsage> usageAfter = gcInfo.getMemoryUsageAfterGc();
        Map<String, MemoryUsage> usageBefore = gcInfo.getMemoryUsageBeforeGc();
        ArrayList<GarbageCollectionEvent.GarbageCollectionHeapSize> heapSizes = new ArrayList<GarbageCollectionEvent.GarbageCollectionHeapSize>();
        for (Map.Entry<String, MemoryUsage> entry : usageAfter.entrySet()) {
            MemoryUsage after;
            MemoryUsage before = usageBefore.get(entry.getKey());
            if (before == null || (after = entry.getValue()).getUsed() == before.getUsed()) continue;
            heapSizes.add(new StandardGarbageCollectionEvent.StandardGarbageCollectionHeapSize(entry.getKey(), before.getUsed(), after.getUsed()));
        }
        StandardGarbageCollectionEvent event = new StandardGarbageCollectionEvent(gcName, action, cause, startTime, endTime, heapSizes);
        if (gcInfo.getDuration() >= this.minDurationThreshold) {
            this.events.add((Object)event);
        }
        RingBufferGarbageCollectionLog ringBufferGarbageCollectionLog = this;
        synchronized (ringBufferGarbageCollectionLog) {
            Tuple<Long, Long> previousTuple = this.timeAndCountPerAction.get(action);
            if (previousTuple == null) {
                this.timeAndCountPerAction.put(action, (Tuple<Long, Long>)new Tuple((Object)gcInfo.getDuration(), (Object)1L));
            } else {
                this.timeAndCountPerAction.put(action, (Tuple<Long, Long>)new Tuple((Object)(gcInfo.getDuration() + (Long)previousTuple.getKey()), (Object)(1L + (Long)previousTuple.getValue())));
            }
            if (this.maxDurationEvent == null || event.getDuration() > this.maxDurationEvent.getDuration()) {
                this.maxDurationEvent = event;
            }
        }
    }
}

