/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSnippet;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.FlowFileConcurrency;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.SnippetUtils;
import org.apache.nifi.web.api.dto.BatchSettingsDTO;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;

public class StandardFlowSnippet
implements FlowSnippet {
    private final FlowSnippetDTO dto;
    private final ExtensionManager extensionManager;

    public StandardFlowSnippet(FlowSnippetDTO dto, ExtensionManager extensionManager) {
        this.dto = dto;
        this.extensionManager = extensionManager;
    }

    @Override
    public void validate(ProcessGroup group) {
        for (PortDTO port : this.dto.getInputPorts()) {
            if (group.getInputPortByName(port.getName()) == null) continue;
            throw new IllegalStateException("One or more of the proposed Port names is not available in the process group");
        }
        for (PortDTO port : this.dto.getOutputPorts()) {
            if (group.getOutputPortByName(port.getName()) == null) continue;
            throw new IllegalStateException("One or more of the proposed Port names is not available in the process group");
        }
        this.verifyComponentTypesInSnippet();
        SnippetUtils.verifyNoVersionControlConflicts((FlowSnippetDTO)this.dto, (ProcessGroup)group);
    }

    @Override
    public void verifyComponentTypesInSnippet() {
        HashMap<String, Set<BundleCoordinate>> processorClasses = new HashMap<String, Set<BundleCoordinate>>();
        for (Object extensionDefinition : this.extensionManager.getExtensions(Processor.class)) {
            String name = extensionDefinition.getImplementationClassName();
            processorClasses.put(name, this.extensionManager.getBundles(name).stream().map(bundle -> bundle.getBundleDetails().getCoordinate()).collect(Collectors.toSet()));
        }
        this.verifyProcessorsInSnippet(this.dto, processorClasses);
        HashMap<String, Set<BundleCoordinate>> controllerServiceClasses = new HashMap<String, Set<BundleCoordinate>>();
        for (Object extensionDefinition : this.extensionManager.getExtensions(ControllerService.class)) {
            String name = extensionDefinition.getImplementationClassName();
            controllerServiceClasses.put(name, this.extensionManager.getBundles(name).stream().map(bundle -> bundle.getBundleDetails().getCoordinate()).collect(Collectors.toSet()));
        }
        this.verifyControllerServicesInSnippet(this.dto, controllerServiceClasses);
        HashSet<String> prioritizerClasses = new HashSet<String>();
        for (ExtensionDefinition extensionDefinition : this.extensionManager.getExtensions(FlowFilePrioritizer.class)) {
            String name = extensionDefinition.getImplementationClassName();
            prioritizerClasses.add(name);
        }
        HashSet<ConnectionDTO> allConns = new HashSet<ConnectionDTO>();
        allConns.addAll(this.dto.getConnections());
        for (ProcessGroupDTO childGroup : this.dto.getProcessGroups()) {
            allConns.addAll(this.findAllConnections(childGroup));
        }
        for (ConnectionDTO conn : allConns) {
            List prioritizers = conn.getPrioritizers();
            if (prioritizers == null) continue;
            for (String prioritizer : prioritizers) {
                if (prioritizerClasses.contains(prioritizer)) continue;
                throw new IllegalStateException("Invalid FlowFile Prioritizer Type: " + prioritizer);
            }
        }
    }

    @Override
    public void instantiate(FlowManager flowManager, FlowController flowController, ProcessGroup group) throws ProcessorInstantiationException {
        this.instantiate(flowManager, flowController, group, true);
    }

    private Set<ConnectionDTO> findAllConnections(ProcessGroupDTO group) {
        HashSet<ConnectionDTO> conns = new HashSet<ConnectionDTO>();
        conns.addAll(group.getContents().getConnections());
        for (ProcessGroupDTO childGroup : group.getContents().getProcessGroups()) {
            conns.addAll(this.findAllConnections(childGroup));
        }
        return conns;
    }

    private void verifyControllerServicesInSnippet(FlowSnippetDTO templateContents, Map<String, Set<BundleCoordinate>> supportedTypes) {
        if (templateContents.getControllerServices() != null) {
            templateContents.getControllerServices().forEach(controllerService -> {
                if (supportedTypes.containsKey(controllerService.getType())) {
                    if (controllerService.getBundle() == null) {
                        throw new IllegalArgumentException("Controller Service bundle must be specified.");
                    }
                } else {
                    throw new IllegalStateException("Invalid Controller Service Type: " + controllerService.getType());
                }
                this.verifyBundleInSnippet(controllerService.getBundle(), (Set)supportedTypes.get(controllerService.getType()));
            });
        }
        if (templateContents.getProcessGroups() != null) {
            templateContents.getProcessGroups().forEach(processGroup -> this.verifyControllerServicesInSnippet(processGroup.getContents(), supportedTypes));
        }
    }

    private void verifyBundleInSnippet(BundleDTO requiredBundle, Set<BundleCoordinate> supportedBundles) {
        BundleCoordinate requiredCoordinate = new BundleCoordinate(requiredBundle.getGroup(), requiredBundle.getArtifact(), requiredBundle.getVersion());
        if (!supportedBundles.contains(requiredCoordinate)) {
            throw new IllegalStateException("Unsupported bundle: " + requiredCoordinate);
        }
    }

    private void verifyProcessorsInSnippet(FlowSnippetDTO templateContents, Map<String, Set<BundleCoordinate>> supportedTypes) {
        if (templateContents.getProcessors() != null) {
            templateContents.getProcessors().forEach(processor -> {
                if (processor.getBundle() == null) {
                    throw new IllegalArgumentException("Processor bundle must be specified.");
                }
                if (!supportedTypes.containsKey(processor.getType())) {
                    throw new IllegalStateException("Invalid Processor Type: " + processor.getType());
                }
                this.verifyBundleInSnippet(processor.getBundle(), (Set)supportedTypes.get(processor.getType()));
            });
        }
        if (templateContents.getProcessGroups() != null) {
            templateContents.getProcessGroups().forEach(processGroup -> this.verifyProcessorsInSnippet(processGroup.getContents(), supportedTypes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(FlowManager flowManager, FlowController flowController, ProcessGroup group, boolean topLevel) {
        String portName;
        BundleCoordinate bundleCoordinate;
        ArrayList<ControllerServiceNode> serviceNodes = new ArrayList<ControllerServiceNode>();
        try {
            ControllerServiceNode serviceNode;
            for (ControllerServiceDTO controllerServiceDTO : this.dto.getControllerServices()) {
                bundleCoordinate = BundleUtils.getBundle(this.extensionManager, controllerServiceDTO.getType(), controllerServiceDTO.getBundle());
                serviceNode = flowManager.createControllerService(controllerServiceDTO.getType(), controllerServiceDTO.getId(), bundleCoordinate, Collections.emptySet(), true, true, null);
                serviceNode.pauseValidationTrigger();
                serviceNodes.add(serviceNode);
                serviceNode.setAnnotationData(controllerServiceDTO.getAnnotationData());
                serviceNode.setComments(controllerServiceDTO.getComments());
                serviceNode.setName(controllerServiceDTO.getName());
                if (!topLevel) {
                    serviceNode.setVersionedComponentId(controllerServiceDTO.getVersionedComponentId());
                }
                group.addControllerService(serviceNode);
            }
            for (ControllerServiceDTO controllerServiceDTO : this.dto.getControllerServices()) {
                String serviceId = controllerServiceDTO.getId();
                serviceNode = flowManager.getControllerServiceNode(serviceId);
                serviceNode.setProperties(controllerServiceDTO.getProperties());
            }
        }
        finally {
            serviceNodes.forEach(ComponentNode::resumeValidationTrigger);
        }
        for (LabelDTO labelDTO : this.dto.getLabels()) {
            Label label = flowManager.createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setPosition(this.toPosition(labelDTO.getPosition()));
            if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
                label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            }
            label.setStyle(labelDTO.getStyle());
            if (labelDTO.getzIndex() != null) {
                label.setZIndex(label.getZIndex());
            }
            if (!topLevel) {
                label.setVersionedComponentId(labelDTO.getVersionedComponentId());
            }
            group.addLabel(label);
        }
        for (FunnelDTO funnelDTO : this.dto.getFunnels()) {
            Funnel funnel = flowManager.createFunnel(funnelDTO.getId());
            funnel.setPosition(this.toPosition(funnelDTO.getPosition()));
            if (!topLevel) {
                funnel.setVersionedComponentId(funnelDTO.getVersionedComponentId());
            }
            group.addFunnel(funnel);
        }
        for (PortDTO portDTO : this.dto.getInputPorts()) {
            Port inputPort;
            if (group.isRootGroup() || Boolean.TRUE.equals(portDTO.getAllowRemoteAccess())) {
                portName = this.generatePublicInputPortName(flowManager, portDTO.getName());
                inputPort = flowManager.createPublicInputPort(portDTO.getId(), portName);
                if (portDTO.getGroupAccessControl() != null) {
                    ((PublicPort)inputPort).setGroupAccessControl(portDTO.getGroupAccessControl());
                }
                if (portDTO.getUserAccessControl() != null) {
                    ((PublicPort)inputPort).setUserAccessControl(portDTO.getUserAccessControl());
                }
            } else {
                inputPort = flowManager.createLocalInputPort(portDTO.getId(), portDTO.getName());
            }
            if (!topLevel) {
                inputPort.setVersionedComponentId(portDTO.getVersionedComponentId());
            }
            inputPort.setPosition(this.toPosition(portDTO.getPosition()));
            inputPort.setProcessGroup(group);
            inputPort.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            inputPort.setComments(portDTO.getComments());
            if (portDTO.getState().equals(ScheduledState.DISABLED.toString())) {
                inputPort.disable();
            }
            group.addInputPort(inputPort);
        }
        for (PortDTO portDTO : this.dto.getOutputPorts()) {
            Port outputPort;
            if (group.isRootGroup() || Boolean.TRUE.equals(portDTO.getAllowRemoteAccess())) {
                portName = this.generatePublicOutputPortName(flowManager, portDTO.getName());
                outputPort = flowManager.createPublicOutputPort(portDTO.getId(), portName);
                if (portDTO.getGroupAccessControl() != null) {
                    ((PublicPort)outputPort).setGroupAccessControl(portDTO.getGroupAccessControl());
                }
                if (portDTO.getUserAccessControl() != null) {
                    ((PublicPort)outputPort).setUserAccessControl(portDTO.getUserAccessControl());
                }
            } else {
                outputPort = flowManager.createLocalOutputPort(portDTO.getId(), portDTO.getName());
            }
            if (!topLevel) {
                outputPort.setVersionedComponentId(portDTO.getVersionedComponentId());
            }
            outputPort.setPosition(this.toPosition(portDTO.getPosition()));
            outputPort.setProcessGroup(group);
            outputPort.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            outputPort.setComments(portDTO.getComments());
            if (portDTO.getState().equals(ScheduledState.DISABLED.toString())) {
                outputPort.disable();
            }
            group.addOutputPort(outputPort);
        }
        for (ProcessorDTO processorDTO : this.dto.getProcessors()) {
            bundleCoordinate = BundleUtils.getBundle(this.extensionManager, processorDTO.getType(), processorDTO.getBundle());
            ProcessorNode procNode = flowManager.createProcessor(processorDTO.getType(), processorDTO.getId(), bundleCoordinate);
            procNode.pauseValidationTrigger();
            try {
                procNode.setPosition(this.toPosition(processorDTO.getPosition()));
                procNode.setProcessGroup(group);
                if (!topLevel) {
                    procNode.setVersionedComponentId(processorDTO.getVersionedComponentId());
                }
                ProcessorConfigDTO config = processorDTO.getConfig();
                procNode.setComments(config.getComments());
                if (config.isLossTolerant() != null) {
                    procNode.setLossTolerant(config.isLossTolerant().booleanValue());
                }
                procNode.setName(processorDTO.getName());
                procNode.setYieldPeriod(config.getYieldDuration());
                procNode.setPenalizationPeriod(config.getPenaltyDuration());
                procNode.setBulletinLevel(LogLevel.valueOf((String)config.getBulletinLevel()));
                procNode.setAnnotationData(config.getAnnotationData());
                procNode.setRetryCount(config.getRetryCount());
                procNode.setRetriedRelationships(config.getRetriedRelationships());
                if (config.getBackoffMechanism() != null) {
                    procNode.setBackoffMechanism(BackoffMechanism.valueOf((String)config.getBackoffMechanism()));
                }
                procNode.setMaxBackoffPeriod(config.getMaxBackoffPeriod());
                procNode.setStyle(processorDTO.getStyle());
                if (config.getRunDurationMillis() != null) {
                    procNode.setRunDuration(config.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
                }
                if (config.getSchedulingStrategy() != null) {
                    procNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)config.getSchedulingStrategy()));
                }
                if (config.getExecutionNode() != null) {
                    procNode.setExecutionNode(ExecutionNode.valueOf((String)config.getExecutionNode()));
                }
                if (processorDTO.getState().equals(ScheduledState.DISABLED.toString())) {
                    procNode.disable();
                }
                procNode.setMaxConcurrentTasks(config.getConcurrentlySchedulableTaskCount().intValue());
                procNode.setScheduldingPeriod(config.getSchedulingPeriod());
                HashSet<Relationship> relationships = new HashSet<Relationship>();
                if (processorDTO.getRelationships() != null) {
                    for (RelationshipDTO rel : processorDTO.getRelationships()) {
                        if (!rel.isAutoTerminate().booleanValue()) continue;
                        relationships.add(procNode.getRelationship(rel.getName()));
                    }
                    procNode.setAutoTerminatedRelationships(relationships);
                }
                group.addProcessor(procNode);
                if (config.getProperties() != null) {
                    procNode.setProperties(config.getProperties());
                }
                StandardProcessContext processContext = new StandardProcessContext(procNode, flowController.getControllerServiceProvider(), flowController.getEncryptor(), flowController.getStateManagerProvider().getStateManager(procNode.getProcessor().getIdentifier()), () -> false, (NodeTypeProvider)flowController);
                procNode.onConfigurationRestored((ProcessContext)processContext);
            }
            finally {
                procNode.resumeValidationTrigger();
            }
        }
        for (RemoteProcessGroupDTO remoteGroupDTO : this.dto.getRemoteProcessGroups()) {
            RemoteProcessGroup remoteGroup = flowManager.createRemoteProcessGroup(remoteGroupDTO.getId(), remoteGroupDTO.getTargetUris());
            remoteGroup.setComments(remoteGroupDTO.getComments());
            remoteGroup.setPosition(this.toPosition(remoteGroupDTO.getPosition()));
            remoteGroup.setCommunicationsTimeout(remoteGroupDTO.getCommunicationsTimeout());
            remoteGroup.setYieldDuration(remoteGroupDTO.getYieldDuration());
            if (!topLevel) {
                remoteGroup.setVersionedComponentId(remoteGroupDTO.getVersionedComponentId());
            }
            if (remoteGroupDTO.getTransportProtocol() == null) {
                remoteGroup.setTransportProtocol(SiteToSiteTransportProtocol.RAW);
            } else {
                remoteGroup.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)remoteGroupDTO.getTransportProtocol()));
            }
            remoteGroup.setProxyHost(remoteGroupDTO.getProxyHost());
            remoteGroup.setProxyPort(remoteGroupDTO.getProxyPort());
            remoteGroup.setProxyUser(remoteGroupDTO.getProxyUser());
            remoteGroup.setProxyPassword(remoteGroupDTO.getProxyPassword());
            remoteGroup.setProcessGroup(group);
            if (remoteGroupDTO.getContents() != null) {
                RemoteProcessGroupContentsDTO contents = remoteGroupDTO.getContents();
                if (contents.getInputPorts() != null) {
                    remoteGroup.setInputPorts(this.convertRemotePort(contents.getInputPorts()), false);
                }
                if (contents.getOutputPorts() != null) {
                    remoteGroup.setOutputPorts(this.convertRemotePort(contents.getOutputPorts()), false);
                }
            }
            group.addRemoteProcessGroup(remoteGroup);
        }
        for (ProcessGroupDTO groupDTO : this.dto.getProcessGroups()) {
            String defaultBackPressureDataSizeThreshold;
            Long defaultBackPressureObjectThreshold;
            String defaultFlowFileExpiration;
            ParameterContext parameterContext;
            ParameterContextReferenceEntity parameterContextReference;
            String outboundPolicyName;
            ProcessGroup childGroup = flowManager.createProcessGroup(groupDTO.getId());
            childGroup.setParent(group);
            childGroup.setPosition(this.toPosition(groupDTO.getPosition()));
            childGroup.setComments(groupDTO.getComments());
            childGroup.setName(groupDTO.getName());
            String flowfileConcurrentName = groupDTO.getFlowfileConcurrency();
            if (flowfileConcurrentName != null) {
                childGroup.setFlowFileConcurrency(FlowFileConcurrency.valueOf((String)flowfileConcurrentName));
            }
            if ((outboundPolicyName = groupDTO.getFlowfileOutboundPolicy()) != null) {
                childGroup.setFlowFileOutboundPolicy(FlowFileOutboundPolicy.valueOf((String)outboundPolicyName));
            }
            if (groupDTO.getVariables() != null) {
                childGroup.setVariables(groupDTO.getVariables());
            }
            if ((parameterContextReference = groupDTO.getParameterContext()) != null && (parameterContext = flowManager.getParameterContextManager().getParameterContext(parameterContextReference.getId())) != null) {
                childGroup.setParameterContext(parameterContext);
            }
            if ((defaultFlowFileExpiration = groupDTO.getDefaultFlowFileExpiration()) != null) {
                childGroup.setDefaultFlowFileExpiration(defaultFlowFileExpiration);
            }
            if ((defaultBackPressureObjectThreshold = groupDTO.getDefaultBackPressureObjectThreshold()) != null) {
                childGroup.setDefaultBackPressureObjectThreshold(defaultBackPressureObjectThreshold);
            }
            if ((defaultBackPressureDataSizeThreshold = groupDTO.getDefaultBackPressureDataSizeThreshold()) != null) {
                childGroup.setDefaultBackPressureDataSizeThreshold(defaultBackPressureDataSizeThreshold);
            }
            if (!topLevel) {
                childGroup.setVersionedComponentId(groupDTO.getVersionedComponentId());
            }
            group.addProcessGroup(childGroup);
            FlowSnippetDTO contents = groupDTO.getContents();
            FlowSnippetDTO childTemplateDTO = new FlowSnippetDTO();
            childTemplateDTO.setConnections(contents.getConnections());
            childTemplateDTO.setInputPorts(contents.getInputPorts());
            childTemplateDTO.setLabels(contents.getLabels());
            childTemplateDTO.setOutputPorts(contents.getOutputPorts());
            childTemplateDTO.setProcessGroups(contents.getProcessGroups());
            childTemplateDTO.setProcessors(contents.getProcessors());
            childTemplateDTO.setFunnels(contents.getFunnels());
            childTemplateDTO.setRemoteProcessGroups(contents.getRemoteProcessGroups());
            childTemplateDTO.setControllerServices(contents.getControllerServices());
            StandardFlowSnippet childSnippet = new StandardFlowSnippet(childTemplateDTO, this.extensionManager);
            childSnippet.instantiate(flowManager, flowController, childGroup, false);
            if (groupDTO.getVersionControlInformation() == null) continue;
            StandardVersionControlInformation vci = StandardVersionControlInformation.Builder.fromDto((VersionControlInformationDTO)groupDTO.getVersionControlInformation()).build();
            childGroup.setVersionControlInformation((VersionControlInformation)vci, Collections.emptyMap());
        }
        for (ConnectionDTO connectionDTO : this.dto.getConnections()) {
            String loadBalanceStrategyName;
            RemoteGroupPort destination;
            RemoteGroupPort source;
            RemoteProcessGroup remoteGroup;
            ConnectableDTO sourceDTO = connectionDTO.getSource();
            ConnectableDTO destinationDTO = connectionDTO.getDestination();
            if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDTO.getType())) {
                remoteGroup = group.getRemoteProcessGroup(sourceDTO.getGroupId());
                source = remoteGroup.getOutputPort(sourceDTO.getId());
            } else {
                ProcessGroup sourceGroup = this.getConnectableParent(group, sourceDTO.getGroupId(), flowManager);
                source = sourceGroup.getConnectable(sourceDTO.getId());
            }
            if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDTO.getType())) {
                remoteGroup = group.getRemoteProcessGroup(destinationDTO.getGroupId());
                destination = remoteGroup.getInputPort(destinationDTO.getId());
            } else {
                ProcessGroup destinationGroup = this.getConnectableParent(group, destinationDTO.getGroupId(), flowManager);
                destination = destinationGroup.getConnectable(destinationDTO.getId());
            }
            HashSet relationships = new HashSet();
            if (connectionDTO.getSelectedRelationships() != null) {
                relationships.addAll(connectionDTO.getSelectedRelationships());
            }
            Connection connection = flowManager.createConnection(connectionDTO.getId(), connectionDTO.getName(), (Connectable)source, (Connectable)destination, relationships);
            if (!topLevel) {
                connection.setVersionedComponentId(connectionDTO.getVersionedComponentId());
            }
            if (connectionDTO.getzIndex() != null) {
                connection.setZIndex(connection.getZIndex());
            }
            if (connectionDTO.getBends() != null) {
                ArrayList<Position> bendPoints = new ArrayList<Position>();
                for (PositionDTO bend : connectionDTO.getBends()) {
                    bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
                }
                connection.setBendPoints(bendPoints);
            }
            FlowFileQueue queue = connection.getFlowFileQueue();
            queue.setBackPressureDataSizeThreshold(connectionDTO.getBackPressureDataSizeThreshold());
            queue.setBackPressureObjectThreshold(connectionDTO.getBackPressureObjectThreshold().longValue());
            queue.setFlowFileExpiration(connectionDTO.getFlowFileExpiration());
            List prioritizers = connectionDTO.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                ArrayList<FlowFilePrioritizer> newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(flowManager.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
                queue.setPriorities(newPrioritizers);
            }
            if ((loadBalanceStrategyName = connectionDTO.getLoadBalanceStrategy()) != null) {
                LoadBalanceStrategy loadBalanceStrategy = LoadBalanceStrategy.valueOf((String)loadBalanceStrategyName);
                String partitioningAttribute = connectionDTO.getLoadBalancePartitionAttribute();
                queue.setLoadBalanceStrategy(loadBalanceStrategy, partitioningAttribute);
            }
            connection.setProcessGroup(group);
            group.addConnection(connection);
        }
    }

    private String generatePublicInputPortName(FlowManager flowManager, String proposedName) {
        Optional existingPort = flowManager.getPublicInputPort(proposedName);
        if (existingPort.isPresent()) {
            return this.generatePublicInputPortName(flowManager, "Copy of " + proposedName);
        }
        return proposedName;
    }

    private String generatePublicOutputPortName(FlowManager flowManager, String proposedName) {
        Optional existingPort = flowManager.getPublicOutputPort(proposedName);
        if (existingPort.isPresent()) {
            return this.generatePublicOutputPortName(flowManager, "Copy of " + proposedName);
        }
        return proposedName;
    }

    private ProcessGroup getConnectableParent(ProcessGroup group, String parentGroupId, FlowManager flowManager) {
        if (flowManager.areGroupsSame(group.getIdentifier(), parentGroupId)) {
            return group;
        }
        return group.getProcessGroup(parentGroupId);
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    private Set<RemoteProcessGroupPortDescriptor> convertRemotePort(Set<RemoteProcessGroupPortDTO> ports) {
        LinkedHashSet<StandardRemoteProcessGroupPortDescriptor> remotePorts = null;
        if (ports != null) {
            remotePorts = new LinkedHashSet<StandardRemoteProcessGroupPortDescriptor>(ports.size());
            for (RemoteProcessGroupPortDTO port : ports) {
                StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
                descriptor.setId(port.getId());
                descriptor.setVersionedComponentId(port.getVersionedComponentId());
                descriptor.setTargetId(port.getTargetId());
                descriptor.setName(port.getName());
                descriptor.setComments(port.getComments());
                descriptor.setTargetRunning(port.isTargetRunning());
                descriptor.setConnected(port.isConnected());
                descriptor.setConcurrentlySchedulableTaskCount(port.getConcurrentlySchedulableTaskCount());
                descriptor.setTransmitting(port.isTransmitting());
                descriptor.setUseCompression(port.getUseCompression());
                BatchSettingsDTO batchSettings = port.getBatchSettings();
                if (batchSettings != null) {
                    descriptor.setBatchCount(batchSettings.getCount());
                    descriptor.setBatchSize(batchSettings.getSize());
                    descriptor.setBatchDuration(batchSettings.getDuration());
                }
                remotePorts.add(descriptor);
            }
        }
        return remotePorts;
    }
}

