/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.queue.AbstractFlowFileQueue;
import org.apache.nifi.controller.queue.ConnectionEventListener;
import org.apache.nifi.controller.queue.DropFlowFileRequest;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueueSize;
import org.apache.nifi.controller.queue.PollStrategy;
import org.apache.nifi.controller.queue.QueueDiagnostics;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.StandardQueueDiagnostics;
import org.apache.nifi.controller.queue.SwappablePriorityQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.status.FlowFileAvailability;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.util.concurrency.TimedLock;

public class StandardFlowFileQueue
extends AbstractFlowFileQueue
implements FlowFileQueue {
    private final SwappablePriorityQueue queue;
    private final ConnectionEventListener eventListener;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final FlowFileSwapManager swapManager;
    private final TimedLock writeLock;

    public StandardFlowFileQueue(String identifier, ConnectionEventListener eventListener, FlowFileRepository flowFileRepo, ProvenanceEventRepository provRepo, ResourceClaimManager resourceClaimManager, ProcessScheduler scheduler, FlowFileSwapManager swapManager, EventReporter eventReporter, int swapThreshold, String expirationPeriod, long defaultBackPressureObjectThreshold, String defaultBackPressureDataSizeThreshold) {
        super(identifier, scheduler, flowFileRepo, provRepo, resourceClaimManager);
        super.setFlowFileExpiration(expirationPeriod);
        this.swapManager = swapManager;
        this.queue = new SwappablePriorityQueue(swapManager, swapThreshold, eventReporter, this, this::drop, null);
        this.eventListener = eventListener;
        this.writeLock = new TimedLock((Lock)this.lock.writeLock(), this.getIdentifier() + " Write Lock", 100);
        this.setBackPressureDataSizeThreshold(defaultBackPressureDataSizeThreshold);
        this.setBackPressureObjectThreshold(defaultBackPressureObjectThreshold);
    }

    public void startLoadBalancing() {
    }

    public void stopLoadBalancing() {
    }

    public void offloadQueue() {
    }

    public void resetOffloadedQueue() {
    }

    public boolean isActivelyLoadBalancing() {
        return false;
    }

    public void setPriorities(List<FlowFilePrioritizer> newPriorities) {
        this.queue.setPriorities(newPriorities);
    }

    public List<FlowFilePrioritizer> getPriorities() {
        return this.queue.getPriorities();
    }

    @Override
    protected List<FlowFileRecord> getListableFlowFiles() {
        return this.queue.getActiveFlowFiles();
    }

    public QueueDiagnostics getQueueDiagnostics() {
        return new StandardQueueDiagnostics(this.queue.getQueueDiagnostics(), Collections.emptyList());
    }

    public void put(FlowFileRecord file) {
        this.queue.put(file);
        this.eventListener.triggerDestinationEvent();
    }

    public void putAll(Collection<FlowFileRecord> files) {
        this.queue.putAll(files);
        this.eventListener.triggerDestinationEvent();
    }

    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        long expirationMillis = this.getFlowFileExpiration(TimeUnit.MILLISECONDS);
        return this.queue.poll(expiredRecords, expirationMillis, pollStrategy);
    }

    public List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        return this.queue.poll(maxResults, expiredRecords, (long)this.getFlowFileExpiration(TimeUnit.MILLISECONDS), pollStrategy);
    }

    public void acknowledge(FlowFileRecord flowFile) {
        this.queue.acknowledge(flowFile);
        this.eventListener.triggerSourceEvent();
    }

    public void acknowledge(Collection<FlowFileRecord> flowFiles) {
        this.queue.acknowledge(flowFiles);
        this.eventListener.triggerSourceEvent();
    }

    public boolean isUnacknowledgedFlowFile() {
        return this.queue.isUnacknowledgedFlowFile();
    }

    public QueueSize size() {
        return this.queue.size();
    }

    public long getTotalQueuedDuration(long fromTimestamp) {
        return this.queue.getTotalQueuedDuration(fromTimestamp);
    }

    public long getMinLastQueueDate() {
        return this.queue.getMinLastQueueDate();
    }

    public boolean isEmpty() {
        return this.queue.getFlowFileQueueSize().isEmpty();
    }

    public FlowFileAvailability getFlowFileAvailability() {
        return this.queue.getFlowFileAvailability();
    }

    public boolean isActiveQueueEmpty() {
        FlowFileQueueSize queueSize = this.queue.getFlowFileQueueSize();
        return queueSize.getActiveCount() == 0 && queueSize.getSwappedCount() == 0;
    }

    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords, PollStrategy pollStrategy) {
        return this.queue.poll(filter, expiredRecords, (long)this.getFlowFileExpiration(TimeUnit.MILLISECONDS), pollStrategy);
    }

    public void purgeSwapFiles() {
        this.swapManager.purge();
    }

    public SwapSummary recoverSwappedFlowFiles() {
        return this.queue.recoverSwappedFlowFiles();
    }

    public String toString() {
        return "FlowFileQueue[id=" + this.getIdentifier() + "]";
    }

    public FlowFileRecord getFlowFile(String flowFileUuid) throws IOException {
        return this.queue.getFlowFile(flowFileUuid);
    }

    @Override
    protected void dropFlowFiles(DropFlowFileRequest dropRequest, String requestor) {
        this.queue.dropFlowFiles(dropRequest, requestor);
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock("external unlock");
    }
}

