/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSerializer;
import org.apache.nifi.controller.serialization.ScheduledStateLookup;
import org.apache.nifi.controller.serialization.VersionedDataflowMapper;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.nar.ExtensionManager;

public class VersionedFlowSerializer
implements FlowSerializer<VersionedDataflow> {
    private static final ObjectMapper JSON_CODEC = new ObjectMapper();
    private final PropertyEncryptor propertyEncryptor;
    private final ExtensionManager extensionManager;

    public VersionedFlowSerializer(PropertyEncryptor propertyEncryptor, ExtensionManager extensionManager) {
        this.propertyEncryptor = propertyEncryptor;
        this.extensionManager = extensionManager;
    }

    @Override
    public VersionedDataflow transform(FlowController controller, ScheduledStateLookup stateLookup) throws FlowSerializationException {
        VersionedDataflowMapper dataflowMapper = new VersionedDataflowMapper(controller, this.extensionManager, arg_0 -> ((PropertyEncryptor)this.propertyEncryptor).encrypt(arg_0), stateLookup);
        VersionedDataflow dataflow = dataflowMapper.createMapping();
        return dataflow;
    }

    @Override
    public void serialize(VersionedDataflow flowConfiguration, OutputStream out) throws FlowSerializationException {
        try {
            JsonFactory factory = new JsonFactory();
            JsonGenerator generator = factory.createGenerator(out);
            generator.setCodec((ObjectCodec)JSON_CODEC);
            generator.writeObject((Object)flowConfiguration);
            generator.flush();
        }
        catch (IOException ioe) {
            throw new FlowSerializationException("Failed to write dataflow", (Throwable)ioe);
        }
    }

    static {
        JSON_CODEC.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JSON_CODEC.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        JSON_CODEC.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(JSON_CODEC.getTypeFactory()));
        JSON_CODEC.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

