/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.reporting.InitializationException;

public class GhostControllerService
implements ControllerService {
    private final String identifier;
    private final String canonicalClassName;

    public GhostControllerService(String identifier, String canonicalClassName) {
        this.identifier = identifier;
        this.canonicalClassName = canonicalClassName;
    }

    public void initialize(ControllerServiceInitializationContext context) throws InitializationException {
    }

    public Collection<ValidationResult> validate(ValidationContext context) {
        return Collections.singleton(new ValidationResult.Builder().input("Any Property").subject("Missing Controller Service").valid(false).explanation("Controller Service is of type " + this.canonicalClassName + ", but this is not a valid Reporting Task type").build());
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return new PropertyDescriptor.Builder().name(propertyName).description(propertyName).required(true).sensitive(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "GhostControllerService[id=" + this.identifier + ", type=" + this.canonicalClassName + "]";
    }
}

