/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.nifi.controller.cluster.ZooKeeperClientConfig;
import org.apache.nifi.controller.state.server.ZooKeeperQuorumX509Util;
import org.apache.nifi.controller.state.server.ZooKeeperServerX509Util;
import org.apache.nifi.util.NiFiProperties;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStateServer
extends ZooKeeperServerMain {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperStateServer.class);
    private static final int MIN_PORT = 1024;
    private static final int MAX_PORT = 65535;
    private static final String ZOOKEEPER_SSL_QUORUM = "sslQuorum";
    private static final String ZOOKEEPER_PORT_UNIFICATION = "portUnification";
    private static final String ZOOKEEPER_SERVER_CNXN_FACTORY = "serverCnxnFactory";
    private final QuorumPeerConfig quorumPeerConfig;
    private volatile boolean started = false;
    private ServerCnxnFactory connectionFactory;
    private FileTxnSnapLog transactionLog;
    private ZooKeeperServer embeddedZkServer;
    private QuorumPeer quorumPeer;
    private DatadirCleanupManager datadirCleanupManager;

    private ZooKeeperStateServer(QuorumPeerConfig config) {
        this.quorumPeerConfig = config;
    }

    final QuorumPeerConfig getQuorumPeerConfig() {
        return this.quorumPeerConfig;
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        if (this.quorumPeerConfig.getPurgeInterval() > 0) {
            this.datadirCleanupManager = new DatadirCleanupManager(this.quorumPeerConfig.getDataDir(), this.quorumPeerConfig.getDataLogDir(), this.quorumPeerConfig.getSnapRetainCount(), this.quorumPeerConfig.getPurgeInterval());
            this.datadirCleanupManager.start();
        }
        if (this.quorumPeerConfig.isDistributed()) {
            this.startDistributed();
        } else {
            this.startStandalone();
        }
        this.started = true;
    }

    private void startStandalone() throws IOException {
        logger.info("Starting Embedded ZooKeeper Server");
        ServerConfig config = new ServerConfig();
        config.readFrom(this.quorumPeerConfig);
        try {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.transactionLog = new FileTxnSnapLog(config.getDataLogDir(), config.getDataDir());
                    break;
                }
                catch (FileTxnSnapLog.DatadirException dde) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            this.embeddedZkServer = new ZooKeeperServer();
            this.embeddedZkServer.setTxnLogFactory(this.transactionLog);
            this.embeddedZkServer.setTickTime(config.getTickTime());
            this.embeddedZkServer.setMinSessionTimeout(config.getMinSessionTimeout());
            this.embeddedZkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            this.connectionFactory = ServerCnxnFactory.createFactory();
            this.connectionFactory.configure(ZooKeeperStateServer.getAvailableSocketAddress(config), config.getMaxClientCnxns(), this.quorumPeerConfig.isSslQuorum());
            this.connectionFactory.startup(this.embeddedZkServer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Embedded ZooKeeper Server interrupted", (Throwable)e);
        }
        catch (IOException ioe) {
            throw new IOException("Failed to start embedded ZooKeeper Server", ioe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start embedded ZooKeeper Server", e);
        }
    }

    private void startDistributed() throws IOException {
        logger.info("Starting Embedded ZooKeeper Peer");
        try {
            this.transactionLog = new FileTxnSnapLog(this.quorumPeerConfig.getDataLogDir(), this.quorumPeerConfig.getDataDir());
            this.connectionFactory = ServerCnxnFactory.createFactory();
            this.connectionFactory.configure(ZooKeeperStateServer.getAvailableSocketAddress(this.quorumPeerConfig), this.quorumPeerConfig.getMaxClientCnxns(), this.quorumPeerConfig.isSslQuorum());
            this.quorumPeer = new QuorumPeer();
            if (this.quorumPeerConfig.isSslQuorum()) {
                this.quorumPeer.setSecureCnxnFactory(this.connectionFactory);
            } else {
                this.quorumPeer.setCnxnFactory(this.connectionFactory);
            }
            this.quorumPeer.setTxnFactory(new FileTxnSnapLog(this.quorumPeerConfig.getDataLogDir(), this.quorumPeerConfig.getDataDir()));
            this.quorumPeer.setElectionType(this.quorumPeerConfig.getElectionAlg());
            this.quorumPeer.setMyid(this.quorumPeerConfig.getServerId());
            this.quorumPeer.setTickTime(this.quorumPeerConfig.getTickTime());
            this.quorumPeer.setMinSessionTimeout(this.quorumPeerConfig.getMinSessionTimeout());
            this.quorumPeer.setMaxSessionTimeout(this.quorumPeerConfig.getMaxSessionTimeout());
            this.quorumPeer.setInitLimit(this.quorumPeerConfig.getInitLimit());
            this.quorumPeer.setSyncLimit(this.quorumPeerConfig.getSyncLimit());
            this.quorumPeer.setQuorumVerifier(this.quorumPeerConfig.getQuorumVerifier(), false);
            this.quorumPeer.setZKDatabase(new ZKDatabase(this.quorumPeer.getTxnFactory()));
            this.quorumPeer.setLearnerType(this.quorumPeerConfig.getPeerType());
            this.quorumPeer.setSyncEnabled(this.quorumPeerConfig.getSyncEnabled());
            this.quorumPeer.setQuorumListenOnAllIPs(this.quorumPeerConfig.getQuorumListenOnAllIPs().booleanValue());
            this.quorumPeer.setSslQuorum(this.quorumPeerConfig.isSslQuorum());
            this.quorumPeer.start();
        }
        catch (IOException ioe) {
            throw new IOException("Failed to start embedded ZooKeeper Peer", ioe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start embedded ZooKeeper Peer", e);
        }
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.started = false;
            if (this.quorumPeer != null && this.quorumPeer.isRunning()) {
                this.quorumPeer.shutdown();
            }
            if (this.connectionFactory != null) {
                try {
                    this.connectionFactory.shutdown();
                }
                catch (Exception e) {
                    logger.warn("Failed to shutdown Connection Factory", (Throwable)e);
                }
            }
            if (this.embeddedZkServer != null && this.embeddedZkServer.isRunning()) {
                try {
                    this.embeddedZkServer.shutdown();
                }
                catch (Exception e) {
                    logger.warn("Failed to shutdown Embedded Zookeeper", (Throwable)e);
                }
            }
            if (this.transactionLog != null) {
                try {
                    this.transactionLog.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close Transaction Log", (Throwable)ioe);
                }
            }
            if (this.datadirCleanupManager != null) {
                this.datadirCleanupManager.shutdown();
            }
        }
    }

    public static ZooKeeperStateServer create(NiFiProperties properties) throws IOException, QuorumPeerConfig.ConfigException {
        File propsFile = properties.getEmbeddedZooKeeperPropertiesFile();
        if (propsFile == null) {
            return null;
        }
        if (!propsFile.exists() || !propsFile.canRead()) {
            throw new IOException("Cannot create Embedded ZooKeeper Server because the Properties File " + propsFile.getAbsolutePath() + " referenced in nifi.properties does not exist or cannot be read");
        }
        Properties zkProperties = new Properties();
        try (FileInputStream fis = new FileInputStream(propsFile);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            zkProperties.load(bis);
        }
        return new ZooKeeperStateServer(ZooKeeperStateServer.reconcileProperties(properties, zkProperties));
    }

    private static QuorumPeerConfig reconcileProperties(NiFiProperties niFiProperties, Properties zkProperties) throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig peerConfig = new QuorumPeerConfig();
        peerConfig.parseProperties(zkProperties);
        boolean niFiConfigIsSecure = ZooKeeperStateServer.isNiFiConfigSecureForZooKeeper(niFiProperties);
        boolean zooKeeperConfigIsSecure = ZooKeeperStateServer.isZooKeeperConfigSecure(peerConfig);
        if (!zooKeeperConfigIsSecure && !niFiConfigIsSecure) {
            logger.debug("{} property is set to false or is not present, and zookeeper.properties file does not contain secureClientPort property, so embedded ZooKeeper will be started without TLS", (Object)"nifi.zookeeper.client.secure");
            return peerConfig;
        }
        if (zooKeeperConfigIsSecure && !niFiConfigIsSecure) {
            throw new QuorumPeerConfig.ConfigException(String.format("ZooKeeper properties file %s was configured to be secure but there was no valid TLS config present in nifi.properties or nifi.zookeeper.client.secure was set to false. Check the administration guide", niFiProperties.getProperty("nifi.state.management.embedded.zookeeper.properties")));
        }
        ZooKeeperStateServer.ensureOnlySecurePortsAreEnabled(peerConfig, zkProperties);
        ZooKeeperStateServer.setTlsProperties(zkProperties, new ZooKeeperServerX509Util(), niFiProperties);
        ZooKeeperStateServer.setTlsProperties(zkProperties, new ZooKeeperQuorumX509Util(), niFiProperties);
        zkProperties.setProperty("secureClientPort", ZooKeeperStateServer.getSecurePort(peerConfig));
        zkProperties.setProperty(ZOOKEEPER_SERVER_CNXN_FACTORY, NettyServerCnxnFactory.class.getName());
        zkProperties.setProperty(ZOOKEEPER_SSL_QUORUM, Boolean.TRUE.toString());
        zkProperties.setProperty(ZOOKEEPER_PORT_UNIFICATION, Boolean.FALSE.toString());
        peerConfig = new QuorumPeerConfig();
        peerConfig.parseProperties(zkProperties);
        return peerConfig;
    }

    private static boolean isZooKeeperConfigSecure(QuorumPeerConfig peerConfig) throws QuorumPeerConfig.ConfigException {
        InetSocketAddress secureAddress = peerConfig.getSecureClientPortAddress();
        InetSocketAddress insecureAddress = peerConfig.getClientPortAddress();
        if (secureAddress == null && insecureAddress == null) {
            throw new QuorumPeerConfig.ConfigException("No clientAddress or secureClientAddress is set in zookeeper.properties");
        }
        return secureAddress != null;
    }

    private static boolean isNiFiConfigSecureForZooKeeper(NiFiProperties niFiProperties) throws QuorumPeerConfig.ConfigException {
        boolean isTlsConfigPresent = niFiProperties.isZooKeeperTlsConfigurationPresent() || niFiProperties.isTlsConfigurationPresent();
        boolean isZooKeeperClientSecure = niFiProperties.isZooKeeperClientSecure();
        if (isZooKeeperClientSecure && !isTlsConfigPresent) {
            throw new QuorumPeerConfig.ConfigException(String.format("%s is true but no TLS configuration is present in nifi.properties", "nifi.zookeeper.client.secure"));
        }
        return isZooKeeperClientSecure && isTlsConfigPresent;
    }

    private static void ensureOnlySecurePortsAreEnabled(QuorumPeerConfig config, Properties zkProperties) {
        InetSocketAddress clientPort = config.getClientPortAddress();
        InetSocketAddress secureClientPort = config.getSecureClientPortAddress();
        if (clientPort != null && secureClientPort != null) {
            zkProperties.remove("clientPort");
            zkProperties.remove("clientPortAddress");
            logger.warn("Invalid configuration was detected: A secure NiFi with an embedded ZooKeeper was configured for insecure connections. Insecure ports have been removed from embedded ZooKeeper configuration to deactivate insecure connections");
        }
    }

    private static void setTlsProperties(Properties zooKeeperProperties, X509Util zooKeeperUtil, NiFiProperties niFiProperties) {
        zooKeeperProperties.setProperty(zooKeeperUtil.getSslKeystoreLocationProperty(), ZooKeeperClientConfig.getPreferredProperty(niFiProperties, "nifi.zookeeper.security.keystore", "nifi.security.keystore"));
        zooKeeperProperties.setProperty(zooKeeperUtil.getSslKeystorePasswdProperty(), ZooKeeperClientConfig.getPreferredProperty(niFiProperties, "nifi.zookeeper.security.keystorePasswd", "nifi.security.keystorePasswd"));
        zooKeeperProperties.setProperty(zooKeeperUtil.getSslKeystoreTypeProperty(), ZooKeeperClientConfig.getPreferredProperty(niFiProperties, "nifi.zookeeper.security.keystoreType", "nifi.security.keystoreType"));
        zooKeeperProperties.setProperty(zooKeeperUtil.getSslTruststoreLocationProperty(), ZooKeeperClientConfig.getPreferredProperty(niFiProperties, "nifi.zookeeper.security.truststore", "nifi.security.truststore"));
        zooKeeperProperties.setProperty(zooKeeperUtil.getSslTruststorePasswdProperty(), ZooKeeperClientConfig.getPreferredProperty(niFiProperties, "nifi.zookeeper.security.truststorePasswd", "nifi.security.truststorePasswd"));
        zooKeeperProperties.setProperty(zooKeeperUtil.getSslTruststoreTypeProperty(), ZooKeeperClientConfig.getPreferredProperty(niFiProperties, "nifi.zookeeper.security.truststoreType", "nifi.security.truststoreType"));
    }

    private static String getSecurePort(QuorumPeerConfig peerConfig) throws QuorumPeerConfig.ConfigException {
        InetSocketAddress secureClientAddress = peerConfig.getSecureClientPortAddress();
        String secureClientPort = null;
        if (secureClientAddress != null && secureClientAddress.getPort() >= 1024 && secureClientAddress.getPort() <= 65535) {
            secureClientPort = String.valueOf(secureClientAddress.getPort());
            if (logger.isDebugEnabled()) {
                logger.debug("Secure client port retrieved from ZooKeeper configuration: {}", (Object)secureClientPort);
            }
            return secureClientPort;
        }
        throw new QuorumPeerConfig.ConfigException(String.format("NiFi was configured to be secure but secureClientPort could not be retrieved from zookeeper.properties file or it was not in valid port range %d - %d", 1024, 65535));
    }

    private static InetSocketAddress getAvailableSocketAddress(ServerConfig config) {
        return config.getSecureClientPortAddress() != null ? config.getSecureClientPortAddress() : config.getClientPortAddress();
    }

    private static InetSocketAddress getAvailableSocketAddress(QuorumPeerConfig quorumConfig) {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(quorumConfig);
        return ZooKeeperStateServer.getAvailableSocketAddress(serverConfig);
    }
}

