/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.extension.manifest.ExtensionManifest;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.manifest.RuntimeManifestService;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.runtime.manifest.RuntimeManifestBuilder;
import org.apache.nifi.runtime.manifest.impl.SchedulingDefaultsFactory;
import org.apache.nifi.runtime.manifest.impl.StandardRuntimeManifestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRuntimeManifestService
implements RuntimeManifestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardRuntimeManifestService.class);
    private static final String RUNTIME_MANIFEST_IDENTIFIER = "nifi";
    private static final String RUNTIME_TYPE = "nifi";
    private final ExtensionManager extensionManager;
    private final ExtensionManifestParser extensionManifestParser;

    public StandardRuntimeManifestService(ExtensionManager extensionManager, ExtensionManifestParser extensionManifestParser) {
        this.extensionManager = extensionManager;
        this.extensionManifestParser = extensionManifestParser;
    }

    public RuntimeManifest getManifest() {
        Set allBundles = this.extensionManager.getAllBundles();
        Bundle frameworkBundle = this.getFrameworkBundle();
        BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
        Date frameworkBuildDate = frameworkDetails.getBuildTimestampDate();
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setVersion(frameworkDetails.getCoordinate().getVersion());
        buildInfo.setRevision(frameworkDetails.getBuildRevision());
        buildInfo.setCompiler(frameworkDetails.getBuildJdk());
        buildInfo.setTimestamp(frameworkBuildDate == null ? null : Long.valueOf(frameworkBuildDate.getTime()));
        RuntimeManifestBuilder manifestBuilder = new StandardRuntimeManifestBuilder().identifier("nifi").runtimeType("nifi").version(buildInfo.getVersion()).schedulingDefaults(SchedulingDefaultsFactory.getNifiSchedulingDefaults()).buildInfo(buildInfo);
        for (Bundle bundle : allBundles) {
            this.getExtensionManifest(bundle).ifPresent(em -> manifestBuilder.addBundle(em));
        }
        return manifestBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ExtensionManifest> getExtensionManifest(Bundle bundle) {
        BundleDetails bundleDetails = bundle.getBundleDetails();
        File manifestFile = new File(bundleDetails.getWorkingDirectory(), "META-INF/docs/extension-manifest.xml");
        if (!manifestFile.exists()) {
            LOGGER.warn("Unable to find extension manifest for [{}] at [{}]...", (Object)bundleDetails.getCoordinate(), (Object)manifestFile.getAbsolutePath());
            return Optional.empty();
        }
        try (FileInputStream inputStream = new FileInputStream(manifestFile);){
            ExtensionManifest extensionManifest = this.extensionManifestParser.parse((InputStream)inputStream);
            extensionManifest.setGroupId(bundleDetails.getCoordinate().getGroup());
            extensionManifest.setArtifactId(bundleDetails.getCoordinate().getId());
            extensionManifest.setVersion(bundleDetails.getCoordinate().getVersion());
            Optional<ExtensionManifest> optional = Optional.of(extensionManifest);
            return optional;
        }
        catch (IOException e) {
            LOGGER.error("Unable to load extension manifest for bundle [{}]", (Object)bundleDetails.getCoordinate(), (Object)e);
            return Optional.empty();
        }
    }

    Bundle getFrameworkBundle() {
        return NarClassLoadersHolder.getInstance().getFrameworkBundle();
    }
}

