/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSerializationStrategy;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.XmlFlowSynchronizer;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSerializer;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.StandardFlowSerializer;
import org.apache.nifi.controller.serialization.StandardFlowSynchronizer;
import org.apache.nifi.controller.serialization.VersionedFlowSerializer;
import org.apache.nifi.controller.serialization.VersionedFlowSynchronizer;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.groups.BundleUpdateStrategy;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.persistence.FlowConfigurationArchiveManager;
import org.apache.nifi.persistence.FlowConfigurationDAO;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class StandardFlowConfigurationDAO
implements FlowConfigurationDAO {
    private static final Logger LOG = LoggerFactory.getLogger(StandardFlowConfigurationDAO.class);
    private static final String CLUSTER_FLOW_SERIALIZATION_FORMAT = "nifi.cluster.flow.serialization.format";
    private static final String FLOW_SERIALIZATION_FORMAT_XML = "XML";
    private final File xmlFile;
    private final File jsonFile;
    private final PropertyEncryptor encryptor;
    private final FlowConfigurationArchiveManager archiveManager;
    private final NiFiProperties nifiProperties;
    private final ExtensionManager extensionManager;
    private volatile boolean jsonFileExists;
    private final String clusterFlowSerializationFormat;
    private final FlowSerializationStrategy serializationStrategy;

    public StandardFlowConfigurationDAO(PropertyEncryptor encryptor, NiFiProperties nifiProperties, ExtensionManager extensionManager, FlowSerializationStrategy serializationStrategy) throws IOException {
        this.nifiProperties = nifiProperties;
        this.clusterFlowSerializationFormat = nifiProperties.getProperty(CLUSTER_FLOW_SERIALIZATION_FORMAT);
        this.serializationStrategy = serializationStrategy;
        this.xmlFile = nifiProperties.getFlowConfigurationFile();
        this.jsonFile = nifiProperties.getFlowConfigurationJsonFile();
        boolean bl = this.jsonFileExists = this.jsonFile.length() > 0L;
        if (!this.jsonFile.exists()) {
            if (!this.jsonFile.getParentFile().exists()) {
                Files.createDirectories(this.jsonFile.getParentFile().toPath(), new FileAttribute[0]);
            }
        } else if (!this.jsonFile.canRead() || !this.jsonFile.canWrite()) {
            throw new IOException(this.jsonFile + " exists but you have insufficient read/write privileges");
        }
        this.encryptor = encryptor;
        this.extensionManager = extensionManager;
        this.archiveManager = new FlowConfigurationArchiveManager(nifiProperties);
    }

    @Override
    public boolean isFlowPresent() {
        return this.getReadableFile() != null;
    }

    @Override
    public synchronized void load(FlowController controller, DataFlow dataFlow, FlowService flowService, BundleUpdateStrategy bundleUpdateStrategy) throws IOException, FlowSerializationException, FlowSynchronizationException, UninheritableFlowException, MissingBundleException {
        VersionedFlowSynchronizer versionedFlowSynchronizer = new VersionedFlowSynchronizer(this.encryptor, this.extensionManager, this.nifiProperties.getFlowConfigurationJsonFile(), this.archiveManager);
        XmlFlowSynchronizer xmlFlowSynchronizer = new XmlFlowSynchronizer(this.encryptor, this.nifiProperties, this.extensionManager);
        StandardFlowSynchronizer standardFlowSynchronizer = new StandardFlowSynchronizer(xmlFlowSynchronizer, versionedFlowSynchronizer);
        controller.synchronize(standardFlowSynchronizer, dataFlow, flowService, bundleUpdateStrategy);
        if (StandardFlowSynchronizer.isFlowEmpty(dataFlow)) {
            this.save(controller, true);
        }
    }

    private File getReadableFile() {
        if (this.jsonFileExists) {
            return this.jsonFile;
        }
        if (this.xmlFile.length() > 0L) {
            return this.xmlFile;
        }
        return null;
    }

    @Override
    public synchronized void load(OutputStream os) throws IOException {
        File file = this.getReadableFile();
        if (file == null) {
            return;
        }
        try (FileInputStream inStream = new FileInputStream(file);
             GZIPInputStream gzipIn = new GZIPInputStream(inStream);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)os);
        }
    }

    @Override
    public void load(OutputStream os, boolean compressed) throws IOException {
        File file = this.getReadableFile();
        if (file == null) {
            return;
        }
        if (compressed) {
            Files.copy(file.toPath(), os);
        } else {
            this.load(os);
        }
    }

    @Override
    public void save(FlowController controller) throws IOException {
        LOG.trace("Saving flow to disk");
        this.save(controller, true);
        this.jsonFileExists = true;
        LOG.debug("Finished saving flow to disk");
    }

    @Override
    public synchronized void save(FlowController controller, OutputStream os) throws IOException {
        try {
            FlowSerializer<Document> serializer = FLOW_SERIALIZATION_FORMAT_XML.equalsIgnoreCase(this.clusterFlowSerializationFormat) ? new StandardFlowSerializer(this.encryptor) : new VersionedFlowSerializer(this.encryptor, this.extensionManager);
            controller.serialize(serializer, os);
        }
        catch (FlowSerializationException fse) {
            throw new IOException(fse);
        }
    }

    @Override
    public synchronized void save(FlowController controller, boolean archive) throws IOException {
        if (null == controller) {
            throw new NullPointerException();
        }
        if (this.serializationStrategy.writesJson()) {
            this.saveJson(controller, archive);
        }
        if (this.serializationStrategy.writesXml()) {
            this.saveXml(controller, archive);
        }
    }

    private void saveJson(FlowController controller, boolean archive) throws IOException {
        VersionedFlowSerializer serializer = new VersionedFlowSerializer(controller.getEncryptor(), controller.getExtensionManager());
        this.saveFlow(controller, serializer, this.jsonFile, archive);
        this.jsonFileExists = true;
    }

    private void saveXml(FlowController controller, boolean archive) throws IOException {
        StandardFlowSerializer serializer = new StandardFlowSerializer(controller.getEncryptor());
        this.saveFlow(controller, serializer, this.xmlFile, archive);
    }

    private void saveFlow(FlowController controller, FlowSerializer<?> serializer, File file, boolean archive) throws IOException {
        block9: {
            File tempFile = new File(file.getParentFile(), file.getName() + ".temp.gz");
            try {
                this.serializeControllerStateToTempFile(controller, serializer, tempFile);
                Files.deleteIfExists(file.toPath());
                FileUtils.renameFile((File)tempFile, (File)file, (int)5, (boolean)true);
            }
            catch (FlowSerializationException fse) {
                throw new IOException(fse);
            }
            finally {
                Files.deleteIfExists(tempFile.toPath());
            }
            if (archive) {
                try {
                    this.archiveManager.archive(file);
                }
                catch (Exception ex) {
                    LOG.error("Unable to archive flow configuration as requested due to " + ex);
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.error("", (Throwable)ex);
                }
            }
        }
    }

    private void serializeControllerStateToTempFile(FlowController controller, FlowSerializer<?> serializer, File tempFile) throws IOException {
        try (FileOutputStream fileOut = new FileOutputStream(tempFile);
             GZIPOutputStream outStream = new GZIPOutputStream(fileOut);){
            controller.serialize(serializer, outStream);
        }
    }
}

