/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.c2.C2NiFiProperties;
import org.apache.nifi.c2.client.C2ClientConfig;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.http.C2HttpClient;
import org.apache.nifi.c2.client.service.C2ClientService;
import org.apache.nifi.c2.client.service.C2HeartbeatFactory;
import org.apache.nifi.c2.client.service.FlowIdHolder;
import org.apache.nifi.c2.client.service.model.RuntimeInfoWrapper;
import org.apache.nifi.c2.client.service.operation.C2OperationService;
import org.apache.nifi.c2.client.service.operation.UpdateConfigurationOperationHandler;
import org.apache.nifi.c2.protocol.api.AgentRepositories;
import org.apache.nifi.c2.protocol.api.AgentRepositoryStatus;
import org.apache.nifi.c2.protocol.api.FlowQueueStatus;
import org.apache.nifi.c2.serializer.C2JacksonSerializer;
import org.apache.nifi.c2.serializer.C2Serializer;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.extension.manifest.parser.jaxb.JAXBExtensionManifestParser;
import org.apache.nifi.manifest.RuntimeManifestService;
import org.apache.nifi.manifest.StandardRuntimeManifestService;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2NifiClientService {
    private static final Logger logger = LoggerFactory.getLogger(C2NifiClientService.class);
    private static final String DEFAULT_CONF_DIR = "./conf";
    private static final String TARGET_CONFIG_FILE = "/config-new.yml";
    private static final String ROOT_GROUP_ID = "root";
    private static final Long INITIAL_DELAY = 10000L;
    private static final Integer TERMINATION_WAIT = 5000;
    private final C2ClientService c2ClientService;
    private final FlowController flowController;
    private final String propertiesDir;
    private final ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private final ExtensionManifestParser extensionManifestParser = new JAXBExtensionManifestParser();
    private final RuntimeManifestService runtimeManifestService;
    private final long heartbeatPeriod;

    public C2NifiClientService(NiFiProperties niFiProperties, FlowController flowController) {
        C2ClientConfig clientConfig = this.generateClientConfig(niFiProperties);
        FlowIdHolder flowIdHolder = new FlowIdHolder(clientConfig.getConfDirectory());
        this.propertiesDir = niFiProperties.getProperty("nifi.properties.file.path", null);
        this.runtimeManifestService = new StandardRuntimeManifestService(ExtensionManagerHolder.getExtensionManager(), this.extensionManifestParser, clientConfig.getRuntimeManifestIdentifier(), clientConfig.getRuntimeType());
        this.heartbeatPeriod = clientConfig.getHeartbeatPeriod();
        this.flowController = flowController;
        C2HttpClient client = new C2HttpClient(clientConfig, (C2Serializer)new C2JacksonSerializer());
        this.c2ClientService = new C2ClientService((C2Client)client, new C2HeartbeatFactory(clientConfig, flowIdHolder), new C2OperationService(Arrays.asList(new UpdateConfigurationOperationHandler((C2Client)client, flowIdHolder, this::updateFlowContent))));
    }

    private C2ClientConfig generateClientConfig(NiFiProperties properties) {
        return new C2ClientConfig.Builder().agentClass(properties.getProperty("c2.agent.class", "")).agentIdentifier(properties.getProperty("c2.agent.identifier")).heartbeatPeriod(Long.parseLong(properties.getProperty("c2.agent.heartbeat.period", String.valueOf(C2NiFiProperties.C2_AGENT_DEFAULT_HEARTBEAT_PERIOD)))).connectTimeout((long)FormatUtils.getPreciseTimeDuration((String)properties.getProperty("c2.rest.connectionTimeout", "5 sec"), (TimeUnit)TimeUnit.MILLISECONDS)).readTimeout((long)FormatUtils.getPreciseTimeDuration((String)properties.getProperty("c2.rest.readTimeout", "5 sec"), (TimeUnit)TimeUnit.MILLISECONDS)).callTimeout((long)FormatUtils.getPreciseTimeDuration((String)properties.getProperty("c2.rest.callTimeout", "10 sec"), (TimeUnit)TimeUnit.MILLISECONDS)).c2Url(properties.getProperty("c2.rest.url", "")).confDirectory(properties.getProperty("c2.config.directory", DEFAULT_CONF_DIR)).runtimeManifestIdentifier(properties.getProperty("c2.runtime.manifest.identifier", "")).runtimeType(properties.getProperty("c2.runtime.type", "")).c2AckUrl(properties.getProperty("c2.rest.url.ack", "")).truststoreFilename(properties.getProperty("c2.security.truststore.location", "")).truststorePassword(properties.getProperty("c2.security.truststore.password", "")).truststoreType(properties.getProperty("c2.security.truststore.type", "JKS")).keystoreFilename(properties.getProperty("c2.security.keystore.location", "")).keystorePassword(properties.getProperty("c2.security.keystore.password", "")).keystoreType(properties.getProperty("c2.security.keystore.type", "JKS")).build();
    }

    public void start() {
        try {
            this.scheduledExecutorService.scheduleAtFixedRate(() -> this.c2ClientService.sendHeartbeat(this.generateRuntimeInfo()), INITIAL_DELAY, this.heartbeatPeriod, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("Could not start C2 Client Heartbeat Reporting", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService.awaitTermination(TERMINATION_WAIT.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignore) {
            logger.info("Stopping C2 Client's thread was interrupted but shutting down anyway the C2NifiClientService");
        }
    }

    private RuntimeInfoWrapper generateRuntimeInfo() {
        return new RuntimeInfoWrapper(this.getAgentRepositories(), this.runtimeManifestService.getManifest(), this.getQueueStatus());
    }

    private AgentRepositories getAgentRepositories() {
        SystemDiagnostics systemDiagnostics = this.flowController.getSystemDiagnostics();
        AgentRepositories repos = new AgentRepositories();
        AgentRepositoryStatus flowFileRepoStatus = new AgentRepositoryStatus();
        StorageUsage ffRepoStorageUsage = systemDiagnostics.getFlowFileRepositoryStorageUsage();
        flowFileRepoStatus.setDataSize(Long.valueOf(ffRepoStorageUsage.getUsedSpace()));
        flowFileRepoStatus.setDataSizeMax(Long.valueOf(ffRepoStorageUsage.getTotalSpace()));
        repos.setFlowFile(flowFileRepoStatus);
        AgentRepositoryStatus provRepoStatus = new AgentRepositoryStatus();
        Iterator provRepoStorageUsages = systemDiagnostics.getProvenanceRepositoryStorageUsage().entrySet().iterator();
        if (provRepoStorageUsages.hasNext()) {
            StorageUsage provRepoStorageUsage = (StorageUsage)provRepoStorageUsages.next().getValue();
            provRepoStatus.setDataSize(Long.valueOf(provRepoStorageUsage.getUsedSpace()));
            provRepoStatus.setDataSizeMax(Long.valueOf(provRepoStorageUsage.getTotalSpace()));
        }
        repos.setProvenance(provRepoStatus);
        return repos;
    }

    private Map<String, FlowQueueStatus> getQueueStatus() {
        ProcessGroupStatus rootProcessGroupStatus = this.flowController.getEventAccess().getGroupStatus(ROOT_GROUP_ID);
        Collection connectionStatuses = rootProcessGroupStatus.getConnectionStatus();
        HashMap<String, FlowQueueStatus> processGroupStatus = new HashMap<String, FlowQueueStatus>();
        for (ConnectionStatus connectionStatus : connectionStatuses) {
            FlowQueueStatus flowQueueStatus = new FlowQueueStatus();
            flowQueueStatus.setSize(Long.valueOf(connectionStatus.getQueuedCount()));
            flowQueueStatus.setSizeMax(Long.valueOf(connectionStatus.getBackPressureObjectThreshold()));
            flowQueueStatus.setDataSize(Long.valueOf(connectionStatus.getQueuedBytes()));
            flowQueueStatus.setDataSizeMax(Long.valueOf(connectionStatus.getBackPressureBytesThreshold()));
            processGroupStatus.put(connectionStatus.getId(), flowQueueStatus);
        }
        return processGroupStatus;
    }

    private boolean updateFlowContent(byte[] updateContent) {
        logger.debug("Update content: \n{}", (Object)new String(updateContent, StandardCharsets.UTF_8));
        Path path = this.getTargetConfigFile().toPath();
        try {
            Files.write(this.getTargetConfigFile().toPath(), updateContent, new OpenOption[0]);
            logger.info("Updated configuration was written to: {}", (Object)path);
            return true;
        }
        catch (IOException e) {
            logger.error("Configuration update failed. File creation was not successful targeting: {}", (Object)path, (Object)e);
            return false;
        }
    }

    private File getTargetConfigFile() {
        return Optional.ofNullable(this.propertiesDir).map(File::new).map(File::getParent).map(parentDir -> new File(parentDir + TARGET_CONFIG_FILE)).orElse(new File("./conf/config-new.yml"));
    }
}

