/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.flow.VersionedFlowEncodingVersion;
import org.apache.nifi.controller.flow.VersionedRegistry;
import org.apache.nifi.controller.flow.VersionedTemplate;
import org.apache.nifi.controller.serialization.ScheduledStateLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.mapping.ComponentIdLookup;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.registry.flow.mapping.SensitiveValueEncryptor;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class VersionedDataflowMapper {
    private static final VersionedFlowEncodingVersion ENCODING_VERSION = new VersionedFlowEncodingVersion(2, 0);
    private final FlowController flowController;
    private final NiFiRegistryFlowMapper flowMapper;
    private final ScheduledStateLookup stateLookup;

    public VersionedDataflowMapper(FlowController flowController, ExtensionManager extensionManager, SensitiveValueEncryptor encryptor, ScheduledStateLookup stateLookup) {
        this.flowController = flowController;
        this.stateLookup = stateLookup;
        VersionedComponentStateLookup versionedComponentStateLookup = this.createStateLookup();
        FlowMappingOptions mappingOptions = new FlowMappingOptions.Builder().mapSensitiveConfiguration(true).mapPropertyDescriptors(false).stateLookup(versionedComponentStateLookup).sensitiveValueEncryptor(encryptor).componentIdLookup(ComponentIdLookup.VERSIONED_OR_GENERATE).mapInstanceIdentifiers(true).mapControllerServiceReferencesToVersionedId(false).build();
        this.flowMapper = new NiFiRegistryFlowMapper(extensionManager, mappingOptions);
    }

    public VersionedDataflow createMapping() {
        VersionedDataflow dataflow = new VersionedDataflow();
        dataflow.setEncodingVersion(ENCODING_VERSION);
        dataflow.setMaxTimerDrivenThreadCount(this.flowController.getMaxTimerDrivenThreadCount());
        dataflow.setControllerServices(this.mapControllerServices());
        dataflow.setParameterContexts(this.mapParameterContexts());
        dataflow.setRegistries(this.mapRegistries());
        dataflow.setReportingTasks(this.mapReportingTasks());
        dataflow.setRootGroup(this.mapRootGroup());
        dataflow.setTemplates(this.mapTemplates());
        return dataflow;
    }

    private List<VersionedControllerService> mapControllerServices() {
        ArrayList<VersionedControllerService> controllerServices = new ArrayList<VersionedControllerService>();
        for (ControllerServiceNode serviceNode : this.flowController.getFlowManager().getRootControllerServices()) {
            VersionedControllerService versionedControllerService = this.flowMapper.mapControllerService(serviceNode, this.flowController.getControllerServiceProvider(), Collections.emptySet(), Collections.emptyMap());
            controllerServices.add(versionedControllerService);
        }
        return controllerServices;
    }

    private List<VersionedParameterContext> mapParameterContexts() {
        ArrayList<VersionedParameterContext> parameterContexts = new ArrayList<VersionedParameterContext>();
        for (ParameterContext parameterContext : this.flowController.getFlowManager().getParameterContextManager().getParameterContexts()) {
            VersionedParameterContext versionedParameterContext = this.flowMapper.mapParameterContext(parameterContext);
            parameterContexts.add(versionedParameterContext);
        }
        return parameterContexts;
    }

    private List<VersionedRegistry> mapRegistries() {
        ArrayList<VersionedRegistry> registries = new ArrayList<VersionedRegistry>();
        FlowRegistryClient flowRegistryClient = this.flowController.getFlowRegistryClient();
        for (String registryId : flowRegistryClient.getRegistryIdentifiers()) {
            FlowRegistry flowRegistry = flowRegistryClient.getFlowRegistry(registryId);
            VersionedRegistry versionedRegistry = this.mapRegistry(flowRegistry);
            registries.add(versionedRegistry);
        }
        return registries;
    }

    private VersionedRegistry mapRegistry(FlowRegistry flowRegistry) {
        VersionedRegistry versionedRegistry = new VersionedRegistry();
        versionedRegistry.setDescription(flowRegistry.getDescription());
        versionedRegistry.setId(flowRegistry.getIdentifier());
        versionedRegistry.setName(flowRegistry.getName());
        versionedRegistry.setUrl(flowRegistry.getURL());
        return versionedRegistry;
    }

    private List<VersionedReportingTask> mapReportingTasks() {
        ArrayList<VersionedReportingTask> reportingTasks = new ArrayList<VersionedReportingTask>();
        for (ReportingTaskNode taskNode : this.flowController.getAllReportingTasks()) {
            VersionedReportingTask versionedReportingTask = this.flowMapper.mapReportingTask(taskNode, this.flowController.getControllerServiceProvider());
            reportingTasks.add(versionedReportingTask);
        }
        return reportingTasks;
    }

    private VersionedProcessGroup mapRootGroup() {
        FlowRegistryClient registryClient = this.flowController.getFlowRegistryClient();
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        InstantiatedVersionedProcessGroup versionedRootGroup = this.flowMapper.mapProcessGroup(rootGroup, this.flowController.getControllerServiceProvider(), registryClient, true);
        return versionedRootGroup;
    }

    private Set<VersionedTemplate> mapTemplates() {
        return this.flowController.getFlowManager().getRootGroup().findAllTemplates().stream().map(this::mapTemplate).collect(Collectors.toSet());
    }

    private VersionedTemplate mapTemplate(Template template) {
        TemplateDTO dto = template.getDetails();
        VersionedTemplate versionedTemplate = new VersionedTemplate();
        versionedTemplate.setIdentifier(template.getIdentifier());
        versionedTemplate.setInstanceIdentifier(template.getIdentifier());
        versionedTemplate.setGroupIdentifier(template.getProcessGroupIdentifier());
        versionedTemplate.setName(dto.getName());
        versionedTemplate.setTemplateDto(dto);
        return versionedTemplate;
    }

    private VersionedComponentStateLookup createStateLookup() {
        return new VersionedComponentStateLookup(){

            public org.apache.nifi.flow.ScheduledState getState(ProcessorNode processorNode) {
                return this.map(VersionedDataflowMapper.this.stateLookup.getScheduledState(processorNode));
            }

            private org.apache.nifi.flow.ScheduledState map(ScheduledState currentState) {
                switch (currentState) {
                    case DISABLED: {
                        return org.apache.nifi.flow.ScheduledState.DISABLED;
                    }
                    case RUNNING: 
                    case STARTING: {
                        return org.apache.nifi.flow.ScheduledState.RUNNING;
                    }
                }
                return org.apache.nifi.flow.ScheduledState.ENABLED;
            }

            public org.apache.nifi.flow.ScheduledState getState(Port port) {
                return this.map(VersionedDataflowMapper.this.stateLookup.getScheduledState(port));
            }

            public org.apache.nifi.flow.ScheduledState getState(ReportingTaskNode taskNode) {
                return this.map(taskNode.getScheduledState());
            }

            public org.apache.nifi.flow.ScheduledState getState(ControllerServiceNode serviceNode) {
                switch (serviceNode.getState()) {
                    case ENABLED: 
                    case ENABLING: {
                        return org.apache.nifi.flow.ScheduledState.ENABLED;
                    }
                }
                return org.apache.nifi.flow.ScheduledState.DISABLED;
            }
        };
    }
}

