/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import org.apache.nifi.controller.queue.QueueSize;

public class FlowFileQueueSize {
    private final int activeQueueCount;
    private final long activeQueueBytes;
    private final int swappedCount;
    private final long swappedBytes;
    private final int swapFiles;
    private final int unacknowledgedCount;
    private final long unacknowledgedBytes;

    public FlowFileQueueSize(int activeQueueCount, long activeQueueBytes, int swappedCount, long swappedBytes, int swapFileCount, int unacknowledgedCount, long unacknowledgedBytes) {
        this.activeQueueCount = activeQueueCount;
        this.activeQueueBytes = activeQueueBytes;
        this.swappedCount = swappedCount;
        this.swappedBytes = swappedBytes;
        this.swapFiles = swapFileCount;
        this.unacknowledgedCount = unacknowledgedCount;
        this.unacknowledgedBytes = unacknowledgedBytes;
    }

    public int getSwappedCount() {
        return this.swappedCount;
    }

    public long getSwappedBytes() {
        return this.swappedBytes;
    }

    public int getSwapFileCount() {
        return this.swapFiles;
    }

    public int getActiveCount() {
        return this.activeQueueCount;
    }

    public long getActiveBytes() {
        return this.activeQueueBytes;
    }

    public int getUnacknowledgedCount() {
        return this.unacknowledgedCount;
    }

    public long getUnacknowledgedBytes() {
        return this.unacknowledgedBytes;
    }

    public boolean isEmpty() {
        return this.activeQueueCount == 0 && this.swappedCount == 0 && this.unacknowledgedCount == 0;
    }

    public QueueSize toQueueSize() {
        return new QueueSize(this.activeQueueCount + this.swappedCount + this.unacknowledgedCount, this.activeQueueBytes + this.swappedBytes + this.unacknowledgedBytes);
    }

    public QueueSize activeQueueSize() {
        return new QueueSize(this.activeQueueCount, this.activeQueueBytes);
    }

    public QueueSize unacknowledgedQueueSize() {
        return new QueueSize(this.unacknowledgedCount, this.unacknowledgedBytes);
    }

    public QueueSize swapQueueSize() {
        return new QueueSize(this.swappedCount, this.swappedBytes);
    }

    public String toString() {
        return "FlowFile Queue Size[ ActiveQueue=[" + this.activeQueueCount + ", " + this.activeQueueBytes + " Bytes], Swap Queue=[" + this.swappedCount + ", " + this.swappedBytes + " Bytes], Swap Files=[" + this.swapFiles + "], Unacknowledged=[" + this.unacknowledgedCount + ", " + this.unacknowledgedBytes + " Bytes] ]";
    }
}

