/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import java.util.Set;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFlowRegistryClient;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleCompatibilityCheck
implements FlowInheritabilityCheck {
    private static final Logger logger = LoggerFactory.getLogger(BundleCompatibilityCheck.class);

    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        if (proposedFlow.isXml()) {
            return this.checkInheritability(proposedFlow.getFlowDocument(), flowController);
        }
        return this.checkVersionedFlowInheritability(proposedFlow, flowController);
    }

    private FlowInheritability checkVersionedFlowInheritability(DataFlow proposedFlow, FlowController flowController) {
        return this.checkBundles(proposedFlow, flowController.getExtensionManager());
    }

    private FlowInheritability checkBundles(DataFlow proposedFlow, ExtensionManager extensionManager) {
        VersionedDataflow dataflow = proposedFlow.getVersionedDataflow();
        if (dataflow == null) {
            return FlowInheritability.inheritable();
        }
        Set missingComponents = proposedFlow.getMissingComponents();
        if (dataflow.getControllerServices() != null) {
            for (VersionedControllerService service : dataflow.getControllerServices()) {
                if (missingComponents.contains(service.getInstanceIdentifier()) || !this.isMissing(service.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Controller Service with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", service.getInstanceIdentifier(), service.getType(), service.getBundle()));
            }
        }
        if (dataflow.getReportingTasks() != null) {
            for (VersionedReportingTask task : dataflow.getReportingTasks()) {
                if (missingComponents.contains(task.getInstanceIdentifier()) || !this.isMissing(task.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Reporting Task with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", task.getInstanceIdentifier(), task.getType(), task.getBundle()));
            }
        }
        if (dataflow.getParameterProviders() != null) {
            for (VersionedReportingTask task : dataflow.getParameterProviders()) {
                if (missingComponents.contains(task.getInstanceIdentifier()) || !this.isMissing(task.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Parameter Provider with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", task.getInstanceIdentifier(), task.getType(), task.getBundle()));
            }
        }
        if (dataflow.getRegistries() != null) {
            for (VersionedFlowRegistryClient registryClient : dataflow.getRegistries()) {
                if (registryClient.getBundle() == null || missingComponents.contains(registryClient.getInstanceIdentifier()) || !this.isMissing(registryClient.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Flow Registry Client with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", registryClient.getInstanceIdentifier(), registryClient.getType(), registryClient.getBundle()));
            }
        }
        return this.checkBundles(dataflow.getRootGroup(), extensionManager, missingComponents);
    }

    private FlowInheritability checkBundles(VersionedProcessGroup group, ExtensionManager extensionManager, Set<String> missingComponents) {
        for (VersionedProcessor processor : group.getProcessors()) {
            if (missingComponents.contains(processor.getInstanceIdentifier()) || !this.isMissing(processor.getBundle(), extensionManager)) continue;
            return FlowInheritability.notInheritable(String.format("Processor with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", processor.getInstanceIdentifier(), processor.getType(), processor.getBundle()));
        }
        for (VersionedControllerService service : group.getControllerServices()) {
            if (missingComponents.contains(service.getInstanceIdentifier()) || !this.isMissing(service.getBundle(), extensionManager)) continue;
            return FlowInheritability.notInheritable(String.format("Controller Service with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", service.getInstanceIdentifier(), service.getType(), service.getBundle()));
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            FlowInheritability childInheritability = this.checkBundles(childGroup, extensionManager, missingComponents);
            if (childInheritability.isInheritable()) continue;
            return childInheritability;
        }
        return FlowInheritability.inheritable();
    }

    private boolean isMissing(org.apache.nifi.flow.Bundle bundle, ExtensionManager extensionManager) {
        BundleCoordinate coordinate = new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
        Bundle existingBundle = extensionManager.getBundle(coordinate);
        return existingBundle == null;
    }

    private FlowInheritability checkInheritability(Document configuration, FlowController flowController) {
        if (configuration == null) {
            return FlowInheritability.inheritable();
        }
        ExtensionManager extensionManager = flowController.getExtensionManager();
        NodeList bundleNodes = configuration.getElementsByTagName("bundle");
        for (int i = 0; i < bundleNodes.getLength(); ++i) {
            Element componentElement;
            Element bundleElement;
            Node componentNode;
            Node bundleNode = bundleNodes.item(i);
            if (!(bundleNode instanceof Element) || !((componentNode = (bundleElement = (Element)bundleNode).getParentNode()) instanceof Element) || this.withinTemplate(componentElement = (Element)componentNode)) continue;
            String componentType = DomUtils.getChildText((Element)componentElement, (String)"class");
            BundleDTO bundleDto = FlowFromDOMFactory.getBundle(bundleElement);
            try {
                BundleUtils.getBundle(extensionManager, componentType, bundleDto);
                continue;
            }
            catch (IllegalStateException e) {
                String bundleDescription = bundleDto.getGroup() + ":" + bundleDto.getArtifact() + ":" + bundleDto.getVersion();
                return FlowInheritability.notInheritable("Could not find Bundle " + bundleDescription + ": " + e.getMessage());
            }
        }
        return FlowInheritability.inheritable();
    }

    private boolean withinTemplate(Element element) {
        if ("template".equals(element.getTagName())) {
            return true;
        }
        Node parentNode = element.getParentNode();
        if (parentNode instanceof Element) {
            return this.withinTemplate((Element)parentNode);
        }
        return false;
    }
}

