/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.nifi.action.Action;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.metrics.EmptyFlowFileEvent;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.reporting.AbstractEventAccess;
import org.apache.nifi.reporting.UserAwareEventAccess;

public class StandardEventAccess
extends AbstractEventAccess
implements UserAwareEventAccess {
    private final FlowManager flowManager;
    private final FlowFileEventRepository flowFileEventRepository;
    private final Authorizer authorizer;
    private final ProvenanceRepository provenanceRepository;
    private final AuditService auditService;

    public StandardEventAccess(FlowManager flowManager, FlowFileEventRepository flowFileEventRepository, ProcessScheduler processScheduler, Authorizer authorizer, ProvenanceRepository provenanceRepository, AuditService auditService, StatusAnalyticsEngine statusAnalyticsEngine) {
        super(processScheduler, statusAnalyticsEngine, flowManager, flowFileEventRepository);
        this.flowFileEventRepository = flowFileEventRepository;
        this.flowManager = flowManager;
        this.authorizer = authorizer;
        this.provenanceRepository = provenanceRepository;
        this.auditService = auditService;
    }

    public List<Action> getFlowChanges(int firstActionId, int maxActions) {
        History history = this.auditService.getActions(firstActionId, maxActions);
        return new ArrayList<Action>(history.getActions());
    }

    public ProvenanceRepository getProvenanceRepository() {
        return this.provenanceRepository;
    }

    public ProcessorStatus getProcessorStatus(String processorId, NiFiUser user) {
        ProcessorNode procNode = this.flowManager.getProcessorNode(processorId);
        if (procNode == null) {
            return null;
        }
        FlowFileEvent flowFileEvent = this.flowFileEventRepository.reportTransferEvents(processorId, System.currentTimeMillis());
        if (flowFileEvent == null) {
            flowFileEvent = EmptyFlowFileEvent.INSTANCE;
        }
        Predicate<Authorizable> authorizer = authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
        return this.getProcessorStatus(flowFileEvent, procNode, authorizer);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user, int recursiveStatusDepth) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport, user, recursiveStatusDepth);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user) {
        ProcessGroup group = this.flowManager.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user), Integer.MAX_VALUE, 1);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport, user);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user, int recursiveStatusDepth) {
        ProcessGroup group = this.flowManager.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user), recursiveStatusDepth, 1);
    }
}

