/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardControllerServiceInitializationContext;
import org.apache.nifi.controller.service.StandardControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.StandardControllerServiceNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceProvider
implements ControllerServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceProvider.class);
    private final ProcessScheduler processScheduler;
    private final BulletinRepository bulletinRepo;
    private final StateManagerProvider stateManagerProvider;
    private final VariableRegistry variableRegistry;
    private final FlowController flowController;
    private final NiFiProperties nifiProperties;

    public StandardControllerServiceProvider(FlowController flowController, ProcessScheduler scheduler, BulletinRepository bulletinRepo, StateManagerProvider stateManagerProvider, VariableRegistry variableRegistry, NiFiProperties nifiProperties) {
        this.flowController = flowController;
        this.processScheduler = scheduler;
        this.bulletinRepo = bulletinRepo;
        this.stateManagerProvider = stateManagerProvider;
        this.variableRegistry = variableRegistry;
        this.nifiProperties = nifiProperties;
    }

    private StateManager getStateManager(String componentId) {
        return this.stateManagerProvider.getStateManager(componentId);
    }

    public ControllerServiceNode createControllerService(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded) {
        if (type == null || id == null || bundleCoordinate == null) {
            throw new NullPointerException();
        }
        InstanceClassLoader cl = null;
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> rawClass;
            try {
                Bundle csBundle = ExtensionManager.getBundle((BundleCoordinate)bundleCoordinate);
                if (csBundle == null) {
                    throw new ControllerServiceInstantiationException("Unable to find bundle for coordinate " + bundleCoordinate.getCoordinate());
                }
                cl = ExtensionManager.createInstanceClassLoader((String)type, (String)id, (Bundle)csBundle, additionalUrls);
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                rawClass = Class.forName(type, false, (ClassLoader)cl);
            }
            catch (Exception e) {
                logger.error("Could not create Controller Service of type " + type + " for ID " + id + "; creating \"Ghost\" implementation", (Throwable)e);
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                ControllerServiceNode controllerServiceNode = this.createGhostControllerService(type, id, bundleCoordinate);
                if (currentContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                }
                return controllerServiceNode;
            }
            Class<ControllerService> controllerServiceClass = rawClass.asSubclass(ControllerService.class);
            ControllerService originalService = controllerServiceClass.newInstance();
            StandardControllerServiceInvocationHandler invocationHandler = new StandardControllerServiceInvocationHandler(originalService);
            List interfaceList = ClassUtils.getAllInterfaces(controllerServiceClass);
            Class[] interfaces = interfaceList.toArray(new Class[interfaceList.size()]);
            ControllerService proxiedService = cl == null ? (ControllerService)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)((Object)invocationHandler)) : (ControllerService)Proxy.newProxyInstance((ClassLoader)cl, interfaces, (InvocationHandler)((Object)invocationHandler));
            logger.info("Created Controller Service of type {} with identifier {}", (Object)type, (Object)id);
            SimpleProcessLogger serviceLogger = new SimpleProcessLogger(id, originalService);
            originalService.initialize((ControllerServiceInitializationContext)new StandardControllerServiceInitializationContext(id, serviceLogger, this, this.getStateManager(id), this.nifiProperties));
            StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this, this.variableRegistry);
            LoggableComponent originalLoggableComponent = new LoggableComponent((ConfigurableComponent)originalService, bundleCoordinate, (ComponentLog)serviceLogger);
            LoggableComponent proxiedLoggableComponent = new LoggableComponent((ConfigurableComponent)proxiedService, bundleCoordinate, (ComponentLog)serviceLogger);
            StandardControllerServiceNode serviceNode = new StandardControllerServiceNode((LoggableComponent<ControllerService>)originalLoggableComponent, (LoggableComponent<ControllerService>)proxiedLoggableComponent, invocationHandler, id, validationContextFactory, this, this.variableRegistry, this.flowController);
            serviceNode.setName(rawClass.getSimpleName());
            invocationHandler.setServiceNode(serviceNode);
            if (firstTimeAdded) {
                try (NarCloseable x = NarCloseable.withComponentNarLoader(originalService.getClass(), (String)originalService.getIdentifier());){
                    ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, originalService, new Object[0]);
                }
                catch (Exception e) {
                    throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + originalService, (Throwable)e);
                }
            }
            StandardControllerServiceNode standardControllerServiceNode = serviceNode;
            return standardControllerServiceNode;
        }
        catch (Throwable t) {
            throw new ControllerServiceInstantiationException(t);
        }
        finally {
            if (currentContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
            }
        }
    }

    private ControllerServiceNode createGhostControllerService(final String type, final String id, BundleCoordinate bundleCoordinate) {
        ControllerServiceInvocationHandler invocationHandler = new ControllerServiceInvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if ("validate".equals(methodName)) {
                    ValidationResult result = new ValidationResult.Builder().input("Any Property").subject("Missing Controller Service").valid(false).explanation("Controller Service could not be created because the Controller Service Type (" + type + ") could not be found").build();
                    return Collections.singleton(result);
                }
                if ("getPropertyDescriptor".equals(methodName)) {
                    String propertyName = (String)args[0];
                    return new PropertyDescriptor.Builder().name(propertyName).description(propertyName).sensitive(true).required(true).build();
                }
                if ("getPropertyDescriptors".equals(methodName)) {
                    return Collections.emptyList();
                }
                if ("onPropertyModified".equals(methodName)) {
                    return null;
                }
                if ("getIdentifier".equals(methodName)) {
                    return id;
                }
                if ("toString".equals(methodName)) {
                    return "GhostControllerService[id=" + id + ", type=" + type + "]";
                }
                if ("hashCode".equals(methodName)) {
                    return 91 * type.hashCode() + 41 * id.hashCode();
                }
                if ("equals".equals(methodName)) {
                    return proxy == args[0];
                }
                throw new IllegalStateException("Controller Service could not be created because the Controller Service Type (" + type + ") could not be found");
            }

            public void setServiceNode(ControllerServiceNode serviceNode) {
            }
        };
        ControllerService proxiedService = (ControllerService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ControllerService.class}, (InvocationHandler)invocationHandler);
        String simpleClassName = type.contains(".") ? StringUtils.substringAfterLast((String)type, (String)".") : type;
        String componentType = "(Missing) " + simpleClassName;
        LoggableComponent proxiedLoggableComponent = new LoggableComponent((ConfigurableComponent)proxiedService, bundleCoordinate, null);
        StandardControllerServiceNode serviceNode = new StandardControllerServiceNode((LoggableComponent<ControllerService>)proxiedLoggableComponent, (LoggableComponent<ControllerService>)proxiedLoggableComponent, invocationHandler, id, new StandardValidationContextFactory(this, this.variableRegistry), this, componentType, type, this.variableRegistry, this.flowController, true);
        return serviceNode;
    }

    public Set<ConfiguredComponent> disableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> toDisable = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        HashSet<ControllerServiceNode> serviceSet = new HashSet<ControllerServiceNode>(toDisable);
        HashSet<ConfiguredComponent> updated = new HashSet<ConfiguredComponent>();
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
            updated.add((ConfiguredComponent)nodeToDisable);
        }
        Collections.reverse(toDisable);
        this.processScheduler.disableControllerServices(toDisable);
        return updated;
    }

    public Set<ConfiguredComponent> scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List<ProcessorNode> processors = this.findRecursiveReferences(serviceNode, ProcessorNode.class);
        List<ReportingTaskNode> reportingTasks = this.findRecursiveReferences(serviceNode, ReportingTaskNode.class);
        HashSet<ConfiguredComponent> updated = new HashSet<ConfiguredComponent>();
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() == ScheduledState.DISABLED) continue;
            processorNode.verifyCanStart();
            updated.add((ConfiguredComponent)processorNode);
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            reportingTaskNode.verifyCanStart();
            updated.add((ConfiguredComponent)reportingTaskNode);
        }
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() == ScheduledState.DISABLED) continue;
            processorNode.getProcessGroup().startProcessor(processorNode);
            updated.add((ConfiguredComponent)processorNode);
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            this.processScheduler.schedule(reportingTaskNode);
            updated.add((ConfiguredComponent)reportingTaskNode);
        }
        return updated;
    }

    public Set<ConfiguredComponent> unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List<ProcessorNode> processors = this.findRecursiveReferences(serviceNode, ProcessorNode.class);
        List<ReportingTaskNode> reportingTasks = this.findRecursiveReferences(serviceNode, ReportingTaskNode.class);
        HashSet<ConfiguredComponent> updated = new HashSet<ConfiguredComponent>();
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() != ScheduledState.RUNNING) continue;
            processorNode.verifyCanStop();
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() != ScheduledState.RUNNING) continue;
            reportingTaskNode.verifyCanStop();
        }
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() != ScheduledState.RUNNING) continue;
            processorNode.getProcessGroup().stopProcessor(processorNode);
            updated.add((ConfiguredComponent)processorNode);
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() != ScheduledState.RUNNING) continue;
            this.processScheduler.unschedule(reportingTaskNode);
            updated.add((ConfiguredComponent)reportingTaskNode);
        }
        return updated;
    }

    public Future<Void> enableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanEnable();
        return this.processScheduler.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        boolean shouldStart = true;
        Iterator<ControllerServiceNode> serviceIter = serviceNodes.iterator();
        while (serviceIter.hasNext() && shouldStart) {
            ControllerServiceNode controllerServiceNode = serviceIter.next();
            List<ControllerServiceNode> requiredServices = ((StandardControllerServiceNode)controllerServiceNode).getRequiredControllerServices();
            for (ControllerServiceNode requiredService : requiredServices) {
                if (requiredService.isActive() || serviceNodes.contains(requiredService)) continue;
                shouldStart = false;
            }
        }
        if (shouldStart) {
            for (ControllerServiceNode controllerServiceNode : serviceNodes) {
                try {
                    if (controllerServiceNode.isActive()) continue;
                    this.enableControllerServiceDependenciesFirst(controllerServiceNode);
                }
                catch (Exception e) {
                    logger.error("Failed to enable " + controllerServiceNode, (Throwable)e);
                    if (this.bulletinRepo == null) continue;
                    this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not start " + controllerServiceNode + " due to " + e)));
                }
            }
        }
    }

    private Future<Void> enableControllerServiceDependenciesFirst(ControllerServiceNode serviceNode) {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (ControllerServiceNode controllerServiceNode : serviceNode.getRequiredControllerServices()) {
            if (controllerServiceNode.isActive()) continue;
            futures.add(this.enableControllerServiceDependenciesFirst(controllerServiceNode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Enabling " + serviceNode);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception exception) {}
        }
        return this.enableControllerService(serviceNode);
    }

    static List<List<ControllerServiceNode>> determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap) {
        ArrayList<List<ControllerServiceNode>> orderedNodeLists = new ArrayList<List<ControllerServiceNode>>();
        for (ControllerServiceNode node : serviceNodeMap.values()) {
            ArrayList<ControllerServiceNode> branch = new ArrayList<ControllerServiceNode>();
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, node, branch, new HashSet<ControllerServiceNode>());
            orderedNodeLists.add(branch);
        }
        return orderedNodeLists;
    }

    private static void determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap, ControllerServiceNode contextNode, List<ControllerServiceNode> orderedNodes, Set<ControllerServiceNode> visited) {
        if (visited.contains(contextNode)) {
            return;
        }
        for (Map.Entry entry : contextNode.getProperties().entrySet()) {
            ControllerServiceNode referencedNode;
            String referencedServiceId;
            if (((PropertyDescriptor)entry.getKey()).getControllerServiceDefinition() == null || (referencedServiceId = (String)entry.getValue()) == null || orderedNodes.contains(referencedNode = serviceNodeMap.get(referencedServiceId))) continue;
            visited.add(contextNode);
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, referencedNode, orderedNodes, visited);
        }
        if (!orderedNodes.contains(contextNode)) {
            orderedNodes.add(contextNode);
        }
    }

    public void disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        this.processScheduler.disableControllerService(serviceNode);
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getProxiedControllerService();
    }

    private ProcessGroup getRootGroup() {
        return this.flowController.getGroup(this.flowController.getRootGroupId());
    }

    public ControllerService getControllerServiceForComponent(String serviceIdentifier, String componentId) {
        ProcessGroup rootGroup = this.getRootGroup();
        ProcessGroup groupOfInterest = null;
        ProcessorNode procNode = rootGroup.findProcessor(componentId);
        if (procNode == null) {
            ControllerServiceNode serviceNode = this.getControllerServiceNode(componentId);
            if (serviceNode == null) {
                ReportingTaskNode taskNode = this.flowController.getReportingTaskNode(componentId);
                if (taskNode == null) {
                    throw new IllegalStateException("Could not find any Processor, Reporting Task, or Controller Service with identifier " + componentId);
                }
                ControllerServiceNode rootServiceNode = this.flowController.getRootControllerService(serviceIdentifier);
                return rootServiceNode == null ? null : rootServiceNode.getProxiedControllerService();
            }
            groupOfInterest = serviceNode.getProcessGroup();
        } else {
            groupOfInterest = procNode.getProcessGroup();
        }
        if (groupOfInterest == null) {
            ControllerServiceNode rootServiceNode = this.flowController.getRootControllerService(serviceIdentifier);
            return rootServiceNode == null ? null : rootServiceNode.getProxiedControllerService();
        }
        Set servicesForGroup = groupOfInterest.getControllerServices(true);
        for (ControllerServiceNode serviceNode : servicesForGroup) {
            if (!serviceIdentifier.equals(serviceNode.getIdentifier())) continue;
            return serviceNode.getProxiedControllerService();
        }
        return null;
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? false : ControllerServiceState.ENABLED == node.getState();
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? false : ControllerServiceState.ENABLING == node.getState();
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        ControllerServiceNode rootServiceNode = this.flowController.getRootControllerService(serviceIdentifier);
        if (rootServiceNode != null) {
            return rootServiceNode;
        }
        return this.getRootGroup().findControllerService(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType, String groupId) {
        Set serviceNodes;
        if (groupId == null) {
            serviceNodes = this.flowController.getRootControllerServices();
        } else {
            ProcessGroup group = this.getRootGroup();
            if (!"root".equals(groupId) && !group.getIdentifier().equals(groupId)) {
                group = group.findProcessGroup(groupId);
            }
            if (group == null) {
                return Collections.emptySet();
            }
            serviceNodes = group.getControllerServices(true);
        }
        HashSet<String> identifiers = new HashSet<String>();
        for (ControllerServiceNode serviceNode : serviceNodes) {
            if (!Objects.requireNonNull(serviceType).isAssignableFrom(serviceNode.getProxiedControllerService().getClass())) continue;
            identifiers.add(serviceNode.getIdentifier());
        }
        return identifiers;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getName();
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        ProcessGroup group = Objects.requireNonNull(serviceNode).getProcessGroup();
        if (group == null) {
            this.flowController.removeRootControllerService(serviceNode);
            return;
        }
        group.removeControllerService(serviceNode);
        ExtensionManager.removeInstanceClassLoader((String)serviceNode.getIdentifier());
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        HashSet<ControllerServiceNode> allServices = new HashSet<ControllerServiceNode>();
        allServices.addAll(this.flowController.getRootControllerServices());
        allServices.addAll(this.getRootGroup().findAllControllerServices());
        return allServices;
    }

    private <T> List<T> findRecursiveReferences(ControllerServiceNode referencedNode, Class<T> componentType) {
        ArrayList<T> references = new ArrayList<T>();
        for (ConfiguredComponent referencingComponent : referencedNode.getReferences().getReferencingComponents()) {
            if (componentType.isAssignableFrom(referencingComponent.getClass())) {
                references.add(componentType.cast(referencingComponent));
            }
            if (!(referencingComponent instanceof ControllerServiceNode)) continue;
            ControllerServiceNode referencingNode = (ControllerServiceNode)referencingComponent;
            List<T> recursive = this.findRecursiveReferences(referencingNode, componentType);
            references.removeAll(recursive);
            references.addAll(recursive);
        }
        return references;
    }

    public Set<ConfiguredComponent> enableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> recursiveReferences = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        logger.debug("Enabling the following Referencing Services for {}: {}", (Object)serviceNode, recursiveReferences);
        return this.enableReferencingServices(serviceNode, recursiveReferences);
    }

    private Set<ConfiguredComponent> enableReferencingServices(ControllerServiceNode serviceNode, List<ControllerServiceNode> recursiveReferences) {
        if (!serviceNode.isActive()) {
            serviceNode.verifyCanEnable(new HashSet<ControllerServiceNode>(recursiveReferences));
        }
        HashSet<ConfiguredComponent> updated = new HashSet<ConfiguredComponent>();
        HashSet<ControllerServiceNode> ifEnabled = new HashSet<ControllerServiceNode>();
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            nodeToEnable.verifyCanEnable(ifEnabled);
            ifEnabled.add(nodeToEnable);
        }
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            logger.debug("Enabling {} because it references {}", (Object)nodeToEnable, (Object)serviceNode);
            this.enableControllerService(nodeToEnable);
            updated.add((ConfiguredComponent)nodeToEnable);
        }
        return updated;
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> referencingServices = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        HashSet<ControllerServiceNode> referencingServiceSet = new HashSet<ControllerServiceNode>(referencingServices);
        for (ControllerServiceNode referencingService : referencingServices) {
            referencingService.verifyCanEnable(referencingServiceSet);
        }
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> referencingServices = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        List<ReportingTaskNode> referencingReportingTasks = this.findRecursiveReferences(serviceNode, ReportingTaskNode.class);
        List<ProcessorNode> referencingProcessors = this.findRecursiveReferences(serviceNode, ProcessorNode.class);
        HashSet<ControllerServiceNode> referencingServiceSet = new HashSet<ControllerServiceNode>(referencingServices);
        for (ReportingTaskNode taskNode : referencingReportingTasks) {
            if (taskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            taskNode.verifyCanStart(referencingServiceSet);
        }
        for (ProcessorNode procNode : referencingProcessors) {
            if (procNode.getScheduledState() == ScheduledState.DISABLED) continue;
            procNode.verifyCanStart(referencingServiceSet);
        }
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> toDisable = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        HashSet<ControllerServiceNode> serviceSet = new HashSet<ControllerServiceNode>(toDisable);
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
        }
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Cannot obtain Controller Service Identifiers for service type " + serviceType + " without providing a Process Group Identifier");
    }
}

