/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.diagnostics.GarbageCollection;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemDiagnosticsFactory {
    private final Logger logger = LoggerFactory.getLogger(SystemDiagnosticsFactory.class);

    public SystemDiagnostics create(FlowFileRepository flowFileRepo, ContentRepository contentRepo) {
        StorageUsage flowFileRepoStorageUsage;
        List<GarbageCollectorMXBean> garbageCollectors;
        SystemDiagnostics systemDiagnostics;
        block8: {
            systemDiagnostics = new SystemDiagnostics();
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            MemoryUsage heap = memory.getHeapMemoryUsage();
            MemoryUsage nonHeap = memory.getNonHeapMemoryUsage();
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            ThreadMXBean threads = ManagementFactory.getThreadMXBean();
            garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            systemDiagnostics.setDaemonThreads(threads.getDaemonThreadCount());
            systemDiagnostics.setTotalThreads(threads.getThreadCount());
            systemDiagnostics.setTotalHeap(heap.getCommitted());
            systemDiagnostics.setUsedHeap(heap.getUsed());
            systemDiagnostics.setMaxHeap(heap.getMax());
            systemDiagnostics.setTotalNonHeap(nonHeap.getCommitted());
            systemDiagnostics.setUsedNonHeap(nonHeap.getUsed());
            systemDiagnostics.setMaxNonHeap(nonHeap.getMax());
            systemDiagnostics.setUptime(runtime.getUptime());
            systemDiagnostics.setAvailableProcessors(os.getAvailableProcessors());
            double systemLoad = os.getSystemLoadAverage();
            if (systemLoad >= 0.0) {
                systemDiagnostics.setProcessorLoadAverage(systemLoad);
            } else {
                systemDiagnostics.setProcessorLoadAverage(-1.0);
            }
            flowFileRepoStorageUsage = new StorageUsage();
            flowFileRepoStorageUsage.setIdentifier("FlowFile Repository");
            try {
                flowFileRepoStorageUsage.setFreeSpace(flowFileRepo.getUsableStorageSpace());
                flowFileRepoStorageUsage.setTotalSpace(flowFileRepo.getStorageCapacity());
            }
            catch (IOException ioe) {
                flowFileRepoStorageUsage.setFreeSpace(0L);
                flowFileRepoStorageUsage.setTotalSpace(-1L);
                this.logger.warn("Unable to determine FlowFile Repository usage due to {}", (Object)ioe.toString());
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.warn("", (Throwable)ioe);
            }
        }
        systemDiagnostics.setFlowFileRepositoryStorageUsage(flowFileRepoStorageUsage);
        Set containerNames = contentRepo.getContainerNames();
        LinkedHashMap<String, StorageUsage> fileRepositoryUsage = new LinkedHashMap<String, StorageUsage>(containerNames.size());
        for (String containerName : containerNames) {
            long containerFree;
            long containerCapacity;
            block9: {
                containerCapacity = -1L;
                containerFree = 0L;
                try {
                    containerFree = contentRepo.getContainerUsableSpace(containerName);
                    containerCapacity = contentRepo.getContainerCapacity(containerName);
                }
                catch (IOException ioe) {
                    this.logger.warn("Unable to determine Content Repository usage for container {} due to {}", (Object)containerName, (Object)ioe.toString());
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.warn("", (Throwable)ioe);
                }
            }
            StorageUsage storageUsage = new StorageUsage();
            storageUsage.setIdentifier(containerName);
            storageUsage.setFreeSpace(containerFree);
            storageUsage.setTotalSpace(containerCapacity);
            fileRepositoryUsage.put(containerName, storageUsage);
        }
        systemDiagnostics.setContentRepositoryStorageUsage(fileRepositoryUsage);
        LinkedHashMap<String, GarbageCollection> garbageCollection = new LinkedHashMap<String, GarbageCollection>(garbageCollectors.size());
        for (GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            GarbageCollection garbageCollectionEntry = new GarbageCollection();
            garbageCollectionEntry.setCollectionCount(garbageCollector.getCollectionCount());
            garbageCollectionEntry.setCollectionTime(garbageCollector.getCollectionTime());
            garbageCollection.put(garbageCollector.getName(), garbageCollectionEntry);
        }
        systemDiagnostics.setGarbageCollection(garbageCollection);
        systemDiagnostics.setCreationTimestamp(new Date().getTime());
        return systemDiagnostics;
    }
}

