/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.VariableRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedVariableRegistry
implements VariableRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedVariableRegistry.class);
    final Map<VariableDescriptor, String> map;

    public FileBasedVariableRegistry(Path[] propertiesPaths) {
        int systemEnvPropCount;
        HashMap<VariableDescriptor, String> newMap = new HashMap<VariableDescriptor, String>(VariableRegistry.ENVIRONMENT_SYSTEM_REGISTRY.getVariableMap());
        int totalPropertiesLoaded = systemEnvPropCount = newMap.size();
        LOG.info("Loaded {} properties from system properties and environment variables", (Object)systemEnvPropCount);
        try {
            for (Path path : propertiesPaths) {
                if (Files.exists(path, new LinkOption[0])) {
                    AtomicInteger propsLoaded = new AtomicInteger(0);
                    try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(path.toFile()));){
                        Properties properties = new Properties();
                        properties.load(inStream);
                        properties.entrySet().stream().forEach(entry -> {
                            VariableDescriptor desc = new VariableDescriptor.Builder(entry.getKey().toString()).description(path.toString()).sensitive(false).build();
                            newMap.put(desc, entry.getValue().toString());
                            propsLoaded.incrementAndGet();
                        });
                    }
                    totalPropertiesLoaded += propsLoaded.get();
                    if (propsLoaded.get() > 0) {
                        LOG.info("Loaded {} properties from '{}'", (Object)propsLoaded.get(), (Object)path);
                        continue;
                    }
                    LOG.warn("No properties loaded from '{}'", (Object)path);
                    continue;
                }
                LOG.warn("Skipping property file {} as it does not appear to exist", (Object)path);
            }
        }
        catch (IOException ioe) {
            LOG.error("Unable to complete variable registry loading from files due to ", (Throwable)ioe);
        }
        LOG.info("Loaded a total of {} properties.  Including precedence overrides effective accessible registry key size is {}", (Object)totalPropertiesLoaded, (Object)newMap.size());
        this.map = newMap;
    }

    public Map<VariableDescriptor, String> getVariableMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

