/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.queue.DropFlowFileRepositoryRecord;
import org.apache.nifi.controller.queue.DropFlowFileRequest;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileSummary;
import org.apache.nifi.controller.queue.ListFlowFileRequest;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.queue.MaxQueueSize;
import org.apache.nifi.controller.queue.PollStrategy;
import org.apache.nifi.controller.queue.QueuePrioritizer;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.TimePeriod;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowFileQueue
implements FlowFileQueue {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFlowFileQueue.class);
    private final String identifier;
    private final FlowFileRepository flowFileRepository;
    private final ProvenanceEventRepository provRepository;
    private final ResourceClaimManager resourceClaimManager;
    private final ProcessScheduler scheduler;
    private final AtomicReference<TimePeriod> expirationPeriod = new AtomicReference<TimePeriod>(new TimePeriod("0 sec", 0L));
    private final AtomicReference<MaxQueueSize> maxQueueSize = new AtomicReference<MaxQueueSize>(new MaxQueueSize("1 GB", 0x40000000L, 10000L));
    private final ConcurrentMap<String, ListFlowFileRequest> listRequestMap = new ConcurrentHashMap<String, ListFlowFileRequest>();
    private final ConcurrentMap<String, DropFlowFileRequest> dropRequestMap = new ConcurrentHashMap<String, DropFlowFileRequest>();
    private LoadBalanceStrategy loadBalanceStrategy = LoadBalanceStrategy.DO_NOT_LOAD_BALANCE;
    private String partitioningAttribute = null;
    private final ReadWriteLock loadBalanceRWLock = new ReentrantReadWriteLock();
    private final Lock loadBalanceReadLock = this.loadBalanceRWLock.readLock();
    private final Lock loadBalanceWriteLock = this.loadBalanceRWLock.writeLock();
    private LoadBalanceCompression compression = LoadBalanceCompression.DO_NOT_COMPRESS;

    public AbstractFlowFileQueue(String identifier, ProcessScheduler scheduler, FlowFileRepository flowFileRepo, ProvenanceEventRepository provRepo, ResourceClaimManager resourceClaimManager) {
        this.identifier = identifier;
        this.scheduler = scheduler;
        this.flowFileRepository = flowFileRepo;
        this.provRepository = provRepo;
        this.resourceClaimManager = resourceClaimManager;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected ProcessScheduler getScheduler() {
        return this.scheduler;
    }

    public String getFlowFileExpiration() {
        return this.expirationPeriod.get().getPeriod();
    }

    public long getFlowFileExpiration(TimeUnit timeUnit) {
        return timeUnit.convert(this.expirationPeriod.get().getMillis(), TimeUnit.MILLISECONDS);
    }

    public void setFlowFileExpiration(String flowExpirationPeriod) {
        long millis = FormatUtils.getTimeDuration((String)flowExpirationPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
        if (millis < 0L) {
            throw new IllegalArgumentException("FlowFile Expiration Period must be positive");
        }
        this.expirationPeriod.set(new TimePeriod(flowExpirationPeriod, millis));
    }

    public void setBackPressureObjectThreshold(long threshold) {
        boolean updated = false;
        while (!updated) {
            MaxQueueSize maxSize = this.getMaxQueueSize();
            MaxQueueSize updatedSize = new MaxQueueSize(maxSize.getMaxSize(), maxSize.getMaxBytes(), threshold);
            updated = this.maxQueueSize.compareAndSet(maxSize, updatedSize);
        }
    }

    public long getBackPressureObjectThreshold() {
        return this.getMaxQueueSize().getMaxCount();
    }

    public void setBackPressureDataSizeThreshold(String maxDataSize) {
        long maxBytes = DataUnit.parseDataSize((String)maxDataSize, (DataUnit)DataUnit.B).longValue();
        boolean updated = false;
        while (!updated) {
            MaxQueueSize maxSize = this.getMaxQueueSize();
            MaxQueueSize updatedSize = new MaxQueueSize(maxDataSize, maxBytes, maxSize.getMaxCount());
            updated = this.maxQueueSize.compareAndSet(maxSize, updatedSize);
        }
    }

    public String getBackPressureDataSizeThreshold() {
        return this.getMaxQueueSize().getMaxSize();
    }

    private MaxQueueSize getMaxQueueSize() {
        return this.maxQueueSize.get();
    }

    public boolean isFull() {
        return this.isFull(this.size());
    }

    protected boolean isFull(QueueSize queueSize) {
        MaxQueueSize maxSize = this.getMaxQueueSize();
        if (maxSize.getMaxBytes() <= 0L && maxSize.getMaxCount() <= 0L) {
            return false;
        }
        if (maxSize.getMaxCount() > 0L && (long)queueSize.getObjectCount() >= maxSize.getMaxCount()) {
            return true;
        }
        return maxSize.getMaxBytes() > 0L && queueSize.getByteCount() >= maxSize.getMaxBytes();
    }

    public ListFlowFileStatus listFlowFiles(String requestIdentifier, final int maxResults) {
        if (this.listRequestMap.size() > 10) {
            ArrayList toDrop = new ArrayList();
            for (Map.Entry entry : this.listRequestMap.entrySet()) {
                ListFlowFileRequest request = (ListFlowFileRequest)entry.getValue();
                boolean completed = request.getState() == ListFlowFileState.COMPLETE || request.getState() == ListFlowFileState.FAILURE;
                if (!completed || System.currentTimeMillis() - request.getLastUpdated() <= TimeUnit.MINUTES.toMillis(5L)) continue;
                toDrop.add(entry.getKey());
            }
            for (String requestId : toDrop) {
                this.listRequestMap.remove(requestId);
            }
        }
        final ListFlowFileRequest listRequest = new ListFlowFileRequest(requestIdentifier, maxResults, this.size());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                int position = 0;
                ArrayList<FlowFileSummary> summaries = new ArrayList<FlowFileSummary>();
                List<FlowFileRecord> allFlowFiles = AbstractFlowFileQueue.this.getListableFlowFiles();
                QueuePrioritizer prioritizer = new QueuePrioritizer(AbstractFlowFileQueue.this.getPriorities());
                listRequest.setState(ListFlowFileState.CALCULATING_LIST);
                allFlowFiles.sort(prioritizer);
                for (FlowFileRecord flowFile : allFlowFiles) {
                    summaries.add(AbstractFlowFileQueue.this.summarize(flowFile, ++position));
                    if (summaries.size() < maxResults) continue;
                    break;
                }
                logger.debug("{} Finished listing FlowFiles for active queue with a total of {} results out of {} FlowFiles", new Object[]{this, summaries.size(), allFlowFiles.size()});
                listRequest.setFlowFileSummaries(summaries);
                listRequest.setState(ListFlowFileState.COMPLETE);
            }
        }, "List FlowFiles for Connection " + this.getIdentifier());
        t.setDaemon(true);
        t.start();
        this.listRequestMap.put(requestIdentifier, listRequest);
        return listRequest;
    }

    public ListFlowFileStatus getListFlowFileStatus(String requestIdentifier) {
        return (ListFlowFileStatus)this.listRequestMap.get(requestIdentifier);
    }

    public ListFlowFileStatus cancelListFlowFileRequest(String requestIdentifier) {
        logger.info("Canceling ListFlowFile Request with ID {}", (Object)requestIdentifier);
        ListFlowFileRequest request = (ListFlowFileRequest)this.listRequestMap.remove(requestIdentifier);
        if (request != null) {
            request.cancel();
        }
        return request;
    }

    protected abstract List<FlowFileRecord> getListableFlowFiles();

    public DropFlowFileStatus dropFlowFiles(String requestIdentifier, final String requestor) {
        logger.info("Initiating drop of FlowFiles from {} on behalf of {} (request identifier={})", new Object[]{this, requestor, requestIdentifier});
        if (this.dropRequestMap.size() > 10) {
            ArrayList toDrop = new ArrayList();
            for (Map.Entry entry : this.dropRequestMap.entrySet()) {
                DropFlowFileRequest request = (DropFlowFileRequest)entry.getValue();
                boolean completed = request.getState() == DropFlowFileState.COMPLETE || request.getState() == DropFlowFileState.FAILURE;
                if (!completed || System.currentTimeMillis() - request.getLastUpdated() <= TimeUnit.MINUTES.toMillis(5L)) continue;
                toDrop.add(entry.getKey());
            }
            for (String requestId : toDrop) {
                this.dropRequestMap.remove(requestId);
            }
        }
        final DropFlowFileRequest dropRequest = new DropFlowFileRequest(requestIdentifier);
        QueueSize originalSize = this.size();
        dropRequest.setCurrentSize(originalSize);
        dropRequest.setOriginalSize(originalSize);
        if (originalSize.getObjectCount() == 0) {
            dropRequest.setDroppedSize(originalSize);
            dropRequest.setState(DropFlowFileState.COMPLETE);
            this.dropRequestMap.put(requestIdentifier, dropRequest);
            return dropRequest;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractFlowFileQueue.this.dropFlowFiles(dropRequest, requestor);
            }
        }, "Drop FlowFiles for Connection " + this.getIdentifier());
        t.setDaemon(true);
        t.start();
        this.dropRequestMap.put(requestIdentifier, dropRequest);
        return dropRequest;
    }

    public DropFlowFileRequest cancelDropFlowFileRequest(String requestIdentifier) {
        DropFlowFileRequest request = (DropFlowFileRequest)this.dropRequestMap.remove(requestIdentifier);
        if (request == null) {
            return null;
        }
        request.cancel();
        return request;
    }

    public DropFlowFileStatus getDropFlowFileStatus(String requestIdentifier) {
        return (DropFlowFileStatus)this.dropRequestMap.get(requestIdentifier);
    }

    protected abstract void dropFlowFiles(DropFlowFileRequest var1, String var2);

    public void verifyCanList() throws IllegalStateException {
    }

    protected FlowFileSummary summarize(FlowFileRecord flowFile, final int position) {
        final String uuid = flowFile.getAttribute(CoreAttributes.UUID.key());
        final String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        final long size = flowFile.getSize();
        final Long lastQueuedTime = flowFile.getLastQueueDate();
        final long lineageStart = flowFile.getLineageStartDate();
        final boolean penalized = flowFile.isPenalized();
        final long penaltyExpires = flowFile.getPenaltyExpirationMillis();
        return new FlowFileSummary(){

            public String getUuid() {
                return uuid;
            }

            public String getFilename() {
                return filename;
            }

            public int getPosition() {
                return position;
            }

            public long getSize() {
                return size;
            }

            public long getLastQueuedTime() {
                return lastQueuedTime == null ? 0L : lastQueuedTime;
            }

            public long getLineageStartDate() {
                return lineageStart;
            }

            public boolean isPenalized() {
                return penalized;
            }

            public long getPenaltyExpirationMillis() {
                return penaltyExpires;
            }
        };
    }

    protected QueueSize drop(List<FlowFileRecord> flowFiles, String requestor) throws IOException {
        ArrayList<ProvenanceEventRecord> provenanceEvents = new ArrayList<ProvenanceEventRecord>(flowFiles.size());
        ArrayList<RepositoryRecord> flowFileRepoRecords = new ArrayList<RepositoryRecord>(flowFiles.size());
        long dropContentSize = 0L;
        for (FlowFileRecord flowFile : flowFiles) {
            provenanceEvents.add(this.createDropProvenanceEvent(flowFile, requestor));
            flowFileRepoRecords.add(this.createDeleteRepositoryRecord(flowFile));
            dropContentSize += flowFile.getSize();
        }
        this.provRepository.registerEvents(provenanceEvents);
        this.flowFileRepository.updateRepository(flowFileRepoRecords);
        return new QueueSize(flowFiles.size(), dropContentSize);
    }

    private ProvenanceEventRecord createDropProvenanceEvent(FlowFileRecord flowFile, String requestor) {
        ProvenanceEventBuilder builder = this.provRepository.eventBuilder();
        builder.fromFlowFile((FlowFile)flowFile);
        builder.setEventType(ProvenanceEventType.DROP);
        builder.setLineageStartDate(flowFile.getLineageStartDate());
        builder.setComponentId(this.getIdentifier());
        builder.setComponentType("Connection");
        builder.setAttributes(flowFile.getAttributes(), Collections.emptyMap());
        builder.setDetails("FlowFile Queue emptied by " + requestor);
        builder.setSourceQueueIdentifier(this.getIdentifier());
        ContentClaim contentClaim = flowFile.getContentClaim();
        if (contentClaim != null) {
            ResourceClaim resourceClaim = contentClaim.getResourceClaim();
            builder.setPreviousContentClaim(resourceClaim.getContainer(), resourceClaim.getSection(), resourceClaim.getId(), Long.valueOf(contentClaim.getOffset()), flowFile.getSize());
        }
        return builder.build();
    }

    private RepositoryRecord createDeleteRepositoryRecord(FlowFileRecord flowFile) {
        return new DropFlowFileRepositoryRecord(this, flowFile);
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy strategy, String partitioningAttribute) {
        this.loadBalanceWriteLock.lock();
        try {
            if (strategy == LoadBalanceStrategy.PARTITION_BY_ATTRIBUTE && !FlowFile.KeyValidator.isValid((String)partitioningAttribute)) {
                throw new IllegalArgumentException("Cannot set Load Balance Strategy to " + strategy + " without providing a valid Partitioning Attribute");
            }
            this.loadBalanceStrategy = strategy;
            this.partitioningAttribute = partitioningAttribute;
        }
        finally {
            this.loadBalanceWriteLock.unlock();
        }
    }

    public String getPartitioningAttribute() {
        this.loadBalanceReadLock.lock();
        try {
            String string = this.partitioningAttribute;
            return string;
        }
        finally {
            this.loadBalanceReadLock.unlock();
        }
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() {
        this.loadBalanceReadLock.lock();
        try {
            LoadBalanceStrategy loadBalanceStrategy = this.loadBalanceStrategy;
            return loadBalanceStrategy;
        }
        finally {
            this.loadBalanceReadLock.unlock();
        }
    }

    public synchronized void setLoadBalanceCompression(LoadBalanceCompression compression) {
        this.loadBalanceWriteLock.lock();
        try {
            this.compression = compression;
        }
        finally {
            this.loadBalanceWriteLock.unlock();
        }
    }

    public synchronized LoadBalanceCompression getLoadBalanceCompression() {
        this.loadBalanceReadLock.lock();
        try {
            LoadBalanceCompression loadBalanceCompression = this.compression;
            return loadBalanceCompression;
        }
        finally {
            this.loadBalanceReadLock.unlock();
        }
    }

    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords) {
        return this.poll(expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    public List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords) {
        return this.poll(maxResults, expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords) {
        return this.poll(filter, expiredRecords, PollStrategy.UNPENALIZED_FLOWFILES);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

